/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.factmodel.traits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.drools.base.RuleBase;
import org.drools.base.base.ClassObjectType;
import org.drools.base.factmodel.traits.Thing;
import org.drools.base.factmodel.traits.Trait;
import org.drools.base.factmodel.traits.Traitable;
import org.drools.base.factmodel.traits.TraitableBean;
import org.drools.base.rule.EntryPointId;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.io.ByteArrayResource;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.traits.compiler.CommonTraitTest;
import org.drools.traits.compiler.Person;
import org.drools.traits.compiler.factmodel.traits.IStudent;
import org.drools.traits.compiler.factmodel.traits.Imp2;
import org.drools.traits.compiler.factmodel.traits.Message;
import org.drools.traits.compiler.factmodel.traits.StudentImpl;
import org.drools.traits.compiler.factmodel.traits.StudentProxyImpl2;
import org.drools.traits.core.factmodel.Entity;
import org.drools.traits.core.factmodel.HierarchyEncoder;
import org.drools.traits.core.factmodel.MapWrapper;
import org.drools.traits.core.factmodel.TraitFactoryImpl;
import org.drools.traits.core.factmodel.TraitProxyImpl;
import org.drools.traits.core.factmodel.TraitRegistryImpl;
import org.drools.traits.core.factmodel.TraitTypeMapImpl;
import org.drools.traits.core.factmodel.TripleBasedBean;
import org.drools.traits.core.factmodel.TripleBasedStruct;
import org.drools.traits.core.factmodel.VirtualPropertyMode;
import org.drools.traits.core.reteoo.TraitRuntimeComponentFactory;
import org.drools.traits.core.util.CodedHierarchyImpl;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.command.CommandFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraitTest
extends CommonTraitTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraitTest.class);

    public static Stream<VirtualPropertyMode> parameters() {
        return Stream.of(VirtualPropertyMode.MAP, VirtualPropertyMode.TRIPLES);
    }

    private KieSession getSession(String ruleFile) {
        return this.loadKnowledgeBaseFromDrlFile(ruleFile).newKieSession();
    }

    private KieSession getSessionFromString(String drl) {
        return this.loadKnowledgeBaseFromString(drl).newKieSession();
    }

    private KieBase getKieBaseFromString(String drl, KieBaseOption ... options) {
        return this.loadKnowledgeBaseWithKieBaseOption(drl, options);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testRetract(VirtualPropertyMode mode) {
        String drl = "package org.drools.compiler.trait.test; \nimport org.drools.base.factmodel.traits.Traitable; \ndeclare Foo @Traitable end\ndeclare trait Bar end \nrule Init when then\n  Foo foo = new Foo(); \n  don(foo, Bar.class); \nend\nrule Retract \nwhen\n $bar : Bar()\nthen\n  delete($bar); \nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        Assertions.assertThat((int)ks.fireAllRules()).isEqualTo(2);
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat((Collection)ks.getObjects()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitWrapGetAndSet(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        Class trait = kb.getFactType("org.drools.compiler.trait.test", "Student").getFactClass();
        TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        Map virtualFields = imp._getDynamicProperties();
        Map wrapper = proxy.getFields();
        wrapper.put("name", "john");
        wrapper.put("virtualField", "xyz");
        wrapper.entrySet();
        Assertions.assertThat((Map)wrapper).hasSize(4);
        Assertions.assertThat((Map)virtualFields).hasSize(2);
        Assertions.assertThat(wrapper.get("name")).isEqualTo((Object)"john");
        Assertions.assertThat(wrapper.get("virtualField")).isEqualTo((Object)"xyz");
        Assertions.assertThat((Object)impClass.get((Object)imp, "name")).isEqualTo((Object)"john");
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitShed(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitShed.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        Assertions.assertThat(info).isEmpty();
        ks.fireAllRules();
        Assertions.assertThat(info).contains((Object[])new String[]{"Student"});
        Assertions.assertThat(info).hasSize(1);
        ks.insert((Object)"hire");
        ks.fireAllRules();
        Assertions.assertThat(info).contains((Object[])new String[]{"Worker"});
        Assertions.assertThat(info).hasSize(2);
        ks.insert((Object)"check");
        ks.fireAllRules();
        Assertions.assertThat(info).hasSize(4);
        Assertions.assertThat(info).contains((Object[])new String[]{"Conflict"});
        Assertions.assertThat(info).contains((Object[])new String[]{"Nothing"});
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitDon(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Collection wm = ks.getObjects();
        ks.insert((Object)"go");
        ks.fireAllRules();
        Assertions.assertThat(info).contains((Object[])new String[]{"DON"});
        Assertions.assertThat(info).contains((Object[])new String[]{"SHED"});
        Iterator it = wm.iterator();
        Object x = it.next();
        if (x instanceof String) {
            x = it.next();
        }
        LOGGER.debug(x.getClass().toString());
        LOGGER.debug(x.getClass().getSuperclass().toString());
        LOGGER.debug(List.of(x.getClass().getInterfaces()).toString());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testMixin(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitMixin.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Assertions.assertThat(info).contains((Object[])new String[]{"27"});
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void traitMethodsWithObjects(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitWrapping.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList errors = new ArrayList();
        ks.setGlobal("list", errors);
        ks.fireAllRules();
        if (!errors.isEmpty()) {
            LOGGER.error(((Object)errors).toString());
        }
        Assertions.assertThat(errors).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void traitMethodsWithPrimitives(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitWrappingPrimitives.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList errors = new ArrayList();
        ks.setGlobal("list", errors);
        ks.fireAllRules();
        if (!errors.isEmpty()) {
            LOGGER.error(((Object)errors).toString());
        }
        Assertions.assertThat(errors).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitProxy(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        impClass.set((Object)imp, "name", (Object)"aaa");
        Class trait = kb.getFactType("org.drools.compiler.trait.test", "Student").getFactClass();
        Class trait2 = kb.getFactType("org.drools.compiler.trait.test", "Role").getFactClass();
        Assertions.assertThat((Class)trait).isNotNull();
        TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        proxy.getFields().put("field", "xyz");
        Assertions.assertThat((Comparable)proxy).isNotNull();
        TraitProxyImpl proxy2 = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        Assertions.assertThat((Comparable)proxy).isSameAs((Object)proxy2);
        TraitProxyImpl proxy3 = (TraitProxyImpl)tFactory.getProxy(imp, trait2, false);
        Assertions.assertThat((Comparable)proxy3).isNotNull();
        Assertions.assertThat(proxy3.getFields().get("field")).isEqualTo((Object)"xyz");
        Assertions.assertThat(proxy3.getFields().get("name")).isEqualTo((Object)"aaa");
        TraitableBean imp2 = (TraitableBean)impClass.newInstance();
        impClass.set((Object)imp2, "name", (Object)"aaa");
        TraitProxyImpl proxy4 = (TraitProxyImpl)tFactory.getProxy(imp2, trait, false);
        proxy4.getFields().put("field", "xyz");
        Assertions.assertThat((Comparable)proxy4).isEqualTo((Object)proxy2);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testWrapperSize(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
        Class trait = traitClass.getFactClass();
        TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        Map virtualFields = imp._getDynamicProperties();
        Map wrapper = proxy.getFields();
        Assertions.assertThat((Map)wrapper).hasSize(3);
        Assertions.assertThat((Map)virtualFields).hasSize(1);
        impClass.set((Object)imp, "name", (Object)"john");
        Assertions.assertThat((Map)wrapper).hasSize(3);
        Assertions.assertThat((Map)virtualFields).hasSize(1);
        proxy.getFields().put("school", "skol");
        Assertions.assertThat((Map)wrapper).hasSize(3);
        Assertions.assertThat((Map)virtualFields).hasSize(1);
        proxy.getFields().put("surname", "xxx");
        Assertions.assertThat((Map)wrapper).hasSize(4);
        Assertions.assertThat((Map)virtualFields).hasSize(2);
        Entity ind = new Entity();
        TraitProxyImpl proxy2 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind, trait, false);
        Map virtualFields2 = ind._getDynamicProperties();
        Map wrapper2 = proxy2.getFields();
        Assertions.assertThat((Map)wrapper2).hasSize(3);
        Assertions.assertThat((Map)virtualFields2).hasSize(3);
        traitClass.set((Object)proxy2, "name", (Object)"john");
        Assertions.assertThat((Map)wrapper2).hasSize(3);
        Assertions.assertThat((Map)virtualFields2).hasSize(3);
        proxy2.getFields().put("school", "skol");
        Assertions.assertThat((Map)wrapper2).hasSize(3);
        Assertions.assertThat((Map)virtualFields2).hasSize(3);
        proxy2.getFields().put("surname", "xxx");
        Assertions.assertThat((Map)wrapper2).hasSize(4);
        Assertions.assertThat((Map)virtualFields2).hasSize(4);
        FactType traitClass2 = kb.getFactType("org.drools.compiler.trait.test", "Role");
        Class trait2 = traitClass2.getFactClass();
        Entity ind2 = new Entity();
        TraitProxyImpl proxy99 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind2, trait2, false);
        proxy99.getFields().put("surname", "xxx");
        proxy99.getFields().put("name", "xyz");
        proxy99.getFields().put("school", "skol");
        Assertions.assertThat((Map)proxy99.getFields()).hasSize(3);
        TraitProxyImpl proxy100 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind2, trait, false);
        Assertions.assertThat((Map)proxy100.getFields()).hasSize(4);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testWrapperEmpty(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        FactType studentClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
        Class trait = studentClass.getFactClass();
        TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        Map wrapper = proxy.getFields();
        Assertions.assertThat((Map)wrapper).isNotEmpty();
        studentClass.set((Object)proxy, "name", (Object)"john");
        Assertions.assertThat((Map)wrapper).isNotEmpty();
        studentClass.set((Object)proxy, "name", null);
        Assertions.assertThat((Map)wrapper).isNotEmpty();
        studentClass.set((Object)proxy, "age", (Object)32);
        Assertions.assertThat((Map)wrapper).isNotEmpty();
        studentClass.set((Object)proxy, "age", null);
        Assertions.assertThat((Map)wrapper).isNotEmpty();
        Entity ind = new Entity();
        FactType RoleClass = kb.getFactType("org.drools.compiler.trait.test", "Role");
        Class trait2 = RoleClass.getFactClass();
        TraitProxyImpl proxy2 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind, trait2, false);
        Map wrapper2 = proxy2.getFields();
        Assertions.assertThat((Map)wrapper2).isEmpty();
        proxy2.getFields().put("name", "john");
        Assertions.assertThat((Map)wrapper2).isNotEmpty();
        proxy2.getFields().put("name", null);
        Assertions.assertThat((Map)wrapper2).isNotEmpty();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testWrapperContainsKey(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        impClass.set((Object)imp, "name", (Object)"john");
        FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
        Class trait = traitClass.getFactClass();
        TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        Map wrapper = proxy.getFields();
        Assertions.assertThat((Map)wrapper).containsKey((Object)"name");
        Assertions.assertThat((Map)wrapper).containsKey((Object)"school");
        Assertions.assertThat((Map)wrapper).containsKey((Object)"age");
        Assertions.assertThat((Map)wrapper).doesNotContainKey((Object)"surname");
        proxy.getFields().put("school", "skol");
        proxy.getFields().put("surname", "xxx");
        Assertions.assertThat((Map)wrapper).containsKey((Object)"surname");
        Entity ind = new Entity();
        TraitProxyImpl proxy2 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind, trait, false);
        Map wrapper2 = proxy2.getFields();
        Assertions.assertThat((Map)wrapper2).containsKey((Object)"name");
        Assertions.assertThat((Map)wrapper2).containsKey((Object)"school");
        Assertions.assertThat((Map)wrapper2).containsKey((Object)"age");
        Assertions.assertThat((Map)wrapper2).doesNotContainKey((Object)"surname");
        traitClass.set((Object)proxy2, "name", (Object)"john");
        proxy2.getFields().put("school", "skol");
        proxy2.getFields().put("surname", "xxx");
        Assertions.assertThat((Map)wrapper2).containsKey((Object)"surname");
        FactType traitClass2 = kb.getFactType("org.drools.compiler.trait.test", "Role");
        Class trait2 = traitClass2.getFactClass();
        Entity ind2 = new Entity();
        TraitProxyImpl proxy99 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind2, trait2, false);
        Map wrapper99 = proxy99.getFields();
        Assertions.assertThat((Map)wrapper99).doesNotContainKey((Object)"name");
        Assertions.assertThat((Map)wrapper99).doesNotContainKey((Object)"school");
        Assertions.assertThat((Map)wrapper99).doesNotContainKey((Object)"age");
        Assertions.assertThat((Map)wrapper99).doesNotContainKey((Object)"surname");
        proxy99.getFields().put("surname", "xxx");
        proxy99.getFields().put("name", "xyz");
        proxy99.getFields().put("school", "skol");
        Assertions.assertThat((Map)wrapper99).containsKey((Object)"name");
        Assertions.assertThat((Map)wrapper99).containsKey((Object)"school");
        Assertions.assertThat((Map)wrapper99).doesNotContainKey((Object)"age");
        Assertions.assertThat((Map)wrapper99).containsKey((Object)"surname");
        Assertions.assertThat((Map)proxy99.getFields()).hasSize(3);
        Entity ind0 = new Entity();
        TraitProxyImpl proxy100 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind0, trait2, false);
        Map wrapper100 = proxy100.getFields();
        Assertions.assertThat((Map)wrapper100).doesNotContainKey((Object)"name");
        Assertions.assertThat((Map)wrapper100).doesNotContainKey((Object)"school");
        Assertions.assertThat((Map)wrapper100).doesNotContainKey((Object)"age");
        Assertions.assertThat((Map)wrapper100).doesNotContainKey((Object)"surname");
        TraitProxyImpl proxy101 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind0, trait, false);
        Assertions.assertThat((Map)wrapper100).containsKey((Object)"name");
        Assertions.assertThat((Map)wrapper100).containsKey((Object)"school");
        Assertions.assertThat((Map)wrapper100).containsKey((Object)"age");
        Assertions.assertThat((Map)wrapper100).doesNotContainKey((Object)"surname");
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testInternalComponents1(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
        Class trait = traitClass.getFactClass();
        TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        Map proxyFields = proxy.getFields();
        Map coreTraits = imp._getTraitMap();
        Map coreProperties = imp._getDynamicProperties();
        Assertions.assertThat((Object)proxyFields).isNotNull();
        Assertions.assertThat((Object)coreTraits).isNotNull();
        Assertions.assertThat((Object)coreProperties).isNotNull();
        if (mode == VirtualPropertyMode.MAP) {
            Assertions.assertThat((Object)proxyFields).isInstanceOf(MapWrapper.class);
            Assertions.assertThat((Object)coreTraits).isInstanceOf(TraitTypeMapImpl.class);
            Assertions.assertThat((Object)coreProperties).isInstanceOf(HashMap.class);
        } else {
            Assertions.assertThat((String)proxyFields.getClass().getName()).isEqualTo("org.drools.compiler.trait.test.Student.org.drools.compiler.trait.test.Imp_ProxyWrapper");
            Assertions.assertThat((Object)proxyFields).isInstanceOf(TripleBasedStruct.class);
            Assertions.assertThat((Object)coreTraits).isInstanceOf(TraitTypeMapImpl.class);
            Assertions.assertThat((Object)coreProperties).isInstanceOf(TripleBasedBean.class);
        }
        StudentProxyImpl2 sp2 = new StudentProxyImpl2(new Imp2(), null);
        LOGGER.debug(sp2.toString());
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testWrapperKeySetAndValues(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
        Class trait = traitClass.getFactClass();
        TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        impClass.set((Object)imp, "name", (Object)"john");
        proxy.getFields().put("surname", "xxx");
        proxy.getFields().put("name2", "john");
        proxy.getFields().put("nfield", null);
        Assertions.assertThat((Map)proxy.getFields()).hasSize(6);
        Assertions.assertThat(proxy.getFields().keySet()).contains((Object[])new String[]{"name", "surname", "age", "school", "name2", "nfield"});
        ArrayList col1 = new ArrayList(proxy.getFields().values());
        List<Object> col2 = Arrays.asList("john", null, 0, "xxx", "john", null);
        Comparator<Object> comp = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 != null) {
                    return 1;
                }
                if (o1 != null && o2 == null) {
                    return -1;
                }
                if (o1 == null && o2 == null) {
                    return 0;
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
        Collections.sort(col1, comp);
        Collections.sort(col2, comp);
        Assertions.assertThat(col2).isEqualTo(col1);
        Assertions.assertThat((Map)proxy.getFields()).containsValue(null);
        Assertions.assertThat((Map)proxy.getFields()).containsValue((Object)"john");
        Assertions.assertThat((Map)proxy.getFields()).containsValue((Object)0);
        Assertions.assertThat((Map)proxy.getFields()).containsValue((Object)"xxx");
        Assertions.assertThat((Map)proxy.getFields()).doesNotContainValue((Object)"randomString");
        Assertions.assertThat((Map)proxy.getFields()).doesNotContainValue((Object)-96);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testWrapperClearAndRemove(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        impClass.set((Object)imp, "name", (Object)"john");
        FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
        Class trait = traitClass.getFactClass();
        TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait, false);
        proxy.getFields().put("surname", "xxx");
        proxy.getFields().put("name2", "john");
        proxy.getFields().put("nfield", null);
        HashSet<String> set = new HashSet<String>();
        set.add("name");
        set.add("surname");
        set.add("age");
        set.add("school");
        set.add("name2");
        set.add("nfield");
        Assertions.assertThat((Map)proxy.getFields()).hasSize(6);
        Assertions.assertThat(proxy.getFields().keySet()).isEqualTo(set);
        proxy.getFields().clear();
        Map fields = proxy.getFields();
        Assertions.assertThat((Map)fields).hasSize(3);
        Assertions.assertThat((Map)fields).containsKey((Object)"age");
        Assertions.assertThat((Map)fields).containsKey((Object)"school");
        Assertions.assertThat((Map)fields).containsKey((Object)"name");
        Assertions.assertThat(fields.get("age")).isEqualTo((Object)0);
        Assertions.assertThat(fields.get("school")).isNull();
        Assertions.assertThat(fields.get("name")).isNotNull();
        proxy.getFields().put("surname", "xxx");
        proxy.getFields().put("name2", "john");
        proxy.getFields().put("nfield", null);
        proxy.getFields().put("age", 24);
        Assertions.assertThat(proxy.getFields().get("name")).isEqualTo((Object)"john");
        Assertions.assertThat(proxy.getFields().get("surname")).isEqualTo((Object)"xxx");
        Assertions.assertThat(proxy.getFields().get("name2")).isEqualTo((Object)"john");
        Assertions.assertThat(proxy.getFields().get("nfield")).isEqualTo(null);
        Assertions.assertThat(proxy.getFields().get("age")).isEqualTo((Object)24);
        Assertions.assertThat(proxy.getFields().get("school")).isEqualTo(null);
        proxy.getFields().remove("surname");
        proxy.getFields().remove("name2");
        proxy.getFields().remove("age");
        proxy.getFields().remove("school");
        proxy.getFields().remove("nfield");
        Assertions.assertThat((Map)proxy.getFields()).hasSize(3);
        Assertions.assertThat(proxy.getFields().get("age")).isEqualTo((Object)0);
        Assertions.assertThat(proxy.getFields().get("school")).isEqualTo(null);
        Assertions.assertThat(proxy.getFields().get("name")).isEqualTo((Object)"john");
        Assertions.assertThat(proxy.getFields().get("nfield")).isEqualTo(null);
        Assertions.assertThat((Map)proxy.getFields()).doesNotContainKey((Object)"nfield");
        Assertions.assertThat(proxy.getFields().get("name2")).isEqualTo(null);
        Assertions.assertThat((Map)proxy.getFields()).doesNotContainKey((Object)"name2");
        Assertions.assertThat(proxy.getFields().get("surname")).isEqualTo(null);
        Assertions.assertThat((Map)proxy.getFields()).doesNotContainKey((Object)"surname");
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsAEvaluator(VirtualPropertyMode mode) {
        String source = "package org.drools.compiler.trait.test;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.traits.core.factmodel.Entity;\nimport org.drools.base.factmodel.traits.Thing;\n\nglobal java.util.List list;\n\n\ndeclare Imp\n    @Traitable\n    name    : String        @key\nend\n\ndeclare trait Person\n    name    : String \n    age     : int   \nend\n  \ndeclare trait Worker\n    job     : String\nend\n \n\n \n \nrule \"Init\"\nwhen\nthen\n    Imp core = new Imp(\"joe\");\n    insert(core);\n    don(core, Person.class);\n    don(core, Worker.class);\n\n    Imp core2 = new Imp(\"adam\");\n    insert(core2);\n    don(core2, Worker.class);\nend\n\nrule \"Mod\"\nwhen\n    $p : Person(name == \"joe\")\nthen\n    modify ($p) { setName(\"john\"); }\nend\n\nrule \"Worker Students v6\"\nwhen\n    $x2 := Person(name == \"john\")\n    $x1 := Worker(core != $x2.core, this not isA $x2)\nthen\n    list.add(\"ok\");\nend\n\n\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        LOGGER.debug(((Object)info).toString());
        Assertions.assertThat(info).contains((Object[])new String[]{"ok"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsA(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitIsA.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        int num = 10;
        LOGGER.debug(((Object)info).toString());
        Assertions.assertThat(info).hasSize(num);
        for (int j = 0; j < num; ++j) {
            Assertions.assertThat(info).contains((Object[])new String[]{"" + j});
        }
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testOverrideType(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitOverride.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ((ThrowableTypeAssert)Assertions.assertThatException().as("An exception was expected since a trait can't override the type of a core class field with these settings ", new Object[0])).isThrownBy(() -> ks.fireAllRules()).extracting(e -> e.getCause()).isInstanceOf(UnsupportedOperationException.class);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testOverrideType2(VirtualPropertyMode mode) {
        String drl = "package org.drools.compiler.trait.test; \nimport org.drools.base.factmodel.traits.Traitable; \ndeclare Foo @Traitable end\ndeclare trait Bar end \ndeclare trait Mask fld : Foo end \ndeclare Face @Traitable fld : Bar end \nrule Don when then\n  Face face = new Face(); \n  don(face, Mask.class); \nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ((ThrowableTypeAssert)Assertions.assertThatException().as("An exception was expected since a trait can't override the type of a core class field with these settings ", new Object[0])).isThrownBy(() -> ks.fireAllRules()).extracting(e -> e.getCause()).isInstanceOf(UnsupportedOperationException.class);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testOverrideType3(VirtualPropertyMode mode) {
        String drl = "package org.drools.compiler.trait.test; \nimport org.drools.base.factmodel.traits.Traitable; \ndeclare trait Foo end\ndeclare trait Bar end \ndeclare trait Mask fld : Foo end \ndeclare Face @Traitable fld : Bar end \nrule Don when then\n  Face face = new Face(); \n  don(face, Mask.class); \nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ((ThrowableTypeAssert)Assertions.assertThatException().as("An exception was expected since a trait can't override the type of a core class field with these settings ", new Object[0])).isThrownBy(() -> ks.fireAllRules()).extracting(e -> e.getCause()).isInstanceOf(UnsupportedOperationException.class);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitLegacy(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitLegacyTrait.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        this.printDebugInfoSessionObjects(ks.getObjects(), info);
        Assertions.assertThat(info).hasSize(5);
        Assertions.assertThat(info).contains((Object[])new String[]{"OK"});
        Assertions.assertThat(info).contains((Object[])new String[]{"OK2"});
        Assertions.assertThat(info).contains((Object[])new String[]{"OK3"});
        Assertions.assertThat(info).contains((Object[])new String[]{"OK4"});
        Assertions.assertThat(info).contains((Object[])new String[]{"OK5"});
    }

    private void printDebugInfoSessionObjects(Collection<? extends Object> facts, List<? extends Object> globalList) {
        LOGGER.debug(" -------------- " + facts.size() + " ---------------- ");
        for (Object object : facts) {
            LOGGER.debug("\t\t" + object);
        }
        LOGGER.debug(" --------------  ---------------- ");
        LOGGER.debug(globalList.toString());
        LOGGER.debug(" --------------  ---------------- ");
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitCollections(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitCollections.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        this.printDebugInfoSessionObjects(ks.getObjects(), info);
        Assertions.assertThat(info).hasSize(1);
        Assertions.assertThat(info).contains((Object[])new String[]{"OK"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitCore(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitLegacyCore.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        this.printDebugInfoSessionObjects(ks.getObjects(), info);
        Assertions.assertThat(info).contains((Object[])new String[]{"OK"});
        Assertions.assertThat(info).contains((Object[])new String[]{"OK2"});
        Assertions.assertThat(info).hasSize(2);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void traitWithEquality(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitWithEquality.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Assertions.assertThat(info).contains((Object[])new String[]{"DON"});
        Assertions.assertThat(info).contains((Object[])new String[]{"EQUAL"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void traitDeclared(VirtualPropertyMode mode) {
        ArrayList trueTraits = new ArrayList();
        ArrayList untrueTraits = new ArrayList();
        KieSession ks = this.getSession("org/drools/compiler/factmodel/traits/testDeclaredFactTrait.drl");
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ks.setGlobal("trueTraits", trueTraits);
        ks.setGlobal("untrueTraits", untrueTraits);
        ks.fireAllRules();
        ks.dispose();
        Assertions.assertThat(trueTraits).contains((Object[])new Integer[]{1});
        Assertions.assertThat(trueTraits).doesNotContain((Object[])new Integer[]{2});
        Assertions.assertThat(untrueTraits).contains((Object[])new Integer[]{2});
        Assertions.assertThat(untrueTraits).doesNotContain((Object[])new Integer[]{1});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void traitPojo(VirtualPropertyMode mode) {
        ArrayList trueTraits = new ArrayList();
        ArrayList untrueTraits = new ArrayList();
        KieSession session = this.getSession("org/drools/compiler/factmodel/traits/testPojoFactTrait.drl");
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)session.getKieBase());
        session.setGlobal("trueTraits", trueTraits);
        session.setGlobal("untrueTraits", untrueTraits);
        session.fireAllRules();
        session.dispose();
        Assertions.assertThat(trueTraits).contains((Object[])new Integer[]{1});
        Assertions.assertThat(trueTraits).doesNotContain((Object[])new Integer[]{2});
        Assertions.assertThat(untrueTraits).contains((Object[])new Integer[]{2});
        Assertions.assertThat(untrueTraits).doesNotContain((Object[])new Integer[]{1});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsAOperator(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitIsA2.drl";
        KieSession ksession = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        Person student = new Person("student", 18);
        ksession.insert((Object)student);
        ksession.fireAllRules();
        ArgumentCaptor cap = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        List values = cap.getAllValues();
        Assertions.assertThat((String)((AfterMatchFiredEvent)values.get(0)).getMatch().getRule().getName()).isEqualTo("create student");
        Assertions.assertThat((String)((AfterMatchFiredEvent)values.get(1)).getMatch().getRule().getName()).isEqualTo("print student");
        Assertions.assertThat((String)((AfterMatchFiredEvent)values.get(2)).getMatch().getRule().getName()).isEqualTo("print school");
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testManyTraits(VirtualPropertyMode mode) {
        String source = "import " + Message.class.getCanonicalName() + ";\nglobal java.util.List list; \ndeclare Message\n      @Traitable\n    end\n\n    declare trait NiceMessage\n       message : String\n    end\nrule \"Nice\"\nwhen\n  $n : NiceMessage($m : message)\nthen\nend\n    rule load\n        when\n\n        then\n            Message message = new Message();\n            message.setMessage(\"Hello World\");\n            insert(message);\n            don(message, NiceMessage.class);\n\n            Message unreadMessage = new Message();\n            unreadMessage.setMessage(\"unread\");\n            insert(unreadMessage);\n            don(unreadMessage, NiceMessage.class);\n\n            Message oldMessage = new Message();\n            oldMessage.setMessage(\"old\");\n            insert(oldMessage);\n            don(oldMessage, NiceMessage.class);            list.add(\"OK\");\n    end";
        KieSession ksession = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person student = new Person("student", 18);
        ksession.insert((Object)student);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"OK"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void traitManyTimes(VirtualPropertyMode mode) {
        KieSession ksession = this.getSession("org/drools/compiler/factmodel/traits/testTraitDonMultiple.drl");
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(2);
        Assertions.assertThat(list).hasSize(5);
        Assertions.assertThat((Integer)((Integer)list.get(0))).isEqualTo(0);
        Assertions.assertThat(list).contains((Object[])new Integer[]{1});
        Assertions.assertThat(list).contains((Object[])new Integer[]{2});
        Assertions.assertThat(list).contains((Object[])new Integer[]{3});
        Assertions.assertThat(list).contains((Object[])new Integer[]{4});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void traitsInBatchExecution(VirtualPropertyMode mode) {
        String str = "package org.jboss.qa.brms.traits\nimport org.drools.traits.compiler.Person;\nimport org.drools.base.factmodel.traits.Traitable;\nglobal java.util.List list;declare Person \n  @Traitable \nend \ndeclare trait Student\n  school : String\nend\n\nrule \"create student\" \n  when\n    $student : Person(age < 26)\n  then\n    Student s = don($student, Student.class);\n    s.setSchool(\"Masaryk University\");\nend\n\nrule \"print student\"\n  when\n    student : Person(this isA Student)\n  then    list.add(1);\nend\n\nrule \"print school\"\n  when\n    Student($school : school)\n  then\n    list.add(2);\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        ArrayList list = new ArrayList();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ksession.setGlobal("list", list);
        ArrayList<Command> commands = new ArrayList<Command>();
        Person student = new Person("student", 18);
        commands.add(CommandFactory.newInsert((Object)student));
        LOGGER.debug("Starting execution...");
        commands.add(CommandFactory.newFireAllRules());
        ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        LOGGER.debug("Finished...");
        Assertions.assertThat(list).hasSize(2);
        Assertions.assertThat(list).contains((Object[])new Integer[]{1});
        Assertions.assertThat(list).contains((Object[])new Integer[]{2});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    @Timeout(value=10000L)
    public void testManyTraitsStateless(VirtualPropertyMode mode) {
        String source = "import " + Message.class.getCanonicalName() + ";\nglobal java.util.List list; \ndeclare Message\n      @Traitable\n    end\n\n    declare trait NiceMessage\n       message : String\n    end\nrule \"Nice\"\nwhen\n  $n : NiceMessage($m : message)\nthen\nend\n    rule load\n        when\n\n        then\n            Message message = new Message();\n            message.setMessage(\"Hello World\");\n            insert(message);\n            don(message, NiceMessage.class);\n\n            Message unreadMessage = new Message();\n            unreadMessage.setMessage(\"unread\");\n            insert(unreadMessage);\n            don(unreadMessage, NiceMessage.class);\n\n            Message oldMessage = new Message();\n            oldMessage.setMessage(\"old\");\n            insert(oldMessage);\n            don(oldMessage, NiceMessage.class);            list.add(\"OK\");\n    end";
        KieBase kb = this.getKieBaseFromString(source, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kb);
        KieSession ksession = kb.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute(CommandFactory.newFireAllRules());
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"OK"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testAliasing(VirtualPropertyMode mode) {
        String drl = "package org.drools.traits\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Alias;\nglobal java.util.List list;declare Person \n  @Traitable \n  nomen     : String  @key @Alias(\"fld1\") \n  workPlace : String \n  address   : String \n  serviceYrs: int \nend \ndeclare trait Student\n  name      : String @Alias(\"fld1\") \n  school    : String  @Alias(\"workPlace\") \n  grade     : int @Alias(\"level\") \n  rank      : int @Alias(\"serviceYrs\") \nend \n\nrule \"create student\" \n  when\n  then\n    Person p = new Person(\"davide\", \"UniBoh\", \"Floor84\", 1); \n    Student s = don(p, Student.class);\nend\n\nrule \"print school\"\n  when\n    $student : Student($school : school == \"UniBoh\",  $f : fields, fields[ \"workPlace\" ] == \"UniBoh\")\n  then \n     $student.setRank(99); \n    $f.put(\"school\", \"Skool\"); \n    list.add($school);\n    list.add($f.get(\"school\"));\n    list.add($student.getSchool());\n    list.add($f.keySet());\n    list.add($f.entrySet());\n    list.add($f.values());\n    list.add($f.containsKey(\"school\"));\n    list.add($student.getRank());\n    list.add($f.get(\"address\"));\nend";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(9);
        Assertions.assertThat(list).contains(new Object[]{"UniBoh"});
        Assertions.assertThat(list).contains(new Object[]{"Skool"});
        Assertions.assertThat((Collection)((Collection)list.get(3))).contains((Object[])new String[]{"workPlace", "nomen", "level"});
        Assertions.assertThat((Collection)((Collection)list.get(5))).contains(new Object[]{"davide", "Skool", 0});
        Assertions.assertThat(list).contains(new Object[]{true});
        Assertions.assertThat(list).contains(new Object[]{"Floor84"});
        Assertions.assertThat(list).contains(new Object[]{99});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitLogicalRemoval(VirtualPropertyMode mode) {
        String drl = "package org.drools.trait.test;\n\nimport org.drools.base.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\ndeclare trait Student\n  age  : int\n  name : String\nend\n\ndeclare trait Worker\n  wage  : int\n  name : String\nend\ndeclare Person\n  @Traitable\n  name : String \nend\n\n\nrule \"Don Logical\"\nwhen\n  $s : String(this == \"trigger\")\nthen\n  Person p = new Person(\"john\");\n  insertLogical(p); \n  don(p, Student.class, true);\nend\n rule \"Don Logical 2\"\nwhen\n  $s : String(this == \"trigger2\")\n  $p : Person(name == \"john\")then\n  don($p, Worker.class, true);\nend";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle h = ksession.insert((Object)"trigger");
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(3);
        ksession.delete(h);
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ksession.getObjects()).isEmpty();
        FactHandle h1 = ksession.insert((Object)"trigger");
        FactHandle h2 = ksession.insert((Object)"trigger2");
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(5);
        ksession.delete(h2);
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(3);
        ksession.delete(h1);
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ksession.getObjects()).isEmpty();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTMSConsistencyWithNonTraitableBeans(VirtualPropertyMode mode) {
        String s1 = "package org.drools.test;\nimport org.drools.traits.compiler.Person; \nimport org.drools.base.factmodel.traits.Traitable; \ndeclare Person @Traitable end \nrule \"Init\"\nwhen\nthen\n  insertLogical(new Person(\"x\", 18));\nend\n\ndeclare trait Student\n  age  : int\n  name : String\nend\n\nrule \"Trait\"\nwhen\n    $p : Person()\nthen\n    don($p, Student.class, true);\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        KieSession ksession = kbase.newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ksession.fireAllRules();
        FactHandle personHandle = (FactHandle)ksession.getFactHandles((ObjectFilter)new ClassObjectFilter(Person.class)).iterator().next();
        InternalFactHandle h = (InternalFactHandle)personHandle;
        ObjectTypeConfigurationRegistry reg = h.getEntryPoint((ReteEvaluator)((InternalWorkingMemory)ksession)).getObjectTypeConfigurationRegistry();
        ObjectTypeConf conf = reg.getOrCreateObjectTypeConf(h.getEntryPointId(), ((InternalFactHandle)personHandle).getObject());
        Assertions.assertThat((boolean)conf.isTMSEnabled()).isTrue();
        ksession.dispose();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitsLegacyWrapperCoherence(VirtualPropertyMode mode) {
        String str = "package org.drools.trait.test; \nglobal java.util.List list; \nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.traits.compiler.factmodel.traits.TraitTest.TBean;\ndeclare TBean \n@Traitable \nend \n declare trait Mask \n  fld : String \n  xyz : int  \nend \n\n rule Init \nwhen \nthen \n  insert(new TBean(\"abc\")); \nend \nrule Don \nno-loop \nwhen \n  $b : TBean() \nthen \n  Mask m = don($b, Mask.class); \n  modify (m) { setXyz(10); } \n  list.add(m); \nend \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Collection yOld = ksession.getObjects();
        Assertions.assertThat((Collection)yOld).hasSize(2);
        Object coreOld = null;
        for (Object o : yOld) {
            if (!(o instanceof TraitableBean)) continue;
            coreOld = (TraitableBean)o;
            break;
        }
        Assertions.assertThat(coreOld).isNotNull();
        Assertions.assertThat(coreOld.getClass().getSuperclass()).isSameAs(TBean.class);
        Assertions.assertThat((String)((TBean)coreOld).getFld()).isEqualTo("abc");
        Assertions.assertThat((Map)coreOld._getDynamicProperties()).hasSize(1);
        Assertions.assertThat((Map)coreOld._getTraitMap()).hasSize(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testHasTypes(VirtualPropertyMode mode) throws Exception {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        InternalRuleBase kb = (InternalRuleBase)this.loadKnowledgeBaseFromDrlFile(source);
        TraitFactoryImpl traitBuilder = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kb);
        FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
        TraitableBean imp = (TraitableBean)impClass.newInstance();
        impClass.set((Object)imp, "name", (Object)"aaabcd");
        Class trait = kb.getFactType("org.drools.compiler.trait.test", "Student").getFactClass();
        Class trait2 = kb.getFactType("org.drools.compiler.trait.test", "Role").getFactClass();
        Assertions.assertThat((Class)trait).isNotNull();
        TraitProxyImpl proxy = (TraitProxyImpl)traitBuilder.getProxy(imp, trait, false);
        Thing thing = traitBuilder.getProxy(imp, Thing.class, false);
        TraitableBean core = proxy.getObject();
        TraitProxyImpl proxy2 = (TraitProxyImpl)traitBuilder.getProxy(imp, trait, false);
        Thing thing2 = traitBuilder.getProxy(imp, Thing.class, false);
        Assertions.assertThat((Comparable)proxy2).isSameAs((Object)proxy);
        Assertions.assertThat((Object)thing2).isSameAs((Object)thing);
        Assertions.assertThat((Collection)core.getTraits()).hasSize(2);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitRedundancy(VirtualPropertyMode mode) {
        String str = "package org.drools.traits.compiler.factmodel.traits; \nglobal java.util.List list; \ndeclare trait IStudent end \ndeclare org.drools.traits.compiler.factmodel.traits.IPerson @typesafe(false) end \nrule \"Students\" \nsalience -10when \n   $s : IStudent() \nthen \nend \nrule \"Don\" \nno-loop  \nwhen \n  $p : IPerson(age < 30) \nthen \n   don($p, IStudent.class);\nend \nrule \"Check\" \nno-loop \nwhen \n  $p : IPerson(this isA IStudent) \nthen \n   modify ($p) { setAge(37); } \n   shed($p, IStudent.class);\nend \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new StudentImpl("skool", "john", 27));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void traitSimpleTypes(VirtualPropertyMode mode) {
        String s1 = "package org.drools.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\ndeclare trait PassMark\nend\n\ndeclare ExamMark \n@Traitable\nvalue : long \nend\nrule \"testTraitFieldTypePrimitive\"\nwhen\n    $mark : ExamMark()\nthen\n    don($mark, PassMark.class);\nend\nrule \"Init\" when then insert(new ExamMark()); end \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            if (o instanceof TraitableBean) {
                TraitableBean tb = (TraitableBean)o;
                Assertions.assertThat((Map)tb._getTraitMap()).hasSize(1);
                BitSet bs = new BitSet();
                bs.set(0);
                Assertions.assertThat((Object)tb.getCurrentTypeCode()).isEqualTo((Object)bs);
            }
            if (!(o instanceof TraitProxyImpl)) continue;
            TraitProxyImpl tp = (TraitProxyImpl)o;
            Assertions.assertThat((Collection)tp.listAssignedOtnTypeCodes()).isEmpty();
        }
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitEncoding(VirtualPropertyMode mode) {
        String s1 = "package org.drools.base.factmodel.traits;\nimport " + Entity.class.getCanonicalName() + ";\ndeclare trait A end\ndeclare trait B extends A end\ndeclare trait C extends A end\ndeclare trait D extends A end\ndeclare trait E extends B end\ndeclare trait F extends C end\ndeclare trait G extends D end\ndeclare trait H extends D end\ndeclare trait I extends E end\ndeclare trait J extends F end\ndeclare trait K extends G, H end\ndeclare trait L extends G, H end\ndeclare trait M extends I, J end\ndeclare trait N extends K, L end\nrule \"donOneThing\"\nwhen\n    $x : Entity()\nthen\n    don($x, A.class);\nend\nrule \"donManyThing\"\nwhen\n    String(this == \"y\") \n    $x : Entity()\nthen\n    don($x, B.class);\n    don($x, D.class);\n    don($x, F.class);\n    don($x, E.class);\n    don($x, I.class);\n    don($x, K.class);\n    don($x, J.class);\n    don($x, C.class);\n    don($x, H.class);\n    don($x, G.class);\n    don($x, L.class);\n    don($x, M.class);\n    don($x, N.class);\nend\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kbase);
        TraitRegistryImpl tr = (TraitRegistryImpl)((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry((RuleBase)kbase);
        LOGGER.debug(tr.getHierarchy().toString());
        Entity ent = new Entity("x");
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)ent);
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ent.getMostSpecificTraits()).hasSize(1);
        ksession.insert((Object)"y");
        ksession.fireAllRules();
        LOGGER.debug(ent.getMostSpecificTraits().toString());
        Assertions.assertThat((Collection)ent.getMostSpecificTraits()).hasSize(2);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitActualTypeCodeWithEntities(VirtualPropertyMode mode) {
        this.testTraitActualTypeCodeWithEntities("ent", mode);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitActualTypeCodeWithCoreMap(VirtualPropertyMode mode) {
        this.testTraitActualTypeCodeWithEntities("kor", mode);
    }

    void testTraitActualTypeCodeWithEntities(String trig, VirtualPropertyMode mode) {
        KieBase kbase = this.loadKnowledgeBaseFromDrlFile("org/drools/compiler/factmodel/traits/testComplexDonShed.drl");
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)trig);
        ksession.fireAllRules();
        TraitableBean ent = (TraitableBean)ksession.getGlobal("core");
        Assertions.assertThat((Object)ent.getCurrentTypeCode()).isEqualTo((Object)CodedHierarchyImpl.stringToBitSet((String)"1"));
        ksession.insert((Object)"b");
        ksession.fireAllRules();
        Assertions.assertThat((Object)ent.getCurrentTypeCode()).isEqualTo((Object)CodedHierarchyImpl.stringToBitSet((String)"11"));
        ksession.insert((Object)"c");
        ksession.fireAllRules();
        Assertions.assertThat((Object)ent.getCurrentTypeCode()).isEqualTo((Object)CodedHierarchyImpl.stringToBitSet((String)"1011"));
        ksession.insert((Object)"e");
        ksession.fireAllRules();
        Assertions.assertThat((Object)ent.getCurrentTypeCode()).isEqualTo((Object)CodedHierarchyImpl.stringToBitSet((String)"11011"));
        ksession.insert((Object)"-c");
        ksession.fireAllRules();
        Assertions.assertThat((Object)ent.getCurrentTypeCode()).isEqualTo((Object)CodedHierarchyImpl.stringToBitSet((String)"11"));
        ksession.insert((Object)"dg");
        ksession.fireAllRules();
        Assertions.assertThat((Object)ent.getCurrentTypeCode()).isEqualTo((Object)CodedHierarchyImpl.stringToBitSet((String)"111111"));
        ksession.insert((Object)"-f");
        ksession.fireAllRules();
        Assertions.assertThat((Object)ent.getCurrentTypeCode()).isEqualTo((Object)CodedHierarchyImpl.stringToBitSet((String)"111"));
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitModifyCore(VirtualPropertyMode mode) {
        String s1 = "package test; import org.drools.base.factmodel.traits.*; global java.util.List list; declare trait Student @PropertyReactive name : String end declare trait Worker @PropertyReactive name : String end declare trait StudentWorker extends Student, Worker @PropertyReactive name : String end declare trait Assistant extends Student, Worker @PropertyReactive name : String end declare Person @Traitable name : String end rule \"Init\"  when  then    Person p = new Person(\"john\");    insert(p);  end  rule \"Don\"  no-loop  when    $p : Person(name == \"john\")  then    don($p, Student.class);    don($p, Worker.class);    don($p, StudentWorker.class);    don($p, Assistant.class);  end  rule \"Log S\"  when    $t : Student() @Watch(name) then    list.add($t.getName());  end  rule \"Log W\"  when    $t : Worker() @Watch(name) then    list.add($t.getName());  end  rule \"Log SW\"  when    $t : StudentWorker() @Watch(name) then    list.add($t.getName());  end  rule \"Log RA\"  when    $t : Assistant() @Watch(name) then    list.add($t.getName());  end  rule \"Mod\"  salience -10  when    $p : Person(name == \"john\") then     modify ($p) { setName(\"alan\"); } end  ";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        int k = ksession.fireAllRules();
        Assertions.assertThat((int)k).isEqualTo(11);
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"john", "john", "john", "john", "alan", "alan", "alan", "alan"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitModifyCore2(VirtualPropertyMode mode) {
        String s1 = "package test; import org.drools.base.factmodel.traits.*; declare trait Student @propertyReactive name : String end declare trait Worker @propertyReactive name : String end declare trait StudentWorker extends Student, Worker @propertyReactive name : String end declare trait StudentWorker2 extends StudentWorker @propertyReactive name : String end declare trait Assistant extends Student, Worker @propertyReactive name : String end declare Person @Traitable @propertyReactive name : String end rule \"Init\"  when  then    Person p = new Person(\"john\");    insert(p);  end  rule \"Don\"  when    $p : Person(name == \"john\")  then    don($p, Worker.class);    don($p, StudentWorker2.class);    don($p, Assistant.class);  end  rule \"Log S\"  when    $t : Student() @watch(name)  then  end  rule \"Log W\"  when    $t : Worker() @watch(name)  then  end  rule \"Log SW\"  when    $t : StudentWorker() @watch(name)  then  end  rule \"Log RA\"  when    $t : Assistant() @watch(name)  then  end  rule \"Log Px\"  salience -1  when    $p : Person() @watch(name)  then  end  rule \"Mod\"  salience -10  when    String(this == \"go\")    $p : Student(name == \"john\")  then    modify ($p) { setName(\"alan\"); } end  ";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        int k = ksession.fireAllRules();
        Assertions.assertThat((int)k).isEqualTo(7);
        ksession.insert((Object)"go");
        k = ksession.fireAllRules();
        Assertions.assertThat((int)k).isEqualTo(6);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitModifyCore2a(VirtualPropertyMode mode) {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list; \ndeclare trait Student @propertyReactive name : String end\ndeclare trait Worker @propertyReactive name : String end\ndeclare trait StudentWorker extends Student, Worker @propertyReactive name : String end\ndeclare trait Assistant extends Student, Worker @propertyReactive name : String end\ndeclare Person @Traitable @propertyReactive name : String end\nrule \"Init\" \nwhen \nthen \n  Person p = new Person(\"john\"); \n  insert(p); \nend \nrule \"Don\" \nwhen \n  $p : Person(name == \"john\") \nthen \n  don($p, Worker.class); \n  don($p, StudentWorker.class); \nend \nrule \"Log W\" \nwhen \n  $t : Worker(this isA StudentWorker) @watch(name) \nthen \n  list.add(true); \nend \nrule \"Log SW\" \nwhen \n  $t : StudentWorker() @watch(name) \nthen \nend \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new Boolean[]{true});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitModifyCore3(VirtualPropertyMode mode) {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list; \ndeclare trait A id : int end\ndeclare trait B extends A end\ndeclare trait C extends A end\ndeclare trait D extends A end\ndeclare trait E extends B end\ndeclare trait F extends C end\ndeclare trait G extends D end\ndeclare trait H extends D end\ndeclare trait I extends E end\ndeclare trait J extends F end\ndeclare trait K extends G, H end\ndeclare trait L extends G, H end\ndeclare trait M extends I, J end\ndeclare trait N extends K, L end\ndeclare Core @Traitable id : int = 0 end \nrule \"Init\" when \nthen \n   insert(new Core());end \nrule \"donManyThing\"\nwhen\n    $x : Core(id == 0)\nthen\n    don($x, A.class);\n    don($x, B.class);\n    don($x, D.class);\n    don($x, F.class);\n    don($x, E.class);\n    don($x, I.class);\n    don($x, K.class);\n    don($x, J.class);\n    don($x, C.class);\n    don($x, H.class);\n    don($x, G.class);\n    don($x, L.class);\n    don($x, M.class);\n    don($x, N.class);\nend\n\n\n\nrule \"Log A\" when $x : A(id == 1) then list.add(1); end \nrule \"Log B\" when $x : B(id == 1) then list.add(2); end \nrule \"Log C\" when $x : C(id == 1) then list.add(3); end \nrule \"Log D\" when $x : D(id == 1) then list.add(4); end \nrule \"Log E\" when $x : E(id == 1) then list.add(5); end \nrule \"Log F\" when $x : F(id == 1) then list.add(6); end \nrule \"Log G\" when $x : G(id == 1) then list.add(7); end \nrule \"Log H\" when $x : H(id == 1) then list.add(8); end \nrule \"Log I\" when $x : I(id == 1) then list.add(9); end \nrule \"Log J\" when $x : J(id == 1) then list.add(10); end \nrule \"Log K\" when $x : K(id == 1) then list.add(11); end \nrule \"Log L\" when $x : L(id == 1) then list.add(12); end \nrule \"Log M\" when $x : M(id == 1) then list.add(13); end \nrule \"Log N\" when $x : N(id == 1) then list.add(14); end \nrule \"Log Core\" when $x : Core($id : id) then end \nrule \"Mod\" \nsalience -10 \nwhen \n  String(this == \"go\") \n  $x : Core(id == 0) \nthen \n  modify ($x) { setId(1); }end \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(14);
        for (int j = 1; j <= 14; ++j) {
            Assertions.assertThat(list).contains((Object[])new Integer[]{j});
        }
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitModifyCoreWithPropertyReactivity(VirtualPropertyMode mode) {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list;\ndeclare trait Student @propertyReactive    name : String    age : int    grades : double    school : String    aaa : boolean end\ndeclare trait Worker @propertyReactive    name : String    wage : double end\ndeclare trait StudentWorker extends Student, Worker @propertyReactive    hours : int end\ndeclare trait Assistant extends Student, Worker @propertyReactive    address : String end\ndeclare Person @propertyReactive @Traitable    wage : double    name : String    age : int  end\nrule \"Init\" \nwhen \nthen \n  Person p = new Person(109.99, \"john\", 18); \n  insert(p); \nend \nrule \"Don\" \nwhen \n  $p : Person(name == \"john\") \nthen \n  don($p, StudentWorker.class); \n  don($p, Assistant.class); \nend \nrule \"Log S\" \nwhen \n  $t : Student(age == 44) \nthen \n  list.add(1);\n end \nrule \"Log W\" \nwhen \n  $t : Worker(name == \"alan\") \nthen \n  list.add(2);\n end \nrule \"Log SW\" \nwhen \n  $t : StudentWorker(age == 44) \nthen \n  list.add(3);\n end \nrule \"Log Pers\" \nwhen \n  $t : Person(age == 44) \nthen \n  list.add(4);\n end \nrule \"Mod\" \nsalience -10 \nwhen \n  String(this == \"go\") \n  $p : Student(name == \"john\") \nthen \n  modify ($p) { setSchool(\"myschool\"), setAge(44), setName(\"alan\"); } end \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        int k = ksession.fireAllRules();
        ksession.insert((Object)"go");
        k = ksession.fireAllRules();
        Assertions.assertThat((int)k).isEqualTo(5);
        Assertions.assertThat(list).hasSize(4);
        Assertions.assertThat(list).contains((Object[])new Integer[]{1, 2, 3, 4});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitEncodeExtendingNonTrait(VirtualPropertyMode mode) {
        String s1 = "package test;\nimport " + IntfParent.class.getCanonicalName() + ";\ndeclare IntfParent end\ndeclare trait TChild extends IntfParent end \n";
        String s2 = "package test; declare trait SomeThing end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder2.hasErrors()) {
            Assertions.fail((String)kbuilder2.getErrors().toString());
        }
        kbase.addPackages(kbuilder2.getKnowledgePackages());
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void isAWithBackChaining(VirtualPropertyMode mode) {
        String source = "org/drools/compiler/factmodel/traits/testTraitIsAWithBC.drl";
        KieSession ksession = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.insert((Object)"Como");
        ksession.fireAllRules();
        Assertions.assertThat(list).contains((Object[])new String[]{"Italy"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsAEvaluatorOnClassification(VirtualPropertyMode mode) {
        String source = "package t.x \n\nglobal java.util.List list; \nimport org.drools.base.factmodel.traits.Thing\nimport org.drools.traits.core.factmodel.Entity\n\ndeclare trait t.x.D\n    @propertyReactive\n\nend\ndeclare trait t.x.E\n    @propertyReactive\n\nend\nrule Init when\nthen\n   Entity o = new Entity();\n   insert(o);\n   don(o, D.class); \nend\nrule Don when\n $o : Entity() \nthen \nend \nrule \"Rule 0 >> http://t/x#D\"\nwhen\n   $t : org.drools.base.factmodel.traits.Thing($c : core, this not isA t.x.E.class, this isA t.x.D.class) then\n   list.add(\"E\"); \n   don($t, E.class); \nend\nrule React \nwhen E() then \n   list.add(\"X\"); \nend \n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(2);
        Assertions.assertThat(list).contains((Object[])new String[]{"E", "X"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testShedWithTMS(VirtualPropertyMode mode) {
        String source = "package t.x \n\nglobal java.util.List list; \nimport org.drools.base.factmodel.traits.Thing\nimport org.drools.traits.core.factmodel.Entity\n\ndeclare trait t.x.D\n    @propertyReactive\n\nend\ndeclare trait t.x.E\n    @propertyReactive\n\nend\nrule Init when\nthen\n   Entity o = new Entity();\n   insert(o);\n   don(o, Thing.class); \n   don(o, D.class); \nend\nrule Don when\n $o : Entity() \nthen \nend \nrule \"Rule 0 >> http://t/x#D\"\nwhen\n   $t : org.drools.base.factmodel.traits.Thing($c : core, _isTop(), this not isA t.x.E.class, this isA t.x.D.class) then\n   list.add(\"E\"); \n   don($t, E.class); \nend\nrule React \nwhen $x : E() then \n   list.add(\"X\"); \nend \nrule Shed \nwhen \n   $s : String() \n   $d : Entity() \nthen \n   delete($s); \n   shed($d, D.class);\nend \n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat(list).hasSize(2);
        Assertions.assertThat(list).contains((Object[])new String[]{"E", "X"});
        ks.insert((Object)"shed");
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat((Collection)ks.getObjects()).hasSize(3);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitInitialization(VirtualPropertyMode mode) {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.base.factmodel.traits.Thing \nimport org.drools.base.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait Foo\n   hardList : List = new ArrayList() \n   softList : List = new ArrayList() \n   moreList : List = new ArrayList() \n   otraList : List = new ArrayList() \n   primFld  : int = 3 \n   primDbl  : double = 0.421 \n\nend\ndeclare Bar\n   @Traitable()\n   hardList : List \n   moreList : List = Arrays.asList(1, 2, 3) \n\nend\nrule Init when\nthen\n   Bar o = new Bar();\n   insert(o);\n   Thing t = don(o, Thing.class); \n   t.getFields().put(\"otraList\", Arrays.asList(42)); \n   don(o, Foo.class); \nend\nrule Don when\n   $x : Foo($h : hardList, $s : softList, $o : otraList, $m : moreList, $i : primFld, $d : primDbl) \nthen \n   list.add($h); \n   list.add($s); \n   list.add($o); \n   list.add($m); \n   list.add($i); \n   list.add($d); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(6);
        Assertions.assertThat(list).doesNotContainNull();
        List hard = (List)list.get(0);
        List soft = (List)list.get(1);
        List otra = (List)list.get(2);
        List more = (List)list.get(3);
        Assertions.assertThat((List)hard).isEmpty();
        Assertions.assertThat((List)soft).isEmpty();
        Assertions.assertThat((List)more).containsExactly((Object[])new Integer[]{1, 2, 3});
        Assertions.assertThat((List)otra).containsExactly((Object[])new Integer[]{42});
        Assertions.assertThat(list).contains(new Object[]{3});
        Assertions.assertThat(list).contains(new Object[]{0.421});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testUnTraitedBean(VirtualPropertyMode mode) {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.base.factmodel.traits.Thing \nimport org.drools.base.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait Foo end\ndeclare Bar\n   @Traitable\nend\ndeclare Bar2\nend\nrule Init when\nthen\n   Bar o = new Bar();\n   insert(o);\n   Bar2 o2 = new Bar2();\n   insert(o2);\nend\nrule Check when\n   $x : Bar(this not isA Foo) \nthen \nend\nrule Check2 when\n   $x : Bar2(this not isA Foo) \nthen \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsAOptimization(VirtualPropertyMode mode) {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.base.factmodel.traits.Thing \nimport org.drools.base.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A end\ndeclare trait B extends A end\ndeclare trait C extends B end\ndeclare trait D extends A end\ndeclare trait E extends C, D end\ndeclare trait F extends E end\ndeclare Kore\n   @Traitable\nend\nrule Init when\nthen\n   Kore k = new Kore();\n   don(k, E.class); \nend\nrule Check_1 when\n   $x : Kore(this isA [ B, D ]) \nthen \n   list.add(\" B+D \"); \nend\nrule Check_2 when\n   $x : Kore(this isA [ A ]) \nthen \n   list.add(\" A \"); \nend\nrule Check_3 when\n   $x : Kore(this not isA [ F ]) \nthen \n   list.add(\" F \"); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTypeRefractionOnInsert(VirtualPropertyMode mode) {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.base.factmodel.traits.Thing \nimport org.drools.base.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A @propertyReactive end\ndeclare trait B extends A @propertyReactive end\ndeclare trait C extends B @propertyReactive end\ndeclare trait D extends A @propertyReactive end\ndeclare trait E extends C, D @propertyReactive end\ndeclare trait F extends E @propertyReactive end\ndeclare Kore\n   @Traitable\nend\nrule Init when\nthen\n   Kore k = new Kore();\n   don(k, B.class); \n   don(k, C.class); \n   don(k, D.class); \n   don(k, E.class); \n   don(k, A.class); \n   don(k, F.class); \nend\nrule Check_1 when\n   $x : A() \nthen \n   list.add($x); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTypeRefractionOnQuery(VirtualPropertyMode mode) {
        String source = "declare BaseObject\n@Traitable\nid : String @key\nend\n\ndeclare trait A\nid : String @key\nend\n\ndeclare trait B extends A\nend\n\ndeclare trait C extends A\nend\n\nrule \"init\"\nwhen\nthen\nBaseObject $obj = new BaseObject(\"testid123\");\ninsert ($obj);\ndon($obj, B.class, true);\ndon($obj, C.class, true);\nend\n\nquery \"QueryTraitA\"\na : A()\nend";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ks.fireAllRules();
        QueryResults res = ks.getQueryResults("QueryTraitA", new Object[0]);
        Assertions.assertThat((Iterable)res).hasSize(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTypeRefractionOnQuery2(VirtualPropertyMode mode) {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.base.factmodel.traits.Thing \nimport org.drools.base.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A end\ndeclare trait B extends A end\ndeclare trait C extends B end\ndeclare trait D extends A end\ndeclare trait E extends C, D end\ndeclare trait F extends E end\ndeclare trait G extends A end\ndeclare Kore\n   @Traitable\nend\nrule Init when\nthen\n   Kore k = new Kore();\n   don(k, C.class); \n   don(k, D.class); \n   don(k, E.class); \n   don(k, B.class); \n   don(k, A.class); \n   don(k, F.class); \n   don(k, G.class); \n   shed(k, B.class); \nend\nrule RuleA\nwhen \n   $x : A() \nthen \nend\n \nquery queryA1\n   $x := A() \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        QueryResults res = ks.getQueryResults("queryA1", new Object[0]);
        Assertions.assertThat((Iterable)res).hasSize(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testNodePartitioningByProxies(VirtualPropertyMode mode) {
        Object source = "package t.x  import java.util.*;  import org.drools.base.factmodel.traits.Thing  import org.drools.base.factmodel.traits.Traitable   global java.util.List list;   declare trait A @PropertyReactive end declare trait B extends A @PropertyReactive end declare trait C extends B @PropertyReactive end declare trait D extends A @PropertyReactive end declare trait E extends C, D @PropertyReactive end declare trait F extends E @PropertyReactive end declare trait G extends A @PropertyReactive end declare Kore    @Traitable end rule Init when then    Kore k = new Kore();    don(k, C.class);     don(k, D.class);     don(k, B.class);     don(k, A.class);     don(k, F.class);     don(k, E.class);     don(k, G.class);  end ";
        for (char c = 'A'; c <= 'G'; c = (char)(c + '\u0001')) {
            String C = "" + c;
            source = (String)source + "rule Rule" + C + " when " + C + "() then list.add('" + C + "'); end ";
        }
        source = (String)source + "rule RuleAll when     A() B() C() D() E() F() G() then     list.add('Z'); end ";
        KieSession ks = this.getSessionFromString((String)source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat(list).containsExactly((Object[])new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('Z')});
        for (Object o : ks.getObjects(object -> object instanceof TraitableBean)) {
            Set<BitSet> otns = this.checkOTNPartitioning((TraitableBean)o, ks);
            Assertions.assertThat(otns).hasSize(7);
        }
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testNodePartitioningByProxiesAfterShed(VirtualPropertyMode mode) {
        Object source = "package t.x  import java.util.*;  import org.drools.base.factmodel.traits.Thing  \nimport org.drools.base.factmodel.traits.Traitable  \n global java.util.List list;  \n declare trait A end \ndeclare trait B extends A end \ndeclare trait C extends B end \ndeclare trait D extends A end \ndeclare trait E extends C, D end \ndeclare trait F extends E end \ndeclare trait G extends A end \ndeclare Kore \n   @Traitable \nend \nrule Init when \nthen \n   Kore k = new Kore(); \n   don(k, C.class);  \n   don(k, D.class);  \n   don(k, B.class);  \n   don(k, A.class);  \n   don(k, F.class);  \n   don(k, E.class);  \n   don(k, G.class);  \n   shed(k, B.class);  \nend \n";
        for (char c = 'A'; c <= 'G'; c = (char)(c + '\u0001')) {
            String C = "" + c;
            source = (String)source + "rule Rule" + C + " when \n" + C + "() \nthen\n System.out.println(\"Rule " + C + "\");\n list.add('" + C + "'); \nend \n";
        }
        source = (String)source + "rule RuleAll \nwhen  \n   A() D() G() \nthen  \n   list.add('Z'); \nend \n";
        System.out.println((String)source);
        KieSession ks = this.getSessionFromString((String)source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat(list).containsExactly((Object[])new Character[]{Character.valueOf('A'), Character.valueOf('D'), Character.valueOf('G'), Character.valueOf('Z')});
        for (Object o : ks.getObjects(object -> object instanceof TraitableBean)) {
            Set<BitSet> otns = this.checkOTNPartitioning((TraitableBean)o, ks);
            Assertions.assertThat(otns).hasSize(3);
        }
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTypeRefractionOnQueryWithIsA(VirtualPropertyMode mode) {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.base.factmodel.traits.Thing \nimport org.drools.base.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A @propertyReactive end\ndeclare trait B extends A @propertyReactive end\ndeclare trait C extends B @propertyReactive end\ndeclare trait D extends A @propertyReactive end\ndeclare trait E extends C, D @propertyReactive end\ndeclare trait F extends E @propertyReactive end\ndeclare Kore\n   @Traitable\nend\nrule Init when\nthen\n   Kore k = new Kore();\n   don(k, C.class); \n   don(k, D.class); \n   don(k, E.class); \n   don(k, B.class); \n   don(k, A.class); \n   don(k, F.class); \n   shed(k, B.class); \nend\n \nquery queryA\n   $x := Kore(this isA A) \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        QueryResults res = ks.getQueryResults("queryA", new Object[0]);
        Iterator iter = res.iterator();
        Object a = ((QueryResultsRow)iter.next()).get("$x");
        Assertions.assertThat((Iterator)iter).isExhausted();
        Assertions.assertThat((Iterable)res).hasSize(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testCoreUpdate4(VirtualPropertyMode mode) {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.base.factmodel.traits.Thing \nimport org.drools.base.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A    age : int \nend\ndeclare Kore\n   @Traitable\n   @propertyReactive   age : int\nend\nrule Init \nwhen\nthen\n   Kore k = new Kore(44);\n   insert(k); \nend\nrule Don \nno-loop \nwhen\n   $x : Kore() \nthen \n   don($x, A.class); \nend\nrule React \nsalience 1when\n   $x : Kore(this isA A.class) \nthen \n   list.add($x); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat(list).hasSize(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void traitLogicalSupportAnddelete(VirtualPropertyMode mode) {
        String drl = "package org.drools.trait.test;\n\nimport org.drools.base.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\ndeclare trait Student\n  age  : int\n  name : String\nend\n\ndeclare Person\n  @Traitable\n  name : String\nend\n\nrule Init when then insert(new Person(\"john\")); end \nrule \"Don Logical\"\nwhen\n  $s : String(this == \"trigger1\")\n  $p : Person() \nthen\n  don($p, Student.class, true);\nend\nrule \"Don Logical2\"\nwhen\n  $s : String(this == \"trigger2\")\n  $p : Person() \nthen\n  don($p, Student.class, true);\nend\nrule \"Undon \"\nwhen\n  $s : String(this == \"trigger3\")\n  $p : Person() \nthen\n  shed($p, org.drools.base.factmodel.traits.Thing.class);   delete($s); \nend\n rule \"Don Logical3\"\nwhen\n  $s : String(this == \"trigger4\")\n  $p : Person() \nthen\n  don($p, Student.class, true);end\n rule \"Undon 2\"\nwhen\n  $s : String(this == \"trigger5\")\n  $p : Person() \nthen\n  delete($s); \n  delete($p); \nend\n";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle h1 = ksession.insert((Object)"trigger1");
        FactHandle h2 = ksession.insert((Object)"trigger2");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        LOGGER.debug("---------------------------------");
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(4);
        ksession.delete(h1);
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        LOGGER.debug("---------------------------------");
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(3);
        ksession.delete(h2);
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        LOGGER.debug("---------------------------------");
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(1);
        ksession.insert((Object)"trigger3");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        LOGGER.debug("---------------------------------");
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(1);
        ksession.insert((Object)"trigger4");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        LOGGER.debug("---------------------------------");
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(3);
        ksession.insert((Object)"trigger5");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        LOGGER.debug("---------------------------------");
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testShedThing(VirtualPropertyMode mode) {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list; \ndeclare trait A id : int end\ndeclare trait B extends A end\ndeclare trait C extends A end\ndeclare trait D extends A end\ndeclare trait E extends B end\ndeclare Core @Traitable id : int = 0 end \nrule \"Init\" when \nthen \n   insert(new Core());end \nrule \"donManyThing\"\nwhen\n    $x : Core(id == 0)\nthen\n    don($x, A.class);\n    don($x, B.class);\n    don($x, C.class);\n    don($x, D.class);\n    don($x, E.class);\nend\n\n\nrule \"Mod\" \nsalience -10 \nwhen \n  $g : String(this == \"go\") \n  $x : Core(id == 0) \nthen \n  shed($x, Thing.class);   delete($g); \n\nend \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testdeleteThings(VirtualPropertyMode mode) {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list; \ndeclare trait A id : int end\ndeclare trait B extends A end\ndeclare trait C extends A end\ndeclare trait D extends A end\ndeclare trait E extends B end\ndeclare Core @Traitable id : int = 0 end \nrule \"Init\" when \nthen \n   insert(new Core());end \nrule \"donManyThing\"\nwhen\n    $x : Core(id == 0)\nthen\n    don($x, A.class);\n    don($x, B.class);\n    don($x, C.class);\n    don($x, D.class);\n    don($x, E.class);\nend\n\n\nrule \"Mod\" \nsalience -10 \nwhen \n  $g : String(this == \"go\") \n  $x : Core(id == 0) \nthen \n  delete($x); \n\n  delete($g); \n\nend \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(s1);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat((Collection)ksession.getObjects()).isEmpty();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void traitLogicalRemovalSimple(VirtualPropertyMode mode) {
        String drl = "package org.drools.compiler.trait.test;\n\nimport org.drools.base.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\ndeclare trait Student\n age : int\n name : String\nend\ndeclare trait Worker\n wage : int\nend\ndeclare trait Scholar extends Student\nend\n\ndeclare Person\n @Traitable\n name : String\nend\n\n\nrule \"Don Logical\"\nwhen\n $s : String(this == \"trigger\")\nthen\n Person p = new Person(\"john\");\n insert(p); \n don(p, Student.class, true);\n don(p, Worker.class);\n don(p, Scholar.class);\nend";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle h = ksession.insert((Object)"trigger");
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(5);
        ksession.delete(h);
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(3);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitDonLegacyClassWithoutEmptyConstructor(VirtualPropertyMode mode) {
        String drl = "package org.drools.compiler.trait.test;\n\nimport " + TraitableFoo.class.getCanonicalName() + ";import org.drools.base.factmodel.traits.Traitable;\n\ndeclare trait Bar\nend\n\nrule \"Don\"\nno-loop \nwhen\n $f : TraitableFoo()\nthen\n  Bar b = don($f, Bar.class);\nend";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        ksession.insert((Object)new TraitableFoo("xx", 0, null));
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(2);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testdeleteCoreObjectChained(VirtualPropertyMode mode) {
        String source = "package org.drools.test;\nimport java.util.List; \nimport org.drools.base.factmodel.traits.Thing \nimport org.drools.base.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A    age : int \nend\ndeclare Kore\n   @Traitable\n   age : int\nend\nrule Init \nwhen\n   $s : String() \nthen\n   Kore k = new Kore(44);\n   insertLogical(k); \nend\nrule Don \nno-loop \nwhen\n   $x : Kore() \nthen \n   don($x, A.class); \nend\nrule delete \nsalience -99 \nwhen \n   $x : String() \nthen \n   delete($x); \nend \n\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.insert((Object)"go");
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat((Collection)ks.getObjects()).isEmpty();
        ks.dispose();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testUpdateLegacyClass(VirtualPropertyMode mode) {
        String source = "package org.drools.text;\n\nglobal java.util.List list;\n\nimport org.drools.traits.compiler.Person;\nimport org.drools.base.factmodel.traits.Traitable;\n\ndeclare Person @Traitable end \ndeclare trait Student\n  name : String\nend\n\nrule \"Init\"\nsalience 10 \nwhen\n  $p : Person(this not isA Student)\nthen\n  don($p, Student.class);\nend\n\nrule \"Go\"\nwhen\n  $s : String(this == \"X\")\n  $p : Person()\nthen\n  delete($s); \n  modify($p) { setName($s); }\nend\n\nrule \"Mod\"\nwhen\n  Student(name == \"X\")\nthen\n  list.add(0);\nend";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.insert((Object)new Person("john", 32));
        ks.insert((Object)"X");
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new Integer[]{0});
        ks.dispose();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testSoftPropertyClash(VirtualPropertyMode mode) {
        String source = "package org.drools.text;\n\nglobal java.util.List list;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Alias;\n\ndeclare Person @Traitable @propertyReactive \nend \ndeclare trait Student\n   @propertyReactive \n   id : String = \"a\" \n   fld2 : int = 4 \n   fld3 : double = 4.0 \n   fld4 : String = \"hello\" \n   fldZ : String = \"hello\" @Alias(\"fld5\")\nend\ndeclare trait Worker\n   @propertyReactive \n   id : int = 3 \n   fld2 : String = \"b\" \n    fld3 : int = 11 \n    fld4 : Class = Object.class \n    fldY : int = 42 @Alias(\"fld5\")\nend\nrule \"Init\" when then \n   insert(new Person()); \nend \n\nrule \"Don\"\nwhen\n   $p : Person() \nthen\n  Student $s = (Student) don($p, Student.class);\n  modify ($s) { setId(\"xyz\"); }     Worker $w = don($p, Worker.class);\n  modify ($w) { setId(99); } end\n\nrule \"Stud\"\nwhen\n  $s : Student($sid : id == \"xyz\", $f2 : fld2, $f3 : fld3, $f4 : fld4, $f5 : fldZ)\nthen\n  list.add($sid); \n  list.add($f2); \n  list.add($f3); \n  list.add($f4); \n  list.add($f5); \nend\n\nrule \"Mod\"\nwhen\n  $w : Worker($wid : id == 99, $f2 : fld2, $f3 : fld3, $f4 : fld4, $f5 : fldY)\nthen\n  list.add($wid); \n  list.add($f2); \n  list.add($f3); \n  list.add($f4); \n  list.add($f5); \nend";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(5);
        Assertions.assertThat(list).containsExactly(new Object[]{99, "b", 11, Object.class, 42});
        ks.dispose();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testMultipleModifications(VirtualPropertyMode mode) {
        String drl = "package org.drools.traits.test;\n\nimport org.drools.base.factmodel.traits.Traitable;\nglobal java.util.List list;\ndeclare Person\n@Traitable\n@propertyReactive\n    ssn : String\n    pob : String\n    isStudent : boolean\n    hasAssistantship : boolean\nend\n\ndeclare trait Student\n@propertyReactive\n    studyingCountry : String\n    hasAssistantship : boolean\nend\n\ndeclare trait Worker\n@propertyReactive\n    pob : String\n    workingCountry : String\nend\n\ndeclare trait USCitizen\n@propertyReactive\n    pob : String = \"US\"\nend\n\ndeclare trait ITCitizen\n@propertyReactive\n    pob : String = \"IT\"\nend\n\ndeclare trait IRCitizen\n@propertyReactive\n    pob : String = \"IR\"\nend\n\nrule \"init\"\nwhen\nthen\n    insert(new Person(\"1234\",\"IR\",true,true));\nend\n\nrule \"check for being student\"\nwhen\n    $p : Person($ssn : ssn, $pob : pob,  isStudent == true)\nthen\n    Student st = (Student) don($p , Student.class);\n    modify(st){\n        setStudyingCountry(\"US\");\n    }\nend\n\nrule \"check for IR\"\nwhen\n    $p : Person(pob == \"IR\")\nthen\n    don($p , IRCitizen.class);\nend\n\nrule \"check for being US citizen\"\nwhen\n    $s : Student(studyingCountry == \"US\")\nthen\n    don($s , USCitizen.class);\nend\n\nrule \"check for being worker\"\nwhen\n    $p : Student(hasAssistantship == true, $sc : studyingCountry)\nthen\n    Worker wr = (Worker) don($p , Worker.class);\n    modify(wr){\n        setWorkingCountry($sc);\n    }\n\nend\n\nrule \"Join Full\"\nsalience -1\nwhen\n    Student()      // $sc := studyingCountry)\n    USCitizen()\n    IRCitizen()      // $pob := pob)\n    Worker()       // pob == $pob , workingCountry == $sc)\nthen\n    list.add(1); end\n\n\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat(list).contains((Object[])new Integer[]{1});
        Assertions.assertThat(list).hasSize(1);
        ks.dispose();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testPropagation(VirtualPropertyMode mode) {
        Object drl = "package org.drools.test;\nimport org.drools.base.factmodel.traits.*; \n\nglobal java.util.List list; \ndeclare X @Traitable end \ndeclare trait A @propertyReactive end\ndeclare trait B extends A @propertyReactive end\ndeclare trait C extends B @propertyReactive end \ndeclare trait D extends C @propertyReactive end\ndeclare trait E extends B,C @propertyReactive end\ndeclare trait F extends E @propertyReactive end\ndeclare trait G extends B @propertyReactive end\ndeclare trait H extends G @propertyReactive end\ndeclare trait I extends E,H @propertyReactive end\ndeclare trait J extends I @propertyReactive end\nrule Init when then X x = new X(); insert(x); don(x, F.class); end \nrule Go when String(this == \"go\") $x : X() then don($x, H.class); end \nrule Go2 when String(this == \"go2\") $x : X() then don($x, D.class); end \n";
        for (int j = 65; j <= 74; ++j) {
            String x = "" + (char)j;
            drl = (String)drl + "rule \"Log " + x + "\" when " + x + "() then list.add(\"" + x + "\"); end \n";
            drl = (String)drl + "rule \"Log II" + x + "\" salience -1 when " + x + "(";
            drl = (String)drl + "this isA H";
            drl = (String)drl + ") then list.add(\"H" + x + "\"); end \n";
        }
        KieSession ks = this.getSessionFromString((String)drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(5);
        Assertions.assertThat(list).contains((Object[])new String[]{"A", "B", "C", "E", "F"});
        list.clear();
        LOGGER.debug("---------------------------------------");
        ks.insert((Object)"go");
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(9);
        Assertions.assertThat(list).contains((Object[])new String[]{"H", "G", "HA", "HB", "HC", "HE", "HF", "HG", "HH"});
        LOGGER.debug(((Object)list).toString());
        list.clear();
        LOGGER.debug("---------------------------------------");
        ks.insert((Object)"go2");
        ks.fireAllRules();
        Assertions.assertThat(list).hasSize(9);
        Assertions.assertThat(list).contains((Object[])new String[]{"D", "HA", "HB", "HC", "HE", "HF", "HG", "HH", "HH", "HD"});
        ks.dispose();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testParentBlockers(VirtualPropertyMode mode) {
        String drl = "package org.drools.test;\nimport org.drools.base.factmodel.traits.*; \n\nglobal java.util.List list; \ndeclare X @Traitable end \ndeclare trait A @propertyReactive end\ndeclare trait B @propertyReactive end\ndeclare trait C extends A, B @propertyReactive end \nrule Init when then X x = new X(); insert(x); don(x, A.class); don(x, B.class); end \nrule Go when String(this == \"go\") $x : X() then don($x, C.class); end \nrule Go2 when String(this == \"go2\") $x : C() then end \n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        ks.insert((Object)"go");
        ks.fireAllRules();
        ks.insert((Object)"go2");
        ks.fireAllRules();
        LOGGER.debug("---------------------------------------");
        ks.dispose();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitLogicalTMS(VirtualPropertyMode mode) {
        String drl = "package org.drools.test;\nimport org.drools.base.factmodel.traits.*; \n\nglobal java.util.List list; \ndeclare X @Traitable end \ndeclare trait A @propertyReactive end\ndeclare trait B @propertyReactive end\nrule Init when then X x = new X(); insert(x); end \nrule Go when String(this == \"go\") $x : X() then don($x, A.class, true); don($x, B.class, true); end \nrule Go2 when String(this == \"go2\") $x : X() then don($x, A.class); end \nrule Go3 when String(this == \"go3\") $x : A() not B() then list.add(100); end \n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        FactHandle handle = ks.insert((Object)"go");
        ks.fireAllRules();
        ks.insert((Object)"go2");
        ks.fireAllRules();
        ks.delete(handle);
        ks.fireAllRules();
        LOGGER.debug("---------------------------------------");
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        ks.insert((Object)"go3");
        ks.fireAllRules();
        Assertions.assertThat(list).containsExactly(new Object[]{100});
        ks.dispose();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitNoType(VirtualPropertyMode mode) {
        String drl = "package org.drools.base.factmodel.traits.test;\n\nimport org.drools.base.factmodel.traits.Thing;\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\n\ndeclare Parent\n@Traitable(logical = true)@propertyReactive\nend\n\ndeclare trait ChildTrait\n@propertyReactive\n    naam : String = \"kudak\"\n    id : int = 1020\nend\n\nrule \"don\"\nno-loop\nwhen\nthen\n    Parent p = new Parent();    insert(p);\n    ChildTrait ct = don(p , ChildTrait.class);\n    list.add(\"correct1\");\nend\n\nrule \"check\"\nno-loop\nwhen\n    $c : ChildTrait($n : naam == \"kudak\", id == 1020)\n    $p : Thing(core == $c.core, fields[\"naam\"] == $n)\nthen\n    list.add(\"correct2\");\nend";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat(list).contains((Object[])new String[]{"correct1", "correct2"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitdeleteOrder(VirtualPropertyMode mode) {
        String drl = "package org.drools.base.factmodel.traits.test;\n\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nimport java.util.*;\n\ndeclare trait A end \ndeclare trait B extends A end \ndeclare trait C end \n\nrule \"don\"\nwhen \n  $e : Entity() \nthen\n  don($e, A.class); \n  don($e, C.class); \n  don($e, B.class); \nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        FactHandle handle = ksession.insert((Object)new Entity());
        ksession.fireAllRules();
        final ArrayList list = new ArrayList();
        ksession.addEventListener(new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent objectInsertedEvent) {
            }

            public void objectUpdated(ObjectUpdatedEvent objectUpdatedEvent) {
            }

            public void objectDeleted(ObjectDeletedEvent objectRetractedEvent) {
                Object o = objectRetractedEvent.getOldObject();
                if (o instanceof TraitProxyImpl) {
                    String traitName = ((TraitProxyImpl)o)._getTraitName();
                    list.add(traitName.substring(traitName.lastIndexOf(".") + 1));
                }
            }
        });
        ksession.delete(handle);
        ksession.fireAllRules();
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"B", "C", "A"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitWithManySoftFields(VirtualPropertyMode mode) {
        Object drl = "package org.drools.base.factmodel.traits.test;\n\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nimport java.util.*;\n\ndeclare trait Tx \n";
        for (int j = 0; j < 150; ++j) {
            drl = (String)drl + " fld" + j + " : String \n";
        }
        drl = (String)drl + "end \n\ndeclare TBean @Traitable fld0 : String end \nrule \"don\"\nwhen \nthen\n  don(new TBean(), Tx.class); \nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(new String[]{drl}).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(2);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testDonManyTraitsAtOnce(VirtualPropertyMode mode) {
        String drl = "package org.drools.base.factmodel.traits.test;\n\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nimport java.util.*;\n\nglobal List list; \ndeclare trait A end \ndeclare trait B end \ndeclare trait C end \ndeclare trait D end \ndeclare trait E end \ndeclare trait F end \n\ndeclare TBean @Traitable @propertyReactive fld0 : String end \nrule \"Don 1\"\nwhen \nthen\n  TBean t = new TBean(); \n  don(t, A.class); \n  don(t, B.class); \nend\nrule \"Don 2\" when \n  $s : String(this == \"go\") \n  $t : TBean() \nthen \n  list.add(0); \n  don($t, Arrays.asList(C.class, D.class, E.class, F.class), true); \nend \nrule Clear \nwhen \n  $s : String(this == \"undo\") \n  $t : TBean() \nthen \n  delete($s); \n  delete($t); \nend \nrule C \nwhen\n  B(this isA C) \nthen \n  list.add(1); \nend \nrule D \nwhen\n  D(this isA A, this isA C) \nthen \n  list.add(2); \nend \nrule E \nwhen\n  D(this isA A, this isA E) \nthen \n  list.add(3); \nend \n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        CountingWorkingMemoryEventListener cwm = new CountingWorkingMemoryEventListener();
        ksession.addEventListener((RuleRuntimeEventListener)cwm);
        ksession.fireAllRules();
        Assertions.assertThat((int)cwm.getdeletes()).isEqualTo(0);
        Assertions.assertThat((int)cwm.getInserts()).isEqualTo(3);
        Assertions.assertThat((int)cwm.getUpdates()).isEqualTo(1);
        cwm.reset();
        FactHandle handle = ksession.insert((Object)"go");
        ksession.fireAllRules();
        Assertions.assertThat((int)cwm.getdeletes()).isEqualTo(0);
        Assertions.assertThat((int)cwm.getInserts()).isEqualTo(4);
        Assertions.assertThat((int)cwm.getUpdates()).isEqualTo(3);
        cwm.reset();
        ksession.delete(handle);
        ksession.fireAllRules();
        Assertions.assertThat((int)cwm.getdeletes()).isEqualTo(4);
        Assertions.assertThat((int)cwm.getInserts()).isEqualTo(0);
        Assertions.assertThat((int)cwm.getUpdates()).isEqualTo(0);
        cwm.reset();
        for (Object o : ksession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        ksession.insert((Object)"undo");
        ksession.fireAllRules();
        Assertions.assertThat((int)cwm.getdeletes()).isEqualTo(3);
        Assertions.assertThat((int)cwm.getInserts()).isEqualTo(0);
        Assertions.assertThat((int)cwm.getUpdates()).isEqualTo(0);
        cwm.reset();
        Assertions.assertThat(list).hasSize(4);
        Assertions.assertThat(list).contains((Object[])new Integer[]{0, 1, 2, 3});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testDonManyTraitsAtOnce2(VirtualPropertyMode mode) {
        String drl = "package org.drools.base.factmodel.traits.test;\n\nimport org.drools.base.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nimport java.util.*;\n\nglobal List list; \ndeclare trait A @propertyReactive end \ndeclare trait B @propertyReactive end \n\ndeclare TBean @Traitable @propertyReactive fld0 : String end \nrule \"Don 1\"\nwhen \nthen\n  TBean t = new TBean(); \n  don(t, A.class); \n  don(t, B.class); \nend\nrule \"Test Don A,B\" when \n  A(this isA B) \nthen \n  list.add(0); \nend \n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        CountingWorkingMemoryEventListener cwm = new CountingWorkingMemoryEventListener();
        ksession.addEventListener((RuleRuntimeEventListener)cwm);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((int)cwm.getdeletes()).isEqualTo(0);
        Assertions.assertThat((int)cwm.getInserts()).isEqualTo(3);
        Assertions.assertThat((int)cwm.getUpdates()).isEqualTo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    @Disabled(value="Triple Store is not thread safe and needs to be rewritten")
    public void testMultithreadingTraits(VirtualPropertyMode mode) throws InterruptedException {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.TraitTest.Item;\ndeclare Item end\ndeclare trait ItemStyle\n    id: String\n    adjustable: boolean\nend\nrule \"Don ItemStyle\"\n    no-loop true\n    when\n        $p : Item ()\n        not ItemStyle (id == $p.id)\n    then\n        don($p, ItemStyle.class);\nend\nrule \"Item Style - Adjustable\"    no-loop true    when        $style : ItemStyle (!adjustable)        Item (            id == $style.id         )    then        modify($style) {            setAdjustable(true)        };end";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.base.factmodel.traits.TraitTest.Item;\ndeclare Item end\ndeclare trait ItemStyle\n    id: String\n    adjustable: boolean\nend\nrule \"Don ItemStyle\"\n    no-loop true\n    when\n        $p : Item ()\n        not ItemStyle (id == $p.id)\n    then\n        don($p, ItemStyle.class);\nend\nrule \"Item Style - Adjustable\"    no-loop true    when        $style : ItemStyle (!adjustable)        Item (            id == $style.id         )    then        modify($style) {            setAdjustable(true)        };end", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        int MAX_THREADS = 20;
        int MAX_REPETITIONS = 100;
        int MAX_WAIT_SECONDS = 60;
        ExecutorService executorService = Executors.newFixedThreadPool(MAX_THREADS);
        try {
            for (int threadIndex = 0; threadIndex < MAX_THREADS; ++threadIndex) {
                executorService.execute(new TraitRulesThread(threadIndex, MAX_REPETITIONS, kbase.newKieSession()));
            }
        }
        finally {
            executorService.shutdown();
            executorService.awaitTermination(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            List<Runnable> queuedTasks = executorService.shutdownNow();
            Assertions.assertThat(queuedTasks).isEmpty();
            Assertions.assertThat((boolean)executorService.isTerminated()).isEqualTo(true);
        }
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testShedOneLastTrait(VirtualPropertyMode mode) throws InterruptedException {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core @Traitable end\ndeclare trait Mask\nend\nrule \"Don ItemStyle\"\n    when\n    then\n        don(new Core(), Mask.class);\nend\nrule \"React\" \n    when \n     $s : String() \n        $m : Mask() \nthen \n     delete($s); \n     shed($m, Mask.class); \nend\nrule Log \nwhen \n $t : Thing() \nthen \n list.add($t.getClass().getName()); \nend \n";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.base.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core @Traitable end\ndeclare trait Mask\nend\nrule \"Don ItemStyle\"\n    when\n    then\n        don(new Core(), Mask.class);\nend\nrule \"React\" \n    when \n     $s : String() \n        $m : Mask() \nthen \n     delete($s); \n     shed($m, Mask.class); \nend\nrule Log \nwhen \n $t : Thing() \nthen \n list.add($t.getClass().getName()); \nend \n", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"test.Mask.test.Core_Proxy"});
        knowledgeSession.insert((Object)"shed");
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(2);
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"test.Mask.test.Core_Proxy", "org.drools.base.factmodel.traits.Thing.test.Core_Proxy"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testShedThingCompletelyThenDonAgain(VirtualPropertyMode mode) throws InterruptedException {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core @Traitable end\ndeclare trait Mask end\ndeclare trait Mask2 end\nrule \"Don ItemStyle\"\n    when\n     $s : String(this == \"don1\") \n    then\n     delete($s); \n        don(new Core(), Mask.class);\nend\nrule \"Clear\" \n    when \n     $s : String(this == \"shed1\") \n        $m : Mask() \nthen \n     delete($s); \n     shed($m, Thing.class); \nend\nrule \"Add\" \n    when \n     $s : String(this == \"don2\") \n        $c : Core() \nthen \n     delete($s); \n     don($c, Mask2.class); \nend\nrule \"Clear Again\" \n    when \n     $s : String(this == \"shed2\") \n        $m : Mask2() \nthen \n     delete($s); \n     shed($m, Mask2.class); \nend\nrule Log \nwhen \n $t : Thing() \nthen \n  list.add($t.getClass().getName()); \nend \n";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.base.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core @Traitable end\ndeclare trait Mask end\ndeclare trait Mask2 end\nrule \"Don ItemStyle\"\n    when\n     $s : String(this == \"don1\") \n    then\n     delete($s); \n        don(new Core(), Mask.class);\nend\nrule \"Clear\" \n    when \n     $s : String(this == \"shed1\") \n        $m : Mask() \nthen \n     delete($s); \n     shed($m, Thing.class); \nend\nrule \"Add\" \n    when \n     $s : String(this == \"don2\") \n        $c : Core() \nthen \n     delete($s); \n     don($c, Mask2.class); \nend\nrule \"Clear Again\" \n    when \n     $s : String(this == \"shed2\") \n        $m : Mask2() \nthen \n     delete($s); \n     shed($m, Mask2.class); \nend\nrule Log \nwhen \n $t : Thing() \nthen \n  list.add($t.getClass().getName()); \nend \n", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)"don1");
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"test.Mask.test.Core_Proxy"});
        knowledgeSession.insert((Object)"shed1");
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"test.Mask.test.Core_Proxy"});
        knowledgeSession.insert((Object)"don2");
        knowledgeSession.fireAllRules();
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat(list).hasSize(2);
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"test.Mask.test.Core_Proxy", "test.Mask2.test.Core_Proxy"});
        knowledgeSession.insert((Object)"shed2");
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"test.Mask.test.Core_Proxy", "test.Mask2.test.Core_Proxy", "org.drools.base.factmodel.traits.Thing.test.Core_Proxy"});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitImplicitInsertionExceptionOnNonTraitable(VirtualPropertyMode mode) throws InterruptedException {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core id : String  end\ndeclare trait Mask  id : String end\nrule \"Don ItemStyle\"\n    when\n    then\n        don(new Core(), Mask.class);\nend\n";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.base.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core id : String  end\ndeclare trait Mask  id : String end\nrule \"Don ItemStyle\"\n    when\n    then\n        don(new Core(), Mask.class);\nend\n", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        try {
            knowledgeSession.fireAllRules();
            Assertions.fail((String)"Core is not declared @Traitable, this test should have thrown an exception");
        }
        catch (Exception csq) {
            Assertions.assertThat((Throwable)csq.getCause()).isInstanceOf(IllegalStateException.class);
        }
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTraitLegacyTraitableWithLegacyTrait(VirtualPropertyMode mode) {
        String s1 = "package org.drools.compiler.factmodel.traits;\nimport " + TraitTest.class.getName() + ".SomeTrait; \nimport " + StudentImpl.class.getCanonicalName() + ";\nimport org.drools.base.factmodel.traits.*; \nimport org.drools.traits.core.factmodel.*; \nglobal java.util.List list;\nrule \"Don ItemStyle\"\n    when\n    then\n        don(new StudentImpl(), SomeTrait.class);\nend\n";
        KieBase kbase = this.getKieBaseFromString(s1, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat((Collection)knowledgeSession.getObjects()).hasSize(2);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsALegacyTrait(VirtualPropertyMode mode) {
        String s1 = "package org.drools.traits.compiler.factmodel.traits;\nimport " + TraitTest.class.getName() + ".SomeTrait; \nimport " + StudentImpl.class.getCanonicalName() + ";\nimport " + Entity.class.getCanonicalName() + ";\nimport org.drools.base.factmodel.traits.*; \nglobal java.util.List list;\ndeclare trait IStudent end \nrule \"Don ItemStyle\"\n    when\n    then\n        insert(new StudentImpl());\n        don(new Entity(), IStudent.class);\nend\nrule Check  when   $s : StudentImpl()   $e : Entity(this isA $s)  then   list.add(1);  end ";
        KieBase kbase = this.getKieBaseFromString(s1, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{1});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    @Disabled(value="Check ReviseTraitTestWithPRAlwaysCategory.java file")
    public void testClassLiteralsWithOr(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; import org.drools.base.factmodel.traits.*; global java.util.List list; declare Foo @Traitable end declare trait A end declare trait B end rule Init when then   Foo f = new Foo();   insert(f); end rule One when   $f : Foo(this not isA A) then   don($f, A.class); end rule Two when   $f : Foo(this not isA B) then   don($f, B.class); end rule Check when     $f : Foo(this isA B || this isA A) then   list.add(1); end ";
        KieBase kbase = this.loadKnowledgeBaseWithKnowledgeBuilderOption(drl, new KnowledgeBuilderOption[]{PropertySpecificOption.ALLOWED});
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{1});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsASwappedArg(VirtualPropertyMode mode) {
        String drl = "package org.drools.traits.compiler.factmodel.traits;\nimport " + TraitTest.class.getName() + ".SomeTrait; \nimport " + StudentImpl.class.getCanonicalName() + ";\nimport " + Entity.class.getCanonicalName() + ";\nimport org.drools.base.factmodel.traits.*; \nglobal java.util.List list; declare Foo @Traitable   object : Object end declare Bar @Traitable end declare trait IStudent end rule Init when then   Foo f = new Foo(new StudentImpl());   don(f, IStudent.class); end rule Match1 when   $f : Foo($x : object)   $p : StudentImpl(this isA $f) from $x then   list.add(1); end rule Match2 when   $f : Foo($x : object)   $p : StudentImpl($f isA this) from $x then   list.add(2); end ";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(2);
        Assertions.assertThat(list).contains((Object[])new Integer[]{1, 2});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testHierarchyEncodeOnPackageMerge(VirtualPropertyMode mode) {
        String drl0 = "package org.drools.test; declare trait X end ";
        String drl1 = "package org.drools.test; import org.drools.base.factmodel.traits.*; global java.util.List list; declare trait A end declare trait B extends A end declare trait C extends B end ";
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)knowledgeBase);
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb.add((Resource)new ByteArrayResource(drl0.getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kb.hasErrors()).isFalse();
        knowledgeBase.addPackages(kb.getKnowledgePackages());
        KnowledgeBuilder kb2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb2.add((Resource)new ByteArrayResource(drl1.getBytes()), ResourceType.DRL);
        LOGGER.debug(kb2.getErrors().toString());
        Assertions.assertThat((boolean)kb2.hasErrors()).isFalse();
        knowledgeBase.addPackages(kb2.getKnowledgePackages());
        HierarchyEncoder hier = ((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry((RuleBase)knowledgeBase).getHierarchy();
        BitSet b = (BitSet)hier.getCode((Object)"org.drools.test.B").clone();
        BitSet c = (BitSet)hier.getCode((Object)"org.drools.test.C").clone();
        c.and(b);
        Assertions.assertThat((Object)c).isEqualTo((Object)b);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    @Disabled
    public void testDonThenReinsert(VirtualPropertyMode mode) throws InterruptedException {
        String s1 = "package test;\nimport org.drools.base.factmodel.traits.*; \nimport org.drools.traits.compiler.factmodel.traits.TraitTest.TBean;\nglobal java.util.List list;\ndeclare TBean  @Traitable  @propertyReactive end declare trait Mask  @propertyReactive end rule 'Don ItemStyle'     when\n     $e : TBean()     then         don($e, Mask.class);\nend\nrule \"React\" \n    when \n        $m : Mask() \nthen \nend\nrule Zero when not Object() then end ";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.base.factmodel.traits.*; \nimport org.drools.traits.compiler.factmodel.traits.TraitTest.TBean;\nglobal java.util.List list;\ndeclare TBean  @Traitable  @propertyReactive end declare trait Mask  @propertyReactive end rule 'Don ItemStyle'     when\n     $e : TBean()     then         don($e, Mask.class);\nend\nrule \"React\" \n    when \n        $m : Mask() \nthen \nend\nrule Zero when not Object() then end ", new KieBaseOption[]{EqualityBehaviorOption.IDENTITY});
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        TBean e = new TBean("aaa");
        int n = knowledgeSession.fireAllRules();
        Assertions.assertThat((int)n).isEqualTo(1);
        knowledgeSession.insert((Object)e);
        n = knowledgeSession.fireAllRules();
        Assertions.assertThat((int)n).isEqualTo(2);
        knowledgeSession.insert((Object)e);
        n = knowledgeSession.fireAllRules();
        Assertions.assertThat((int)n).isEqualTo(0);
        knowledgeSession.delete(knowledgeSession.getFactHandle((Object)e));
        n = knowledgeSession.fireAllRules();
        Assertions.assertThat((int)n).isEqualTo(1);
        Assertions.assertThat((Collection)knowledgeSession.getObjects()).isEmpty();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testCastOnTheFly(VirtualPropertyMode mode) throws InterruptedException {
        String s1 = "package test; import org.drools.base.factmodel.traits.*; global java.util.List list; declare Foo  @Traitable  @propertyReactive  id : int end declare trait Upper  @propertyReactive  id : int end declare trait Lower extends Upper  @propertyReactive end rule Init  dialect 'mvel'     when     then      Foo o = insert(new Foo(42)).as(Foo.class);      list.add(o.getId()); end rule Don  when      $f : Foo()  then      Lower l = don($f, Lower.class);      Upper u = bolster($f).as(Upper.class);      list.add(u.getId() + 1);  end ";
        KieBase kbase = this.getKieBaseFromString("package test; import org.drools.base.factmodel.traits.*; global java.util.List list; declare Foo  @Traitable  @propertyReactive  id : int end declare trait Upper  @propertyReactive  id : int end declare trait Lower extends Upper  @propertyReactive end rule Init  dialect 'mvel'     when     then      Foo o = insert(new Foo(42)).as(Foo.class);      list.add(o.getId()); end rule Don  when      $f : Foo()  then      Lower l = don($f, Lower.class);      Upper u = bolster($f).as(Upper.class);      list.add(u.getId() + 1);  end ", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{42, 43});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testDonModify(VirtualPropertyMode mode) {
        String drl = "import org.drools.traits.core.factmodel.Entity;\nimport org.drools.traits.compiler.factmodel.traits.IPerson;\nimport org.drools.compiler.factmodel.traits.IStudent;\ndeclare trait IPerson end\ndeclare trait IStudent end\ndeclare trait Person\n    name : String\nend\nrule \"Init\"\nwhen\nthen\n    Entity core = new Entity();\n    insert(core);\nend\nrule Trait when\n    $core: Entity()\nthen\n    IPerson x = don($core, IPerson.class, true);\n    IStudent s = don($core, IStudent.class, true);\n    Person p = don($core, Person.class, true);\nend\nrule R2 when\n    $p: IPerson(name == null)\nthen\nend\n";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession kSession = kbase.newKieSession();
        Assertions.assertThat((int)kSession.fireAllRules()).isEqualTo(3);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testAlphaNodeSharing(VirtualPropertyMode mode) {
        String drl = "package test; import " + Entity.class.getName() + " declare trait Person\n    name : String\nend\nrule Init when then     don(new Entity(), Person.class); end\nrule One when    $core: Entity(this isA Person) then end rule Two when    $core: Entity(this isA Person) then end \n";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession kSession = kbase.newKieSession();
        Assertions.assertThat((int)kSession.fireAllRules()).isEqualTo(3);
        NamedEntryPoint nep = (NamedEntryPoint)kSession.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId());
        ObjectTypeNode otn = (ObjectTypeNode)nep.getEntryPointNode().getObjectTypeNodes().get(new ClassObjectType(Entity.class));
        Assertions.assertThat((Object)otn).isNotNull();
        Assertions.assertThat((int)otn.getObjectSinkPropagator().getSinks().length).isEqualTo(1);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testPartitionWithSiblingsOnDelete(VirtualPropertyMode mode) {
        String drl = "import " + Entity.class.getName() + ";global java.util.List list; declare trait A @propertyReactive end declare trait B extends A @propertyReactive end declare trait C extends A @propertyReactive end rule Trait when     $core: Entity() then     don($core, A.class);     don($core, B.class);     don($core, C.class); end rule Shed when    $s: String()    $core : Entity() then    shed($core, C.class); end rule RA when A() then list.add('A'); end rule RB when B() then list.add('B'); end rule RC when C() then list.add('C'); end  ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Entity e = new Entity();
        ksession.insert((Object)e);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactly((Object[])new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C')});
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        Set<BitSet> s = this.checkOTNPartitioning((TraitableBean)e, ksession);
        Assertions.assertThat(s).hasSize(2);
        Assertions.assertThat(list).containsExactly((Object[])new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C')});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testTupleIntegrityOnModification(VirtualPropertyMode mode) {
        String drl = "package test import " + Entity.class.getName() + ";global java.util.List list; declare trait A @propertyReactive value : int end rule Trait when     $core: Entity() then     A o = don($core, A.class); end rule Test when    $x: A(value == 0) then    list.add(0); end rule Check when    $x: A(value == 42) then    list.add(42); end rule Mood when   $x : A(value != 42) then   modify ($x) { setValue(42); } end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Entity());
        ksession.fireAllRules();
        for (Object o : ksession.getObjects(object -> object.getClass().getName().contains("test.A"))) {
            InternalFactHandle handle = (InternalFactHandle)ksession.getFactHandle(o);
            TupleImpl first = handle.getFirstLeftTuple();
            Assertions.assertThat((Object)first).isInstanceOf(RuleTerminalNodeLeftTuple.class);
            Assertions.assertThat((String)((RuleTerminalNodeLeftTuple)first).getRule().getName()).isEqualTo("Check");
        }
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{0, 42});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testShedVacancy(VirtualPropertyMode mode) {
        String drl = "package org.drools.test import " + Entity.class.getName() + ";global java.util.List list; declare trait A @propertyReactive end declare trait B @propertyReactive end declare trait C extends A,B @propertyReactive end declare trait D extends B @propertyReactive end rule Trait when then     Entity e = new Entity('x1');     don(e, C.class);     don(e, D.class); end rule Mood when   $x : B() then end rule Shed when   $s : String()   $x : Entity() then   delete($s);   shed($x, A.class); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HierarchyEncoder hier = ((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry((RuleBase)((InternalKnowledgeBase)kbase)).getHierarchy();
        BitSet a = (BitSet)hier.getCode((Object)"org.drools.test.A").clone();
        BitSet b = (BitSet)hier.getCode((Object)"org.drools.test.B").clone();
        BitSet c = (BitSet)hier.getCode((Object)"org.drools.test.C").clone();
        BitSet d = (BitSet)hier.getCode((Object)"org.drools.test.D").clone();
        int n = ksession.fireAllRules();
        Assertions.assertThat((int)n).isEqualTo(2);
        LOGGER.debug("---------------------------------------------------------------\n\n\n ");
        int counter = 0;
        for (Object o : ksession.getObjects()) {
            if (o instanceof TraitProxyImpl) {
                TraitProxyImpl tp = (TraitProxyImpl)o;
                if (tp._getTypeCode().equals(c)) {
                    Assertions.assertThat((Collection)tp.listAssignedOtnTypeCodes()).hasSize(1);
                    Assertions.assertThat((Collection)tp.listAssignedOtnTypeCodes()).contains((Object[])new BitSet[]{b});
                    ++counter;
                    continue;
                }
                if (!tp._getTypeCode().equals(d)) continue;
                Assertions.assertThat((Collection)tp.listAssignedOtnTypeCodes()).isEmpty();
                ++counter;
                continue;
            }
            if (!(o instanceof TraitableBean)) continue;
            TraitableBean tb = (TraitableBean)o;
            LOGGER.debug(tb.getCurrentTypeCode().toString());
            ++counter;
        }
        Assertions.assertThat((int)counter).isEqualTo(3);
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        LOGGER.debug("---------------------------------------------------------------\n\n\n ");
        int counter2 = 0;
        for (Object o : ksession.getObjects()) {
            if (o instanceof TraitProxyImpl) {
                TraitProxyImpl tp = (TraitProxyImpl)o;
                Assertions.assertThat((Object)tp._getTypeCode()).isEqualTo((Object)d);
                Assertions.assertThat((Collection)tp.listAssignedOtnTypeCodes()).hasSize(1);
                Assertions.assertThat((Collection)tp.listAssignedOtnTypeCodes()).contains((Object[])new BitSet[]{b});
                ++counter2;
                continue;
            }
            if (!(o instanceof TraitableBean)) continue;
            TraitableBean tb = (TraitableBean)o;
            Assertions.assertThat((Object)tb.getCurrentTypeCode()).isEqualTo((Object)d);
            ++counter2;
        }
        Assertions.assertThat((int)counter2).isEqualTo(2);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testExternalUpdateWithProxyRefreshInEqualityMode(VirtualPropertyMode mode) {
        String drl = "package org.drools.trait.test; import " + ExtEntity.class.getCanonicalName() + "; global " + List.class.getName() + " list; declare trait Mask   id  : String   num : int end rule Don when   $x : ExtEntity($id : id) then   list.add($id);   don($x, Mask.class); end rule Test when   Mask($n : num) then   list.add($n); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[]{EqualityBehaviorOption.EQUALITY});
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle handle = ksession.insert((Object)new ExtEntity("x1", 42));
        ksession.fireAllRules();
        ksession.update(handle, (Object)new ExtEntity("x1", 35));
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactly(new Object[]{"x1", 42, "x1", 42});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsAInstanceOf(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; import " + StudentImpl.class.getName() + "; import " + IStudent.class.getName() + "; global java.util.List list; rule Test1 when   StudentImpl(this isA IStudent.class) then list.add(1); end rule Test2 when   IStudent(this isA StudentImpl.class) then list.add(2); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)new StudentImpl());
        Assertions.assertThat((int)knowledgeSession.fireAllRules()).isEqualTo(2);
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{1, 2});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testIsAInstanceOfNonTraitable(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; global java.util.List list; rule Test1 when   Object(this isA String.class) then list.add(1); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)"hello");
        Assertions.assertThat((int)knowledgeSession.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{1});
    }

    protected Set<BitSet> checkOTNPartitioning(TraitableBean core, KieSession wm) {
        HashSet<BitSet> otns = new HashSet<BitSet>();
        for (Object o : core._getTraitMap().values()) {
            TraitProxyImpl tp = (TraitProxyImpl)o;
            Set localNodes = tp.listAssignedOtnTypeCodes();
            for (BitSet code : localNodes) {
                Assertions.assertThat(otns).doesNotContain((Object[])new BitSet[]{code});
                otns.add(code);
            }
        }
        return otns;
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testSerializeKieBaseWithTraits(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; import " + StudentImpl.class.getName() + "; import " + IStudent.class.getName() + "; global java.util.List list; rule Test1 when   StudentImpl(this isA IStudent.class) then list.add(1); end rule Test2 when   IStudent(this isA StudentImpl.class) then list.add(2); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kbase);
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)new StudentImpl());
        Assertions.assertThat((int)knowledgeSession.fireAllRules()).isEqualTo(2);
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{1, 2});
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testMixin2(VirtualPropertyMode mode) {
        String drl = "package org.drools.test.traits\nimport " + Scholar.class.getCanonicalName() + ";\nimport " + ScholarImpl.class.getCanonicalName() + ";\n\n\ndeclare Person\n    @Traitable\n    name    : String       = \"john\"     @key\n    age     : int          = 18\n    weight  : Double       = 75.4\nend\n\ndeclare Scholar end\n\ndeclare trait Student extends Scholar\n    name    : String\n    age     : int\n    weight  : Double\n    school  : String\nend\n\n\nrule \"Zero\"\nwhen\nthen\n    insert(new Person());\nend\n\n\nrule \"Student\"\nno-loop\nwhen\n    $p : Person($name : name, $age : age < 25, $weight : weight)\nthen\n    Student s = don($p, Student.class);\n        s.setSchool(\"SomeSchool\");\n        s.learn(\" AI \");\nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ks.fireAllRules();
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testMixinWithConflictsUsingDeclarationOrder(VirtualPropertyMode mode) {
        this.checkMixinResolutionUsesOrder("Y,Z", "Y", mode);
        this.checkMixinResolutionUsesOrder("Z,Y", "Z", mode);
    }

    private void checkMixinResolutionUsesOrder(String interfaces, String first, VirtualPropertyMode mode) {
        String drl = "package org.drools.test.traits\nimport " + Y.class.getCanonicalName() + ";\nimport " + Z.class.getCanonicalName() + ";\n\nglobal java.util.List list;\ndeclare Bean\n    @Traitable\n    name    : String       = \"xxx\"     @key\nend\n\n\ndeclare X extends " + interfaces + " @Trait(mixinSolveConflicts = Trait.MixinConflictResolutionStrategy.DECLARATION_ORDER) end\n\nrule Init when\nthen\n    insert(new Bean());\nend\n\nrule Exec no-loop when\n    $b : Bean()\nthen\n    X x = don($b, X.class);\n    list.add(x.getYValue());\n    list.add(x.getZValue());\n    list.add(x.getShared());\nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("Y");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("Z");
        Assertions.assertThat((String)((String)list.get(2))).isEqualTo(first);
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testMixinWithConflictsThrowingError(VirtualPropertyMode mode) {
        String drl = "package org.drools.test.traits\nimport " + Y.class.getCanonicalName() + ";\nimport " + Z.class.getCanonicalName() + ";\n\nglobal java.util.List list;\ndeclare Bean\n    @Traitable\n    name    : String       = \"xxx\"     @key\nend\n\n\ndeclare X extends Y,Z @Trait(mixinSolveConflicts = Trait.MixinConflictResolutionStrategy.ERROR_ON_CONFLICT) end\n\nrule Init when\nthen\n    insert(new Bean());\nend\n\nrule Exec no-loop when\n    $b : Bean()\nthen\n    X x = don($b, X.class);\n    list.add(x.getYValue());\n    list.add(x.getZValue());\n    list.add(x.getShared());\nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ((ThrowableTypeAssert)Assertions.assertThatException().as("don should fail due to the conflict in getShared() method", new Object[0])).isThrownBy(() -> ks.fireAllRules());
    }

    @ParameterizedTest(name="KieBase type={0}")
    @MethodSource(value={"parameters"})
    public void testPreserveAllSetBitMask(VirtualPropertyMode mode) {
        String drl = "package t.x;\nimport " + Entity.class.getName() + "; declare trait MyThing end\ndeclare trait RootThing extends MyThing  objProp : java.util.List = new java.util.ArrayList() end declare trait F extends RootThing end\ndeclare trait D extends RootThing end\ndeclare trait E extends D end\nrule Init when\nthen  Entity e1 = new Entity(\"X\");  insert(e1);  Entity e2 = new Entity(\"Y\");  insert(e2);   D d1 = don(e1, D.class, true);  F f2 = don(e2, F.class, true);   modify (d1) { getObjProp().add(f2.getCore()); }  modify (f2.getCore()) {} end rule Rec no-loop when\n MyThing($x_0 := core, this isA D.class, $p : this#RootThing.objProp)  exists MyThing($x_1 := core , core memberOf $p, this isA F.class) then  don($x_0, E.class, true); end rule Shed_2 when\n $s : String(this == \"go2\")  $x : E($objs : objProp)  $y : F($z : core memberOf $objs) then  retract($s);  modify ($x) { getObjProp().remove($z); }  modify ($y) {} end ";
        KieBase kieBase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kieBase);
        KieSession kSession = kieBase.newKieSession();
        kSession.fireAllRules();
        kSession.insert((Object)"go2");
        kSession.fireAllRules();
        for (Object o : kSession.getObjects((ObjectFilter)new ClassObjectFilter(Entity.class))) {
            Entity e = (Entity)o;
            if (e.getId().equals("X")) {
                Assertions.assertThat((boolean)e.hasTrait("t.x.D")).isTrue();
                Assertions.assertThat((boolean)e.hasTrait("t.x.E")).isFalse();
                Assertions.assertThat((boolean)e.hasTrait("t.x.F")).isFalse();
                Assertions.assertThat((List)((List)e._getDynamicProperties().get("objProp"))).isEmpty();
                continue;
            }
            if (e.getId().equals("Y")) {
                Assertions.assertThat((boolean)e.hasTrait("t.x.F")).isTrue();
                Assertions.assertThat((boolean)e.hasTrait("t.x.D")).isFalse();
                Assertions.assertThat((boolean)e.hasTrait("t.x.E")).isFalse();
                continue;
            }
            Assertions.fail((String)"Unrecognized entity in WM");
        }
    }

    public static class TBean {
        private String fld;

        public String getFld() {
            return this.fld;
        }

        public void setFld(String fld) {
            this.fld = fld;
        }

        public TBean(String fld) {
            this.fld = fld;
        }
    }

    public static interface IntfParent {
    }

    @Traitable
    public static class TraitableFoo {
        private String id;

        public TraitableFoo(String id, int x, Object k) {
            this.setId(id);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class CountingWorkingMemoryEventListener
    implements RuleRuntimeEventListener {
        private int inserts = 0;
        private int updates = 0;
        private int deletes = 0;

        public int getInserts() {
            return this.inserts;
        }

        public int getUpdates() {
            return this.updates;
        }

        public int getdeletes() {
            return this.deletes;
        }

        public void objectInserted(ObjectInsertedEvent event) {
            if (!(event.getObject() instanceof String)) {
                ++this.inserts;
            }
        }

        public void objectUpdated(ObjectUpdatedEvent event) {
            if (!(event.getObject() instanceof String)) {
                ++this.updates;
            }
        }

        public void objectDeleted(ObjectDeletedEvent objectdeleteedEvent) {
            if (!(objectdeleteedEvent.getOldObject() instanceof String)) {
                ++this.deletes;
            }
        }

        public void reset() {
            this.inserts = 0;
            this.deletes = 0;
            this.updates = 0;
        }
    }

    public static class TraitRulesThread
    implements Runnable {
        int threadIndex;
        int numRepetitions;
        KieSession ksession;

        public TraitRulesThread(int threadIndex, int numRepetitions, KieSession ksession) {
            this.threadIndex = threadIndex;
            this.numRepetitions = numRepetitions;
            this.ksession = ksession;
        }

        @Override
        public void run() {
            for (int repetitionIndex = 0; repetitionIndex < this.numRepetitions; ++repetitionIndex) {
                Item i = new Item();
                i.setId(String.format("testId_%d%d", this.threadIndex, repetitionIndex));
                this.ksession.insert((Object)i);
                this.ksession.fireAllRules();
            }
        }
    }

    @Traitable
    @PropertyReactive
    public static class ExtEntity
    extends Entity {
        private int num;

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }

        public ExtEntity(String id, int num) {
            super(id);
            this.num = num;
        }
    }

    @Trait(impl=ScholarImpl.class)
    public static interface Scholar<K> {
        public void learn(String var1);
    }

    public static class ScholarImpl<K>
    implements Scholar<K> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ScholarImpl.class);
        private Thing<K> core;

        public ScholarImpl() {
        }

        public ScholarImpl(Thing<K> arg) {
            this.core = arg;
        }

        @Override
        public void learn(String subject) {
            LOGGER.debug("I " + this.core.getFields().get("name") + ", now know everything about " + subject);
        }
    }

    @Trait(impl=YImpl.class)
    public static interface Y {
        public String getShared();

        public String getYValue();
    }

    @Trait(impl=ZImpl.class)
    public static interface Z {
        public String getShared();

        public String getZValue();
    }

    public static class ZImpl
    implements Z {
        @Override
        public String getShared() {
            return "Z";
        }

        @Override
        public String getZValue() {
            return "Z";
        }
    }

    public static class YImpl
    implements Y {
        @Override
        public String getShared() {
            return "Y";
        }

        @Override
        public String getYValue() {
            return "Y";
        }
    }

    @Trait
    public static interface SomeTrait<K>
    extends Thing<K> {
        public String getFoo();

        public void setFoo(String var1);
    }

    @Traitable
    public static class Item {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    @Traitable
    public static class XYZ
    extends TraitableFoo {
        public XYZ() {
            super(null, 0, null);
        }
    }
}

