/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.base.base.FieldAccessor;
import org.drools.base.factmodel.ClassDefinition;
import org.drools.base.factmodel.FieldDefinition;
import org.drools.compiler.builder.impl.classbuilder.ClassBuilder;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.traits.core.factmodel.TraitClassBuilderFactory;
import org.drools.util.ClassUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.drools.wiring.dynamic.PackageClassLoader;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClassBuilderTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    ClassLoader classLoader;
    JavaDialectRuntimeData data;

    @BeforeEach
    public void setUp() throws Exception {
        this.data = new JavaDialectRuntimeData();
    }

    private Class build(ClassBuilder builder, ClassDefinition classDef) throws Exception {
        this.classLoader = new PackageClassLoader(this.data.getStore(), (ClassLoader)ProjectClassLoader.createProjectClassLoader());
        byte[] d = builder.buildClass(classDef, this.classLoader);
        this.data.write(ClassUtils.convertClassToResourcePath((String)classDef.getClassName()), d);
        this.store = new ClassFieldAccessorStore();
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.classLoader));
        this.store.setEagerWire(true);
        Class<?> clazz = this.classLoader.loadClass(classDef.getClassName());
        classDef.setDefinedClass(clazz);
        return clazz;
    }

    @Test
    public void testBuildClass() throws Exception {
        ClassBuilder builder = new TraitClassBuilderFactory().getBeanClassBuilder();
        ClassDefinition classDef = new ClassDefinition("org.drools.TestClass1", null, new String[]{"java.io.Serializable"});
        FieldDefinition intDef = new FieldDefinition("intAttr", "int");
        FieldDefinition stringDef = new FieldDefinition("stringAttr", "java.lang.String");
        classDef.addField(intDef);
        classDef.addField(stringDef);
        Class clazz = this.build(builder, classDef);
        intDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, intDef.getName()));
        stringDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, stringDef.getName()));
        byte[] d = builder.buildClass(classDef, this.classLoader);
        ((ClassAssert)Assertions.assertThat((Class)clazz).as("Returned class should be the same", new Object[0])).isSameAs((Object)classDef.getDefinedClass());
        ((AbstractStringAssert)Assertions.assertThat((String)clazz.getName()).as("Class name should be equal", new Object[0])).isEqualTo(classDef.getClassName());
        Serializable instance = (Serializable)clazz.newInstance();
        String stringValue = "Atributo String ok";
        stringDef.setValue((Object)instance, (Object)stringValue);
        ((ObjectAssert)Assertions.assertThat((Object)stringDef.getValue((Object)instance)).as("Attribute should have been correctly set", new Object[0])).isEqualTo((Object)stringValue);
        int intValue = 50;
        intDef.setValue((Object)instance, (Object)new Integer(intValue));
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)intDef.getValue((Object)instance))).as("Attribute should have been correctly set", new Object[0])).isEqualTo(intValue);
        clazz = this.build(builder, classDef);
    }

    private void writeJar(byte[] data) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream("/Users/michaelneale/edson.jar");
        JarOutputStream jout = new JarOutputStream(out);
        JarEntry je = new JarEntry("br/com/auster/TestClass1.class");
        jout.putNextEntry(je);
        jout.write(data);
        jout.closeEntry();
        jout.close();
    }

    @Test
    public void testEquals() throws Exception {
        ClassBuilder builder = new TraitClassBuilderFactory().getBeanClassBuilder();
        ClassDefinition classDef = new ClassDefinition("org.drools.TestClass2", null, new String[0]);
        FieldDefinition long1Def = new FieldDefinition("longAttr1", "long", true);
        FieldDefinition long2Def = new FieldDefinition("longAttr2", "long", true);
        FieldDefinition doubleDef = new FieldDefinition("doubleAttr", "double", true);
        FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
        FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", true);
        FieldDefinition dateDef = new FieldDefinition("dateAttr", "java.util.Date", true);
        FieldDefinition str2Def = new FieldDefinition("stringAttr2", "java.lang.String");
        classDef.addField(long1Def);
        classDef.addField(long2Def);
        classDef.addField(doubleDef);
        classDef.addField(intDef);
        classDef.addField(strDef);
        classDef.addField(dateDef);
        classDef.addField(str2Def);
        Class clazz = this.build(builder, classDef);
        long1Def.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, long1Def.getName()));
        long2Def.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, long2Def.getName()));
        doubleDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, doubleDef.getName()));
        intDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, intDef.getName()));
        strDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, strDef.getName()));
        dateDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, dateDef.getName()));
        str2Def.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, str2Def.getName()));
        Object x = clazz.newInstance();
        Object y = clazz.newInstance();
        long1Def.setValue(x, (Object)20L);
        long2Def.setValue(x, (Object)30L);
        doubleDef.setValue(x, (Object)50.0);
        intDef.setValue(x, (Object)10);
        strDef.setValue(x, (Object)"abc");
        dateDef.setValue(x, (Object)new Date(1000L));
        str2Def.setValue(x, (Object)"instance1");
        long1Def.setValue(y, (Object)20L);
        long2Def.setValue(y, (Object)30L);
        doubleDef.setValue(y, (Object)50.0);
        intDef.setValue(y, (Object)10);
        strDef.setValue(y, (Object)"abc");
        dateDef.setValue(y, (Object)new Date(1000L));
        str2Def.setValue(y, (Object)"instance2");
        Object o = new Object();
        Assertions.assertThat(x).isEqualTo(x);
        Assertions.assertThat(x).isNotEqualTo(o);
        Assertions.assertThat(x).isEqualTo(y);
        intDef.setValue(y, (Object)1);
        Assertions.assertThat(x).isNotEqualTo(y);
        intDef.setValue(y, (Object)10);
        strDef.setValue(y, (Object)"xyz");
        Assertions.assertThat(x).isNotEqualTo(y);
        strDef.setValue(y, null);
        Assertions.assertThat(x).isNotEqualTo(y);
        strDef.setValue(y, (Object)"abc");
        dateDef.setValue(y, (Object)new Date(1L));
        Assertions.assertThat(x).isNotEqualTo(y);
        dateDef.setValue(y, null);
        Assertions.assertThat(x).isNotEqualTo(y);
    }

    @Test
    public void testHashCode() throws Exception {
        ClassBuilder builder = new TraitClassBuilderFactory().getBeanClassBuilder();
        ClassDefinition classDef = new ClassDefinition("org.drools.TestClass3", null, new String[0]);
        FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
        FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", false);
        classDef.addField(intDef);
        classDef.addField(strDef);
        Class clazz = this.build(builder, classDef);
        intDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, intDef.getName()));
        strDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, strDef.getName()));
        Object x = clazz.newInstance();
        intDef.setValue(x, (Object)new Integer(10));
        strDef.setValue(x, (Object)"abc");
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.hashCode()).as("Wrong hashcode calculation", new Object[0])).isEqualTo(41);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.hashCode()).as("Wrong hashcode calculation", new Object[0])).isEqualTo(x.hashCode());
    }

    @Test
    public void testToString() throws Exception {
        ClassBuilder builder = new TraitClassBuilderFactory().getBeanClassBuilder();
        ClassDefinition classDef = new ClassDefinition("org.drools.TestClass4", null, new String[0]);
        FieldDefinition long1Def = new FieldDefinition("longAttr1", "long", true);
        FieldDefinition long2Def = new FieldDefinition("longAttr2", "long", true);
        FieldDefinition doubleDef = new FieldDefinition("doubleAttr", "double", true);
        FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
        FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", true);
        FieldDefinition dateDef = new FieldDefinition("dateAttr", "java.util.Date", true);
        FieldDefinition str2Def = new FieldDefinition("stringAttr2", "java.lang.String");
        classDef.addField(long1Def);
        classDef.addField(long2Def);
        classDef.addField(doubleDef);
        classDef.addField(intDef);
        classDef.addField(strDef);
        classDef.addField(dateDef);
        classDef.addField(str2Def);
        Class clazz = this.build(builder, classDef);
        long1Def.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, long1Def.getName()));
        long2Def.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, long2Def.getName()));
        doubleDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, doubleDef.getName()));
        intDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, intDef.getName()));
        strDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, strDef.getName()));
        dateDef.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, dateDef.getName()));
        str2Def.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, str2Def.getName()));
        Object x = clazz.newInstance();
        long1Def.setValue(x, (Object)new Long(20L));
        long2Def.setValue(x, (Object)new Long(30L));
        doubleDef.setValue(x, (Object)new Double(50.0));
        intDef.setValue(x, (Object)new Integer(10));
        strDef.setValue(x, (Object)"abc");
        dateDef.setValue(x, (Object)new Date(1000L));
        str2Def.setValue(x, (Object)"instance1");
        String result = x.toString();
        Assertions.assertThat((String)result).contains(new CharSequence[]{long1Def.getName()});
        Assertions.assertThat((String)result).contains(new CharSequence[]{long2Def.getName()});
        Assertions.assertThat((String)result).contains(new CharSequence[]{doubleDef.getName()});
        Assertions.assertThat((String)result).contains(new CharSequence[]{intDef.getName()});
        Assertions.assertThat((String)result).contains(new CharSequence[]{strDef.getName()});
        Assertions.assertThat((String)result).contains(new CharSequence[]{dateDef.getName()});
        Assertions.assertThat((String)result).contains(new CharSequence[]{str2Def.getName()});
    }

    @Test
    public void testConstructorWithFields() throws Exception {
        ClassBuilder builder = new TraitClassBuilderFactory().getBeanClassBuilder();
        ClassDefinition classDef = new ClassDefinition("org.drools.TestClass5", null, new String[0]);
        String[] types = new String[]{"byte", "short", "int", "long", "float", "double", "char", "java.lang.String", "boolean"};
        FieldDefinition[] fields = new FieldDefinition[types.length];
        for (int i = 0; i < types.length; ++i) {
            Object attrName = types[i].substring(types[i].lastIndexOf(46) + 1);
            attrName = ((String)attrName).substring(0, 1).toLowerCase() + ((String)attrName).substring(1) + "Attr";
            fields[i] = new FieldDefinition((String)attrName, types[i], i % 2 == 0);
            classDef.addField(fields[i]);
        }
        Class clazz = this.build(builder, classDef);
        for (FieldDefinition field : fields) {
            field.setReadWriteAccessor((FieldAccessor)this.store.getAccessor(clazz, field.getName()));
        }
        Constructor<?>[] cons = clazz.getConstructors();
        Assertions.assertThat((int)cons.length).isEqualTo(3);
        for (Constructor<?> c : cons) {
            Class<?>[] ptypes = c.getParameterTypes();
            if (ptypes.length == 0) continue;
            if (ptypes.length == fields.length) {
                for (int i = 0; i < ptypes.length; ++i) {
                    if (ptypes[i].equals(fields[i].getType())) continue;
                    Assertions.fail((String)("Wrong parameter in constructor. index=" + i + " expected=" + fields[i].getType() + " found=" + ptypes[i]));
                }
                Object instance = c.newInstance((byte)1, (short)2, 3, 4L, Float.valueOf(5.0f), 6.0, Character.valueOf('a'), "xyz", true);
                Assertions.assertThat((Object)fields[0].getValue(instance)).isEqualTo((Object)1);
                Assertions.assertThat((Object)fields[1].getValue(instance)).isEqualTo((Object)2);
                Assertions.assertThat((Object)fields[2].getValue(instance)).isEqualTo((Object)3);
                Assertions.assertThat((Object)fields[3].getValue(instance)).isEqualTo((Object)4L);
                Assertions.assertThat((Object)fields[4].getValue(instance)).isEqualTo((Object)Float.valueOf(5.0f));
                Assertions.assertThat((Object)fields[5].getValue(instance)).isEqualTo((Object)6.0);
                Assertions.assertThat((Object)fields[6].getValue(instance)).isEqualTo((Object)Character.valueOf('a'));
                Assertions.assertThat((Object)fields[7].getValue(instance)).isEqualTo((Object)"xyz");
                Assertions.assertThat((Object)fields[8].getValue(instance)).isEqualTo((Object)true);
                continue;
            }
            if (ptypes.length == fields.length / 2 + 1) {
                int i = 0;
                for (FieldDefinition field : fields) {
                    if (!field.isKey() || ptypes[i++].equals(field.getType())) continue;
                    Assertions.fail((String)("Wrong parameter in constructor. index=" + i + " expected=" + field.getType() + " found=" + ptypes[i]));
                }
                Object instance = c.newInstance((byte)1, 3, Float.valueOf(5.0f), Character.valueOf('a'), true);
                Assertions.assertThat((Object)fields[0].getValue(instance)).isEqualTo((Object)1);
                Assertions.assertThat((Object)fields[2].getValue(instance)).isEqualTo((Object)3);
                Assertions.assertThat((Object)fields[4].getValue(instance)).isEqualTo((Object)Float.valueOf(5.0f));
                Assertions.assertThat((Object)fields[6].getValue(instance)).isEqualTo((Object)Character.valueOf('a'));
                Assertions.assertThat((Object)fields[8].getValue(instance)).isEqualTo((Object)true);
                continue;
            }
            Assertions.fail((String)("Unexpected constructor: " + c.toString()));
        }
    }

    @Test
    public void testGetResourcesJBRULES3122() throws Exception {
        ClassBuilder builder = new TraitClassBuilderFactory().getBeanClassBuilder();
        ClassDefinition classDef = new ClassDefinition("org.drools.TestClass4", null, new String[0]);
        Class clazz = this.build(builder, classDef);
        ClassLoader cl = clazz.getClassLoader();
        Assertions.assertThat((boolean)cl.getResources("not-there.txt").hasMoreElements()).isFalse();
    }
}

