/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.traits.core.factmodel.HierarchyEncoder;
import org.drools.traits.core.factmodel.IndexedTypeHierarchy;
import org.drools.traits.core.util.HierarchyEncoderImpl;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchyTest.class);

    @Test
    public void testHierEncoderTrivial() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", List.of("A"));
        encoder.encode((Object)"C", List.of("B"));
        encoder.encode((Object)"D", Arrays.asList("B", "C"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("11"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("111"));
    }

    @Test
    public void testHierManyRoots() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", Collections.emptyList());
        encoder.encode((Object)"C", Collections.emptyList());
        encoder.encode((Object)"D", Collections.emptyList());
        encoder.encode((Object)"E", Collections.emptyList());
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"E")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((int)encoder.size()).isEqualTo(5);
        Assertions.assertThat((List)encoder.getSortedMembers()).hasSize(5);
        Assertions.assertThat((Map)encoder.getSortedMap()).hasSize(5);
    }

    @Test
    public void testHierManyRootsPropagation() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", List.of("A"));
        encoder.encode((Object)"C", List.of("A"));
        encoder.encode((Object)"D", Arrays.asList("B", "C"));
        encoder.encode((Object)"E", Collections.emptyList());
        LOGGER.debug(encoder.toString());
        BitSet a = encoder.getCode((Object)"A");
        BitSet b = encoder.getCode((Object)"B");
        BitSet c = encoder.getCode((Object)"C");
        BitSet d = encoder.getCode((Object)"D");
        BitSet e = encoder.getCode((Object)"E");
        Assertions.assertThat((int)encoder.superset(b, a)).isGreaterThan(0);
        Assertions.assertThat((int)encoder.superset(c, a)).isGreaterThan(0);
        Assertions.assertThat((int)encoder.superset(d, a)).isGreaterThan(0);
        Assertions.assertThat((int)encoder.superset(d, b)).isGreaterThan(0);
        Assertions.assertThat((int)encoder.superset(d, c)).isGreaterThan(0);
        Assertions.assertThat((int)encoder.superset(e, a)).isLessThan(0);
        Assertions.assertThat((int)encoder.superset(e, b)).isLessThan(0);
        Assertions.assertThat((int)encoder.superset(e, c)).isLessThan(0);
        Assertions.assertThat((int)encoder.superset(e, d)).isLessThan(0);
        Assertions.assertThat((int)encoder.superset(e, e)).isEqualTo(0);
    }

    @Test
    public void testHierALotOfClasses() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        int N = 1194;
        encoder.encode((Object)"A", Collections.emptyList());
        for (int j = 1; j < N; ++j) {
            encoder.encode((Object)("X" + j), List.of("A"));
        }
        Assertions.assertThat((int)encoder.size()).isEqualTo(N);
        BitSet code = encoder.getCode((Object)("X" + (N - 1)));
        Assertions.assertThat((int)code.cardinality()).isEqualTo(1);
        Assertions.assertThat((boolean)code.get(N - 2)).isTrue();
    }

    @Test
    public void testHierEncoderSimpleInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", List.of("A"));
        encoder.encode((Object)"C", List.of("A"));
        encoder.encode((Object)"D", List.of("B"));
        encoder.encode((Object)"E", List.of("B"));
        encoder.encode((Object)"F", List.of("C"));
        encoder.encode((Object)"G", List.of("C"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"E")).isEqualTo((Object)this.parseBitSet("1001"));
        Assertions.assertThat((Object)encoder.getCode((Object)"F")).isEqualTo((Object)this.parseBitSet("110"));
        Assertions.assertThat((Object)encoder.getCode((Object)"G")).isEqualTo((Object)this.parseBitSet("1010"));
    }

    @Test
    public void testHierEncoderAnotherSimpleInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", Collections.emptyList());
        encoder.encode((Object)"A1", List.of("R"));
        encoder.encode((Object)"A2", List.of("R"));
        encoder.encode((Object)"A3", List.of("R"));
        encoder.encode((Object)"B1", List.of("R"));
        encoder.encode((Object)"B2", List.of("R"));
        encoder.encode((Object)"B3", List.of("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("11000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("101000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("110000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B7")).isEqualTo((Object)this.parseBitSet("111000"));
    }

    @Test
    public void testHierEncoderAnotherSimpleInheritanceChangeOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", Collections.emptyList());
        encoder.encode((Object)"B1", List.of("R"));
        encoder.encode((Object)"B2", List.of("R"));
        encoder.encode((Object)"B3", List.of("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        encoder.encode((Object)"A1", List.of("R"));
        encoder.encode((Object)"A2", List.of("R"));
        encoder.encode((Object)"A3", List.of("R"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("11"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("110"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B7")).isEqualTo((Object)this.parseBitSet("111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100000"));
    }

    @Test
    public void testHierEncoderBipartiteInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", Collections.emptyList());
        encoder.encode((Object)"A1", List.of("R"));
        encoder.encode((Object)"A2", List.of("R"));
        encoder.encode((Object)"A3", List.of("R"));
        encoder.encode((Object)"B1", List.of("R"));
        encoder.encode((Object)"B2", List.of("R"));
        encoder.encode((Object)"B3", List.of("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B1", "B2", "B3"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("10111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("1111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("100111000"));
    }

    @Test
    public void testHierEncoderBipartiteInheritanceDiffOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", Collections.emptyList());
        encoder.encode((Object)"B1", List.of("R"));
        encoder.encode((Object)"B2", List.of("R"));
        encoder.encode((Object)"B3", List.of("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"A1", List.of("R"));
        encoder.encode((Object)"A2", List.of("R"));
        encoder.encode((Object)"A3", List.of("R"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("10111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("1111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("100111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100000000"));
    }

    @Test
    public void testSquare() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"T", Collections.emptyList());
        encoder.encode((Object)"A", List.of("T"));
        encoder.encode((Object)"B", List.of("T"));
        encoder.encode((Object)"C", Arrays.asList("A", "B"));
        encoder.encode((Object)"D", Arrays.asList("A", "B"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"T")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("1011"));
    }

    @Test
    public void testConflictArising() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", List.of("A"));
        encoder.encode((Object)"C", List.of("A"));
        encoder.encode((Object)"D", List.of("B"));
        encoder.encode((Object)"E", List.of("B"));
        encoder.encode((Object)"F", List.of("C"));
        encoder.encode((Object)"G", List.of("C"));
        encoder.encode((Object)"H", List.of("E"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"E")).isEqualTo((Object)this.parseBitSet("1001"));
        Assertions.assertThat((Object)encoder.getCode((Object)"F")).isEqualTo((Object)this.parseBitSet("110"));
        Assertions.assertThat((Object)encoder.getCode((Object)"G")).isEqualTo((Object)this.parseBitSet("1010"));
        Assertions.assertThat((Object)encoder.getCode((Object)"H")).isEqualTo((Object)this.parseBitSet("11001"));
        encoder.encode((Object)"I", Arrays.asList("E", "F"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"E")).isEqualTo((Object)this.parseBitSet("1000001"));
        Assertions.assertThat((Object)encoder.getCode((Object)"F")).isEqualTo((Object)this.parseBitSet("100010"));
        Assertions.assertThat((Object)encoder.getCode((Object)"G")).isEqualTo((Object)this.parseBitSet("1010"));
        Assertions.assertThat((Object)encoder.getCode((Object)"H")).isEqualTo((Object)this.parseBitSet("1010001"));
        Assertions.assertThat((Object)encoder.getCode((Object)"I")).isEqualTo((Object)this.parseBitSet("1100011"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'I');
    }

    @Test
    public void testConflictArising2() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", List.of("A"));
        encoder.encode((Object)"C", List.of("A"));
        encoder.encode((Object)"D", List.of("B"));
        encoder.encode((Object)"E", List.of("B"));
        encoder.encode((Object)"F", List.of("C"));
        encoder.encode((Object)"G", List.of("C"));
        encoder.encode((Object)"H", List.of("E"));
        encoder.encode((Object)"J", List.of("F"));
        encoder.encode((Object)"K", List.of("J"));
        LOGGER.debug(encoder.toString());
        encoder.encode((Object)"I", Arrays.asList("E", "F"));
        LOGGER.debug(encoder.toString());
        this.checkHier((HierarchyEncoder<String>)encoder, 'K');
    }

    @Test
    public void testHierEncoderBipartiteStarInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", Collections.emptyList());
        encoder.encode((Object)"B1", List.of("R"));
        encoder.encode((Object)"B2", List.of("R"));
        encoder.encode((Object)"B3", List.of("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        encoder.encode((Object)"A1", List.of("R"));
        encoder.encode((Object)"A2", List.of("R"));
        encoder.encode((Object)"A3", List.of("R"));
        encoder.encode((Object)"A4", Arrays.asList("A1", "A2", "A3"));
        encoder.encode((Object)"A5", List.of("A4"));
        encoder.encode((Object)"A6", List.of("A4"));
        encoder.encode((Object)"A7", List.of("A4"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("11"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("110"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B7")).isEqualTo((Object)this.parseBitSet("111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A4")).isEqualTo((Object)this.parseBitSet("111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A5")).isEqualTo((Object)this.parseBitSet("1111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A6")).isEqualTo((Object)this.parseBitSet("10111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A7")).isEqualTo((Object)this.parseBitSet("100111000"));
    }

    @Test
    public void testHierEncoderBipartiteStarInheritanceDiffOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", Collections.emptyList());
        encoder.encode((Object)"A1", List.of("R"));
        encoder.encode((Object)"A2", List.of("R"));
        encoder.encode((Object)"A3", List.of("R"));
        encoder.encode((Object)"A4", Arrays.asList("A1", "A2", "A3"));
        encoder.encode((Object)"A5", List.of("A4"));
        encoder.encode((Object)"A6", List.of("A4"));
        encoder.encode((Object)"A7", List.of("A4"));
        encoder.encode((Object)"B1", List.of("R"));
        encoder.encode((Object)"B2", List.of("R"));
        encoder.encode((Object)"B3", List.of("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A4")).isEqualTo((Object)this.parseBitSet("111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A5")).isEqualTo((Object)this.parseBitSet("1111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A6")).isEqualTo((Object)this.parseBitSet("10111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A7")).isEqualTo((Object)this.parseBitSet("100111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("011000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("101000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("110000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B7")).isEqualTo((Object)this.parseBitSet("111000000"));
    }

    private BitSet parseBitSet(String s) {
        BitSet b = new BitSet();
        int n = s.length();
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) != '1') continue;
            b.set(n - j - 1);
        }
        return b;
    }

    @Test
    public void testHierEncoderComplexInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        this.checkHier((HierarchyEncoder<String>)encoder, 'A');
        encoder.encode((Object)"B", List.of("A"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'B');
        encoder.encode((Object)"C", List.of("A"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'C');
        encoder.encode((Object)"D", List.of("B"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'D');
        encoder.encode((Object)"E", List.of("B"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'E');
        encoder.encode((Object)"F", List.of("C"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'F');
        encoder.encode((Object)"G", List.of("C"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'G');
        encoder.encode((Object)"H", List.of("D"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'H');
        encoder.encode((Object)"I", List.of("D"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'I');
        encoder.encode((Object)"J", Arrays.asList("E", "F"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'J');
        encoder.encode((Object)"K", Arrays.asList("E", "F"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'K');
        encoder.encode((Object)"L", List.of("G"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'L');
        encoder.encode((Object)"M", List.of("G"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'M');
        encoder.encode((Object)"N", Arrays.asList("I", "L"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'N');
        encoder.encode((Object)"O", Arrays.asList("H", "M"));
        this.checkHier((HierarchyEncoder<String>)encoder, 'O');
        LOGGER.debug(encoder.toString());
        Collection codes = encoder.getSortedMap().values();
        Iterator iter = codes.iterator();
        Long last = -1L;
        for (int j = 0; j < codes.size() - 1; ++j) {
            BitSet ns = (BitSet)iter.next();
            Long next = this.toLong(ns);
            LOGGER.debug(next.toString());
            Assertions.assertThat((Long)next).isGreaterThan((Comparable)last);
            last = next;
        }
    }

    private Long toLong(BitSet ns) {
        long l = 0L;
        for (int j = 0; j < ns.length(); ++j) {
            if (!ns.get(j)) continue;
            l += (long)(1 << j);
        }
        return l;
    }

    private void checkHier(HierarchyEncoder<String> encoder, char fin) {
        int j;
        ArrayList[] sups = new ArrayList[fin - 65 + 1];
        for (j = 65; j <= fin; ++j) {
            sups[j - 65] = ((HierarchyEncoderImpl)encoder).ancestorValues((Object)("" + (char)j));
        }
        for (j = 65; j < 65 + sups.length; ++j) {
            for (int k = 65; k < 65 + sups.length; ++k) {
                String x = "" + (char)j;
                String y = "" + (char)k;
                BitSet xcode = encoder.getCode((Object)x);
                BitSet ycode = encoder.getCode((Object)y);
                int subOf = ((HierarchyEncoderImpl)encoder).superset(xcode, ycode);
                if (x.equals(y)) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)subOf).as(x + " vs " + y, new Object[0])).isEqualTo(0);
                    continue;
                }
                if (sups[j - 65].contains(y)) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)subOf).as(x + " vs " + y, new Object[0])).isEqualTo(1);
                    continue;
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)subOf).as(x + " vs " + y, new Object[0])).isEqualTo(-1);
            }
        }
    }

    @Test
    public void testHierEncoderMoreInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", List.of("A"));
        encoder.encode((Object)"C", List.of("A"));
        encoder.encode((Object)"D", List.of("A"));
        encoder.encode((Object)"E", List.of("B"));
        encoder.encode((Object)"F", List.of("C"));
        encoder.encode((Object)"G", List.of("D"));
        encoder.encode((Object)"H", List.of("D"));
        encoder.encode((Object)"I", List.of("E"));
        encoder.encode((Object)"J", List.of("F"));
        encoder.encode((Object)"K", List.of("G"));
        encoder.encode((Object)"L", Arrays.asList("I", "J"));
        List[] sups = new List[]{encoder.ancestorValues((Object)"A"), encoder.ancestorValues((Object)"B"), encoder.ancestorValues((Object)"C"), encoder.ancestorValues((Object)"D"), encoder.ancestorValues((Object)"E"), encoder.ancestorValues((Object)"F"), encoder.ancestorValues((Object)"G"), encoder.ancestorValues((Object)"H"), encoder.ancestorValues((Object)"I"), encoder.ancestorValues((Object)"J"), encoder.ancestorValues((Object)"K"), encoder.ancestorValues((Object)"L")};
        for (int j = 65; j <= 76; ++j) {
            for (int k = 65; k <= 76; ++k) {
                String x = "" + (char)j;
                String y = "" + (char)k;
                BitSet xcode = encoder.getCode((Object)x);
                BitSet ycode = encoder.getCode((Object)y);
                int subOf = encoder.superset(xcode, ycode);
                if (x.equals(y)) {
                    Assertions.assertThat((int)subOf).isEqualTo(0);
                    continue;
                }
                if (sups[j - 65].contains(y)) {
                    Assertions.assertThat((int)subOf).isEqualTo(1);
                    continue;
                }
                Assertions.assertThat((int)subOf).isEqualTo(-1);
            }
        }
    }

    @Test
    public void testSecondOrderInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"T", Collections.emptyList());
        encoder.encode((Object)"A", List.of("T"));
        encoder.encode((Object)"B", List.of("T"));
        encoder.encode((Object)"C", List.of("T"));
        encoder.encode((Object)"D", List.of("C"));
        encoder.encode((Object)"F", Arrays.asList("B", "C"));
        LOGGER.debug(encoder.toString());
        encoder.encode((Object)"Z", Arrays.asList("A", "B", "D"));
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((int)encoder.superset(encoder.getCode((Object)"Z"), encoder.getCode((Object)"F"))).isLessThan(0);
        Assertions.assertThat((int)encoder.superset(encoder.getCode((Object)"F"), encoder.getCode((Object)"Z"))).isLessThan(0);
    }

    @Test
    public void testDecoderAncestors() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", Collections.emptyList());
        encoder.encode((Object)"A", List.of("Thing"));
        encoder.encode((Object)"Z", List.of("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", List.of("Thing"));
        encoder.encode((Object)"Q", List.of("Thing"));
        encoder.encode((Object)"R", List.of("Thing"));
        encoder.encode((Object)"S", List.of("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        LOGGER.debug(encoder.toString());
        BitSet b = this.parseBitSet("1100111");
        Collection x = encoder.upperAncestors(b);
        LOGGER.debug("ANC " + x);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Q"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"R"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"S"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"M"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        Assertions.assertThat((Collection)x).hasSize(9);
        b = this.parseBitSet("100000");
        x = encoder.upperAncestors(b);
        LOGGER.debug("ANC " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Q"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        b = this.parseBitSet("1111");
        x = encoder.upperAncestors(b);
        LOGGER.debug("ANC " + x);
        Assertions.assertThat((Collection)x).hasSize(6);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"B"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"N"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        b = this.parseBitSet("111");
        x = encoder.upperAncestors(b);
        LOGGER.debug("ANC " + x);
        Assertions.assertThat((Collection)x).hasSize(4);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        b = this.parseBitSet("1");
        x = encoder.upperAncestors(b);
        LOGGER.debug("ANC " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        b = this.parseBitSet("10");
        x = encoder.upperAncestors(b);
        LOGGER.debug("ANC " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        b = this.parseBitSet("0");
        x = encoder.upperAncestors(b);
        LOGGER.debug("ANC " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        b = this.parseBitSet("1011");
        x = encoder.upperAncestors(b);
        LOGGER.debug("ANC " + x);
        Assertions.assertThat((Collection)x).hasSize(4);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"B"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
    }

    @Test
    public void testDecoderDescendants() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", Collections.emptyList());
        encoder.encode((Object)"A", List.of("Thing"));
        encoder.encode((Object)"Z", List.of("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", List.of("Thing"));
        encoder.encode((Object)"Q", List.of("Thing"));
        encoder.encode((Object)"R", List.of("Thing"));
        encoder.encode((Object)"S", List.of("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        LOGGER.debug(encoder.toString());
        BitSet b = this.parseBitSet("111");
        Collection x = encoder.lowerDescendants(b);
        LOGGER.debug("DESC " + x);
        Assertions.assertThat((Collection)x).hasSize(3);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"N"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        b = this.parseBitSet("10");
        x = encoder.lowerDescendants(b);
        LOGGER.debug("DESC " + x);
        Assertions.assertThat((Collection)x).hasSize(5);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"N"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"B"});
        b = this.parseBitSet("100000");
        x = encoder.lowerDescendants(b);
        LOGGER.debug("DESC " + x);
        Assertions.assertThat((Collection)x).hasSize(4);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Q"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"M"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"O"});
        b = this.parseBitSet("100010");
        x = encoder.lowerDescendants(b);
        LOGGER.debug("DESC " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        b = this.parseBitSet("1111");
        x = encoder.lowerDescendants(b);
        LOGGER.debug("DESC " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"N"});
        b = this.parseBitSet("1");
        x = encoder.lowerDescendants(b);
        LOGGER.debug("DESC " + x);
        Assertions.assertThat((Collection)x).hasSize(5);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"B"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"N"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        LOGGER.debug(" +*******************************+ ");
        x = encoder.lowerDescendants(new BitSet());
        LOGGER.debug("DESC " + x);
        Assertions.assertThat((Collection)x).hasSize(13);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
    }

    @Test
    public void testHierEncoderDecoderLower() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", Collections.emptyList());
        encoder.encode((Object)"A", List.of("Thing"));
        encoder.encode((Object)"Z", List.of("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", List.of("Thing"));
        encoder.encode((Object)"Q", List.of("Thing"));
        encoder.encode((Object)"R", List.of("Thing"));
        encoder.encode((Object)"S", List.of("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        LOGGER.debug(encoder.toString());
        Collection x = encoder.lowerBorder(encoder.metMembersCode(List.of("B")));
        LOGGER.debug("GCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"B"});
        x = encoder.immediateChildren(encoder.metMembersCode(List.of("B")));
        LOGGER.debug("GCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"N"});
        x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("Z", "Q")));
        LOGGER.debug("GCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("Z", "Q")));
        LOGGER.debug("GCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("A", "Z")));
        LOGGER.debug("GCS " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"B"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("A", "Z")));
        LOGGER.debug("GCS " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"B"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        x = encoder.lowerBorder(encoder.metMembersCode(List.of("Thing")));
        LOGGER.debug("GCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        x = encoder.immediateChildren(encoder.metMembersCode(List.of("Thing")));
        LOGGER.debug("GCS " + x);
        Assertions.assertThat((Collection)x).hasSize(5);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"P"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Q"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"R"});
    }

    @Test
    public void testHierEncoderDecoderUpper() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", Collections.emptyList());
        encoder.encode((Object)"A", List.of("Thing"));
        encoder.encode((Object)"Z", List.of("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", List.of("Thing"));
        encoder.encode((Object)"Q", List.of("Thing"));
        encoder.encode((Object)"R", List.of("Thing"));
        encoder.encode((Object)"S", List.of("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        LOGGER.debug(encoder.toString());
        Collection x = encoder.upperBorder(encoder.metMembersCode(List.of("B")));
        LOGGER.debug("LCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"B"});
        x = encoder.immediateParents(encoder.metMembersCode(List.of("B")));
        LOGGER.debug("LCS " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        x = encoder.upperBorder(encoder.jointMembersCode(Arrays.asList("Z", "Q")));
        LOGGER.debug("LCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        x = encoder.immediateParents(encoder.jointMembersCode(Arrays.asList("Z", "Q")));
        LOGGER.debug("LCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Thing"});
        x = encoder.upperBorder(encoder.jointMembersCode(Arrays.asList("B", "C")));
        LOGGER.debug("LCS " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        x = encoder.immediateParents(encoder.jointMembersCode(Arrays.asList("B", "C")));
        LOGGER.debug("LCS " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"A"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Z"});
        x = encoder.upperBorder(encoder.jointMembersCode(List.of("T")));
        LOGGER.debug("LCS " + x);
        Assertions.assertThat((Collection)x).hasSize(1);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"T"});
        x = encoder.immediateParents(encoder.jointMembersCode(List.of("T")));
        LOGGER.debug("LCS " + x);
        Assertions.assertThat((Collection)x).hasSize(2);
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"C"});
        Assertions.assertThat((Collection)x).contains((Object[])new String[]{"Q"});
    }

    @Test
    public void testClassInstanceHierarchies() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        BitSet ak = encoder.encode((Object)"A", Collections.emptyList());
        BitSet bk = encoder.encode((Object)"B", List.of("A"));
        BitSet ck = encoder.encode((Object)"C", List.of("A"));
        BitSet dk = encoder.encode((Object)"D", List.of("B"));
        BitSet ek = encoder.encode((Object)"E", List.of("B"));
        BitSet fk = encoder.encode((Object)"F", List.of("C"));
        BitSet gk = encoder.encode((Object)"G", List.of("C"));
        BitSet hk = encoder.encode((Object)"H", List.of("D"));
        BitSet ik = encoder.encode((Object)"I", List.of("D"));
        BitSet jk = encoder.encode((Object)"J", Arrays.asList("E", "F"));
        BitSet kk = encoder.encode((Object)"K", Arrays.asList("E", "F"));
        BitSet lk = encoder.encode((Object)"L", List.of("G"));
        BitSet mk = encoder.encode((Object)"M", List.of("G"));
        BitSet nk = encoder.encode((Object)"N", Arrays.asList("I", "L"));
        BitSet ok = encoder.encode((Object)"O", Arrays.asList("H", "M"));
        LOGGER.debug(encoder.toString());
        IndexedTypeHierarchy types = new IndexedTypeHierarchy((Object)"A", new BitSet(), (Object)"ZZZZ", encoder.getBottom());
        types.addMember((Object)"A", ak);
        types.addMember((Object)"c", ck);
        types.addMember((Object)"f", fk);
        types.addMember((Object)"j", jk);
        types.addMember((Object)"k", kk);
        types.addMember((Object)"n", nk);
        types.addMember((Object)"o", ok);
        types.addMember((Object)"h", hk);
        LOGGER.debug(types.toString());
        Assertions.assertThat((Collection)types.children((Object)"A")).isEqualTo(Arrays.asList("c", "h"));
        Assertions.assertThat((Collection)types.children((Object)"c")).isEqualTo(Arrays.asList("f", "n", "o"));
        Assertions.assertThat((Collection)types.children((Object)"f")).isEqualTo(Arrays.asList("j", "k"));
        Assertions.assertThat((Collection)types.children((Object)"j")).isEqualTo(List.of("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"k")).isEqualTo(List.of("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"n")).isEqualTo(List.of("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"o")).isEqualTo(List.of("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"h")).isEqualTo(List.of("o"));
        Assertions.assertThat((Collection)types.children((Object)"ZZZZ")).isEqualTo(List.of());
        Assertions.assertThat((Collection)types.parents((Object)"a")).isEqualTo(List.of());
        Assertions.assertThat((Collection)types.parents((Object)"c")).isEqualTo(List.of("A"));
        Assertions.assertThat((Collection)types.parents((Object)"f")).isEqualTo(List.of("c"));
        Assertions.assertThat((Collection)types.parents((Object)"j")).isEqualTo(List.of("f"));
        Assertions.assertThat((Collection)types.parents((Object)"k")).isEqualTo(List.of("f"));
        Assertions.assertThat((Collection)types.parents((Object)"n")).isEqualTo(List.of("c"));
        Assertions.assertThat((Collection)types.parents((Object)"o")).isEqualTo(Arrays.asList("c", "h"));
        Assertions.assertThat((Collection)types.parents((Object)"h")).isEqualTo(List.of("A"));
        Assertions.assertThat((Collection)types.parents((Object)"ZZZZ")).isEqualTo(Arrays.asList("j", "k", "n", "o"));
        BitSet pk = encoder.encode((Object)"P", List.of("O"));
        types.addMember((Object)"p", pk);
        LOGGER.debug(types.toString());
        Assertions.assertThat((Collection)types.parents((Object)"p")).isEqualTo(List.of("o"));
        Assertions.assertThat((Collection)types.parents((Object)"ZZZZ")).isEqualTo(Arrays.asList("j", "k", "n", "p"));
        Assertions.assertThat((Collection)types.children((Object)"p")).isEqualTo(List.of("ZZZZ"));
        types.removeMember((Object)"o");
        LOGGER.debug(types.toString());
        Assertions.assertThat((Collection)types.parents((Object)"p")).isEqualTo(Arrays.asList("c", "h"));
        Assertions.assertThat((Collection)types.children((Object)"c")).isEqualTo(Arrays.asList("f", "n", "p"));
        Assertions.assertThat((Collection)types.children((Object)"f")).isEqualTo(Arrays.asList("j", "k"));
        Assertions.assertThat((Collection)types.children((Object)"n")).isEqualTo(List.of("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"p")).isEqualTo(List.of("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"h")).isEqualTo(List.of("p"));
    }

    @Test
    public void testUnwantedCodeOverriding() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        BitSet ak = encoder.encode((Object)"A", Collections.emptyList());
        BitSet ck = encoder.encode((Object)"C", List.of("A"));
        BitSet dk = encoder.encode((Object)"D", List.of("A"));
        BitSet gk = encoder.encode((Object)"G", Arrays.asList("C", "D"));
        BitSet bk = encoder.encode((Object)"B", List.of("A"));
        BitSet ek = encoder.encode((Object)"E", List.of("B"));
        BitSet ik = encoder.encode((Object)"I", Arrays.asList("E", "C"));
        BitSet fk = encoder.encode((Object)"F", Arrays.asList("B", "C"));
        BitSet jk = encoder.encode((Object)"J", Arrays.asList("F", "D"));
        BitSet lk = encoder.encode((Object)"L", List.of("J"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet ok = encoder.encode((Object)"O", List.of("L"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet kk = encoder.encode((Object)"K", Arrays.asList("F", "G"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet mk = encoder.encode((Object)"M", Arrays.asList("J", "K"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet nk = encoder.encode((Object)"N", List.of("K"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet hk = encoder.encode((Object)"H", List.of("F"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet pk = encoder.encode((Object)"P", List.of("A"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        LOGGER.debug(encoder.toString());
        Assertions.assertThat((int)encoder.size()).isEqualTo(16);
    }

    @Test
    public void testDeepTree() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", List.of("A"));
        encoder.encode((Object)"C", List.of("A"));
        encoder.encode((Object)"D", List.of("C"));
        encoder.encode((Object)"E", List.of("D"));
        encoder.encode((Object)"F", List.of("D"));
        encoder.encode((Object)"G", List.of("C"));
        encoder.encode((Object)"H", List.of("G"));
        encoder.encode((Object)"I", List.of("G"));
        encoder.encode((Object)"J", List.of("C"));
        encoder.encode((Object)"K", List.of("C"));
        encoder.encode((Object)"L", List.of("B"));
        encoder.encode((Object)"M", List.of("B"));
        encoder.encode((Object)"N", List.of("A"));
        encoder.encode((Object)"O", List.of("N"));
        LOGGER.debug(encoder.toString());
        this.checkHier((HierarchyEncoder<String>)encoder, 'O');
    }

    @Test
    public void testNestedTree() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", Collections.emptyList());
        encoder.encode((Object)"B", List.of("A"));
        encoder.encode((Object)"C", List.of("B"));
        encoder.encode((Object)"D", List.of("B"));
        encoder.encode((Object)"E", List.of("D"));
        encoder.encode((Object)"F", List.of("E"));
        encoder.encode((Object)"G", List.of("E"));
        encoder.encode((Object)"H", List.of("G"));
        encoder.encode((Object)"I", List.of("H"));
        encoder.encode((Object)"J", List.of("E"));
        encoder.encode((Object)"K", List.of("J"));
        encoder.encode((Object)"L", List.of("K"));
        encoder.encode((Object)"M", List.of("J"));
        encoder.encode((Object)"N", List.of("M"));
        encoder.encode((Object)"O", List.of("J"));
        encoder.encode((Object)"P", List.of("O"));
        encoder.encode((Object)"Q", List.of("J"));
        encoder.encode((Object)"R", List.of("Q"));
        encoder.encode((Object)"S", List.of("B"));
        encoder.encode((Object)"T", List.of("S"));
        encoder.encode((Object)"U", List.of("T"));
        encoder.encode((Object)"V", List.of("B"));
        encoder.encode((Object)"W", List.of("V"));
        encoder.encode((Object)"X", List.of("W"));
        LOGGER.debug(encoder.toString());
        encoder.encode((Object)"Y", Arrays.asList("F", "W"));
        LOGGER.debug(encoder.toString());
        this.checkHier((HierarchyEncoder<String>)encoder, (char)(65 + encoder.size() - 1));
    }
}

