/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.persistence;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Stream;
import org.drools.base.factmodel.traits.Traitable;
import org.drools.traits.persistence.DroolsPersistenceUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.definition.type.Position;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;

public class PersistenceTest {
    private Map<String, Object> context;
    private Environment env;

    public static Stream<String> parameters() {
        return Stream.of(DroolsPersistenceUtil.OPTIMISTIC_LOCKING, DroolsPersistenceUtil.PESSIMISTIC_LOCKING);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.env = DroolsPersistenceUtil.createEnvironment(this.context);
    }

    private void setUpLocking(String locking) {
        if (DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking)) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testTraitsSerialization(String locking) throws Exception {
        this.setUpLocking(locking);
        String drl = "package org.drools.persistence.kie.persistence.session\n\nimport java.util.List\n\nimport " + Door.class.getCanonicalName() + ";\n\ndeclare trait WoodenDoor\n    from : String\n    to : String\n    wood : String\nend\n\nrule \"wooden door\"\n    no-loop\n    when\n        $door : Door()\n    then\n        WoodenDoor woodenDoor = don( $door, WoodenDoor.class );\nend";
        KieServices ks = KieServices.Factory.get();
        Resource drlResource = ks.getResources().newByteArrayResource(drl.getBytes());
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drlResource);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        ksession.insert((Object)new Door());
        ksession.fireAllRules();
    }

    @Traitable
    public static class Door
    implements Serializable {
        private static final long serialVersionUID = 4173662501120948262L;
        @Position(value=0)
        private String fromLocation;
        @Position(value=1)
        private String toLocation;

        public Door() {
            this(null, null);
        }

        public Door(String fromLocation, String toLocation) {
            this.fromLocation = fromLocation;
            this.toLocation = toLocation;
        }

        public String getFromLocation() {
            return this.fromLocation;
        }

        public void setFromLocation(String fromLocation) {
            this.fromLocation = fromLocation;
        }

        public String getToLocation() {
            return this.toLocation;
        }

        public void setToLocation(String toLocation) {
            this.toLocation = toLocation;
        }
    }
}

