/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.meta.org;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.traits.compiler.Person;
import org.drools.traits.compiler.factmodel.traits.TraitTestUtils;
import org.drools.traits.core.factmodel.AbstractTraitFactory;
import org.drools.traits.core.factmodel.Entity;
import org.drools.traits.core.meta.org.test.AnotherKlass;
import org.drools.traits.core.meta.org.test.AnotherKlassImpl;
import org.drools.traits.core.meta.org.test.AnotherKlass_;
import org.drools.traits.core.meta.org.test.Klass;
import org.drools.traits.core.meta.org.test.KlassImpl;
import org.drools.traits.core.meta.org.test.Klass_;
import org.drools.traits.core.meta.org.test.SubKlass;
import org.drools.traits.core.meta.org.test.SubKlassImpl;
import org.drools.traits.core.meta.org.test.SubKlass_;
import org.drools.traits.core.metadata.Identifiable;
import org.drools.traits.core.metadata.Lit;
import org.drools.traits.core.metadata.MetadataContainer;
import org.drools.traits.core.metadata.With;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest {
    @Test
    public void testKlassAndSubKlassWithImpl() {
        SubKlassImpl ski = new SubKlassImpl();
        ski.setSubProp(42);
        ski.setProp("hello");
        SubKlass_<SubKlassImpl> sk = new SubKlass_<SubKlassImpl>(ski);
        Assert.assertEquals((long)42L, (long)((Integer)SubKlass_.subProp.get((Object)ski)).intValue());
        Assert.assertEquals((Object)"hello", (Object)SubKlass_.prop.get((Object)ski));
        ((SubKlass_.SubKlass_Modify)((SubKlass_.SubKlass_Modify)sk.modify(new With[0])).prop("bye")).subProp(-99).call();
        Assert.assertEquals((long)-99L, (long)((Integer)SubKlass_.subProp.get((Object)ski)).intValue());
        Assert.assertEquals((Object)"bye", (Object)SubKlass_.prop.get((Object)ski));
    }

    @Test
    public void testKlassAndSubKlassWithHolderImpl() {
        SubKlassImpl ski = new SubKlassImpl();
        ski.setSubProp(42);
        ski.setProp("hello");
        SubKlass_ sk = ski.get_();
        Assert.assertEquals((long)42L, (long)((Integer)SubKlass_.subProp.get((Object)ski)).intValue());
        Assert.assertEquals((Object)"hello", (Object)SubKlass_.prop.get((Object)ski));
        ((SubKlass_.SubKlass_Modify)((SubKlass_.SubKlass_Modify)sk.modify(new With[0])).prop("bye")).subProp(-99).call();
        Assert.assertEquals((long)-99L, (long)((Integer)SubKlass_.subProp.get((Object)ski)).intValue());
        Assert.assertEquals((Object)"bye", (Object)SubKlass_.prop.get((Object)ski));
    }

    @Test
    public void testKlassAndSubKlassWithInterfaces() {
        Foo ski = new Foo();
        ski.setSubProp(42);
        ski.setProp("hello");
        SubKlass_<Foo> sk = new SubKlass_<Foo>(ski);
        Assert.assertEquals((long)42L, (long)((Integer)SubKlass_.subProp.get((Object)ski)).intValue());
        Assert.assertEquals((Object)"hello", (Object)SubKlass_.prop.get((Object)ski));
        ((SubKlass_.SubKlass_Modify)sk.modify(new With[0])).subProp(-99).prop("bye").call();
        Assert.assertEquals((long)-99L, (long)((Integer)SubKlass_.subProp.get((Object)ski)).intValue());
        Assert.assertEquals((Object)"bye", (Object)SubKlass_.prop.get((Object)ski));
        System.out.println(ski.map);
        HashMap<String, Object> tgt = new HashMap<String, Object>();
        tgt.put("prop", "bye");
        tgt.put("subProp", -99);
        Assert.assertEquals(tgt, ski.map);
    }

    @Test
    public void testMetaPropertiesWithManyKlasses() {
        Foo ski = new Foo();
        ski.setSubProp(42);
        ski.setProp("hello");
        SubKlass_<Foo> sk = new SubKlass_<Foo>(ski);
        AnotherKlassImpl aki = new AnotherKlassImpl();
        aki.setNum(1);
        AnotherKlass_<AnotherKlassImpl> ak = new AnotherKlass_<AnotherKlassImpl>(aki);
        ((SubKlass_.SubKlass_Modify)sk.modify(new With[0])).subProp(-99).prop("bye").call();
        ak.modify(new With[0]).num(-5).call();
        Assert.assertEquals((long)-5L, (long)aki.getNum());
        Assert.assertEquals((long)-99L, (long)ski.getSubProp().intValue());
    }

    @Test
    public void testMetadataInternals() {
        SubKlass_<SubKlassImpl> sk = new SubKlass_<SubKlassImpl>(new SubKlassImpl());
        Klass_<KlassImpl> k = new Klass_<KlassImpl>(new KlassImpl());
        AnotherKlass_<AnotherKlassImpl> ak = new AnotherKlass_<AnotherKlassImpl>(new AnotherKlassImpl());
        Assert.assertEquals((long)4L, (long)ak.getMetaClassInfo().getProperties().length);
        Assert.assertEquals((long)4L, (long)sk.getMetaClassInfo().getProperties().length);
        Assert.assertEquals((long)4L, (long)k.getMetaClassInfo().getProperties().length);
        Assert.assertEquals((Object)"subProp", (Object)sk.getMetaClassInfo().getProperties()[2].getName());
    }

    @Test
    public void testMetadataModifyStyle() {
        SubKlassImpl ski = new SubKlassImpl();
        ((SubKlass_.SubKlass_Modify)SubKlass_.modify(ski, new With[0]).prop("hello")).subProp(42).call();
        Assert.assertEquals((Object)"hello", (Object)ski.getProp());
        Assert.assertEquals((long)42L, (long)ski.getSubProp().intValue());
    }

    @Test
    public void testModificationMask() {
        SubKlassImpl ski = new SubKlassImpl();
        SubKlass_.SubKlass_Modify task = ((SubKlass_.SubKlass_Modify)SubKlass_.modify(ski, new With[0]).prop("hello")).subProp(42);
        task.call();
        Assert.assertEquals((Object)"144", (Object)task.getModificationMask().toString());
        Klass_.Klass_Modify task2 = SubKlass_.modify(ski, new With[0]).prop("hello");
        task2.call();
        Assert.assertEquals((Object)"16", (Object)task2.getModificationMask().toString());
        SubKlass_.SubKlass_Modify<SubKlass> task3 = SubKlass_.modify(ski, new With[0]).subProp(42);
        task3.call();
        Assert.assertEquals((Object)"128", (Object)task3.getModificationMask().toString());
    }

    @Test
    public void testURIs() {
        AnotherKlassImpl aki = new AnotherKlassImpl();
        Assert.assertEquals((Object)URI.create("http://www.test.org#AnotherKlass"), (Object)aki.get_().getMetaClassInfo().getUri());
        URI uRI = URI.create("http://www.test.org#AnotherKlass?num");
        aki.get_();
        Assert.assertEquals((Object)uRI, (Object)AnotherKlass_.num.getUri());
        URI uri = AnotherKlass_.getIdentifier((Object)aki);
        Assert.assertEquals((Object)URI.create("http://www.test.org#AnotherKlass/AnotherKlassImpl/" + System.identityHashCode(aki)), (Object)uri);
        Assert.assertEquals((Object)URI.create(uri.toString() + "/modify?num"), (Object)AnotherKlass_.modify(aki, new With[0]).num(33).getUri());
        Assert.assertTrue((boolean)uri.toString().startsWith(aki.get_().getMetaClassInfo().getUri().toString()));
        Assert.assertEquals((Object)URI.create("http://www.test.org#SubKlass/123?create"), (Object)SubKlass_.newSubKlass(URI.create("http://www.test.org#SubKlass/123"), new With[0]).getUri());
        URI uRI2 = URI.create("123?don=org.drools.traits.core.meta.org.test.AnotherKlass");
        aki.get_();
        Assert.assertEquals((Object)uRI2, (Object)AnotherKlass_.donAnotherKlass(new Foo(), new With[0]).getUri());
    }

    @Test
    public void testNewInstance() {
        Klass klass = (Klass)Klass_.newKlass(URI.create("test"), new With[0]).call();
        Assert.assertNotNull((Object)klass);
        Assert.assertTrue((boolean)(klass instanceof KlassImpl));
        SubKlass klass2 = (SubKlass)SubKlass_.newSubKlass(URI.create("test2"), new With[0]).subProp(42).prop("hello").call();
        Assert.assertEquals((Object)"hello", (Object)klass2.getProp());
        Assert.assertEquals((long)42L, (long)klass2.getSubProp().intValue());
    }

    @Test
    public void testURIsOnLegacyClasses() {
        Person p = new Person();
        URI uri = MetadataContainer.getIdentifier((Object)p);
        Assert.assertEquals((Object)URI.create("urn:" + p.getClass().getPackage().getName() + "/" + p.getClass().getSimpleName() + "/" + System.identityHashCode(p)), (Object)uri);
    }

    @Test
    public void testDon() {
        Entity entity = new Entity("123");
        entity._setDynamicProperties(new HashMap());
        entity._getDynamicProperties().put("prop", "hello");
        Klass klass = (Klass)Klass_.donKlass(entity, new With[0]).setTraitFactory((AbstractTraitFactory)TraitTestUtils.createStandaloneTraitFactory()).call();
        Assert.assertEquals((Object)"hello", (Object)klass.getProp());
    }

    @Test
    public void testDonWithAttributes() {
        Entity entity = new Entity("123");
        entity._setDynamicProperties(new HashMap());
        SubKlass klass = (SubKlass)((SubKlass_.SubKlass_Don)((SubKlass_.SubKlass_Don)SubKlass_.donSubKlass(entity, new With[0]).setTraitFactory((AbstractTraitFactory)TraitTestUtils.createStandaloneTraitFactory())).prop("hello")).subProp(32).call();
        Assert.assertEquals((Object)"hello", (Object)klass.getProp());
        Assert.assertEquals((long)32L, (long)klass.getSubProp().intValue());
    }

    @Test
    public void testInitWithModifyArgs() {
        AnotherKlass aki = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        SubKlass ski = (SubKlass)((SubKlass_.SubKlass_NewInstance)SubKlass_.newSubKlass(URI.create("123"), With.with((Object[])new Object[]{aki})).prop("hello")).subProp(42).another(aki).call();
        Klass ki = (Klass)Klass_.newKlass("1421", new With[0]).call();
        Assert.assertEquals((Object)"hello", (Object)ski.getProp());
        Assert.assertEquals((long)42L, (long)ski.getSubProp().intValue());
        Assert.assertEquals((Object)aki, (Object)ski.getAnother());
    }

    @Test
    public void testCollectionOrientedProperties() {
        AnotherKlass aki0 = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        AnotherKlass aki1 = (AnotherKlass)AnotherKlass_.newAnotherKlass("001", new With[0]).call();
        AnotherKlass aki2 = (AnotherKlass)AnotherKlass_.newAnotherKlass("002", new With[0]).call();
        AnotherKlass aki3 = (AnotherKlass)AnotherKlass_.newAnotherKlass("003", new With[0]).call();
        AnotherKlass aki4 = (AnotherKlass)AnotherKlass_.newAnotherKlass("004", new With[0]).call();
        ArrayList<AnotherKlass> initial = new ArrayList<AnotherKlass>(Arrays.asList(aki0, aki1));
        SubKlass ski = (SubKlass)SubKlass_.newSubKlass(URI.create("123"), new With[0]).links(initial, Lit.SET).links(aki1, Lit.REMOVE).links(aki2, Lit.ADD).links(Arrays.asList(aki3, aki4), Lit.REMOVE).call();
        Assert.assertEquals(Arrays.asList(aki0, aki2), ski.getLinks());
    }

    @Test
    public void testOneToOneProperty() {
        AnotherKlass aki0 = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        Klass klass = (Klass)Klass_.newKlass("001", new With[0]).call();
        Klass_.modify(klass, With.with((Object[])new Object[]{aki0})).another(aki0).call();
        Assert.assertSame((Object)klass.getAnother(), (Object)aki0);
        Assert.assertSame((Object)klass, (Object)aki0.getTheKlass());
        Klass klass1 = (Klass)Klass_.newKlass("002", new With[0]).call();
        AnotherKlass_.modify(aki0, new With[0]).theKlass(klass1).call();
        Assert.assertSame((Object)aki0, (Object)klass1.getAnother());
        Assert.assertSame((Object)klass1, (Object)aki0.getTheKlass());
        Klass_.modify(klass, new With[0]).another(null).call();
        Assert.assertNull((Object)klass.getAnother());
        Assert.assertNull((Object)aki0.getTheKlass());
    }

    @Test
    public void testOneToManyProperty() {
        AnotherKlass aki = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        AnotherKlass aki2 = (AnotherKlass)AnotherKlass_.newAnotherKlass("999", new With[0]).call();
        Klass klass1 = (Klass)Klass_.newKlass("001", new With[0]).call();
        Klass klass2 = (Klass)Klass_.newKlass("002", new With[0]).call();
        AnotherKlass_.modify(aki, With.with((Object[])new Object[]{klass1, klass2})).manyKlasses(new ArrayList<Klass>(Arrays.asList(klass1, klass2)), Lit.SET).call();
        Assert.assertSame((Object)aki, (Object)klass1.getOneAnother());
        Assert.assertSame((Object)aki, (Object)klass2.getOneAnother());
        AnotherKlass_.modify(aki2, new With[0]).manyKlasses(klass1, Lit.ADD).call();
        Assert.assertSame((Object)aki2, (Object)klass1.getOneAnother());
        Assert.assertSame((Object)aki, (Object)klass2.getOneAnother());
        Assert.assertFalse((boolean)aki.getManyKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki2.getManyKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki.getManyKlasses().contains(klass2));
        AnotherKlass_.modify(aki2, new With[0]).manyKlasses(klass1, Lit.REMOVE).call();
        Assert.assertNull((Object)klass1.getOneAnother());
        Assert.assertFalse((boolean)aki2.getManyKlasses().contains(klass1));
    }

    @Test
    public void testManyToOneProperty() {
        AnotherKlass aki = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        AnotherKlass aki2 = (AnotherKlass)AnotherKlass_.newAnotherKlass("999", new With[0]).call();
        Klass klass1 = (Klass)Klass_.newKlass("001", new With[0]).call();
        Klass klass2 = (Klass)Klass_.newKlass("002", new With[0]).call();
        Klass_.modify(klass1, new With[0]).oneAnother(aki).call();
        Klass_.modify(klass2, new With[0]).oneAnother(aki).call();
        Assert.assertSame((Object)aki, (Object)klass1.getOneAnother());
        Assert.assertSame((Object)aki, (Object)klass2.getOneAnother());
        Assert.assertEquals(Arrays.asList(klass1, klass2), aki.getManyKlasses());
        Klass_.modify(klass1, new With[0]).oneAnother(aki2).call();
        Assert.assertSame((Object)aki2, (Object)klass1.getOneAnother());
        Assert.assertEquals(Arrays.asList(klass1), aki2.getManyKlasses());
        Assert.assertEquals(Arrays.asList(klass2), aki.getManyKlasses());
    }

    @Test
    public void testManyToManyProperty() {
        AnotherKlass aki1 = (AnotherKlass)AnotherKlass_.newAnotherKlass("000", new With[0]).call();
        AnotherKlass aki2 = (AnotherKlass)AnotherKlass_.newAnotherKlass("999", new With[0]).call();
        Klass klass1 = (Klass)Klass_.newKlass("001", new With[0]).call();
        Klass klass2 = (Klass)Klass_.newKlass("002", new With[0]).call();
        Klass_.modify(klass1, new With[0]).manyOthers(aki1, Lit.ADD).call();
        Klass_.modify(klass1, new With[0]).manyOthers(aki2, Lit.ADD).call();
        AnotherKlass_.modify(aki2, new With[0]).manyMoreKlasses(klass2, Lit.ADD).call();
        AnotherKlass_.modify(aki1, new With[0]).manyMoreKlasses(klass2, Lit.ADD).call();
        Assert.assertTrue((boolean)klass1.getManyAnothers().contains(aki1));
        Assert.assertTrue((boolean)klass1.getManyAnothers().contains(aki2));
        Assert.assertTrue((boolean)klass2.getManyAnothers().contains(aki1));
        Assert.assertTrue((boolean)klass2.getManyAnothers().contains(aki2));
        Assert.assertTrue((boolean)aki1.getManyMoreKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki1.getManyMoreKlasses().contains(klass2));
        Assert.assertTrue((boolean)aki2.getManyMoreKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki2.getManyMoreKlasses().contains(klass2));
        AnotherKlass_.modify(aki2, new With[0]).manyMoreKlasses(klass2, Lit.REMOVE).call();
        Assert.assertTrue((boolean)klass1.getManyAnothers().contains(aki1));
        Assert.assertTrue((boolean)klass1.getManyAnothers().contains(aki2));
        Assert.assertTrue((boolean)klass2.getManyAnothers().contains(aki1));
        Assert.assertFalse((boolean)klass2.getManyAnothers().contains(aki2));
        Assert.assertTrue((boolean)aki1.getManyMoreKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki1.getManyMoreKlasses().contains(klass2));
        Assert.assertTrue((boolean)aki2.getManyMoreKlasses().contains(klass1));
        Assert.assertFalse((boolean)aki2.getManyMoreKlasses().contains(klass2));
        AnotherKlass_.modify(aki2, new With[0]).manyMoreKlasses(klass2, Lit.ADD).call();
        Assert.assertTrue((boolean)klass1.getManyAnothers().contains(aki1));
        Assert.assertTrue((boolean)klass1.getManyAnothers().contains(aki2));
        Assert.assertTrue((boolean)klass2.getManyAnothers().contains(aki1));
        Assert.assertTrue((boolean)klass2.getManyAnothers().contains(aki2));
        Assert.assertTrue((boolean)aki1.getManyMoreKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki1.getManyMoreKlasses().contains(klass2));
        Assert.assertTrue((boolean)aki2.getManyMoreKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki2.getManyMoreKlasses().contains(klass2));
        AnotherKlass_.modify(aki2, new With[0]).manyMoreKlasses(klass2, Lit.SET).call();
        Assert.assertTrue((boolean)klass1.getManyAnothers().contains(aki1));
        Assert.assertFalse((boolean)klass1.getManyAnothers().contains(aki2));
        Assert.assertTrue((boolean)klass2.getManyAnothers().contains(aki1));
        Assert.assertTrue((boolean)klass2.getManyAnothers().contains(aki2));
        Assert.assertTrue((boolean)aki1.getManyMoreKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki1.getManyMoreKlasses().contains(klass2));
        Assert.assertFalse((boolean)aki2.getManyMoreKlasses().contains(klass1));
        Assert.assertTrue((boolean)aki2.getManyMoreKlasses().contains(klass2));
    }

    public static class Foo
    implements SubKlass,
    Identifiable {
        private URI uri;
        public Map<String, Object> map = new HashMap<String, Object>();

        public Foo() {
            this("123");
        }

        public Foo(String uri) {
            this.uri = URI.create(uri);
        }

        @Override
        public String getProp() {
            return (String)this.map.get("prop");
        }

        @Override
        public void setProp(String value) {
            this.map.put("prop", value);
        }

        @Override
        public AnotherKlass getAnother() {
            return (AnotherKlass)this.map.get("another");
        }

        @Override
        public void setAnother(AnotherKlass another) {
            this.map.put("another", another);
        }

        @Override
        public AnotherKlass getOneAnother() {
            return null;
        }

        @Override
        public void setOneAnother(AnotherKlass another) {
        }

        @Override
        public List<AnotherKlass> getManyAnothers() {
            return null;
        }

        @Override
        public void setManyAnothers(List<AnotherKlass> anothers) {
        }

        @Override
        public Integer getSubProp() {
            return (Integer)this.map.get("subProp");
        }

        @Override
        public void setSubProp(Integer value) {
            this.map.put("subProp", value);
        }

        @Override
        public List<AnotherKlass> getLinks() {
            return null;
        }

        @Override
        public void setLinks(List<AnotherKlass> links) {
        }

        public URI getUri() {
            return this.uri;
        }

        public Object getId() {
            return this.uri;
        }
    }
}

