/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.util.HierarchyEncoder;
import org.drools.traits.core.factmodel.IndexedTypeHierarchy;
import org.drools.traits.core.util.HierarchyEncoderImpl;
import org.junit.Assert;
import org.junit.Test;

public class HierarchyTest {
    @Test
    public void testHierEncoderTrivial() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("B"));
        encoder.encode((Object)"D", Arrays.asList("B", "C"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"A"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"B"));
        Assert.assertEquals((Object)this.parseBitSet("11"), (Object)encoder.getCode((Object)"C"));
        Assert.assertEquals((Object)this.parseBitSet("111"), (Object)encoder.getCode((Object)"D"));
    }

    @Test
    public void testHierManyRoots() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"C", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"D", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"E", (Collection)Collections.EMPTY_LIST);
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"A"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"B"));
        Assert.assertEquals((Object)this.parseBitSet("100"), (Object)encoder.getCode((Object)"C"));
        Assert.assertEquals((Object)this.parseBitSet("1000"), (Object)encoder.getCode((Object)"D"));
        Assert.assertEquals((Object)this.parseBitSet("10000"), (Object)encoder.getCode((Object)"E"));
        Assert.assertEquals((long)5L, (long)encoder.size());
        Assert.assertEquals((long)5L, (long)encoder.getSortedMembers().size());
        Assert.assertEquals((long)5L, (long)encoder.getSortedMap().size());
    }

    @Test
    public void testHierManyRootsPropagation() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("B", "C"));
        encoder.encode((Object)"E", (Collection)Collections.EMPTY_LIST);
        System.out.println(encoder);
        BitSet a = encoder.getCode((Object)"A");
        BitSet b = encoder.getCode((Object)"B");
        BitSet c = encoder.getCode((Object)"C");
        BitSet d = encoder.getCode((Object)"D");
        BitSet e = encoder.getCode((Object)"E");
        Assert.assertTrue((encoder.superset(b, a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(c, a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(d, a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(d, b) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(d, c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(e, a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(e, b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(e, c) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(e, d) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(e, e) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHierALotOfClasses() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        int N = 1194;
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        for (int j = 1; j < N; ++j) {
            encoder.encode((Object)("X" + j), Arrays.asList("A"));
        }
        Assert.assertEquals((long)N, (long)encoder.size());
        BitSet code = encoder.getCode((Object)("X" + (N - 1)));
        Assert.assertEquals((long)1L, (long)code.cardinality());
        Assert.assertTrue((boolean)code.get(N - 2));
    }

    @Test
    public void testHierEncoderSimpleInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("B"));
        encoder.encode((Object)"E", Arrays.asList("B"));
        encoder.encode((Object)"F", Arrays.asList("C"));
        encoder.encode((Object)"G", Arrays.asList("C"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"A"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"B"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"C"));
        Assert.assertEquals((Object)this.parseBitSet("101"), (Object)encoder.getCode((Object)"D"));
        Assert.assertEquals((Object)this.parseBitSet("1001"), (Object)encoder.getCode((Object)"E"));
        Assert.assertEquals((Object)this.parseBitSet("110"), (Object)encoder.getCode((Object)"F"));
        Assert.assertEquals((Object)this.parseBitSet("1010"), (Object)encoder.getCode((Object)"G"));
    }

    @Test
    public void testHierEncoderAnotherSimpleInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"R"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"A1"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"A2"));
        Assert.assertEquals((Object)this.parseBitSet("100"), (Object)encoder.getCode((Object)"A3"));
        Assert.assertEquals((Object)this.parseBitSet("1000"), (Object)encoder.getCode((Object)"B1"));
        Assert.assertEquals((Object)this.parseBitSet("10000"), (Object)encoder.getCode((Object)"B2"));
        Assert.assertEquals((Object)this.parseBitSet("100000"), (Object)encoder.getCode((Object)"B3"));
        Assert.assertEquals((Object)this.parseBitSet("11000"), (Object)encoder.getCode((Object)"B4"));
        Assert.assertEquals((Object)this.parseBitSet("101000"), (Object)encoder.getCode((Object)"B5"));
        Assert.assertEquals((Object)this.parseBitSet("110000"), (Object)encoder.getCode((Object)"B6"));
        Assert.assertEquals((Object)this.parseBitSet("111000"), (Object)encoder.getCode((Object)"B7"));
    }

    @Test
    public void testHierEncoderAnotherSimpleInheritanceChangeOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"R"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"B1"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"B2"));
        Assert.assertEquals((Object)this.parseBitSet("100"), (Object)encoder.getCode((Object)"B3"));
        Assert.assertEquals((Object)this.parseBitSet("11"), (Object)encoder.getCode((Object)"B4"));
        Assert.assertEquals((Object)this.parseBitSet("101"), (Object)encoder.getCode((Object)"B5"));
        Assert.assertEquals((Object)this.parseBitSet("110"), (Object)encoder.getCode((Object)"B6"));
        Assert.assertEquals((Object)this.parseBitSet("111"), (Object)encoder.getCode((Object)"B7"));
        Assert.assertEquals((Object)this.parseBitSet("1000"), (Object)encoder.getCode((Object)"A1"));
        Assert.assertEquals((Object)this.parseBitSet("10000"), (Object)encoder.getCode((Object)"A2"));
        Assert.assertEquals((Object)this.parseBitSet("100000"), (Object)encoder.getCode((Object)"A3"));
    }

    @Test
    public void testHierEncoderBipartiteInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B1", "B2", "B3"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"R"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"A1"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"A2"));
        Assert.assertEquals((Object)this.parseBitSet("100"), (Object)encoder.getCode((Object)"A3"));
        Assert.assertEquals((Object)this.parseBitSet("1000"), (Object)encoder.getCode((Object)"B1"));
        Assert.assertEquals((Object)this.parseBitSet("10000"), (Object)encoder.getCode((Object)"B2"));
        Assert.assertEquals((Object)this.parseBitSet("100000"), (Object)encoder.getCode((Object)"B3"));
        Assert.assertEquals((Object)this.parseBitSet("10111000"), (Object)encoder.getCode((Object)"B4"));
        Assert.assertEquals((Object)this.parseBitSet("1111000"), (Object)encoder.getCode((Object)"B5"));
        Assert.assertEquals((Object)this.parseBitSet("100111000"), (Object)encoder.getCode((Object)"B6"));
    }

    @Test
    public void testHierEncoderBipartiteInheritanceDiffOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"R"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"B1"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"B2"));
        Assert.assertEquals((Object)this.parseBitSet("100"), (Object)encoder.getCode((Object)"B3"));
        Assert.assertEquals((Object)this.parseBitSet("10111"), (Object)encoder.getCode((Object)"B4"));
        Assert.assertEquals((Object)this.parseBitSet("1111"), (Object)encoder.getCode((Object)"B5"));
        Assert.assertEquals((Object)this.parseBitSet("100111"), (Object)encoder.getCode((Object)"B6"));
        Assert.assertEquals((Object)this.parseBitSet("1000000"), (Object)encoder.getCode((Object)"A1"));
        Assert.assertEquals((Object)this.parseBitSet("10000000"), (Object)encoder.getCode((Object)"A2"));
        Assert.assertEquals((Object)this.parseBitSet("100000000"), (Object)encoder.getCode((Object)"A3"));
    }

    @Test
    public void testSquare() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"T", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("T"));
        encoder.encode((Object)"B", Arrays.asList("T"));
        encoder.encode((Object)"C", Arrays.asList("A", "B"));
        encoder.encode((Object)"D", Arrays.asList("A", "B"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"T"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"A"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"B"));
        Assert.assertEquals((Object)this.parseBitSet("111"), (Object)encoder.getCode((Object)"D"));
        Assert.assertEquals((Object)this.parseBitSet("1011"), (Object)encoder.getCode((Object)"C"));
    }

    @Test
    public void testConflictArising() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("B"));
        encoder.encode((Object)"E", Arrays.asList("B"));
        encoder.encode((Object)"F", Arrays.asList("C"));
        encoder.encode((Object)"G", Arrays.asList("C"));
        encoder.encode((Object)"H", Arrays.asList("E"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"A"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"B"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"C"));
        Assert.assertEquals((Object)this.parseBitSet("101"), (Object)encoder.getCode((Object)"D"));
        Assert.assertEquals((Object)this.parseBitSet("1001"), (Object)encoder.getCode((Object)"E"));
        Assert.assertEquals((Object)this.parseBitSet("110"), (Object)encoder.getCode((Object)"F"));
        Assert.assertEquals((Object)this.parseBitSet("1010"), (Object)encoder.getCode((Object)"G"));
        Assert.assertEquals((Object)this.parseBitSet("11001"), (Object)encoder.getCode((Object)"H"));
        encoder.encode((Object)"I", Arrays.asList("E", "F"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"A"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"B"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"C"));
        Assert.assertEquals((Object)this.parseBitSet("101"), (Object)encoder.getCode((Object)"D"));
        Assert.assertEquals((Object)this.parseBitSet("1000001"), (Object)encoder.getCode((Object)"E"));
        Assert.assertEquals((Object)this.parseBitSet("100010"), (Object)encoder.getCode((Object)"F"));
        Assert.assertEquals((Object)this.parseBitSet("1010"), (Object)encoder.getCode((Object)"G"));
        Assert.assertEquals((Object)this.parseBitSet("1010001"), (Object)encoder.getCode((Object)"H"));
        Assert.assertEquals((Object)this.parseBitSet("1100011"), (Object)encoder.getCode((Object)"I"));
        this.checkHier((HierarchyEncoder)encoder, 'I');
    }

    @Test
    public void testConflictArising2() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("B"));
        encoder.encode((Object)"E", Arrays.asList("B"));
        encoder.encode((Object)"F", Arrays.asList("C"));
        encoder.encode((Object)"G", Arrays.asList("C"));
        encoder.encode((Object)"H", Arrays.asList("E"));
        encoder.encode((Object)"J", Arrays.asList("F"));
        encoder.encode((Object)"K", Arrays.asList("J"));
        System.out.println(encoder);
        encoder.encode((Object)"I", Arrays.asList("E", "F"));
        System.out.println(encoder);
        this.checkHier((HierarchyEncoder)encoder, 'K');
    }

    @Test
    public void testHierEncoderBipartiteStarInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        encoder.encode((Object)"A4", Arrays.asList("A1", "A2", "A3"));
        encoder.encode((Object)"A5", Arrays.asList("A4"));
        encoder.encode((Object)"A6", Arrays.asList("A4"));
        encoder.encode((Object)"A7", Arrays.asList("A4"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"R"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"B1"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"B2"));
        Assert.assertEquals((Object)this.parseBitSet("100"), (Object)encoder.getCode((Object)"B3"));
        Assert.assertEquals((Object)this.parseBitSet("11"), (Object)encoder.getCode((Object)"B4"));
        Assert.assertEquals((Object)this.parseBitSet("101"), (Object)encoder.getCode((Object)"B5"));
        Assert.assertEquals((Object)this.parseBitSet("110"), (Object)encoder.getCode((Object)"B6"));
        Assert.assertEquals((Object)this.parseBitSet("111"), (Object)encoder.getCode((Object)"B7"));
        Assert.assertEquals((Object)this.parseBitSet("1000"), (Object)encoder.getCode((Object)"A1"));
        Assert.assertEquals((Object)this.parseBitSet("10000"), (Object)encoder.getCode((Object)"A2"));
        Assert.assertEquals((Object)this.parseBitSet("100000"), (Object)encoder.getCode((Object)"A3"));
        Assert.assertEquals((Object)this.parseBitSet("111000"), (Object)encoder.getCode((Object)"A4"));
        Assert.assertEquals((Object)this.parseBitSet("1111000"), (Object)encoder.getCode((Object)"A5"));
        Assert.assertEquals((Object)this.parseBitSet("10111000"), (Object)encoder.getCode((Object)"A6"));
        Assert.assertEquals((Object)this.parseBitSet("100111000"), (Object)encoder.getCode((Object)"A7"));
    }

    @Test
    public void testHierEncoderBipartiteStarInheritanceDiffOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        encoder.encode((Object)"A4", Arrays.asList("A1", "A2", "A3"));
        encoder.encode((Object)"A5", Arrays.asList("A4"));
        encoder.encode((Object)"A6", Arrays.asList("A4"));
        encoder.encode((Object)"A7", Arrays.asList("A4"));
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        System.out.println(encoder);
        Assert.assertEquals((Object)this.parseBitSet("0"), (Object)encoder.getCode((Object)"R"));
        Assert.assertEquals((Object)this.parseBitSet("1"), (Object)encoder.getCode((Object)"A1"));
        Assert.assertEquals((Object)this.parseBitSet("10"), (Object)encoder.getCode((Object)"A2"));
        Assert.assertEquals((Object)this.parseBitSet("100"), (Object)encoder.getCode((Object)"A3"));
        Assert.assertEquals((Object)this.parseBitSet("111"), (Object)encoder.getCode((Object)"A4"));
        Assert.assertEquals((Object)this.parseBitSet("1111"), (Object)encoder.getCode((Object)"A5"));
        Assert.assertEquals((Object)this.parseBitSet("10111"), (Object)encoder.getCode((Object)"A6"));
        Assert.assertEquals((Object)this.parseBitSet("100111"), (Object)encoder.getCode((Object)"A7"));
        Assert.assertEquals((Object)this.parseBitSet("1000000"), (Object)encoder.getCode((Object)"B1"));
        Assert.assertEquals((Object)this.parseBitSet("10000000"), (Object)encoder.getCode((Object)"B2"));
        Assert.assertEquals((Object)this.parseBitSet("100000000"), (Object)encoder.getCode((Object)"B3"));
        Assert.assertEquals((Object)this.parseBitSet("011000000"), (Object)encoder.getCode((Object)"B4"));
        Assert.assertEquals((Object)this.parseBitSet("101000000"), (Object)encoder.getCode((Object)"B5"));
        Assert.assertEquals((Object)this.parseBitSet("110000000"), (Object)encoder.getCode((Object)"B6"));
        Assert.assertEquals((Object)this.parseBitSet("111000000"), (Object)encoder.getCode((Object)"B7"));
    }

    private BitSet parseBitSet(String s) {
        BitSet b = new BitSet();
        int n = s.length();
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) != '1') continue;
            b.set(n - j - 1);
        }
        return b;
    }

    @Test
    public void testHierEncoderComplexInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        this.checkHier((HierarchyEncoder)encoder, 'A');
        encoder.encode((Object)"B", Arrays.asList("A"));
        this.checkHier((HierarchyEncoder)encoder, 'B');
        encoder.encode((Object)"C", Arrays.asList("A"));
        this.checkHier((HierarchyEncoder)encoder, 'C');
        encoder.encode((Object)"D", Arrays.asList("B"));
        this.checkHier((HierarchyEncoder)encoder, 'D');
        encoder.encode((Object)"E", Arrays.asList("B"));
        this.checkHier((HierarchyEncoder)encoder, 'E');
        encoder.encode((Object)"F", Arrays.asList("C"));
        this.checkHier((HierarchyEncoder)encoder, 'F');
        encoder.encode((Object)"G", Arrays.asList("C"));
        this.checkHier((HierarchyEncoder)encoder, 'G');
        encoder.encode((Object)"H", Arrays.asList("D"));
        this.checkHier((HierarchyEncoder)encoder, 'H');
        encoder.encode((Object)"I", Arrays.asList("D"));
        this.checkHier((HierarchyEncoder)encoder, 'I');
        encoder.encode((Object)"J", Arrays.asList("E", "F"));
        this.checkHier((HierarchyEncoder)encoder, 'J');
        encoder.encode((Object)"K", Arrays.asList("E", "F"));
        this.checkHier((HierarchyEncoder)encoder, 'K');
        encoder.encode((Object)"L", Arrays.asList("G"));
        this.checkHier((HierarchyEncoder)encoder, 'L');
        encoder.encode((Object)"M", Arrays.asList("G"));
        this.checkHier((HierarchyEncoder)encoder, 'M');
        encoder.encode((Object)"N", Arrays.asList("I", "L"));
        this.checkHier((HierarchyEncoder)encoder, 'N');
        encoder.encode((Object)"O", Arrays.asList("H", "M"));
        this.checkHier((HierarchyEncoder)encoder, 'O');
        System.out.println(encoder);
        Collection codes = encoder.getSortedMap().values();
        Iterator iter = codes.iterator();
        Long last = -1L;
        for (int j = 0; j < codes.size() - 1; ++j) {
            BitSet ns = (BitSet)iter.next();
            Long next = this.toLong(ns);
            System.out.println(next);
            Assert.assertTrue((next > last ? 1 : 0) != 0);
            last = next;
        }
    }

    private Long toLong(BitSet ns) {
        Long l = 0L;
        for (int j = 0; j < ns.length(); ++j) {
            if (!ns.get(j)) continue;
            l = l + (long)(1 << j);
        }
        return l;
    }

    private void checkHier(HierarchyEncoder encoder, char fin) {
        int j;
        ArrayList[] sups = new ArrayList[fin - 65 + 1];
        for (j = 65; j <= fin; ++j) {
            sups[j - 65] = ((HierarchyEncoderImpl)encoder).ancestorValues((Object)("" + (char)j));
        }
        for (j = 65; j < 65 + sups.length; ++j) {
            for (int k = 65; k < 65 + sups.length; ++k) {
                String x = "" + (char)j;
                String y = "" + (char)k;
                BitSet xcode = encoder.getCode((Object)x);
                BitSet ycode = encoder.getCode((Object)y);
                int subOf = ((HierarchyEncoderImpl)encoder).superset(xcode, ycode);
                if (x.equals(y)) {
                    Assert.assertEquals((String)(x + " vs " + y), (long)0L, (long)subOf);
                    continue;
                }
                if (sups[j - 65].contains(y)) {
                    Assert.assertEquals((String)(x + " vs " + y), (long)1L, (long)subOf);
                    continue;
                }
                Assert.assertEquals((String)(x + " vs " + y), (long)-1L, (long)subOf);
            }
        }
    }

    @Test
    public void testHierEncoderMoreInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("A"));
        encoder.encode((Object)"E", Arrays.asList("B"));
        encoder.encode((Object)"F", Arrays.asList("C"));
        encoder.encode((Object)"G", Arrays.asList("D"));
        encoder.encode((Object)"H", Arrays.asList("D"));
        encoder.encode((Object)"I", Arrays.asList("E"));
        encoder.encode((Object)"J", Arrays.asList("F"));
        encoder.encode((Object)"K", Arrays.asList("G"));
        encoder.encode((Object)"L", Arrays.asList("I", "J"));
        List[] sups = new List[]{encoder.ancestorValues((Object)"A"), encoder.ancestorValues((Object)"B"), encoder.ancestorValues((Object)"C"), encoder.ancestorValues((Object)"D"), encoder.ancestorValues((Object)"E"), encoder.ancestorValues((Object)"F"), encoder.ancestorValues((Object)"G"), encoder.ancestorValues((Object)"H"), encoder.ancestorValues((Object)"I"), encoder.ancestorValues((Object)"J"), encoder.ancestorValues((Object)"K"), encoder.ancestorValues((Object)"L")};
        for (int j = 65; j <= 76; ++j) {
            for (int k = 65; k <= 76; ++k) {
                String x = "" + (char)j;
                String y = "" + (char)k;
                BitSet xcode = encoder.getCode((Object)x);
                BitSet ycode = encoder.getCode((Object)y);
                int subOf = encoder.superset(xcode, ycode);
                if (x.equals(y)) {
                    Assert.assertEquals((long)0L, (long)subOf);
                    continue;
                }
                if (sups[j - 65].contains(y)) {
                    Assert.assertEquals((long)1L, (long)subOf);
                    continue;
                }
                Assert.assertEquals((long)-1L, (long)subOf);
            }
        }
    }

    @Test
    public void testSecondOrderInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"T", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("T"));
        encoder.encode((Object)"B", Arrays.asList("T"));
        encoder.encode((Object)"C", Arrays.asList("T"));
        encoder.encode((Object)"D", Arrays.asList("C"));
        encoder.encode((Object)"F", Arrays.asList("B", "C"));
        System.out.println(encoder);
        encoder.encode((Object)"Z", Arrays.asList("A", "B", "D"));
        System.out.println(encoder);
        Assert.assertTrue((encoder.superset(encoder.getCode((Object)"Z"), encoder.getCode((Object)"F")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((encoder.superset(encoder.getCode((Object)"F"), encoder.getCode((Object)"Z")) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDecoderAncestors() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("Thing"));
        encoder.encode((Object)"Z", Arrays.asList("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", Arrays.asList("Thing"));
        encoder.encode((Object)"Q", Arrays.asList("Thing"));
        encoder.encode((Object)"R", Arrays.asList("Thing"));
        encoder.encode((Object)"S", Arrays.asList("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        System.out.println(encoder);
        BitSet b = this.parseBitSet("1100111");
        Collection x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("Z"));
        Assert.assertTrue((boolean)x.contains("C"));
        Assert.assertTrue((boolean)x.contains("Q"));
        Assert.assertTrue((boolean)x.contains("T"));
        Assert.assertTrue((boolean)x.contains("R"));
        Assert.assertTrue((boolean)x.contains("S"));
        Assert.assertTrue((boolean)x.contains("M"));
        Assert.assertTrue((boolean)x.contains("Thing"));
        Assert.assertEquals((long)9L, (long)x.size());
        b = this.parseBitSet("100000");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Q"));
        Assert.assertTrue((boolean)x.contains("Thing"));
        b = this.parseBitSet("1111");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assert.assertEquals((long)6L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("Z"));
        Assert.assertTrue((boolean)x.contains("B"));
        Assert.assertTrue((boolean)x.contains("C"));
        Assert.assertTrue((boolean)x.contains("N"));
        Assert.assertTrue((boolean)x.contains("Thing"));
        b = this.parseBitSet("111");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assert.assertEquals((long)4L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("Z"));
        Assert.assertTrue((boolean)x.contains("C"));
        Assert.assertTrue((boolean)x.contains("Thing"));
        b = this.parseBitSet("1");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("Thing"));
        b = this.parseBitSet("10");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Z"));
        Assert.assertTrue((boolean)x.contains("Thing"));
        b = this.parseBitSet("0");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Thing"));
        b = this.parseBitSet("1011");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assert.assertEquals((long)4L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Thing"));
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("B"));
        Assert.assertTrue((boolean)x.contains("Z"));
    }

    @Test
    public void testDecoderDescendants() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("Thing"));
        encoder.encode((Object)"Z", Arrays.asList("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", Arrays.asList("Thing"));
        encoder.encode((Object)"Q", Arrays.asList("Thing"));
        encoder.encode((Object)"R", Arrays.asList("Thing"));
        encoder.encode((Object)"S", Arrays.asList("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        System.out.println(encoder);
        BitSet b = this.parseBitSet("111");
        Collection x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assert.assertEquals((long)3L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("C"));
        Assert.assertTrue((boolean)x.contains("N"));
        Assert.assertTrue((boolean)x.contains("T"));
        b = this.parseBitSet("10");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assert.assertEquals((long)5L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("C"));
        Assert.assertTrue((boolean)x.contains("N"));
        Assert.assertTrue((boolean)x.contains("T"));
        Assert.assertTrue((boolean)x.contains("Z"));
        Assert.assertTrue((boolean)x.contains("B"));
        b = this.parseBitSet("100000");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assert.assertEquals((long)4L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Q"));
        Assert.assertTrue((boolean)x.contains("T"));
        Assert.assertTrue((boolean)x.contains("M"));
        Assert.assertTrue((boolean)x.contains("O"));
        b = this.parseBitSet("100010");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("T"));
        b = this.parseBitSet("1111");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("N"));
        b = this.parseBitSet("1");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assert.assertEquals((long)5L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("B"));
        Assert.assertTrue((boolean)x.contains("C"));
        Assert.assertTrue((boolean)x.contains("N"));
        Assert.assertTrue((boolean)x.contains("T"));
        System.out.println(" +*******************************+ ");
        x = encoder.lowerDescendants(new BitSet());
        System.out.println("DESC " + x);
        Assert.assertEquals((long)13L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Z"));
        Assert.assertTrue((boolean)x.contains("Thing"));
    }

    @Test
    public void testHierEncoderDecoderLower() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("Thing"));
        encoder.encode((Object)"Z", Arrays.asList("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", Arrays.asList("Thing"));
        encoder.encode((Object)"Q", Arrays.asList("Thing"));
        encoder.encode((Object)"R", Arrays.asList("Thing"));
        encoder.encode((Object)"S", Arrays.asList("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        System.out.println(encoder);
        Collection x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("B")));
        System.out.println("GCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("B"));
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("B")));
        System.out.println("GCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("N"));
        x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("Z", "Q")));
        System.out.println("GCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("T"));
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("Z", "Q")));
        System.out.println("GCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("T"));
        x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("A", "Z")));
        System.out.println("GCS " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("B"));
        Assert.assertTrue((boolean)x.contains("C"));
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("A", "Z")));
        System.out.println("GCS " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("B"));
        Assert.assertTrue((boolean)x.contains("C"));
        x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("Thing")));
        System.out.println("GCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Thing"));
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("Thing")));
        System.out.println("GCS " + x);
        Assert.assertEquals((long)5L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("Z"));
        Assert.assertTrue((boolean)x.contains("P"));
        Assert.assertTrue((boolean)x.contains("Q"));
        Assert.assertTrue((boolean)x.contains("R"));
    }

    @Test
    public void testHierEncoderDecoderUpper() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("Thing"));
        encoder.encode((Object)"Z", Arrays.asList("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", Arrays.asList("Thing"));
        encoder.encode((Object)"Q", Arrays.asList("Thing"));
        encoder.encode((Object)"R", Arrays.asList("Thing"));
        encoder.encode((Object)"S", Arrays.asList("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        System.out.println(encoder);
        Collection x = encoder.upperBorder(encoder.metMembersCode(Arrays.asList("B")));
        System.out.println("LCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("B"));
        x = encoder.immediateParents(encoder.metMembersCode(Arrays.asList("B")));
        System.out.println("LCS " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("Z"));
        x = encoder.upperBorder(encoder.jointMembersCode(Arrays.asList("Z", "Q")));
        System.out.println("LCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Thing"));
        x = encoder.immediateParents(encoder.jointMembersCode(Arrays.asList("Z", "Q")));
        System.out.println("LCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("Thing"));
        x = encoder.upperBorder(encoder.jointMembersCode(Arrays.asList("B", "C")));
        System.out.println("LCS " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("Z"));
        x = encoder.immediateParents(encoder.jointMembersCode(Arrays.asList("B", "C")));
        System.out.println("LCS " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("A"));
        Assert.assertTrue((boolean)x.contains("Z"));
        x = encoder.upperBorder(encoder.jointMembersCode(Arrays.asList("T")));
        System.out.println("LCS " + x);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("T"));
        x = encoder.immediateParents(encoder.jointMembersCode(Arrays.asList("T")));
        System.out.println("LCS " + x);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains("C"));
        Assert.assertTrue((boolean)x.contains("Q"));
    }

    @Test
    public void testClassInstanceHierarchies() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        BitSet ak = encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        BitSet bk = encoder.encode((Object)"B", Arrays.asList("A"));
        BitSet ck = encoder.encode((Object)"C", Arrays.asList("A"));
        BitSet dk = encoder.encode((Object)"D", Arrays.asList("B"));
        BitSet ek = encoder.encode((Object)"E", Arrays.asList("B"));
        BitSet fk = encoder.encode((Object)"F", Arrays.asList("C"));
        BitSet gk = encoder.encode((Object)"G", Arrays.asList("C"));
        BitSet hk = encoder.encode((Object)"H", Arrays.asList("D"));
        BitSet ik = encoder.encode((Object)"I", Arrays.asList("D"));
        BitSet jk = encoder.encode((Object)"J", Arrays.asList("E", "F"));
        BitSet kk = encoder.encode((Object)"K", Arrays.asList("E", "F"));
        BitSet lk = encoder.encode((Object)"L", Arrays.asList("G"));
        BitSet mk = encoder.encode((Object)"M", Arrays.asList("G"));
        BitSet nk = encoder.encode((Object)"N", Arrays.asList("I", "L"));
        BitSet ok = encoder.encode((Object)"O", Arrays.asList("H", "M"));
        System.out.println(encoder);
        IndexedTypeHierarchy types = new IndexedTypeHierarchy((Object)"A", new BitSet(), (Object)"ZZZZ", encoder.getBottom());
        types.addMember((Object)"A", ak);
        types.addMember((Object)"c", ck);
        types.addMember((Object)"f", fk);
        types.addMember((Object)"j", jk);
        types.addMember((Object)"k", kk);
        types.addMember((Object)"n", nk);
        types.addMember((Object)"o", ok);
        types.addMember((Object)"h", hk);
        System.out.println(types);
        Assert.assertEquals(Arrays.asList("c", "h"), (Object)types.children((Object)"A"));
        Assert.assertEquals(Arrays.asList("f", "n", "o"), (Object)types.children((Object)"c"));
        Assert.assertEquals(Arrays.asList("j", "k"), (Object)types.children((Object)"f"));
        Assert.assertEquals(Arrays.asList("ZZZZ"), (Object)types.children((Object)"j"));
        Assert.assertEquals(Arrays.asList("ZZZZ"), (Object)types.children((Object)"k"));
        Assert.assertEquals(Arrays.asList("ZZZZ"), (Object)types.children((Object)"n"));
        Assert.assertEquals(Arrays.asList("ZZZZ"), (Object)types.children((Object)"o"));
        Assert.assertEquals(Arrays.asList("o"), (Object)types.children((Object)"h"));
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)types.children((Object)"ZZZZ"));
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)types.parents((Object)"a"));
        Assert.assertEquals(Arrays.asList("A"), (Object)types.parents((Object)"c"));
        Assert.assertEquals(Arrays.asList("c"), (Object)types.parents((Object)"f"));
        Assert.assertEquals(Arrays.asList("f"), (Object)types.parents((Object)"j"));
        Assert.assertEquals(Arrays.asList("f"), (Object)types.parents((Object)"k"));
        Assert.assertEquals(Arrays.asList("c"), (Object)types.parents((Object)"n"));
        Assert.assertEquals(Arrays.asList("c", "h"), (Object)types.parents((Object)"o"));
        Assert.assertEquals(Arrays.asList("A"), (Object)types.parents((Object)"h"));
        Assert.assertEquals(Arrays.asList("j", "k", "n", "o"), (Object)types.parents((Object)"ZZZZ"));
        BitSet pk = encoder.encode((Object)"P", Arrays.asList("O"));
        types.addMember((Object)"p", pk);
        System.out.println(types);
        Assert.assertEquals(Arrays.asList("o"), (Object)types.parents((Object)"p"));
        Assert.assertEquals(Arrays.asList("j", "k", "n", "p"), (Object)types.parents((Object)"ZZZZ"));
        Assert.assertEquals(Arrays.asList("ZZZZ"), (Object)types.children((Object)"p"));
        types.removeMember((Object)"o");
        System.out.println(types);
        Assert.assertEquals(Arrays.asList("c", "h"), (Object)types.parents((Object)"p"));
        Assert.assertEquals(Arrays.asList("f", "n", "p"), (Object)types.children((Object)"c"));
        Assert.assertEquals(Arrays.asList("j", "k"), (Object)types.children((Object)"f"));
        Assert.assertEquals(Arrays.asList("ZZZZ"), (Object)types.children((Object)"n"));
        Assert.assertEquals(Arrays.asList("ZZZZ"), (Object)types.children((Object)"p"));
        Assert.assertEquals(Arrays.asList("p"), (Object)types.children((Object)"h"));
    }

    @Test
    public void testUnwantedCodeOverriding() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        BitSet ak = encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        BitSet ck = encoder.encode((Object)"C", Arrays.asList("A"));
        BitSet dk = encoder.encode((Object)"D", Arrays.asList("A"));
        BitSet gk = encoder.encode((Object)"G", Arrays.asList("C", "D"));
        BitSet bk = encoder.encode((Object)"B", Arrays.asList("A"));
        BitSet ek = encoder.encode((Object)"E", Arrays.asList("B"));
        BitSet ik = encoder.encode((Object)"I", Arrays.asList("E", "C"));
        BitSet fk = encoder.encode((Object)"F", Arrays.asList("B", "C"));
        BitSet jk = encoder.encode((Object)"J", Arrays.asList("F", "D"));
        BitSet lk = encoder.encode((Object)"L", Arrays.asList("J"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet ok = encoder.encode((Object)"O", Arrays.asList("L"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet kk = encoder.encode((Object)"K", Arrays.asList("F", "G"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet mk = encoder.encode((Object)"M", Arrays.asList("J", "K"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet nk = encoder.encode((Object)"N", Arrays.asList("K"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet hk = encoder.encode((Object)"H", Arrays.asList("F"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet pk = encoder.encode((Object)"P", Arrays.asList("A"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        System.out.println(encoder);
        Assert.assertEquals((long)16L, (long)encoder.size());
    }

    @Test
    public void testDeepTree() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("C"));
        encoder.encode((Object)"E", Arrays.asList("D"));
        encoder.encode((Object)"F", Arrays.asList("D"));
        encoder.encode((Object)"G", Arrays.asList("C"));
        encoder.encode((Object)"H", Arrays.asList("G"));
        encoder.encode((Object)"I", Arrays.asList("G"));
        encoder.encode((Object)"J", Arrays.asList("C"));
        encoder.encode((Object)"K", Arrays.asList("C"));
        encoder.encode((Object)"L", Arrays.asList("B"));
        encoder.encode((Object)"M", Arrays.asList("B"));
        encoder.encode((Object)"N", Arrays.asList("A"));
        encoder.encode((Object)"O", Arrays.asList("N"));
        System.out.println(encoder);
        this.checkHier((HierarchyEncoder)encoder, 'O');
    }

    @Test
    public void testNestedTree() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("B"));
        encoder.encode((Object)"D", Arrays.asList("B"));
        encoder.encode((Object)"E", Arrays.asList("D"));
        encoder.encode((Object)"F", Arrays.asList("E"));
        encoder.encode((Object)"G", Arrays.asList("E"));
        encoder.encode((Object)"H", Arrays.asList("G"));
        encoder.encode((Object)"I", Arrays.asList("H"));
        encoder.encode((Object)"J", Arrays.asList("E"));
        encoder.encode((Object)"K", Arrays.asList("J"));
        encoder.encode((Object)"L", Arrays.asList("K"));
        encoder.encode((Object)"M", Arrays.asList("J"));
        encoder.encode((Object)"N", Arrays.asList("M"));
        encoder.encode((Object)"O", Arrays.asList("J"));
        encoder.encode((Object)"P", Arrays.asList("O"));
        encoder.encode((Object)"Q", Arrays.asList("J"));
        encoder.encode((Object)"R", Arrays.asList("Q"));
        encoder.encode((Object)"S", Arrays.asList("B"));
        encoder.encode((Object)"T", Arrays.asList("S"));
        encoder.encode((Object)"U", Arrays.asList("T"));
        encoder.encode((Object)"V", Arrays.asList("B"));
        encoder.encode((Object)"W", Arrays.asList("V"));
        encoder.encode((Object)"X", Arrays.asList("W"));
        System.out.println(encoder);
        encoder.encode((Object)"Y", Arrays.asList("F", "W"));
        System.out.println(encoder);
        this.checkHier((HierarchyEncoder)encoder, (char)(65 + encoder.size() - 1));
    }
}

