/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits;

import org.assertj.core.api.Assertions;
import org.drools.core.common.DefaultAgenda;
import org.drools.core.reteoo.ReteDumper;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class UseOfRuleFlowGroupPlusLockOnTest {
    private static final String drl = "package com.sample\nimport " + Person.class.getCanonicalName() + " ;\nimport " + Cheese.class.getCanonicalName() + " ;\nrule R1\nruleflow-group \"group1\"\nlock-on-active true\nwhen\n   $p : Person()\nthen\n   $p.setName(\"John\");\n   update ($p);\nend\n rule R2\nruleflow-group \"group1\"\nlock-on-active true\nwhen\n   $p : Person( name == null )\n   forall ( Cheese ( type == \"cheddar\" ))\nthen\nend\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        KieHelper kieHelper = new KieHelper().addContent(drl, ResourceType.DRL);
        KieBase kbase = kieHelper.build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        ReteDumper.dumpRete((KieSession)ksession);
        ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        try {
            ksession.insert((Object)new Person());
            ksession.insert((Object)new Cheese("eidam"));
            ((DefaultAgenda)ksession.getAgenda()).activateRuleFlowGroup("group1");
            int rulesFired = ksession.fireAllRules();
            Assertions.assertThat((int)rulesFired).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    public class Person {
        private String name;

        public Person() {
        }

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "[Person name='" + this.name + "']";
        }
    }

    public class Cheese {
        private String type;
        private int price;

        public Cheese() {
        }

        public Cheese(String type) {
            this.type = type;
        }

        public int getPrice() {
            return this.price;
        }

        public String getType() {
            return this.type;
        }

        public void setPrice(int price) {
            this.price = price;
        }
    }
}

