/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.factmodel.traits;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.rule.EntryPointId;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.traits.compiler.CommonTraitTest;
import org.drools.traits.compiler.Person;
import org.drools.traits.compiler.ReviseTraitTestWithPRAlwaysCategory;
import org.drools.traits.compiler.factmodel.traits.IStudent;
import org.drools.traits.compiler.factmodel.traits.Imp2;
import org.drools.traits.compiler.factmodel.traits.Message;
import org.drools.traits.compiler.factmodel.traits.StudentImpl;
import org.drools.traits.compiler.factmodel.traits.StudentProxyImpl2;
import org.drools.traits.core.factmodel.Entity;
import org.drools.traits.core.factmodel.HierarchyEncoder;
import org.drools.traits.core.factmodel.LogicalTypeInconsistencyException;
import org.drools.traits.core.factmodel.MapWrapper;
import org.drools.traits.core.factmodel.TraitFactoryImpl;
import org.drools.traits.core.factmodel.TraitProxyImpl;
import org.drools.traits.core.factmodel.TraitRegistryImpl;
import org.drools.traits.core.factmodel.TraitTypeMapImpl;
import org.drools.traits.core.factmodel.TripleBasedBean;
import org.drools.traits.core.factmodel.TripleBasedStruct;
import org.drools.traits.core.factmodel.VirtualPropertyMode;
import org.drools.traits.core.reteoo.TraitRuntimeComponentFactory;
import org.drools.traits.core.util.CodedHierarchyImpl;
import org.drools.util.io.ByteArrayResource;
import org.drools.util.io.ClassPathResource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TraitTest
extends CommonTraitTest {
    private static long t0;
    public VirtualPropertyMode mode;

    @Parameterized.Parameters
    public static Collection modes() {
        return Arrays.asList({VirtualPropertyMode.MAP}, {VirtualPropertyMode.TRIPLES});
    }

    public TraitTest(VirtualPropertyMode m) {
        this.mode = m;
    }

    private KieSession getSession(String ... ruleFiles) {
        KieHelper kieHelper = new KieHelper();
        for (String file : ruleFiles) {
            kieHelper.kfs.write((Resource)new ClassPathResource(file));
        }
        return kieHelper.build(new KieBaseOption[0]).newKieSession();
    }

    private KieSession getSessionFromString(String drl) {
        return new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
    }

    private KieBase getKieBaseFromString(String drl, KieBaseOption ... options) {
        return new KieHelper().addContent(drl, ResourceType.DRL).build(options);
    }

    @Test
    public void testRetract() {
        String drl = "package org.drools.compiler.trait.test; \nimport org.drools.core.factmodel.traits.Traitable; \ndeclare Foo @Traitable end\ndeclare trait Bar end \nrule Init when then\n  Foo foo = new Foo(); \n  don( foo, Bar.class ); \nend\nrule Retract \nwhen\n $bar : Bar()\nthen\n  delete( $bar ); \nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        Assert.assertEquals((long)2L, (long)ks.fireAllRules());
        for (Object o : ks.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)0L, (long)ks.getObjects().size());
    }

    @Test
    public void testTraitWrapGetAndSet() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            Class trait = kb.getFactType("org.drools.compiler.trait.test", "Student").getFactClass();
            TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            Map virtualFields = imp._getDynamicProperties();
            Map wrapper = proxy.getFields();
            wrapper.put("name", "john");
            wrapper.put("virtualField", "xyz");
            wrapper.entrySet();
            Assert.assertEquals((long)4L, (long)wrapper.size());
            Assert.assertEquals((long)2L, (long)virtualFields.size());
            Assert.assertEquals((Object)"john", wrapper.get("name"));
            Assert.assertEquals((Object)"xyz", wrapper.get("virtualField"));
            Assert.assertEquals((Object)"john", (Object)impClass.get((Object)imp, "name"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitShed() {
        String source = "org/drools/compiler/factmodel/traits/testTraitShed.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        Assert.assertTrue((boolean)info.isEmpty());
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("Student"));
        Assert.assertEquals((long)1L, (long)info.size());
        ks.insert((Object)"hire");
        ks.fireAllRules();
        Collection c = ks.getObjects();
        Assert.assertTrue((boolean)info.contains("Worker"));
        Assert.assertEquals((long)2L, (long)info.size());
        ks.insert((Object)"check");
        ks.fireAllRules();
        Assert.assertEquals((long)4L, (long)info.size());
        Assert.assertTrue((boolean)info.contains("Conflict"));
        Assert.assertTrue((boolean)info.contains("Nothing"));
    }

    @Test
    public void testTraitDon() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Collection wm = ks.getObjects();
        ks.insert((Object)"go");
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("DON"));
        Assert.assertTrue((boolean)info.contains("SHED"));
        Iterator it = wm.iterator();
        Object x = it.next();
        if (x instanceof String) {
            x = it.next();
        }
        System.out.println(x.getClass());
        System.out.println(x.getClass().getSuperclass());
        System.out.println(Arrays.asList(x.getClass().getInterfaces()));
    }

    @Test
    public void testMixin() {
        String source = "org/drools/compiler/factmodel/traits/testTraitMixin.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("27"));
    }

    @Test
    public void traitMethodsWithObjects() {
        String source = "org/drools/compiler/factmodel/traits/testTraitWrapping.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList errors = new ArrayList();
        ks.setGlobal("list", errors);
        ks.fireAllRules();
        if (!errors.isEmpty()) {
            System.err.println(((Object)errors).toString());
        }
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void traitMethodsWithPrimitives() {
        String source = "org/drools/compiler/factmodel/traits/testTraitWrappingPrimitives.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList errors = new ArrayList();
        ks.setGlobal("list", errors);
        ks.fireAllRules();
        if (!errors.isEmpty()) {
            System.err.println(errors);
        }
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testTraitProxy() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"aaa");
            Class trait = kb.getFactType("org.drools.compiler.trait.test", "Student").getFactClass();
            Class trait2 = kb.getFactType("org.drools.compiler.trait.test", "Role").getFactClass();
            Assert.assertNotNull((Object)trait);
            TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            proxy.getFields().put("field", "xyz");
            Assert.assertNotNull((Object)proxy);
            TraitProxyImpl proxy2 = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            Assert.assertSame((Object)proxy2, (Object)proxy);
            TraitProxyImpl proxy3 = (TraitProxyImpl)tFactory.getProxy(imp, trait2);
            Assert.assertNotNull((Object)proxy3);
            Assert.assertEquals((Object)"xyz", proxy3.getFields().get("field"));
            Assert.assertEquals((Object)"aaa", proxy3.getFields().get("name"));
            TraitableBean imp2 = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp2, "name", (Object)"aaa");
            TraitProxyImpl proxy4 = (TraitProxyImpl)tFactory.getProxy(imp2, trait);
            proxy4.getFields().put("field", "xyz");
            Assert.assertEquals((Object)proxy2, (Object)proxy4);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (LogicalTypeInconsistencyException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWrapperSize() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            Map virtualFields = imp._getDynamicProperties();
            Map wrapper = proxy.getFields();
            Assert.assertEquals((long)3L, (long)wrapper.size());
            Assert.assertEquals((long)1L, (long)virtualFields.size());
            impClass.set((Object)imp, "name", (Object)"john");
            Assert.assertEquals((long)3L, (long)wrapper.size());
            Assert.assertEquals((long)1L, (long)virtualFields.size());
            proxy.getFields().put("school", "skol");
            Assert.assertEquals((long)3L, (long)wrapper.size());
            Assert.assertEquals((long)1L, (long)virtualFields.size());
            proxy.getFields().put("surname", "xxx");
            Assert.assertEquals((long)4L, (long)wrapper.size());
            Assert.assertEquals((long)2L, (long)virtualFields.size());
            Entity ind = new Entity();
            TraitProxyImpl proxy2 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind, trait);
            Map virtualFields2 = ind._getDynamicProperties();
            Map wrapper2 = proxy2.getFields();
            Assert.assertEquals((long)3L, (long)wrapper2.size());
            Assert.assertEquals((long)3L, (long)virtualFields2.size());
            traitClass.set((Object)proxy2, "name", (Object)"john");
            Assert.assertEquals((long)3L, (long)wrapper2.size());
            Assert.assertEquals((long)3L, (long)virtualFields2.size());
            proxy2.getFields().put("school", "skol");
            Assert.assertEquals((long)3L, (long)wrapper2.size());
            Assert.assertEquals((long)3L, (long)virtualFields2.size());
            proxy2.getFields().put("surname", "xxx");
            Assert.assertEquals((long)4L, (long)wrapper2.size());
            Assert.assertEquals((long)4L, (long)virtualFields2.size());
            FactType traitClass2 = kb.getFactType("org.drools.compiler.trait.test", "Role");
            Class trait2 = traitClass2.getFactClass();
            Entity ind2 = new Entity();
            TraitProxyImpl proxy99 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind2, trait2);
            proxy99.getFields().put("surname", "xxx");
            proxy99.getFields().put("name", "xyz");
            proxy99.getFields().put("school", "skol");
            Assert.assertEquals((long)3L, (long)proxy99.getFields().size());
            TraitProxyImpl proxy100 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind2, trait);
            Assert.assertEquals((long)4L, (long)proxy100.getFields().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWrapperEmpty() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType studentClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
            Class trait = studentClass.getFactClass();
            TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            Map virtualFields = imp._getDynamicProperties();
            Map wrapper = proxy.getFields();
            Assert.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "name", (Object)"john");
            Assert.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "name", null);
            Assert.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "age", (Object)32);
            Assert.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "age", null);
            Assert.assertFalse((boolean)wrapper.isEmpty());
            Entity ind = new Entity();
            FactType RoleClass = kb.getFactType("org.drools.compiler.trait.test", "Role");
            Class trait2 = RoleClass.getFactClass();
            TraitProxyImpl proxy2 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind, trait2);
            Map wrapper2 = proxy2.getFields();
            Assert.assertTrue((boolean)wrapper2.isEmpty());
            proxy2.getFields().put("name", "john");
            Assert.assertFalse((boolean)wrapper2.isEmpty());
            proxy2.getFields().put("name", null);
            Assert.assertFalse((boolean)wrapper2.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWrapperContainsKey() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"john");
            FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            Map virtualFields = imp._getDynamicProperties();
            Map wrapper = proxy.getFields();
            Assert.assertTrue((boolean)wrapper.containsKey("name"));
            Assert.assertTrue((boolean)wrapper.containsKey("school"));
            Assert.assertTrue((boolean)wrapper.containsKey("age"));
            Assert.assertFalse((boolean)wrapper.containsKey("surname"));
            proxy.getFields().put("school", "skol");
            proxy.getFields().put("surname", "xxx");
            Assert.assertTrue((boolean)wrapper.containsKey("surname"));
            Entity ind = new Entity();
            TraitProxyImpl proxy2 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind, trait);
            Map virtualFields2 = ind._getDynamicProperties();
            Map wrapper2 = proxy2.getFields();
            Assert.assertTrue((boolean)wrapper2.containsKey("name"));
            Assert.assertTrue((boolean)wrapper2.containsKey("school"));
            Assert.assertTrue((boolean)wrapper2.containsKey("age"));
            Assert.assertFalse((boolean)wrapper2.containsKey("surname"));
            traitClass.set((Object)proxy2, "name", (Object)"john");
            proxy2.getFields().put("school", "skol");
            proxy2.getFields().put("surname", "xxx");
            Assert.assertTrue((boolean)wrapper2.containsKey("surname"));
            FactType traitClass2 = kb.getFactType("org.drools.compiler.trait.test", "Role");
            Class trait2 = traitClass2.getFactClass();
            Entity ind2 = new Entity();
            TraitProxyImpl proxy99 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind2, trait2);
            Map wrapper99 = proxy99.getFields();
            Assert.assertFalse((boolean)wrapper99.containsKey("name"));
            Assert.assertFalse((boolean)wrapper99.containsKey("school"));
            Assert.assertFalse((boolean)wrapper99.containsKey("age"));
            Assert.assertFalse((boolean)wrapper99.containsKey("surname"));
            proxy99.getFields().put("surname", "xxx");
            proxy99.getFields().put("name", "xyz");
            proxy99.getFields().put("school", "skol");
            Assert.assertTrue((boolean)wrapper99.containsKey("name"));
            Assert.assertTrue((boolean)wrapper99.containsKey("school"));
            Assert.assertFalse((boolean)wrapper99.containsKey("age"));
            Assert.assertTrue((boolean)wrapper99.containsKey("surname"));
            Assert.assertEquals((long)3L, (long)proxy99.getFields().size());
            Entity ind0 = new Entity();
            TraitProxyImpl proxy100 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind0, trait2);
            Map wrapper100 = proxy100.getFields();
            Assert.assertFalse((boolean)wrapper100.containsKey("name"));
            Assert.assertFalse((boolean)wrapper100.containsKey("school"));
            Assert.assertFalse((boolean)wrapper100.containsKey("age"));
            Assert.assertFalse((boolean)wrapper100.containsKey("surname"));
            TraitProxyImpl proxy101 = (TraitProxyImpl)tFactory.getProxy((TraitableBean)ind0, trait);
            Assert.assertTrue((boolean)wrapper100.containsKey("name"));
            Assert.assertTrue((boolean)wrapper100.containsKey("school"));
            Assert.assertTrue((boolean)wrapper100.containsKey("age"));
            Assert.assertFalse((boolean)wrapper100.containsKey("surname"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInternalComponents1() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            Map proxyFields = proxy.getFields();
            Map coreTraits = imp._getTraitMap();
            Map coreProperties = imp._getDynamicProperties();
            Assert.assertTrue((boolean)(proxy.getObject() instanceof TraitableBean));
            Assert.assertNotNull((Object)proxyFields);
            Assert.assertNotNull((Object)coreTraits);
            Assert.assertNotNull((Object)coreProperties);
            if (this.mode == VirtualPropertyMode.MAP) {
                Assert.assertTrue((boolean)(proxyFields instanceof MapWrapper));
                Assert.assertTrue((boolean)(coreTraits instanceof TraitTypeMapImpl));
                Assert.assertTrue((boolean)(coreProperties instanceof HashMap));
            } else {
                Assert.assertEquals((Object)"org.drools.compiler.trait.test.Student.org.drools.compiler.trait.test.Imp_ProxyWrapper", (Object)proxyFields.getClass().getName());
                Assert.assertTrue((boolean)(proxyFields instanceof TripleBasedStruct));
                Assert.assertTrue((boolean)(coreTraits instanceof TraitTypeMapImpl));
                Assert.assertTrue((boolean)(coreProperties instanceof TripleBasedBean));
            }
            StudentProxyImpl2 sp2 = new StudentProxyImpl2(new Imp2(), null);
            System.out.println(sp2.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWrapperKeySetAndValues() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            impClass.set((Object)imp, "name", (Object)"john");
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            HashSet<String> set = new HashSet<String>();
            set.add("name");
            set.add("surname");
            set.add("age");
            set.add("school");
            set.add("name2");
            set.add("nfield");
            Assert.assertEquals((long)6L, (long)proxy.getFields().keySet().size());
            Assert.assertEquals(set, proxy.getFields().keySet());
            Collection col1 = proxy.getFields().values();
            List<Serializable> col2 = Arrays.asList("john", null, 0, "xxx", "john", null);
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            };
            Collections.sort((List)col1, comp);
            Collections.sort(col2, comp);
            Assert.assertEquals(col1, col2);
            Assert.assertTrue((boolean)proxy.getFields().containsValue(null));
            Assert.assertTrue((boolean)proxy.getFields().containsValue("john"));
            Assert.assertTrue((boolean)proxy.getFields().containsValue(0));
            Assert.assertTrue((boolean)proxy.getFields().containsValue("xxx"));
            Assert.assertFalse((boolean)proxy.getFields().containsValue("randomString"));
            Assert.assertFalse((boolean)proxy.getFields().containsValue(-96));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWrapperClearAndRemove() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        TraitFactoryImpl tFactory = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"john");
            FactType traitClass = kb.getFactType("org.drools.compiler.trait.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxyImpl proxy = (TraitProxyImpl)tFactory.getProxy(imp, trait);
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            HashSet<String> set = new HashSet<String>();
            set.add("name");
            set.add("surname");
            set.add("age");
            set.add("school");
            set.add("name2");
            set.add("nfield");
            Assert.assertEquals((long)6L, (long)proxy.getFields().keySet().size());
            Assert.assertEquals(set, proxy.getFields().keySet());
            proxy.getFields().clear();
            Map fields = proxy.getFields();
            Assert.assertEquals((long)3L, (long)fields.size());
            Assert.assertTrue((boolean)fields.containsKey("age"));
            Assert.assertTrue((boolean)fields.containsKey("school"));
            Assert.assertTrue((boolean)fields.containsKey("name"));
            Assert.assertEquals((Object)0, fields.get("age"));
            Assert.assertNull(fields.get("school"));
            Assert.assertNotNull(fields.get("name"));
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            proxy.getFields().put("age", 24);
            Assert.assertEquals((Object)"john", proxy.getFields().get("name"));
            Assert.assertEquals((Object)"xxx", proxy.getFields().get("surname"));
            Assert.assertEquals((Object)"john", proxy.getFields().get("name2"));
            Assert.assertEquals(null, proxy.getFields().get("nfield"));
            Assert.assertEquals((Object)24, proxy.getFields().get("age"));
            Assert.assertEquals(null, proxy.getFields().get("school"));
            proxy.getFields().remove("surname");
            proxy.getFields().remove("name2");
            proxy.getFields().remove("age");
            proxy.getFields().remove("school");
            proxy.getFields().remove("nfield");
            Assert.assertEquals((long)3L, (long)proxy.getFields().size());
            Assert.assertEquals((Object)0, proxy.getFields().get("age"));
            Assert.assertEquals(null, proxy.getFields().get("school"));
            Assert.assertEquals((Object)"john", proxy.getFields().get("name"));
            Assert.assertEquals(null, proxy.getFields().get("nfield"));
            Assert.assertFalse((boolean)proxy.getFields().containsKey("nfield"));
            Assert.assertEquals(null, proxy.getFields().get("name2"));
            Assert.assertFalse((boolean)proxy.getFields().containsKey("name2"));
            Assert.assertEquals(null, proxy.getFields().get("surname"));
            Assert.assertFalse((boolean)proxy.getFields().containsKey("surname"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsAEvaluator() {
        String source = "package org.drools.compiler.trait.test;\n\nimport org.drools.core.factmodel.traits.Traitable;\nimport org.drools.traits.core.factmodel.Entity;\nimport org.drools.core.factmodel.traits.Thing;\n\nglobal java.util.List list;\n\n\ndeclare Imp\n    @Traitable\n    name    : String        @key\nend\n\ndeclare trait Person\n    name    : String \n    age     : int   \nend\n  \ndeclare trait Worker\n    job     : String\nend\n \n\n \n \nrule \"Init\"\nwhen\nthen\n    Imp core = new Imp( \"joe\" );\n    insert( core );\n    don( core, Person.class );\n    don( core, Worker.class );\n\n    Imp core2 = new Imp( \"adam\" );\n    insert( core2 );\n    don( core2, Worker.class );\nend\n\nrule \"Mod\"\nwhen\n    $p : Person( name == \"joe\" )\nthen\n    modify ($p) { setName( \"john\" ); }\nend\n\nrule \"Worker Students v6\"\nwhen\n    $x2 := Person( name == \"john\" )\n    $x1 := Worker( core != $x2.core, this not isA $x2 )\nthen\n    list.add( \"ok\" );\nend\n\n\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.out.println(info);
        Assert.assertTrue((boolean)info.contains("ok"));
    }

    @Test
    public void testIsA() {
        String source = "org/drools/compiler/factmodel/traits/testTraitIsA.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        int num = 10;
        System.out.println(info);
        Assert.assertEquals((long)num, (long)info.size());
        for (int j = 0; j < num; ++j) {
            Assert.assertTrue((boolean)info.contains("" + j));
        }
    }

    @Test
    public void testOverrideType() {
        String source = "org/drools/compiler/factmodel/traits/testTraitOverride.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        try {
            ks.fireAllRules();
            Assert.fail((String)"An exception was expected since a trait can't override the type of a core class field with these settings ");
        }
        catch (Throwable rde) {
            Assert.assertTrue((boolean)(rde.getCause() instanceof UnsupportedOperationException));
        }
    }

    @Test
    public void testOverrideType2() {
        String drl = "package org.drools.compiler.trait.test; \nimport org.drools.core.factmodel.traits.Traitable; \ndeclare Foo @Traitable end\ndeclare trait Bar end \ndeclare trait Mask fld : Foo end \ndeclare Face @Traitable fld : Bar end \nrule Don when then\n  Face face = new Face(); \n  don( face, Mask.class ); \nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        try {
            ks.fireAllRules();
            Assert.fail((String)"An exception was expected since a trait can't override the type of a core class field with these settings ");
        }
        catch (Throwable rde) {
            Assert.assertTrue((boolean)(rde.getCause() instanceof UnsupportedOperationException));
        }
    }

    @Test
    public void testOverrideType3() {
        String drl = "package org.drools.compiler.trait.test; \nimport org.drools.core.factmodel.traits.Traitable; \ndeclare trait Foo end\ndeclare trait Bar end \ndeclare trait Mask fld : Foo end \ndeclare Face @Traitable fld : Bar end \nrule Don when then\n  Face face = new Face(); \n  don( face, Mask.class ); \nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        try {
            ks.fireAllRules();
            Assert.fail((String)"An exception was expected since a trait can't override the type of a core class field with these settings ");
        }
        catch (Throwable rde) {
            Assert.assertTrue((boolean)(rde.getCause() instanceof UnsupportedOperationException));
        }
    }

    @Test
    public void testTraitLegacy() {
        String source = "org/drools/compiler/factmodel/traits/testTraitLegacyTrait.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        Assert.assertEquals((long)5L, (long)info.size());
        Assert.assertTrue((boolean)info.contains("OK"));
        Assert.assertTrue((boolean)info.contains("OK2"));
        Assert.assertTrue((boolean)info.contains("OK3"));
        Assert.assertTrue((boolean)info.contains("OK4"));
        Assert.assertTrue((boolean)info.contains("OK5"));
    }

    @Test
    public void testTraitCollections() {
        String source = "org/drools/compiler/factmodel/traits/testTraitCollections.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertTrue((boolean)info.contains("OK"));
    }

    @Test
    public void testTraitCore() {
        String source = "org/drools/compiler/factmodel/traits/testTraitLegacyCore.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        Assert.assertTrue((boolean)info.contains("OK"));
        Assert.assertTrue((boolean)info.contains("OK2"));
        Assert.assertEquals((long)2L, (long)info.size());
    }

    @Test
    public void traitWithEquality() {
        String source = "org/drools/compiler/factmodel/traits/testTraitWithEquality.drl";
        KieSession ks = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("DON"));
        Assert.assertTrue((boolean)info.contains("EQUAL"));
    }

    @Test
    public void traitDeclared() {
        ArrayList trueTraits = new ArrayList();
        ArrayList untrueTraits = new ArrayList();
        KieSession ks = this.getSession("org/drools/compiler/factmodel/traits/testDeclaredFactTrait.drl");
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ks.setGlobal("trueTraits", trueTraits);
        ks.setGlobal("untrueTraits", untrueTraits);
        ks.fireAllRules();
        ks.dispose();
        Assert.assertTrue((boolean)trueTraits.contains(1));
        Assert.assertFalse((boolean)trueTraits.contains(2));
        Assert.assertTrue((boolean)untrueTraits.contains(2));
        Assert.assertFalse((boolean)untrueTraits.contains(1));
    }

    @Test
    public void traitPojo() {
        ArrayList trueTraits = new ArrayList();
        ArrayList untrueTraits = new ArrayList();
        KieSession session = this.getSession("org/drools/compiler/factmodel/traits/testPojoFactTrait.drl");
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)session.getKieBase());
        session.setGlobal("trueTraits", trueTraits);
        session.setGlobal("untrueTraits", untrueTraits);
        session.fireAllRules();
        session.dispose();
        Assert.assertTrue((boolean)trueTraits.contains(1));
        Assert.assertFalse((boolean)trueTraits.contains(2));
        Assert.assertTrue((boolean)untrueTraits.contains(2));
        Assert.assertFalse((boolean)untrueTraits.contains(1));
    }

    @Test
    public void testIsAOperator() {
        String source = "org/drools/compiler/factmodel/traits/testTraitIsA2.drl";
        KieSession ksession = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        Person student = new Person("student", 18);
        ksession.insert((Object)student);
        ksession.fireAllRules();
        ArgumentCaptor cap = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        List values = cap.getAllValues();
        MatcherAssert.assertThat((Object)((AfterMatchFiredEvent)values.get(0)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"create student"));
        MatcherAssert.assertThat((Object)((AfterMatchFiredEvent)values.get(1)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"print student"));
        MatcherAssert.assertThat((Object)((AfterMatchFiredEvent)values.get(2)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"print school"));
    }

    @Test
    public void testManyTraits() {
        String source = "import " + Message.class.getCanonicalName() + ";\nglobal java.util.List list; \ndeclare Message\n      @Traitable\n    end\n\n    declare trait NiceMessage\n       message : String\n    end\nrule \"Nice\"\nwhen\n  $n : NiceMessage( $m : message )\nthen\n  System.out.println( $m );\nend\n    rule load\n        when\n\n        then\n            Message message = new Message();\n            message.setMessage(\"Hello World\");\n            insert(message);\n            don( message, NiceMessage.class );\n\n            Message unreadMessage = new Message();\n            unreadMessage.setMessage(\"unread\");\n            insert(unreadMessage);\n            don( unreadMessage, NiceMessage.class );\n\n            Message oldMessage = new Message();\n            oldMessage.setMessage(\"old\");\n            insert(oldMessage);\n            don( oldMessage, NiceMessage.class );            list.add(\"OK\");\n    end";
        KieSession ksession = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person student = new Person("student", 18);
        ksession.insert((Object)student);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("OK"));
    }

    @Test
    public void traitManyTimes() {
        KieSession ksession = this.getSession("org/drools/compiler/factmodel/traits/testTraitDonMultiple.drl");
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.err.println(o);
        }
        Collection x = ksession.getObjects();
        Assert.assertEquals((long)2L, (long)ksession.getObjects().size());
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((Object)0, list.get(0));
        Assert.assertTrue((boolean)list.contains(1));
        Assert.assertTrue((boolean)list.contains(2));
        Assert.assertTrue((boolean)list.contains(3));
        Assert.assertTrue((boolean)list.contains(4));
    }

    @Test
    public void traitsInBatchExecution() {
        String str = "package org.jboss.qa.brms.traits\nimport org.drools.traits.compiler.Person;\nimport org.drools.core.factmodel.traits.Traitable;\nglobal java.util.List list;declare Person \n  @Traitable \nend \ndeclare trait Student\n  school : String\nend\n\nrule \"create student\" \n  when\n    $student : Person( age < 26 )\n  then\n    Student s = don( $student, Student.class );\n    s.setSchool(\"Masaryk University\");\nend\n\nrule \"print student\"\n  when\n    student : Person( this isA Student )\n  then    list.add( 1 );\n    System.out.println(\"Person is a student: \" + student);\nend\n\nrule \"print school\"\n  when\n    Student( $school : school )\n  then\n    list.add( 2 );\n    System.out.println(\"Student is attending \" + $school);\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        ArrayList list = new ArrayList();
        KieBase kbase = kbuilder.newKieBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        ksession.setGlobal("list", list);
        ArrayList<Command> commands = new ArrayList<Command>();
        Person student = new Person("student", 18);
        commands.add(CommandFactory.newInsert((Object)student));
        System.out.println("Starting execution...");
        commands.add(CommandFactory.newFireAllRules());
        ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        System.out.println("Finished...");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(1));
        Assert.assertTrue((boolean)list.contains(2));
    }

    @Test(timeout=10000L)
    public void testManyTraitsStateless() {
        String source = "import " + Message.class.getCanonicalName() + ";\nglobal java.util.List list; \ndeclare Message\n      @Traitable\n    end\n\n    declare trait NiceMessage\n       message : String\n    end\nrule \"Nice\"\nwhen\n  $n : NiceMessage( $m : message )\nthen\n  System.out.println( $m );\nend\n    rule load\n        when\n\n        then\n            Message message = new Message();\n            message.setMessage(\"Hello World\");\n            insert(message);\n            don( message, NiceMessage.class );\n\n            Message unreadMessage = new Message();\n            unreadMessage.setMessage(\"unread\");\n            insert(unreadMessage);\n            don( unreadMessage, NiceMessage.class );\n\n            Message oldMessage = new Message();\n            oldMessage.setMessage(\"old\");\n            insert(oldMessage);\n            don( oldMessage, NiceMessage.class );            list.add(\"OK\");\n    end";
        KieBase kb = this.getKieBaseFromString(source, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kb);
        KieSession ksession = kb.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute(CommandFactory.newFireAllRules());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("OK"));
    }

    @Test
    public void testAliasing() {
        String drl = "package org.drools.traits\nimport org.drools.core.factmodel.traits.Traitable;\nimport org.drools.core.factmodel.traits.Alias;\nglobal java.util.List list;declare Person \n  @Traitable \n  nomen     : String  @key @Alias(\"fld1\") \n  workPlace : String \n  address   : String \n  serviceYrs: int \nend \ndeclare trait Student\n  name      : String @Alias(\"fld1\") \n  school    : String  @Alias(\"workPlace\") \n  grade     : int @Alias(\"level\") \n  rank      : int @Alias(\"serviceYrs\") \nend \n\nrule \"create student\" \n  when\n  then\n    Person p = new Person( \"davide\", \"UniBoh\", \"Floor84\", 1 ); \n    Student s = don( p, Student.class );\nend\n\nrule \"print school\"\n  when\n    $student : Student( $school : school == \"UniBoh\",  $f : fields, fields[ \"workPlace\" ] == \"UniBoh\" )\n  then \n     $student.setRank( 99 ); \n    System.out.println( $student ); \n    $f.put( \"school\", \"Skool\" ); \n    list.add( $school );\n    list.add( $f.get( \"school\" ) );\n    list.add( $student.getSchool() );\n    list.add( $f.keySet() );\n    list.add( $f.entrySet() );\n    list.add( $f.values() );\n    list.add( $f.containsKey( \"school\" ) );\n    list.add( $student.getRank() );\n    list.add( $f.get( \"address\" ) );\nend";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)9L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("UniBoh"));
        Assert.assertTrue((boolean)list.contains("Skool"));
        Assert.assertTrue((boolean)((Collection)list.get(3)).containsAll(Arrays.asList("workPlace", "nomen", "level")));
        Assert.assertTrue((boolean)((Collection)list.get(5)).containsAll(Arrays.asList("davide", "Skool", 0)));
        Assert.assertTrue((boolean)list.contains(true));
        Assert.assertTrue((boolean)list.contains("Floor84"));
        Assert.assertTrue((boolean)list.contains(99));
    }

    @Test
    public void testTraitLogicalRemoval() {
        String drl = "package org.drools.trait.test;\n\nimport org.drools.core.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\ndeclare trait Student\n  age  : int\n  name : String\nend\n\ndeclare trait Worker\n  wage  : int\n  name : String\nend\ndeclare Person\n  @Traitable\n  name : String \nend\n\n\nrule \"Don Logical\"\nwhen\n  $s : String( this == \"trigger\" )\nthen\n  Person p = new Person( \"john\" );\n  insertLogical( p ); \n  don( p, Student.class, true );\nend\n rule \"Don Logical 2\"\nwhen\n  $s : String( this == \"trigger2\" )\n  $p : Person( name == \"john\" )then\n  don( $p, Worker.class, true );\nend";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle h = ksession.insert((Object)"trigger");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)ksession.getObjects().size());
        ksession.delete(h);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)ksession.getObjects().size());
        FactHandle h1 = ksession.insert((Object)"trigger");
        FactHandle h2 = ksession.insert((Object)"trigger2");
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)ksession.getObjects().size());
        ksession.delete(h2);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)ksession.getObjects().size());
        ksession.delete(h1);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)ksession.getObjects().size());
    }

    @Test
    public void testTMSConsistencyWithNonTraitableBeans() {
        String s1 = "package org.drools.test;\nimport org.drools.traits.compiler.Person; \nimport org.drools.core.factmodel.traits.Traitable; \ndeclare Person @Traitable end \nrule \"Init\"\nwhen\nthen\n  insertLogical( new Person( \"x\", 18 ) );\nend\n\ndeclare trait Student\n  age  : int\n  name : String\nend\n\nrule \"Trait\"\nwhen\n    $p : Person( )\nthen\n    don( $p, Student.class, true );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ksession.fireAllRules();
        FactHandle personHandle = (FactHandle)ksession.getFactHandles((ObjectFilter)new ClassObjectFilter(Person.class)).iterator().next();
        InternalFactHandle h = (InternalFactHandle)personHandle;
        ObjectTypeConfigurationRegistry reg = h.getEntryPoint((ReteEvaluator)((InternalWorkingMemory)ksession)).getObjectTypeConfigurationRegistry();
        ObjectTypeConf conf = reg.getOrCreateObjectTypeConf(h.getEntryPointId(), ((InternalFactHandle)personHandle).getObject());
        Assert.assertTrue((boolean)conf.isTMSEnabled());
        ksession.dispose();
    }

    @Test
    public void testTraitsLegacyWrapperCoherence() {
        String str = "package org.drools.trait.test; \nglobal java.util.List list; \nimport org.drools.core.factmodel.traits.Traitable;\nimport org.drools.traits.compiler.factmodel.traits.TraitTest.TBean;\ndeclare TBean \n@Traitable \nend \n declare trait Mask \n  fld : String \n  xyz : int  \nend \n\n rule Init \nwhen \nthen \n  insert( new TBean(\"abc\") ); \nend \nrule Don \nno-loop \nwhen \n  $b : TBean( ) \nthen \n  Mask m = don( $b, Mask.class ); \n  modify (m) { setXyz( 10 ); } \n  list.add( m ); \n  System.out.println( \"Don result : \" + m ); \n end \n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Collection yOld = ksession.getObjects();
        Assert.assertEquals((long)2L, (long)yOld.size());
        Object coreOld = null;
        for (Object o : yOld) {
            if (!(o instanceof TraitableBean)) continue;
            coreOld = (TraitableBean)o;
            break;
        }
        Assert.assertNotNull(coreOld);
        Assert.assertSame(TBean.class, coreOld.getClass().getSuperclass());
        Assert.assertEquals((Object)"abc", (Object)((TBean)coreOld).getFld());
        Assert.assertEquals((long)1L, (long)coreOld._getDynamicProperties().size());
        Assert.assertEquals((long)1L, (long)coreOld._getTraitMap().size());
    }

    @Test
    public void testHasTypes() {
        String source = "org/drools/compiler/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        TraitFactoryImpl traitBuilder = (TraitFactoryImpl)RuntimeComponentFactory.get().getTraitFactory((RuleBase)kb);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kb);
        try {
            FactType impClass = kb.getFactType("org.drools.compiler.trait.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"aaabcd");
            Class trait = kb.getFactType("org.drools.compiler.trait.test", "Student").getFactClass();
            Class trait2 = kb.getFactType("org.drools.compiler.trait.test", "Role").getFactClass();
            Assert.assertNotNull((Object)trait);
            TraitProxyImpl proxy = (TraitProxyImpl)traitBuilder.getProxy(imp, trait);
            Thing thing = traitBuilder.getProxy(imp, Thing.class);
            TraitableBean core = proxy.getObject();
            TraitProxyImpl proxy2 = (TraitProxyImpl)traitBuilder.getProxy(imp, trait);
            Thing thing2 = traitBuilder.getProxy(imp, Thing.class);
            Assert.assertSame((Object)proxy, (Object)proxy2);
            Assert.assertSame((Object)thing, (Object)thing2);
            Assert.assertEquals((long)2L, (long)core.getTraits().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitRedundancy() {
        String str = "package org.drools.traits.compiler.factmodel.traits; \nglobal java.util.List list; \ndeclare trait IStudent end \ndeclare org.drools.traits.compiler.factmodel.traits.IPerson @typesafe(false) end \nrule \"Students\" \nsalience -10when \n   $s : IStudent() \nthen \n   System.out.println( \"Student in \" + $s ); \nend \nrule \"Don\" \nno-loop  \nwhen \n  $p : IPerson( age < 30 ) \nthen \n   System.out.println( \"Candidate student \" + $p ); \n   don( $p, IStudent.class );\nend \nrule \"Check\" \nno-loop \nwhen \n  $p : IPerson( this isA IStudent ) \nthen \n   System.out.println( \"Known student \" + $p );    modify ($p) { setAge( 37 ); } \n   shed( $p, IStudent.class );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new StudentImpl("skool", "john", 27));
        Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
        for (Object o : ksession.getObjects()) {
            System.err.println(o);
        }
    }

    @Test
    public void traitSimpleTypes() {
        String s1 = "package org.drools.factmodel.traits;\n\nimport org.drools.core.factmodel.traits.Traitable;\ndeclare trait PassMark\nend\n\ndeclare ExamMark \n@Traitable\nvalue : long \nend\nrule \"testTraitFieldTypePrimitive\"\nwhen\n    $mark : ExamMark()\nthen\n    don($mark, PassMark.class);\nend\nrule \"Init\" when then insert( new ExamMark() ); end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            if (o instanceof TraitableBean) {
                TraitableBean tb = (TraitableBean)o;
                Assert.assertEquals((long)1L, (long)tb._getTraitMap().size());
                BitSet bs = new BitSet();
                bs.set(0);
                Assert.assertEquals((Object)bs, (Object)tb.getCurrentTypeCode());
            }
            if (!(o instanceof TraitProxyImpl)) continue;
            TraitProxyImpl tp = (TraitProxyImpl)o;
            Assert.assertEquals((long)0L, (long)tp.listAssignedOtnTypeCodes().size());
        }
    }

    @Test
    public void testTraitEncoding() {
        String s1 = "package org.drools.core.factmodel.traits;\nimport " + Entity.class.getCanonicalName() + ";\ndeclare trait A end\ndeclare trait B extends A end\ndeclare trait C extends A end\ndeclare trait D extends A end\ndeclare trait E extends B end\ndeclare trait F extends C end\ndeclare trait G extends D end\ndeclare trait H extends D end\ndeclare trait I extends E end\ndeclare trait J extends F end\ndeclare trait K extends G, H end\ndeclare trait L extends G, H end\ndeclare trait M extends I, J end\ndeclare trait N extends K, L end\nrule \"donOneThing\"\nwhen\n    $x : Entity()\nthen\n    don( $x, A.class );\nend\nrule \"donManyThing\"\nwhen\n    String( this == \"y\" ) \n    $x : Entity()\nthen\n    don( $x, B.class );\n    don( $x, D.class );\n    don( $x, F.class );\n    don( $x, E.class );\n    don( $x, I.class );\n    don( $x, K.class );\n    don( $x, J.class );\n    don( $x, C.class );\n    don( $x, H.class );\n    don( $x, G.class );\n    don( $x, L.class );\n    don( $x, M.class );\n    don( $x, N.class );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        TraitRegistryImpl tr = (TraitRegistryImpl)((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry((RuleBase)kbase);
        System.out.println(tr.getHierarchy());
        Entity ent = new Entity("x");
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)ent);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)ent.getMostSpecificTraits().size());
        ksession.insert((Object)"y");
        ksession.fireAllRules();
        System.out.println(ent.getMostSpecificTraits());
        Assert.assertEquals((long)2L, (long)ent.getMostSpecificTraits().size());
    }

    @Test
    public void testTraitActualTypeCodeWithEntities() {
        this.testTraitActualTypeCodeWithEntities("ent", this.mode);
    }

    @Test
    public void testTraitActualTypeCodeWithCoreMap() {
        this.testTraitActualTypeCodeWithEntities("kor", this.mode);
    }

    void testTraitActualTypeCodeWithEntities(String trig, VirtualPropertyMode mode) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("org/drools/compiler/factmodel/traits/testComplexDonShed.drl"), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)trig);
        ksession.fireAllRules();
        TraitableBean ent = (TraitableBean)ksession.getGlobal("core");
        Assert.assertEquals((Object)CodedHierarchyImpl.stringToBitSet((String)"1"), (Object)ent.getCurrentTypeCode());
        ksession.insert((Object)"b");
        ksession.fireAllRules();
        Assert.assertEquals((Object)CodedHierarchyImpl.stringToBitSet((String)"11"), (Object)ent.getCurrentTypeCode());
        ksession.insert((Object)"c");
        ksession.fireAllRules();
        Assert.assertEquals((Object)CodedHierarchyImpl.stringToBitSet((String)"1011"), (Object)ent.getCurrentTypeCode());
        ksession.insert((Object)"e");
        ksession.fireAllRules();
        Assert.assertEquals((Object)CodedHierarchyImpl.stringToBitSet((String)"11011"), (Object)ent.getCurrentTypeCode());
        ksession.insert((Object)"-c");
        ksession.fireAllRules();
        Assert.assertEquals((Object)CodedHierarchyImpl.stringToBitSet((String)"11"), (Object)ent.getCurrentTypeCode());
        ksession.insert((Object)"dg");
        ksession.fireAllRules();
        Assert.assertEquals((Object)CodedHierarchyImpl.stringToBitSet((String)"111111"), (Object)ent.getCurrentTypeCode());
        ksession.insert((Object)"-f");
        ksession.fireAllRules();
        Assert.assertEquals((Object)CodedHierarchyImpl.stringToBitSet((String)"111"), (Object)ent.getCurrentTypeCode());
    }

    @Test
    public void testTraitModifyCore() {
        String s1 = "package test; import org.drools.core.factmodel.traits.*; global java.util.List list; declare trait Student @PropertyReactive name : String end declare trait Worker @PropertyReactive name : String end declare trait StudentWorker extends Student, Worker @PropertyReactive name : String end declare trait Assistant extends Student, Worker @PropertyReactive name : String end declare Person @Traitable name : String end rule \"Init\"  when  then    Person p = new Person( \"john\" );    insert( p );  end  rule \"Don\"  no-loop  when    $p : Person( name == \"john\" )  then    System.out.println( $p );    System.out.println( \" ----------------------------------------------------------------------------------- Don student\" );    don( $p, Student.class );    System.out.println( \" ----------------------------------------------------------------------------------- Don worker\" );    don( $p, Worker.class );    System.out.println( \" ----------------------------------------------------------------------------------- Don studentworker\" );    don( $p, StudentWorker.class );    System.out.println( \" ----------------------------------------------------------------------------------- Don assistant\" );    don( $p, Assistant.class );  end  rule \"Log S\"  when    $t : Student() @Watch( name ) then    System.out.println( \"Student >> \" +  $t );   list.add( $t.getName() );  end  rule \"Log W\"  when    $t : Worker() @Watch( name ) then    System.out.println( \"Worker >> \" + $t );    list.add( $t.getName() );  end  rule \"Log SW\"  when    $t : StudentWorker() @Watch( name ) then    System.out.println( \"StudentWorker >> \" + $t );    list.add( $t.getName() );  end  rule \"Log RA\"  when    $t : Assistant() @Watch( name ) then    System.out.println( \"Assistant >> \" + $t );    list.add( $t.getName() );  end  rule \"Mod\"  salience -10  when    $p : Person( name == \"john\" ) then     System.out.println( \"-----------------------------\" );    modify ( $p ) { setName( \"alan\" ); } end  ";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        int k = ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList("john", "john", "john", "john", "alan", "alan", "alan", "alan"), list);
        Assert.assertEquals((long)11L, (long)k);
    }

    @Test
    public void testTraitModifyCore2() {
        String s1 = "package test; import org.drools.core.factmodel.traits.*; declare trait Student @propertyReactive name : String end declare trait Worker @propertyReactive name : String end declare trait StudentWorker extends Student, Worker @propertyReactive name : String end declare trait StudentWorker2 extends StudentWorker @propertyReactive name : String end declare trait Assistant extends Student, Worker @propertyReactive name : String end declare Person @Traitable @propertyReactive name : String end rule \"Init\"  when  then    Person p = new Person( \"john\" );    insert( p );  end  rule \"Don\"  when    $p : Person( name == \"john\" )  then    System.out.println( \">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> DON WORKER \" + $p  );    don( $p, Worker.class );    System.out.println( \">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> DON STUDWORKER-2 \" + $p );    don( $p, StudentWorker2.class );    System.out.println( \">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> DON ASSISTANT \" + $p );    don( $p, Assistant.class );  end  rule \"Log S\"  when    $t : Student() @watch( name )  then    System.err.println( \"@@Student >> \" +  $t );  end  rule \"Log W\"  when    $t : Worker() @watch( name )  then    System.err.println( \"@@Worker >> \" + $t );  end  rule \"Log SW\"  when    $t : StudentWorker() @watch( name )  then    System.err.println( \"@@StudentWorker >> \" + $t );  end  rule \"Log RA\"  when    $t : Assistant() @watch( name )  then    System.err.println( \"@@Assistant >> \" + $t );  end  rule \"Log Px\"  salience -1  when    $p : Person() @watch( name )  then    System.err.println( \"Poor Core Person >> \" + $p );  end  rule \"Mod\"  salience -10  when    String( this == \"go\" )    $p : Student( name == \"john\" )  then    System.out.println( \" ------------------------------------------------------------------------------ \" + $p );    modify ( $p ) { setName( \"alan\" ); } end  ";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        int k = ksession.fireAllRules();
        Assert.assertEquals((long)7L, (long)k);
        ksession.insert((Object)"go");
        k = ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)k);
    }

    @Test
    public void testTraitModifyCore2a() {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list; \ndeclare trait Student @propertyReactive name : String end\ndeclare trait Worker @propertyReactive name : String end\ndeclare trait StudentWorker extends Student, Worker @propertyReactive name : String end\ndeclare trait Assistant extends Student, Worker @propertyReactive name : String end\ndeclare Person @Traitable @propertyReactive name : String end\nrule \"Init\" \nwhen \nthen \n  Person p = new Person( \"john\" ); \n  insert( p ); \nend \nrule \"Don\" \nwhen \n  $p : Person( name == \"john\" ) \nthen \n  System.out.println( \">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> DON WORKER \" + $p  ); \n  don( $p, Worker.class ); \n  System.out.println( \">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> DON STUDWORKER \" + $p ); \n  don( $p, StudentWorker.class ); \nend \nrule \"Log W\" \nwhen \n  $t : Worker( this isA StudentWorker ) @watch( name ) \nthen \n  System.out.println( \"@@Worker >> \" + $t ); \n  list.add( true ); \nend \nrule \"Log SW\" \nwhen \n  $t : StudentWorker() @watch( name ) \nthen \n  System.out.println( \"@@StudentWorker >> \" + $t ); \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        int k = ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(true));
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testTraitModifyCore3() {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list; \ndeclare trait A id : int end\ndeclare trait B extends A end\ndeclare trait C extends A end\ndeclare trait D extends A end\ndeclare trait E extends B end\ndeclare trait F extends C end\ndeclare trait G extends D end\ndeclare trait H extends D end\ndeclare trait I extends E end\ndeclare trait J extends F end\ndeclare trait K extends G, H end\ndeclare trait L extends G, H end\ndeclare trait M extends I, J end\ndeclare trait N extends K, L end\ndeclare Core @Traitable id : int = 0 end \nrule \"Init\" when \nthen \n   insert( new Core() );end \nrule \"donManyThing\"\nwhen\n    $x : Core( id == 0 )\nthen\n    don( $x, A.class );\n    don( $x, B.class );\n    don( $x, D.class );\n    don( $x, F.class );\n    don( $x, E.class );\n    don( $x, I.class );\n    don( $x, K.class );\n    don( $x, J.class );\n    don( $x, C.class );\n    don( $x, H.class );\n    don( $x, G.class );\n    don( $x, L.class );\n    don( $x, M.class );\n    don( $x, N.class );\nend\n\n\n\nrule \"Log A\" when $x : A( id == 1 ) then System.out.println( \"A >> \" +  $x ); list.add( 1 ); end \nrule \"Log B\" when $x : B( id == 1 ) then System.out.println( \"B >> \" +  $x ); list.add( 2 ); end \nrule \"Log C\" when $x : C( id == 1 ) then System.out.println( \"C >> \" +  $x ); list.add( 3 ); end \nrule \"Log D\" when $x : D( id == 1 ) then System.out.println( \"D >> \" +  $x ); list.add( 4 ); end \nrule \"Log E\" when $x : E( id == 1 ) then System.out.println( \"E >> \" +  $x ); list.add( 5 ); end \nrule \"Log F\" when $x : F( id == 1 ) then System.out.println( \"F >> \" +  $x ); list.add( 6 ); end \nrule \"Log G\" when $x : G( id == 1 ) then System.out.println( \"G >> \" +  $x ); list.add( 7 ); end \nrule \"Log H\" when $x : H( id == 1 ) then System.out.println( \"H >> \" +  $x ); list.add( 8 ); end \nrule \"Log I\" when $x : I( id == 1 ) then System.out.println( \"I >> \" +  $x ); list.add( 9 ); end \nrule \"Log J\" when $x : J( id == 1 ) then System.out.println( \"J >> \" +  $x ); list.add( 10 ); end \nrule \"Log K\" when $x : K( id == 1 ) then System.out.println( \"K >> \" +  $x ); list.add( 11 ); end \nrule \"Log L\" when $x : L( id == 1 ) then System.out.println( \"L >> \" +  $x ); list.add( 12 ); end \nrule \"Log M\" when $x : M( id == 1 ) then System.out.println( \"M >> \" +  $x ); list.add( 13 ); end \nrule \"Log N\" when $x : N( id == 1 ) then System.out.println( \"N >> \" +  $x ); list.add( 14 ); end \nrule \"Log Core\" when $x : Core( $id : id ) then System.out.println( \"Core >>>>>> \" +  $x ); end \nrule \"Mod\" \nsalience -10 \nwhen \n  String( this == \"go\" ) \n  $x : Core( id == 0 ) \nthen \n  System.out.println( \" ------------------------------------------------------------------------------ \" ); \n  modify ( $x ) { setId( 1 ); }end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        Assert.assertEquals((long)14L, (long)list.size());
        for (int j = 1; j <= 14; ++j) {
            Assert.assertTrue((boolean)list.contains(j));
        }
    }

    @Test
    public void testTraitModifyCoreWithPropertyReactivity() {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list;\ndeclare trait Student @propertyReactive    name : String    age : int    grades : double    school : String    aaa : boolean end\ndeclare trait Worker @propertyReactive    name : String    wage : double end\ndeclare trait StudentWorker extends Student, Worker @propertyReactive    hours : int end\ndeclare trait Assistant extends Student, Worker @propertyReactive    address : String end\ndeclare Person @propertyReactive @Traitable    wage : double    name : String    age : int  end\nrule \"Init\" \nwhen \nthen \n  Person p = new Person( 109.99, \"john\", 18 ); \n  insert( p ); \nend \nrule \"Don\" \nwhen \n  $p : Person( name == \"john\" ) \nthen \n  System.out.println( $p ); \n  don( $p, StudentWorker.class ); \n  don( $p, Assistant.class ); \nend \nrule \"Log S\" \nwhen \n  $t : Student( age == 44 ) \nthen \n  list.add( 1 );\n   System.out.println( \"Student >> \" +  $t ); \nend \nrule \"Log W\" \nwhen \n  $t : Worker( name == \"alan\" ) \nthen \n  list.add( 2 );\n   System.out.println( \"Worker >> \" + $t ); \nend \nrule \"Log SW\" \nwhen \n  $t : StudentWorker( age == 44 ) \nthen \n  list.add( 3 );\n   System.out.println( \"StudentWorker >> \" + $t ); \nend \nrule \"Log Pers\" \nwhen \n  $t : Person( age == 44 ) \nthen \n  list.add( 4 );\n   System.out.println( \"Person >> \" + $t ); \nend \nrule \"Mod\" \nsalience -10 \nwhen \n  String( this == \"go\" ) \n  $p : Student( name == \"john\" ) \nthen \n  System.out.println( \" ------------------------------------------------------------------------------ \" + $p ); \n  modify ( $p ) { setSchool( \"myschool\" ), setAge( 44 ), setName( \"alan\" ); } end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        int k = ksession.fireAllRules();
        ksession.insert((Object)"go");
        k = ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)k);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(1));
        Assert.assertTrue((boolean)list.contains(2));
        Assert.assertTrue((boolean)list.contains(3));
        Assert.assertTrue((boolean)list.contains(4));
    }

    @Test
    public void testTraitEncodeExtendingNonTrait() {
        String s1 = "package test;\nimport " + IntfParent.class.getCanonicalName() + ";\ndeclare IntfParent end\ndeclare trait TChild extends IntfParent end \n";
        String s2 = "package test; declare trait SomeThing end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder2.hasErrors()) {
            Assert.fail((String)kbuilder2.getErrors().toString());
        }
        kbase.addPackages(kbuilder2.getKnowledgePackages());
    }

    @Test
    public void isAWithBackChaining() {
        String source = "org/drools/compiler/factmodel/traits/testTraitIsAWithBC.drl";
        KieSession ksession = this.getSession(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.insert((Object)"Como");
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains("Italy"));
    }

    @Test
    public void testIsAEvaluatorOnClassification() {
        String source = "package t.x \n\nglobal java.util.List list; \nimport org.drools.core.factmodel.traits.Thing\nimport org.drools.traits.core.factmodel.Entity\n\ndeclare trait t.x.D\n    @propertyReactive\n\nend\ndeclare trait t.x.E\n    @propertyReactive\n\nend\nrule Init when\nthen\n   Entity o = new Entity();\n   insert(o);\n   don( o, D.class ); \nend\nrule Don when\n $o : Entity() \nthen \nend \nrule \"Rule 0 >> http://t/x#D\"\nwhen\n   $t : org.drools.core.factmodel.traits.Thing( $c : core, this not isA t.x.E.class, this isA t.x.D.class ) then\n   list.add( \"E\" ); \n   don( $t, E.class ); \nend\nrule React \nwhen E() then \n   list.add( \"X\" ); \nend \n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("E"));
        Assert.assertTrue((boolean)list.contains("X"));
    }

    @Test
    public void testShedWithTMS() {
        String source = "package t.x \n\nglobal java.util.List list; \nimport org.drools.core.factmodel.traits.Thing\nimport org.drools.traits.core.factmodel.Entity\n\ndeclare trait t.x.D\n    @propertyReactive\n\nend\ndeclare trait t.x.E\n    @propertyReactive\n\nend\nrule Init when\nthen\n   Entity o = new Entity();\n   insert(o);\n   don( o, Thing.class ); \n   don( o, D.class ); \nend\nrule Don when\n $o : Entity() \nthen \nend \nrule \"Rule 0 >> http://t/x#D\"\nwhen\n   $t : org.drools.core.factmodel.traits.Thing( $c : core, _isTop(), this not isA t.x.E.class, this isA t.x.D.class ) then\n   list.add( \"E\" ); \n   System.out.println( \"E due to \" + $t); \n   don( $t, E.class ); \nend\nrule React \nwhen $x : E() then \n   list.add( \"X\" ); \nend \nrule Shed \nwhen \n   $s : String() \n   $d : Entity() \nthen \n   delete( $s ); \n   shed( $d, D.class );\nend \n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("E"));
        Assert.assertTrue((boolean)list.contains("X"));
        ks.insert((Object)"shed");
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)3L, (long)ks.getObjects().size());
    }

    @Test
    public void testTraitInitialization() {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.core.factmodel.traits.Thing \nimport org.drools.core.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait Foo\n   hardList : List = new ArrayList() \n   softList : List = new ArrayList() \n   moreList : List = new ArrayList() \n   otraList : List = new ArrayList() \n   primFld  : int = 3 \n   primDbl  : double = 0.421 \n\nend\ndeclare Bar\n   @Traitable()\n   hardList : List \n   moreList : List = Arrays.asList( 1, 2, 3 ) \n\nend\nrule Init when\nthen\n   Bar o = new Bar();\n   insert(o);\n   Thing t = don( o, Thing.class ); \n   t.getFields().put( \"otraList\", Arrays.asList( 42 ) ); \n   don( o, Foo.class ); \nend\nrule Don when\n   $x : Foo( $h : hardList, $s : softList, $o : otraList, $m : moreList, $i : primFld, $d : primDbl ) \nthen \n   list.add( $h ); \n   list.add( $s ); \n   list.add( $o ); \n   list.add( $m ); \n   list.add( $i ); \n   list.add( $d ); \n   System.out.println( $x ); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertFalse((boolean)list.contains(null));
        List hard = (List)list.get(0);
        List soft = (List)list.get(1);
        List otra = (List)list.get(2);
        List more = (List)list.get(3);
        Assert.assertTrue((boolean)hard.isEmpty());
        Assert.assertTrue((boolean)soft.isEmpty());
        Assert.assertEquals((Object)more, Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)otra, Arrays.asList(42));
        Assert.assertTrue((boolean)list.contains(3));
        Assert.assertTrue((boolean)list.contains(0.421));
    }

    @Test
    public void testUnTraitedBean() {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.core.factmodel.traits.Thing \nimport org.drools.core.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait Foo end\ndeclare Bar\n   @Traitable\nend\ndeclare Bar2\nend\nrule Init when\nthen\n   Bar o = new Bar();\n   insert(o);\n   Bar2 o2 = new Bar2();\n   insert(o2);\nend\nrule Check when\n   $x : Bar( this not isA Foo ) \nthen \n   System.out.println( $x ); \nend\nrule Check2 when\n   $x : Bar2( this not isA Foo ) \nthen \n   System.out.println( $x ); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
    }

    @Test
    public void testIsAOptimization() {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.core.factmodel.traits.Thing \nimport org.drools.core.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A end\ndeclare trait B extends A end\ndeclare trait C extends B end\ndeclare trait D extends A end\ndeclare trait E extends C, D end\ndeclare trait F extends E end\ndeclare Kore\n   @Traitable\nend\nrule Init when\nthen\n   Kore k = new Kore();\n   don( k, E.class ); \nend\nrule Check_1 when\n   $x : Kore( this isA [ B, D ]  ) \nthen \n   list.add( \" B+D \" ); \nend\nrule Check_2 when\n   $x : Kore( this isA [ A ]  ) \nthen \n   list.add( \" A \" ); \nend\nrule Check_3 when\n   $x : Kore( this not isA [ F ]  ) \nthen \n   list.add( \" F \" ); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testTypeRefractionOnInsert() {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.core.factmodel.traits.Thing \nimport org.drools.core.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A @propertyReactive end\ndeclare trait B extends A @propertyReactive end\ndeclare trait C extends B @propertyReactive end\ndeclare trait D extends A @propertyReactive end\ndeclare trait E extends C, D @propertyReactive end\ndeclare trait F extends E @propertyReactive end\ndeclare Kore\n   @Traitable\nend\nrule Init when\nthen\n   Kore k = new Kore();\n   System.out.println( \"-----------------------------------------------------------------------\" ); \n    don( k, B.class ); \n   System.out.println( \"-----------------------------------------------------------------------\" ); \n    don( k, C.class ); \n   System.out.println( \"-----------------------------------------------------------------------\" ); \n    don( k, D.class ); \n   System.out.println( \"-----------------------------------------------------------------------\" ); \n    don( k, E.class ); \n   System.out.println( \"-----------------------------------------------------------------------\" ); \n    don( k, A.class ); \n   System.out.println( \"-----------------------------------------------------------------------\" ); \n    don( k, F.class ); \nend\nrule Check_1 when\n   $x : A( ) \nthen \n   list.add( $x ); \n   System.out.println( \" A by \" + $x ); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testTypeRefractionOnQuery() {
        String source = "declare BaseObject\n@Traitable\nid : String @key\nend\n\ndeclare trait A\nid : String @key\nend\n\ndeclare trait B extends A\nend\n\ndeclare trait C extends A\nend\n\nrule \"init\"\nwhen\nthen\nBaseObject $obj = new BaseObject(\"testid123\");\ninsert ($obj);\ndon($obj, B.class, true);\ndon($obj, C.class, true);\nend\n\nquery \"QueryTraitA\"\na : A()\nend";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ks.fireAllRules();
        QueryResults res = ks.getQueryResults("QueryTraitA", new Object[0]);
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test
    public void testTypeRefractionOnQuery2() {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.core.factmodel.traits.Thing \nimport org.drools.core.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A end\ndeclare trait B extends A end\ndeclare trait C extends B end\ndeclare trait D extends A end\ndeclare trait E extends C, D end\ndeclare trait F extends E end\ndeclare trait G extends A end\ndeclare Kore\n   @Traitable\nend\nrule Init when\nthen\n   Kore k = new Kore();\n   don( k, C.class ); \n   don( k, D.class ); \n   don( k, E.class ); \n   don( k, B.class ); \n   don( k, A.class ); \n   don( k, F.class ); \n   don( k, G.class ); \n   shed( k, B.class ); \nend\nrule RuleA\nwhen \n   $x : A(  ) \nthen \n   System.out.println( $x ); \n end\n \nquery queryA1\n   $x := A(  ) \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        QueryResults res = ks.getQueryResults("queryA1", new Object[0]);
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test
    public void testNodePartitioningByProxies() {
        String source = "package t.x  import java.util.*;  import org.drools.core.factmodel.traits.Thing  import org.drools.core.factmodel.traits.Traitable   global java.util.List list;   declare trait A @PropertyReactive end declare trait B extends A @PropertyReactive end declare trait C extends B @PropertyReactive end declare trait D extends A @PropertyReactive end declare trait E extends C, D @PropertyReactive end declare trait F extends E @PropertyReactive end declare trait G extends A @PropertyReactive end declare Kore    @Traitable end rule Init when then    Kore k = new Kore();    don( k, C.class );     don( k, D.class );     don( k, B.class );     don( k, A.class );     don( k, F.class );     don( k, E.class );     don( k, G.class );  end ";
        for (char c = 'A'; c <= 'G'; c = (char)(c + '\u0001')) {
            String C = "" + c;
            source = source + "rule Rule" + C + " when " + C + "() then list.add( '" + C + "' ); end ";
        }
        source = source + "rule RuleAll when     A() B() C() D() E() F() G() then     list.add( 'Z' ); end ";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        System.out.println(list);
        Assert.assertEquals(Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('Z')), list);
        for (Object o : ks.getObjects((ObjectFilter)new org.drools.core.ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof TraitableBean;
            }
        })) {
            Set<BitSet> otns = this.checkOTNPartitioning((TraitableBean)o, ks);
            Assert.assertEquals((long)7L, (long)otns.size());
        }
    }

    @Test
    public void testNodePartitioningByProxiesAfterShed() {
        String source = "package t.x  import java.util.*;  import org.drools.core.factmodel.traits.Thing  import org.drools.core.factmodel.traits.Traitable   global java.util.List list;   declare trait A end declare trait B extends A end declare trait C extends B end declare trait D extends A end declare trait E extends C, D end declare trait F extends E end declare trait G extends A end declare Kore    @Traitable end rule Init when then    Kore k = new Kore();    don( k, C.class );     don( k, D.class );     don( k, B.class );     don( k, A.class );     don( k, F.class );     don( k, E.class );     don( k, G.class );     shed( k, B.class );  end ";
        for (char c = 'A'; c <= 'G'; c = (char)(c + '\u0001')) {
            String C = "" + c;
            source = source + "rule Rule" + C + " when " + C + "() then list.add( '" + C + "' ); end ";
        }
        source = source + "rule RuleAll when     A() D() G() then     list.add( 'Z' ); end ";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        System.out.println(list);
        Assert.assertEquals(Arrays.asList(Character.valueOf('A'), Character.valueOf('D'), Character.valueOf('G'), Character.valueOf('Z')), list);
        for (Object o : ks.getObjects((ObjectFilter)new org.drools.core.ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof TraitableBean;
            }
        })) {
            Set<BitSet> otns = this.checkOTNPartitioning((TraitableBean)o, ks);
            Assert.assertEquals((long)3L, (long)otns.size());
        }
    }

    @Test
    public void testTypeRefractionOnQueryWithIsA() {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.core.factmodel.traits.Thing \nimport org.drools.core.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A @propertyReactive end\ndeclare trait B extends A @propertyReactive end\ndeclare trait C extends B @propertyReactive end\ndeclare trait D extends A @propertyReactive end\ndeclare trait E extends C, D @propertyReactive end\ndeclare trait F extends E @propertyReactive end\ndeclare Kore\n   @Traitable\nend\nrule Init when\nthen\n   Kore k = new Kore();\n   don( k, C.class ); \n   don( k, D.class ); \n   don( k, E.class ); \n   don( k, B.class ); \n   don( k, A.class ); \n   don( k, F.class ); \n   shed( k, B.class ); \nend\n \nquery queryA\n   $x := Kore( this isA A ) \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        QueryResults res = ks.getQueryResults("queryA", new Object[0]);
        Iterator iter = res.iterator();
        Object a = ((QueryResultsRow)iter.next()).get("$x");
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test
    public void testCoreUpdate4() {
        String source = "package t.x \nimport java.util.*; \nimport org.drools.core.factmodel.traits.Thing \nimport org.drools.core.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A    age : int \nend\ndeclare Kore\n   @Traitable\n   @propertyReactive   age : int\nend\nrule Init \nwhen\nthen\n   Kore k = new Kore( 44 );\n   insert( k ); \nend\nrule Don \nno-loop \nwhen\n   $x : Kore() \nthen \n   System.out.println( \"Donning\" ); \n   don( $x, A.class ); \nend\nrule React \nsalience 1when\n   $x : Kore( this isA A.class ) \nthen \n   System.out.println( \"XXXXXXXXXXXXXXXXXXXXXX \" + $x ); \n   list.add( $x ); \nend\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            System.err.println(o);
        }
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void traitLogicalSupportAnddelete() {
        String drl = "package org.drools.trait.test;\n\nimport org.drools.core.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\ndeclare trait Student\n  age  : int\n  name : String\nend\n\ndeclare Person\n  @Traitable\n  name : String\nend\n\nrule Init when then insert( new Person( \"john\" ) ); end \nrule \"Don Logical\"\nwhen\n  $s : String( this == \"trigger1\" )\n  $p : Person() \nthen\n  don( $p, Student.class, true );\nend\nrule \"Don Logical2\"\nwhen\n  $s : String( this == \"trigger2\" )\n  $p : Person() \nthen\n  don( $p, Student.class, true );\nend\nrule \"Undon \"\nwhen\n  $s : String( this == \"trigger3\" )\n  $p : Person() \nthen\n  shed( $p, org.drools.core.factmodel.traits.Thing.class );   delete( $s ); \nend\n rule \"Don Logical3\"\nwhen\n  $s : String( this == \"trigger4\" )\n  $p : Person() \nthen\n  don( $p, Student.class, true );end\n rule \"Undon 2\"\nwhen\n  $s : String( this == \"trigger5\" )\n  $p : Person() \nthen\n  delete( $s ); \n  delete( $p ); \nend\n";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle h1 = ksession.insert((Object)"trigger1");
        FactHandle h2 = ksession.insert((Object)"trigger2");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.err.println(o);
        }
        System.err.println("---------------------------------");
        Assert.assertEquals((long)4L, (long)ksession.getObjects().size());
        ksession.delete(h1);
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.err.println(o);
        }
        System.err.println("---------------------------------");
        Assert.assertEquals((long)3L, (long)ksession.getObjects().size());
        ksession.delete(h2);
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.err.println(o);
        }
        System.err.println("---------------------------------");
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        ksession.insert((Object)"trigger3");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.err.println(o);
        }
        System.err.println("---------------------------------");
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        ksession.insert((Object)"trigger4");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.err.println(o);
        }
        System.err.println("---------------------------------");
        Assert.assertEquals((long)3L, (long)ksession.getObjects().size());
        ksession.insert((Object)"trigger5");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.err.println(o);
        }
        System.err.println("---------------------------------");
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
    }

    @Test
    public void testShedThing() {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list; \ndeclare trait A id : int end\ndeclare trait B extends A end\ndeclare trait C extends A end\ndeclare trait D extends A end\ndeclare trait E extends B end\ndeclare Core @Traitable id : int = 0 end \nrule \"Init\" when \nthen \n   insert( new Core() );end \nrule \"donManyThing\"\nwhen\n    $x : Core( id == 0 )\nthen\n    don( $x, A.class );\n    don( $x, B.class );\n    don( $x, C.class );\n    don( $x, D.class );\n    don( $x, E.class );\nend\n\n\nrule \"Mod\" \nsalience -10 \nwhen \n  $g : String( this == \"go\" ) \n  $x : Core( id == 0 ) \nthen \n  shed( $x, Thing.class );   delete( $g ); \n\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
    }

    @Test
    public void testdeleteThings() {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nglobal java.util.List list; \ndeclare trait A id : int end\ndeclare trait B extends A end\ndeclare trait C extends A end\ndeclare trait D extends A end\ndeclare trait E extends B end\ndeclare Core @Traitable id : int = 0 end \nrule \"Init\" when \nthen \n   insert( new Core() );end \nrule \"donManyThing\"\nwhen\n    $x : Core( id == 0 )\nthen\n    don( $x, A.class );\n    don( $x, B.class );\n    don( $x, C.class );\n    don( $x, D.class );\n    don( $x, E.class );\nend\n\n\nrule \"Mod\" \nsalience -10 \nwhen \n  $g : String( this == \"go\" ) \n  $x : Core( id == 0 ) \nthen \n  delete( $x ); \n\n  delete( $g ); \n\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)kbase);
        kbase.addPackages(kbuilder.getKnowledgePackages());
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)0L, (long)ksession.getObjects().size());
    }

    @Test
    public void traitLogicalRemovalSimple() {
        String drl = "package org.drools.compiler.trait.test;\n\nimport org.drools.core.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\ndeclare trait Student\n age : int\n name : String\nend\ndeclare trait Worker\n wage : int\nend\ndeclare trait Scholar extends Student\nend\n\ndeclare Person\n @Traitable\n name : String\nend\n\n\nrule \"Don Logical\"\nwhen\n $s : String( this == \"trigger\" )\nthen\n Person p = new Person( \"john\" );\n insert( p ); \n don( p, Student.class, true );\n don( p, Worker.class );\n don( p, Scholar.class );\nend";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle h = ksession.insert((Object)"trigger");
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)ksession.getObjects().size());
        ksession.delete(h);
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)3L, (long)ksession.getObjects().size());
    }

    @Test
    public void testTraitDonLegacyClassWithoutEmptyConstructor() {
        String drl = "package org.drools.compiler.trait.test;\n\nimport " + TraitableFoo.class.getCanonicalName() + ";import org.drools.core.factmodel.traits.Traitable;\n\ndeclare trait Bar\nend\n\nrule \"Don\"\nno-loop \nwhen\n $f : TraitableFoo( )\nthen\n  Bar b = don( $f, Bar.class );\nend";
        KieSession ksession = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        ksession.insert((Object)new TraitableFoo("xx", 0, null));
        ksession.fireAllRules();
        for (Object o : ksession.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)2L, (long)ksession.getObjects().size());
    }

    @Test
    public void testdeleteCoreObjectChained() {
        String source = "package org.drools.test;\nimport java.util.List; \nimport org.drools.core.factmodel.traits.Thing \nimport org.drools.core.factmodel.traits.Traitable \n\nglobal java.util.List list; \n\ndeclare trait A    age : int \nend\ndeclare Kore\n   @Traitable\n   age : int\nend\nrule Init \nwhen\n   $s : String() \nthen\n   Kore k = new Kore( 44 );\n   insertLogical( k ); \nend\nrule Don \nno-loop \nwhen\n   $x : Kore() \nthen \n   System.out.println( \"Donning\" ); \n   don( $x, A.class ); \nend\nrule delete \nsalience -99 \nwhen \n   $x : String() \nthen \n   System.out.println( \"deleteing\" ); \n   delete( $x ); \nend \n\n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.insert((Object)"go");
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            System.out.println(o);
        }
        Assert.assertEquals((long)0L, (long)ks.getObjects().size());
        ks.dispose();
    }

    @Test
    public void testUpdateLegacyClass() {
        String source = "package org.drools.text;\n\nglobal java.util.List list;\n\nimport org.drools.traits.compiler.Person;\nimport org.drools.core.factmodel.traits.Traitable;\n\ndeclare Person @Traitable end \ndeclare trait Student\n  name : String\nend\n\nrule \"Init\"\nsalience 10 \nwhen\n  $p : Person( this not isA Student )\nthen\n  System.out.println( \"Don person\" ); \n  don( $p, Student.class );\nend\n\nrule \"Go\"\nwhen\n  $s : String( this == \"X\" )\n  $p : Person()\nthen\n  System.out.println( \"Change name\" ); \n  delete( $s ); \n  modify( $p ) { setName( $s ); }\nend\n\nrule \"Mod\"\nwhen\n  Student( name == \"X\" )\nthen\n  System.out.println( \"Update detected\" );\n  list.add( 0 );\nend";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.insert((Object)new Person("john", 32));
        ks.insert((Object)"X");
        ks.fireAllRules();
        Assert.assertTrue((boolean)list.contains(0));
        Assert.assertEquals((long)1L, (long)list.size());
        ks.dispose();
    }

    @Test
    public void testSoftPropertyClash() {
        String source = "package org.drools.text;\n\nglobal java.util.List list;\n\nimport org.drools.core.factmodel.traits.Traitable;\nimport org.drools.core.factmodel.traits.Alias;\n\ndeclare Person @Traitable @propertyReactive \nend \ndeclare trait Student\n   @propertyReactive \n   id : String = \"a\" \n   fld2 : int = 4 \n   fld3 : double = 4.0 \n   fld4 : String = \"hello\" \n   fldZ : String = \"hello\" @Alias( \"fld5\" )\nend\ndeclare trait Worker\n   @propertyReactive \n   id : int = 3 \n   fld2 : String = \"b\" \n    fld3 : int = 11 \n    fld4 : Class = Object.class \n    fldY : int = 42 @Alias( \"fld5\" )\nend\nrule \"Init\" when then \n   insert( new Person() ); \nend \n\nrule \"Don\"\nwhen\n   $p : Person() \nthen\n  System.out.println( \"Don person\" ); \n  Student $s = (Student) don( $p, Student.class );\n  modify ( $s ) { setId( \"xyz\" ); }     Worker $w = don( $p, Worker.class );\n  modify ( $w ) { setId( 99 ); } end\n\nrule \"Stud\"\nwhen\n  $s : Student( $sid : id == \"xyz\", $f2 : fld2, $f3 : fld3, $f4 : fld4, $f5 : fldZ )\nthen\n  System.out.println( \">>>>>>>>>> Student\" + $s ); \n  list.add( $sid ); \n  list.add( $f2 ); \n  list.add( $f3 ); \n  list.add( $f4 ); \n  list.add( $f5 ); \nend\n\nrule \"Mod\"\nwhen\n  $w : Worker( $wid : id == 99, $f2 : fld2, $f3 : fld3, $f4 : fld4, $f5 : fldY )\nthen\n  System.out.println( \">>>>>>>>>> Worker\" + $w );\n  list.add( $wid ); \n  list.add( $f2 ); \n  list.add( $f3 ); \n  list.add( $f4 ); \n  list.add( $f5 ); \nend";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals(Arrays.asList(99, "b", 11, Object.class, 42), list);
        ks.dispose();
    }

    @Test
    public void testMultipleModifications() {
        String drl = "package org.drools.traits.test;\n\nimport org.drools.core.factmodel.traits.Traitable;\nglobal java.util.List list;\ndeclare Person\n@Traitable\n@propertyReactive\n    ssn : String\n    pob : String\n    isStudent : boolean\n    hasAssistantship : boolean\nend\n\ndeclare trait Student\n@propertyReactive\n    studyingCountry : String\n    hasAssistantship : boolean\nend\n\ndeclare trait Worker\n@propertyReactive\n    pob : String\n    workingCountry : String\nend\n\ndeclare trait USCitizen\n@propertyReactive\n    pob : String = \"US\"\nend\n\ndeclare trait ITCitizen\n@propertyReactive\n    pob : String = \"IT\"\nend\n\ndeclare trait IRCitizen\n@propertyReactive\n    pob : String = \"IR\"\nend\n\nrule \"init\"\nwhen\nthen\n    insert( new Person(\"1234\",\"IR\",true,true) );\nend\n\nrule \"check for being student\"\nwhen\n    $p : Person( $ssn : ssn, $pob : pob,  isStudent == true )\nthen\n    Student st = (Student) don( $p , Student.class );\n    modify( st ){\n        setStudyingCountry( \"US\" );\n    }\nend\n\nrule \"check for IR\"\nwhen\n    $p : Person( pob == \"IR\" )\nthen\n    don( $p , IRCitizen.class );\nend\n\nrule \"check for being US citizen\"\nwhen\n    $s : Student( studyingCountry == \"US\" )\nthen\n    don( $s , USCitizen.class );\nend\n\nrule \"check for being worker\"\nwhen\n    $p : Student( hasAssistantship == true, $sc : studyingCountry  )\nthen\n    Worker wr = (Worker) don( $p , Worker.class );\n    modify( wr ){\n        setWorkingCountry( $sc );\n    }\n\nend\n\nrule \"Join Full\"\nsalience -1\nwhen\n    Student( )      // $sc := studyingCountry )\n    USCitizen( )\n    IRCitizen( )      // $pob := pob )\n    Worker( )       // pob == $pob , workingCountry == $sc )\nthen\n    list.add( 1 ); end\n\n\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertTrue((boolean)list.contains(1));
        Assert.assertEquals((long)1L, (long)list.size());
        ks.dispose();
    }

    @Test
    public void testPropagation() {
        String drl = "package org.drools.test;\nimport org.drools.core.factmodel.traits.*; \n\nglobal java.util.List list; \ndeclare X @Traitable end \ndeclare trait A @propertyReactive end\ndeclare trait B extends A @propertyReactive end\ndeclare trait C extends B @propertyReactive end \ndeclare trait D extends C @propertyReactive end\ndeclare trait E extends B,C @propertyReactive end\ndeclare trait F extends E @propertyReactive end\ndeclare trait G extends B @propertyReactive end\ndeclare trait H extends G @propertyReactive end\ndeclare trait I extends E,H @propertyReactive end\ndeclare trait J extends I @propertyReactive end\nrule Init when then X x = new X(); insert( x ); don( x, F.class); end \nrule Go when String( this == \"go\" ) $x : X() then don( $x, H.class); end \nrule Go2 when String( this == \"go2\" ) $x : X() then don( $x, D.class); end \n";
        for (int j = 65; j <= 74; ++j) {
            String x = "" + (char)j;
            drl = drl + "rule \"Log " + x + "\" when " + x + "() then System.out.println( \"@@ " + x + " detected \" ); list.add( \"" + x + "\" ); end \n";
            drl = drl + "rule \"Log II" + x + "\" salience -1 when " + x + "( ";
            drl = drl + "this isA H";
            drl = drl + " ) then System.out.println( \"@@ as H >> " + x + " detected \" ); list.add( \"H" + x + "\" ); end \n";
        }
        KieSession ks = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertTrue((boolean)list.contains("A"));
        Assert.assertTrue((boolean)list.contains("B"));
        Assert.assertTrue((boolean)list.contains("C"));
        Assert.assertTrue((boolean)list.contains("E"));
        Assert.assertTrue((boolean)list.contains("F"));
        Assert.assertEquals((long)5L, (long)list.size());
        list.clear();
        System.out.println("---------------------------------------");
        ks.insert((Object)"go");
        ks.fireAllRules();
        Assert.assertTrue((boolean)list.contains("H"));
        Assert.assertTrue((boolean)list.contains("G"));
        Assert.assertTrue((boolean)list.contains("HA"));
        Assert.assertTrue((boolean)list.contains("HB"));
        Assert.assertTrue((boolean)list.contains("HC"));
        Assert.assertTrue((boolean)list.contains("HE"));
        Assert.assertTrue((boolean)list.contains("HF"));
        Assert.assertTrue((boolean)list.contains("HG"));
        Assert.assertTrue((boolean)list.contains("HH"));
        System.out.println(list);
        Assert.assertEquals((long)9L, (long)list.size());
        list.clear();
        System.out.println("---------------------------------------");
        ks.insert((Object)"go2");
        ks.fireAllRules();
        Assert.assertTrue((boolean)list.contains("D"));
        Assert.assertTrue((boolean)list.contains("HA"));
        Assert.assertTrue((boolean)list.contains("HB"));
        Assert.assertTrue((boolean)list.contains("HC"));
        Assert.assertTrue((boolean)list.contains("HE"));
        Assert.assertTrue((boolean)list.contains("HF"));
        Assert.assertTrue((boolean)list.contains("HG"));
        Assert.assertTrue((boolean)list.contains("HH"));
        Assert.assertTrue((boolean)list.contains("HH"));
        Assert.assertTrue((boolean)list.contains("HD"));
        Assert.assertEquals((long)9L, (long)list.size());
        ks.dispose();
    }

    @Test
    public void testParentBlockers() {
        String drl = "package org.drools.test;\nimport org.drools.core.factmodel.traits.*; \n\nglobal java.util.List list; \ndeclare X @Traitable end \ndeclare trait A @propertyReactive end\ndeclare trait B @propertyReactive end\ndeclare trait C extends A, B @propertyReactive end \nrule Init when then X x = new X(); insert( x ); don( x, A.class); don( x, B.class); end \nrule Go when String( this == \"go\" ) $x : X() then don( $x, C.class); end \nrule Go2 when String( this == \"go2\" ) $x : C() then System.out.println( 1000 ); end \n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        ks.insert((Object)"go");
        ks.fireAllRules();
        ks.insert((Object)"go2");
        ks.fireAllRules();
        System.out.println("---------------------------------------");
        ks.dispose();
    }

    @Test
    public void testTraitLogicalTMS() {
        String drl = "package org.drools.test;\nimport org.drools.core.factmodel.traits.*; \n\nglobal java.util.List list; \ndeclare X @Traitable end \ndeclare trait A @propertyReactive end\ndeclare trait B @propertyReactive end\nrule Init when then X x = new X(); insert( x ); end \nrule Go when String( this == \"go\" ) $x : X() then don( $x, A.class, true ); don( $x, B.class, true ); end \nrule Go2 when String( this == \"go2\" ) $x : X() then don( $x, A.class ); end \nrule Go3 when String( this == \"go3\" ) $x : A() not B() then list.add( 100 ); end \n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        FactHandle handle = ks.insert((Object)"go");
        ks.fireAllRules();
        ks.insert((Object)"go2");
        ks.fireAllRules();
        ks.delete(handle);
        ks.fireAllRules();
        System.out.println("---------------------------------------");
        for (Object o : ks.getObjects()) {
            System.out.println(o);
        }
        ks.insert((Object)"go3");
        ks.fireAllRules();
        Assert.assertEquals(Arrays.asList(100), list);
        ks.dispose();
    }

    @Test
    public void testTraitNoType() {
        String drl = "package org.drools.core.factmodel.traits.test;\n\nimport org.drools.core.factmodel.traits.Thing;\nimport org.drools.core.factmodel.traits.Traitable;\nimport org.drools.core.factmodel.traits.Trait;\nimport org.drools.core.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\n\ndeclare Parent\n@Traitable( logical = true )@propertyReactive\nend\n\ndeclare trait ChildTrait\n@propertyReactive\n    naam : String = \"kudak\"\n    id : int = 1020\nend\n\nrule \"don\"\nno-loop\nwhen\nthen\n    Parent p = new Parent();    insert(p);\n    ChildTrait ct = don( p , ChildTrait.class );\n    list.add(\"correct1\");\nend\n\nrule \"check\"\nno-loop\nwhen\n    $c : ChildTrait($n : naam == \"kudak\", id == 1020 )\n    $p : Thing( core == $c.core, fields[\"naam\"] == $n )\nthen\n    list.add(\"correct2\");\nend";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains("correct1"));
        Assert.assertTrue((boolean)list.contains("correct2"));
    }

    @Test
    public void testTraitdeleteOrder() {
        String drl = "package org.drools.core.factmodel.traits.test;\n\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nimport java.util.*;\n\ndeclare trait A end \ndeclare trait B extends A end \ndeclare trait C end \n\nrule \"don\"\nwhen \n  $e : Entity() \nthen\n  don( $e, A.class ); \n  don( $e, C.class ); \n  don( $e, B.class ); \nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        FactHandle handle = ksession.insert((Object)new Entity());
        ksession.fireAllRules();
        final ArrayList list = new ArrayList();
        ksession.addEventListener(new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent objectInsertedEvent) {
            }

            public void objectUpdated(ObjectUpdatedEvent objectUpdatedEvent) {
            }

            public void objectDeleted(ObjectDeletedEvent objectRetractedEvent) {
                Object o = objectRetractedEvent.getOldObject();
                if (o instanceof TraitProxyImpl) {
                    String traitName = ((TraitProxyImpl)o)._getTraitName();
                    list.add(traitName.substring(traitName.lastIndexOf(".") + 1));
                }
            }
        });
        ksession.delete(handle);
        ksession.fireAllRules();
        System.out.println(list);
        Assert.assertEquals(Arrays.asList("B", "C", "A"), list);
    }

    @Test
    public void testTraitWithManySoftFields() {
        String drl = "package org.drools.core.factmodel.traits.test;\n\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nimport java.util.*;\n\ndeclare trait Tx \n";
        for (int j = 0; j < 150; ++j) {
            drl = drl + " fld" + j + " : String \n";
        }
        drl = drl + "end \n\ndeclare TBean @Traitable fld0 : String end \nrule \"don\"\nwhen \nthen\n  don( new TBean(), Tx.class ); \nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)ksession.getObjects().size());
    }

    @Test
    public void testDonManyTraitsAtOnce() {
        String drl = "package org.drools.core.factmodel.traits.test;\n\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nimport java.util.*;\n\nglobal List list; \ndeclare trait A end \ndeclare trait B end \ndeclare trait C end \ndeclare trait D end \ndeclare trait E end \ndeclare trait F end \n\ndeclare TBean @Traitable @propertyReactive fld0 : String end \nrule \"Don 1\"\nwhen \nthen\n  TBean t = new TBean(); \n  don( t, A.class ); \n  don( t, B.class ); \nend\nrule \"Don 2\" when \n  $s : String( this == \"go\" ) \n  $t : TBean() \nthen \n  list.add( 0 ); \n  System.out.println( \"Call DON MANY \" );   don( $t, Arrays.asList( C.class, D.class, E.class, F.class ), true ); \nend \nrule Clear \nwhen \n  $s : String( this == \"undo\" ) \n  $t : TBean() \nthen \n  delete( $s ); \n  delete( $t ); \nend \nrule C \nwhen\n  B( this isA C ) \nthen \n  list.add( 1 ); \n  System.err.println( \"C is HERE !! \" ); end \nrule D \nwhen\n  D( this isA A, this isA C ) \nthen \n  list.add( 2 ); \n  System.err.println( \"D is HERE TOO !! \" ); end \nrule E \nwhen\n  D( this isA A, this isA E ) \nthen \n  list.add( 3 ); \n  System.err.println( \"AND E JOINS THE COMPANY !! \" ); end \n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        CountingWorkingMemoryEventListener cwm = new CountingWorkingMemoryEventListener();
        ksession.addEventListener((RuleRuntimeEventListener)cwm);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)cwm.getdeletes());
        Assert.assertEquals((long)3L, (long)cwm.getInserts());
        Assert.assertEquals((long)1L, (long)cwm.getUpdates());
        cwm.reset();
        FactHandle handle = ksession.insert((Object)"go");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)cwm.getdeletes());
        Assert.assertEquals((long)4L, (long)cwm.getInserts());
        Assert.assertEquals((long)3L, (long)cwm.getUpdates());
        cwm.reset();
        ksession.delete(handle);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)cwm.getdeletes());
        Assert.assertEquals((long)0L, (long)cwm.getInserts());
        Assert.assertEquals((long)0L, (long)cwm.getUpdates());
        cwm.reset();
        for (Object o : ksession.getObjects()) {
            System.out.println(o);
        }
        ksession.insert((Object)"undo");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)cwm.getdeletes());
        Assert.assertEquals((long)0L, (long)cwm.getInserts());
        Assert.assertEquals((long)0L, (long)cwm.getUpdates());
        cwm.reset();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(0, 1, 2, 3)));
    }

    @Test
    public void testDonManyTraitsAtOnce2() {
        String drl = "package org.drools.core.factmodel.traits.test;\n\nimport org.drools.core.factmodel.traits.*;\nimport org.drools.traits.core.factmodel.*;\nimport java.util.*;\n\nglobal List list; \ndeclare trait A @propertyReactive end \ndeclare trait B @propertyReactive end \n\ndeclare TBean @Traitable @propertyReactive fld0 : String end \nrule \"Don 1\"\nwhen \nthen\n  TBean t = new TBean(); \n  don( t, A.class ); \n  don( t, B.class ); \nend\nrule \"Test Don A,B\" when \n  A(this isA B) \nthen \n  list.add( 0 ); \n  System.out.println( \"Call DON MANY (A isA B) \" ); end \n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        CountingWorkingMemoryEventListener cwm = new CountingWorkingMemoryEventListener();
        ksession.addEventListener((RuleRuntimeEventListener)cwm);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(0), list);
        Assert.assertEquals((long)0L, (long)cwm.getdeletes());
        Assert.assertEquals((long)3L, (long)cwm.getInserts());
        Assert.assertEquals((long)1L, (long)cwm.getUpdates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Triple Store is not thread safe and needs to be rewritten")
    public void testMultithreadingTraits() throws InterruptedException {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.TraitTest.Item;\ndeclare Item end\ndeclare trait ItemStyle\n\tid: String\n\tadjustable: boolean\nend\nrule \"Don ItemStyle\"\n\tno-loop true\n\twhen\n\t\t$p : Item ()\n\t\tnot ItemStyle ( id == $p.id )\n\tthen\n\t\tdon($p, ItemStyle.class);\nend\nrule \"Item Style - Adjustable\"\tno-loop true\twhen\t\t$style : ItemStyle ( !adjustable )\t\tItem (\t\t\tid == $style.id \t\t)\tthen\t\tmodify($style) {\t\t\tsetAdjustable(true)\t\t};end";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.core.factmodel.traits.TraitTest.Item;\ndeclare Item end\ndeclare trait ItemStyle\n\tid: String\n\tadjustable: boolean\nend\nrule \"Don ItemStyle\"\n\tno-loop true\n\twhen\n\t\t$p : Item ()\n\t\tnot ItemStyle ( id == $p.id )\n\tthen\n\t\tdon($p, ItemStyle.class);\nend\nrule \"Item Style - Adjustable\"\tno-loop true\twhen\t\t$style : ItemStyle ( !adjustable )\t\tItem (\t\t\tid == $style.id \t\t)\tthen\t\tmodify($style) {\t\t\tsetAdjustable(true)\t\t};end", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        int MAX_THREADS = 20;
        int MAX_REPETITIONS = 100;
        int MAX_WAIT_SECONDS = 60;
        ExecutorService executorService = Executors.newFixedThreadPool(MAX_THREADS);
        try {
            for (int threadIndex = 0; threadIndex < MAX_THREADS; ++threadIndex) {
                executorService.execute(new TraitRulesThread(threadIndex, MAX_REPETITIONS, kbase.newKieSession()));
            }
        }
        finally {
            executorService.shutdown();
            executorService.awaitTermination(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            List<Runnable> queuedTasks = executorService.shutdownNow();
            Assert.assertEquals((long)0L, (long)queuedTasks.size());
            Assert.assertEquals((Object)true, (Object)executorService.isTerminated());
        }
    }

    @Test
    public void testShedOneLastTrait() throws InterruptedException {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core @Traitable end\ndeclare trait Mask\nend\nrule \"Don ItemStyle\"\n\twhen\n\tthen\n\t\tdon( new Core(), Mask.class );\nend\nrule \"React\" \n\twhen \n     $s : String() \n\t\t$m : Mask() \nthen \n     delete( $s ); \n     shed( $m, Mask.class ); \nend\nrule Log \nwhen \n $t : Thing() \nthen \n System.out.println( \"Thing detected \" + $t ); \n list.add( $t.getClass().getName() ); \nend \n";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.core.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core @Traitable end\ndeclare trait Mask\nend\nrule \"Don ItemStyle\"\n\twhen\n\tthen\n\t\tdon( new Core(), Mask.class );\nend\nrule \"React\" \n\twhen \n     $s : String() \n\t\t$m : Mask() \nthen \n     delete( $s ); \n     shed( $m, Mask.class ); \nend\nrule Log \nwhen \n $t : Thing() \nthen \n System.out.println( \"Thing detected \" + $t ); \n list.add( $t.getClass().getName() ); \nend \n", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Arrays.asList("test.Mask.test.Core_Proxy"), list);
        knowledgeSession.insert((Object)"shed");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals(Arrays.asList("test.Mask.test.Core_Proxy", "org.drools.core.factmodel.traits.Thing.test.Core_Proxy"), list);
    }

    @Test
    public void testShedThingCompletelyThenDonAgain() throws InterruptedException {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core @Traitable end\ndeclare trait Mask end\ndeclare trait Mask2 end\nrule \"Don ItemStyle\"\n\twhen\n     $s : String( this == \"don1\" ) \n\tthen\n     delete( $s ); \n\t\tdon( new Core(), Mask.class );\nend\nrule \"Clear\" \n\twhen \n     $s : String( this == \"shed1\" ) \n\t\t$m : Mask() \nthen \n     delete( $s ); \n     shed( $m, Thing.class ); \nend\nrule \"Add\" \n\twhen \n     $s : String( this == \"don2\" ) \n\t\t$c : Core() \nthen \n     delete( $s ); \n     don( $c, Mask2.class ); \nend\nrule \"Clear Again\" \n\twhen \n     $s : String( this == \"shed2\" ) \n\t\t$m : Mask2() \nthen \n     delete( $s ); \n     shed( $m, Mask2.class ); \nend\nrule Log \nwhen \n $t : Thing() \nthen \n  System.out.println( \"Thing detected \" + $t ); \n  list.add( $t.getClass().getName() ); \nend \n";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.core.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core @Traitable end\ndeclare trait Mask end\ndeclare trait Mask2 end\nrule \"Don ItemStyle\"\n\twhen\n     $s : String( this == \"don1\" ) \n\tthen\n     delete( $s ); \n\t\tdon( new Core(), Mask.class );\nend\nrule \"Clear\" \n\twhen \n     $s : String( this == \"shed1\" ) \n\t\t$m : Mask() \nthen \n     delete( $s ); \n     shed( $m, Thing.class ); \nend\nrule \"Add\" \n\twhen \n     $s : String( this == \"don2\" ) \n\t\t$c : Core() \nthen \n     delete( $s ); \n     don( $c, Mask2.class ); \nend\nrule \"Clear Again\" \n\twhen \n     $s : String( this == \"shed2\" ) \n\t\t$m : Mask2() \nthen \n     delete( $s ); \n     shed( $m, Mask2.class ); \nend\nrule Log \nwhen \n $t : Thing() \nthen \n  System.out.println( \"Thing detected \" + $t ); \n  list.add( $t.getClass().getName() ); \nend \n", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)"don1");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Arrays.asList("test.Mask.test.Core_Proxy"), list);
        knowledgeSession.insert((Object)"shed1");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Arrays.asList("test.Mask.test.Core_Proxy"), list);
        knowledgeSession.insert((Object)"don2");
        knowledgeSession.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals(Arrays.asList("test.Mask.test.Core_Proxy", "test.Mask2.test.Core_Proxy"), list);
        knowledgeSession.insert((Object)"shed2");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals(Arrays.asList("test.Mask.test.Core_Proxy", "test.Mask2.test.Core_Proxy", "org.drools.core.factmodel.traits.Thing.test.Core_Proxy"), list);
    }

    @Test
    public void testTraitImplicitInsertionExceptionOnNonTraitable() throws InterruptedException {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core id : String  end\ndeclare trait Mask  id : String end\nrule \"Don ItemStyle\"\n\twhen\n\tthen\n\t\tdon( new Core(), Mask.class );\nend\n";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.core.factmodel.traits.*; \nglobal java.util.List list;\ndeclare Core id : String  end\ndeclare trait Mask  id : String end\nrule \"Don ItemStyle\"\n\twhen\n\tthen\n\t\tdon( new Core(), Mask.class );\nend\n", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        try {
            knowledgeSession.fireAllRules();
            Assert.fail((String)"Core is not declared @Traitable, this test should have thrown an exception");
        }
        catch (Exception csq) {
            Assert.assertTrue((boolean)(csq.getCause() instanceof IllegalStateException));
        }
    }

    @Test
    public void testTraitLegacyTraitableWithLegacyTrait() {
        String s1 = "package org.drools.compiler.factmodel.traits;\nimport " + TraitTest.class.getName() + ".SomeTrait; \nimport " + StudentImpl.class.getCanonicalName() + ";\nimport org.drools.core.factmodel.traits.*; \nimport org.drools.traits.core.factmodel.*; \nglobal java.util.List list;\nrule \"Don ItemStyle\"\n\twhen\n\tthen\n\t\tdon( new StudentImpl(), SomeTrait.class );\nend\n";
        KieBase kbase = this.getKieBaseFromString(s1, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)knowledgeSession.getObjects().size());
    }

    @Test
    public void testIsALegacyTrait() {
        String s1 = "package org.drools.traits.compiler.factmodel.traits;\nimport " + TraitTest.class.getName() + ".SomeTrait; \nimport " + StudentImpl.class.getCanonicalName() + ";\nimport " + Entity.class.getCanonicalName() + ";\nimport org.drools.core.factmodel.traits.*; \nglobal java.util.List list;\ndeclare trait IStudent end \nrule \"Don ItemStyle\"\n\twhen\n\tthen\n\t\tinsert( new StudentImpl() );\n\t\tdon( new Entity(), IStudent.class );\nend\nrule Check  when   $s : StudentImpl()   $e : Entity( this isA $s )  then   list.add( 1 );  end ";
        KieBase kbase = this.getKieBaseFromString(s1, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals(Arrays.asList(1), list);
    }

    @Category(value={ReviseTraitTestWithPRAlwaysCategory.class})
    @Test
    public void testClassLiteralsWithOr() {
        String drl = "package org.drools.test; import org.drools.core.factmodel.traits.*; global java.util.List list; declare Foo @Traitable end declare trait A end declare trait B end rule Init when then   Foo f = new Foo();   insert( f ); end rule One when   $f : Foo( this not isA A ) then   don( $f, A.class ); end rule Two when   $f : Foo( this not isA B ) then   don( $f, B.class ); end rule Check when     $f : Foo( this isA B || this isA A ) then   list.add( 1 ); end ";
        KieBase kbase = new KieHelper(new KnowledgeBuilderOption[]{PropertySpecificOption.ALLOWED}).addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(1), list);
    }

    @Test
    public void testIsASwappedArg() {
        String drl = "package org.drools.traits.compiler.factmodel.traits;\nimport " + TraitTest.class.getName() + ".SomeTrait; \nimport " + StudentImpl.class.getCanonicalName() + ";\nimport " + Entity.class.getCanonicalName() + ";\nimport org.drools.core.factmodel.traits.*; \nglobal java.util.List list; declare Foo @Traitable   object : Object end declare Bar @Traitable end declare trait IStudent end rule Init when then   Foo f = new Foo( new StudentImpl() );   don( f, IStudent.class ); end rule Match1 when   $f : Foo( $x : object )   $p : StudentImpl( this isA $f ) from $x then   list.add( 1 ); end rule Match2 when   $f : Foo( $x : object )   $p : StudentImpl( $f isA this ) from $x then   list.add( 2 ); end ";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(1));
        Assert.assertTrue((boolean)list.contains(2));
    }

    @Test
    public void testHierarchyEncodeOnPackageMerge() {
        String drl0 = "package org.drools.test; declare trait X end ";
        String drl1 = "package org.drools.test; import org.drools.core.factmodel.traits.*; global java.util.List list; declare trait A end declare trait B extends A end declare trait C extends B end ";
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (InternalKnowledgeBase)knowledgeBase);
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb.add((Resource)new ByteArrayResource(drl0.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kb.hasErrors());
        knowledgeBase.addPackages(kb.getKnowledgePackages());
        KnowledgeBuilder kb2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb2.add((Resource)new ByteArrayResource(drl1.getBytes()), ResourceType.DRL);
        System.out.print(kb2.getErrors());
        Assert.assertFalse((boolean)kb2.hasErrors());
        knowledgeBase.addPackages(kb2.getKnowledgePackages());
        HierarchyEncoder hier = ((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry((RuleBase)knowledgeBase).getHierarchy();
        BitSet b = (BitSet)hier.getCode((Object)"org.drools.test.B").clone();
        BitSet c = (BitSet)hier.getCode((Object)"org.drools.test.C").clone();
        c.and(b);
        Assert.assertEquals((Object)b, (Object)c);
    }

    @Test
    @Ignore
    public void testDonThenReinsert() throws InterruptedException {
        String s1 = "package test;\nimport org.drools.core.factmodel.traits.*; \nimport org.drools.traits.compiler.factmodel.traits.TraitTest.TBean;\nglobal java.util.List list;\ndeclare TBean  @Traitable  @propertyReactive end declare trait Mask  @propertyReactive end rule 'Don ItemStyle' \twhen\n     $e : TBean( ) \tthen      System.out.println( 'Don' ); \t\tdon( $e, Mask.class );\nend\nrule \"React\" \n\twhen \n\t\t$m : Mask() \nthen \n     System.out.println( $m ); \nend\nrule Zero when not Object() then System.out.println( 'Clean' ); end ";
        KieBase kbase = this.getKieBaseFromString("package test;\nimport org.drools.core.factmodel.traits.*; \nimport org.drools.traits.compiler.factmodel.traits.TraitTest.TBean;\nglobal java.util.List list;\ndeclare TBean  @Traitable  @propertyReactive end declare trait Mask  @propertyReactive end rule 'Don ItemStyle' \twhen\n     $e : TBean( ) \tthen      System.out.println( 'Don' ); \t\tdon( $e, Mask.class );\nend\nrule \"React\" \n\twhen \n\t\t$m : Mask() \nthen \n     System.out.println( $m ); \nend\nrule Zero when not Object() then System.out.println( 'Clean' ); end ", new KieBaseOption[]{EqualityBehaviorOption.IDENTITY});
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        TBean e = new TBean("aaa");
        int n = knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)n);
        knowledgeSession.insert((Object)e);
        n = knowledgeSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)n);
        knowledgeSession.insert((Object)e);
        n = knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)n);
        knowledgeSession.delete(knowledgeSession.getFactHandle((Object)e));
        n = knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)n);
        Assert.assertEquals((long)0L, (long)knowledgeSession.getObjects().size());
    }

    @Test
    public void testCastOnTheFly() throws InterruptedException {
        String s1 = "package test; import org.drools.core.factmodel.traits.*; global java.util.List list; declare Foo  @Traitable  @propertyReactive  id : int end declare trait Upper  @propertyReactive  id : int end declare trait Lower extends Upper  @propertyReactive end rule Init  dialect 'mvel' \twhen \tthen      Foo o = insert( new Foo( 42 ) ).as( Foo.class );      list.add( o.getId() ); end rule Don  when      $f : Foo()  then      Lower l = don( $f, Lower.class );      Upper u = bolster( $f ).as( Upper.class );      list.add( u.getId() + 1 );  end ";
        KieBase kbase = this.getKieBaseFromString("package test; import org.drools.core.factmodel.traits.*; global java.util.List list; declare Foo  @Traitable  @propertyReactive  id : int end declare trait Upper  @propertyReactive  id : int end declare trait Lower extends Upper  @propertyReactive end rule Init  dialect 'mvel' \twhen \tthen      Foo o = insert( new Foo( 42 ) ).as( Foo.class );      list.add( o.getId() ); end rule Don  when      $f : Foo()  then      Lower l = don( $f, Lower.class );      Upper u = bolster( $f ).as( Upper.class );      list.add( u.getId() + 1 );  end ", new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        ArrayList list = new ArrayList();
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals(Arrays.asList(42, 43), list);
    }

    @Test
    public void testDonModify() {
        String drl = "import org.drools.traits.core.factmodel.Entity;\nimport org.drools.traits.compiler.factmodel.traits.IPerson;\nimport org.drools.compiler.factmodel.traits.IStudent;\ndeclare trait IPerson end\ndeclare trait IStudent end\ndeclare trait Person\n    name : String\nend\nrule \"Init\"\nwhen\nthen\n    Entity core = new Entity();\n    insert( core );\nend\nrule Trait when\n    $core: Entity( )\nthen\n    IPerson x = don( $core, IPerson.class, true );\n    IStudent s = don( $core, IStudent.class, true );\n    Person p = don( $core, Person.class, true );\n    System.err.println( \"            Done donning              \" );\n end\nrule R2 when\n    $p: IPerson( name == null )\nthen\n    System.out.println(\"IPerson: \" + $p);\nend\n\n";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession kSession = kbase.newKieSession();
        Assert.assertEquals((long)3L, (long)kSession.fireAllRules());
    }

    @Test
    public void testAlphaNodeSharing() {
        String drl = "package test; import " + Entity.class.getName() + " declare trait Person\n    name : String\nend\nrule Init when then     don( new Entity(), Person.class ); end\nrule One when    $core: Entity( this isA Person ) then end rule Two when    $core: Entity( this isA Person ) then end \n";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession kSession = kbase.newKieSession();
        Assert.assertEquals((long)3L, (long)kSession.fireAllRules());
        NamedEntryPoint nep = (NamedEntryPoint)kSession.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId());
        ObjectTypeNode otn = (ObjectTypeNode)nep.getEntryPointNode().getObjectTypeNodes().get(new ClassObjectType(Entity.class));
        Assert.assertNotNull((Object)otn);
        Assert.assertEquals((long)1L, (long)otn.getObjectSinkPropagator().getSinks().length);
    }

    @Test
    public void testPartitionWithSiblingsOnDelete() {
        String drl = "import " + Entity.class.getName() + ";global java.util.List list; declare trait A @propertyReactive end declare trait B extends A @propertyReactive end declare trait C extends A @propertyReactive end rule Trait when     $core: Entity( ) then     don( $core, A.class );     don( $core, B.class );     don( $core, C.class ); end rule Shed when    $s: String()    $core : Entity() then    shed( $core, C.class ); end rule RA when A() then list.add( 'A' ); end rule RB when B() then list.add( 'B' ); end rule RC when C() then list.add( 'C' ); end  ";
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Entity e = new Entity();
        ksession.insert((Object)e);
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C')), list);
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        Set<BitSet> s = this.checkOTNPartitioning((TraitableBean)e, ksession);
        Assert.assertEquals((long)2L, (long)s.size());
        Assert.assertEquals(Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C')), list);
    }

    @Test
    public void testTupleIntegrityOnModification() {
        String drl = "package test import " + Entity.class.getName() + ";global java.util.List list; declare trait A @propertyReactive value : int end rule Trait when     $core: Entity( ) then     A o = don( $core, A.class );     System.out.println( 'Found ! ' + o ); end rule Test when    $x: A( value == 0 ) then    list.add( 0 ); end rule Check when    $x: A( value == 42 ) then    list.add( 42 ); end rule Mood when   $x : A( value != 42 ) then   modify ( $x ) { setValue( 42 ); } end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Entity());
        ksession.fireAllRules();
        for (Object o : ksession.getObjects((ObjectFilter)new org.drools.core.ObjectFilter(){

            public boolean accept(Object object) {
                return object.getClass().getName().contains("test.A");
            }
        })) {
            InternalFactHandle handle = (InternalFactHandle)ksession.getFactHandle(o);
            LeftTuple first = handle.getFirstLeftTuple();
            Assert.assertTrue((boolean)(first instanceof RuleTerminalNodeLeftTuple));
            Assert.assertEquals((Object)"Check", (Object)((RuleTerminalNodeLeftTuple)first).getRule().getName());
        }
        Assert.assertEquals(Arrays.asList(0, 42), list);
    }

    @Test
    public void testShedVacancy() {
        String drl = "package org.drools.test import " + Entity.class.getName() + ";global java.util.List list; declare trait A @propertyReactive end declare trait B @propertyReactive end declare trait C extends A,B @propertyReactive end declare trait D extends B @propertyReactive end rule Trait when then     Entity e = new Entity( 'x1' );     don( e, C.class );     don( e, D.class ); end rule Mood when   $x : B() then   System.out.println( 'Found B' ); end rule Shed when   $s : String()   $x : Entity() then   delete( $s );   shed( $x, A.class ); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HierarchyEncoder hier = ((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry((RuleBase)((InternalKnowledgeBase)kbase)).getHierarchy();
        BitSet a = (BitSet)hier.getCode((Object)"org.drools.test.A").clone();
        BitSet b = (BitSet)hier.getCode((Object)"org.drools.test.B").clone();
        BitSet c = (BitSet)hier.getCode((Object)"org.drools.test.C").clone();
        BitSet d = (BitSet)hier.getCode((Object)"org.drools.test.D").clone();
        int n = ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)n);
        System.err.print("---------------------------------------------------------------\n\n\n ");
        int counter = 0;
        for (Object o : ksession.getObjects()) {
            if (o instanceof TraitProxyImpl) {
                TraitProxyImpl tp = (TraitProxyImpl)o;
                if (tp._getTypeCode().equals(c)) {
                    Assert.assertEquals((long)1L, (long)tp.listAssignedOtnTypeCodes().size());
                    Assert.assertTrue((boolean)tp.listAssignedOtnTypeCodes().contains(b));
                    ++counter;
                    continue;
                }
                if (!tp._getTypeCode().equals(d)) continue;
                Assert.assertTrue((boolean)tp.listAssignedOtnTypeCodes().isEmpty());
                ++counter;
                continue;
            }
            if (!(o instanceof TraitableBean)) continue;
            TraitableBean tb = (TraitableBean)o;
            System.out.println(tb.getCurrentTypeCode());
            ++counter;
        }
        Assert.assertEquals((long)3L, (long)counter);
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        System.err.print("---------------------------------------------------------------\n\n\n ");
        int counter2 = 0;
        for (Object o : ksession.getObjects()) {
            if (o instanceof TraitProxyImpl) {
                TraitProxyImpl tp = (TraitProxyImpl)o;
                Assert.assertEquals((Object)d, (Object)tp._getTypeCode());
                Assert.assertEquals((long)1L, (long)tp.listAssignedOtnTypeCodes().size());
                Assert.assertTrue((boolean)tp.listAssignedOtnTypeCodes().contains(b));
                ++counter2;
                continue;
            }
            if (!(o instanceof TraitableBean)) continue;
            TraitableBean tb = (TraitableBean)o;
            Assert.assertEquals((Object)d, (Object)tb.getCurrentTypeCode());
            ++counter2;
        }
        Assert.assertEquals((long)2L, (long)counter2);
    }

    @Test
    public void testExternalUpdateWithProxyRefreshInEqualityMode() {
        String drl = "package org.drools.trait.test; import " + ExtEntity.class.getCanonicalName() + "; global " + List.class.getName() + " list; declare trait Mask   id  : String   num : int end rule Don when   $x : ExtEntity( $id : id ) then   list.add( $id );   don( $x, Mask.class ); end rule Test when   Mask( $n : num ) then   list.add( $n ); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[]{EqualityBehaviorOption.EQUALITY});
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle handle = ksession.insert((Object)new ExtEntity("x1", 42));
        ksession.fireAllRules();
        ksession.update(handle, (Object)new ExtEntity("x1", 35));
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList("x1", 42, "x1", 42), list);
    }

    @Test
    public void testIsAInstanceOf() {
        String drl = "package org.drools.test; import " + StudentImpl.class.getName() + "; import " + IStudent.class.getName() + "; global java.util.List list; rule Test1 when   StudentImpl( this isA IStudent.class ) then list.add( 1 ); end rule Test2 when   IStudent( this isA StudentImpl.class ) then list.add( 2 ); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)new StudentImpl());
        Assert.assertEquals((long)2L, (long)knowledgeSession.fireAllRules());
        Assert.assertEquals(Arrays.asList(1, 2), list);
    }

    @Test
    public void testIsAInstanceOfNonTraitable() {
        String drl = "package org.drools.test; global java.util.List list; rule Test1 when   Object( this isA String.class ) then list.add( 1 ); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)"hello");
        Assert.assertEquals((long)1L, (long)knowledgeSession.fireAllRules());
        Assert.assertEquals(Arrays.asList(1), list);
    }

    protected Set<BitSet> checkOTNPartitioning(TraitableBean core, KieSession wm) {
        HashSet<BitSet> otns = new HashSet<BitSet>();
        for (Object o : core._getTraitMap().values()) {
            TraitProxyImpl tp = (TraitProxyImpl)o;
            Set localNodes = tp.listAssignedOtnTypeCodes();
            for (BitSet code : localNodes) {
                Assert.assertFalse((boolean)otns.contains(code));
                otns.add(code);
            }
        }
        return otns;
    }

    @Test
    public void testSerializeKieBaseWithTraits() {
        String drl = "package org.drools.test; import " + StudentImpl.class.getName() + "; import " + IStudent.class.getName() + "; global java.util.List list; rule Test1 when   StudentImpl( this isA IStudent.class ) then list.add( 1 ); end rule Test2 when   IStudent( this isA StudentImpl.class ) then list.add( 2 ); end ";
        KieBase kbase = this.getKieBaseFromString(drl, new KieBaseOption[0]);
        ArrayList list = new ArrayList();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kbase);
        KieSession knowledgeSession = kbase.newKieSession();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)new StudentImpl());
        Assert.assertEquals((long)2L, (long)knowledgeSession.fireAllRules());
        Assert.assertEquals(Arrays.asList(1, 2), list);
    }

    @Test
    public void testMixin2() {
        String drl = "package org.drools.test.traits\nimport " + Scholar.class.getCanonicalName() + ";\nimport " + ScholarImpl.class.getCanonicalName() + ";\n\n\ndeclare Person\n    @Traitable\n    name    : String       = \"john\"     @key\n    age     : int          = 18\n    weight  : Double       = 75.4\nend\n\ndeclare Scholar end\n\ndeclare trait Student extends Scholar\n    name    : String\n    age     : int\n    weight  : Double\n    school  : String\nend\n\n\nrule \"Zero\"\nwhen\nthen\n    insert( new Person() );\nend\n\n\nrule \"Student\"\nno-loop\nwhen\n    $p : Person( $name : name, $age : age < 25, $weight : weight )\nthen\n    Student s = don( $p, Student.class );\n        s.setSchool( \"SomeSchool\" );\n        s.learn( \" AI \" );\nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ks.fireAllRules();
    }

    @Test
    public void testMixinWithConflictsUsingDeclarationOrder() {
        this.checkMixinResolutionUsesOrder("Y,Z", "Y");
        this.checkMixinResolutionUsesOrder("Z,Y", "Z");
    }

    private void checkMixinResolutionUsesOrder(String interfaces, String first) {
        String drl = "package org.drools.test.traits\nimport " + Y.class.getCanonicalName() + ";\nimport " + Z.class.getCanonicalName() + ";\n\nglobal java.util.List list;\ndeclare Bean\n    @Traitable\n    name    : String       = \"xxx\"     @key\nend\n\n\ndeclare X extends " + interfaces + " @Trait( mixinSolveConflicts = Trait.MixinConflictResolutionStrategy.DECLARATION_ORDER ) end\n\nrule Init when\nthen\n    insert( new Bean() );\nend\n\nrule Exec no-loop when\n    $b : Bean()\nthen\n    X x = don( $b, X.class );\n    list.add( x.getYValue() );\n    list.add( x.getZValue() );\n    list.add( x.getShared() );\nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((Object)"Y", list.get(0));
        Assert.assertEquals((Object)"Z", list.get(1));
        Assert.assertEquals((Object)first, list.get(2));
    }

    @Test
    public void testMixinWithConflictsThrowingError() {
        String drl = "package org.drools.test.traits\nimport " + Y.class.getCanonicalName() + ";\nimport " + Z.class.getCanonicalName() + ";\n\nglobal java.util.List list;\ndeclare Bean\n    @Traitable\n    name    : String       = \"xxx\"     @key\nend\n\n\ndeclare X extends Y,Z @Trait( mixinSolveConflicts = Trait.MixinConflictResolutionStrategy.ERROR_ON_CONFLICT ) end\n\nrule Init when\nthen\n    insert( new Bean() );\nend\n\nrule Exec no-loop when\n    $b : Bean()\nthen\n    X x = don( $b, X.class );\n    list.add( x.getYValue() );\n    list.add( x.getZValue() );\n    list.add( x.getShared() );\nend\n";
        KieSession ks = this.getSessionFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        try {
            ks.fireAllRules();
            Assert.fail((String)"don should fail due to the conflict in getShared() method");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPreserveAllSetBitMask() {
        String drl = "package t.x;\nimport " + Entity.class.getName() + "; declare trait MyThing end\ndeclare trait RootThing extends MyThing  objProp : java.util.List = new java.util.ArrayList() end declare trait F extends RootThing end\ndeclare trait D extends RootThing end\ndeclare trait E extends D end\nrule Init when\nthen  Entity e1 = new Entity( \"X\" );  insert( e1 );  Entity e2 = new Entity( \"Y\" );  insert( e2 );   D d1 = don( e1, D.class, true );  F f2 = don( e2, F.class, true );   modify ( d1 ) { getObjProp().add( f2.getCore() ); }  modify ( f2.getCore() ) {} end rule Rec no-loop when\n MyThing( $x_0 := core, this isA D.class, $p : this#RootThing.objProp )  exists MyThing( $x_1 := core , core memberOf $p, this isA F.class ) then  System.out.println( \"Recognized \" + $x_0 + \" as an instance of E by rule \" + drools.getRule().getName() );  don( $x_0, E.class, true ); end rule Shed_2 when\n $s : String( this == \"go2\")  $x : E( $objs : objProp )  $y : F( $z : core memberOf $objs ) then  retract( $s );  System.out.println( \"SUCCESS : E has been recognized, removing Y \" );  modify ( $x ) { getObjProp().remove( $z ); }  modify ( $y ) {} end ";
        KieHelper helper = new KieHelper();
        KieBase kieBase = helper.addContent(drl, ResourceType.DRL).getKieContainer().getKieBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kieBase);
        KieSession kSession = kieBase.newKieSession();
        kSession.fireAllRules();
        kSession.insert((Object)"go2");
        kSession.fireAllRules();
        for (Object o : kSession.getObjects((ObjectFilter)new ClassObjectFilter(Entity.class))) {
            Entity e = (Entity)o;
            if (e.getId().equals("X")) {
                Assert.assertTrue((boolean)e.hasTrait("t.x.D"));
                Assert.assertFalse((boolean)e.hasTrait("t.x.E"));
                Assert.assertFalse((boolean)e.hasTrait("t.x.F"));
                Assert.assertEquals((long)0L, (long)((List)e._getDynamicProperties().get("objProp")).size());
                continue;
            }
            if (e.getId().equals("Y")) {
                Assert.assertTrue((boolean)e.hasTrait("t.x.F"));
                Assert.assertFalse((boolean)e.hasTrait("t.x.D"));
                Assert.assertFalse((boolean)e.hasTrait("t.x.E"));
                continue;
            }
            Assert.fail((String)"Unrecognized entity in WM");
        }
    }

    public static class ZImpl
    implements Z {
        @Override
        public String getShared() {
            return "Z";
        }

        @Override
        public String getZValue() {
            return "Z";
        }
    }

    @Trait(impl=ZImpl.class)
    public static interface Z {
        public String getShared();

        public String getZValue();
    }

    public static class YImpl
    implements Y {
        @Override
        public String getShared() {
            return "Y";
        }

        @Override
        public String getYValue() {
            return "Y";
        }
    }

    @Trait(impl=YImpl.class)
    public static interface Y {
        public String getShared();

        public String getYValue();
    }

    public static class ScholarImpl<K>
    implements Scholar<K> {
        private Thing<K> core;

        public ScholarImpl() {
        }

        public ScholarImpl(Thing<K> arg) {
            this.core = arg;
        }

        @Override
        public void learn(String subject) {
            System.out.println("I " + this.core.getFields().get("name") + ", now know everything about " + subject);
        }
    }

    @Trait(impl=ScholarImpl.class)
    public static interface Scholar<K> {
        public void learn(String var1);
    }

    @Traitable
    @PropertyReactive
    public static class ExtEntity
    extends Entity {
        private int num;

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }

        public ExtEntity(String id, int num) {
            super(id);
            this.num = num;
        }
    }

    @Trait
    public static interface SomeTrait<K>
    extends Thing<K> {
        public String getFoo();

        public void setFoo(String var1);
    }

    public static class TraitRulesThread
    implements Runnable {
        int threadIndex;
        int numRepetitions;
        KieSession ksession;

        public TraitRulesThread(int threadIndex, int numRepetitions, KieSession ksession) {
            this.threadIndex = threadIndex;
            this.numRepetitions = numRepetitions;
            this.ksession = ksession;
        }

        @Override
        public void run() {
            for (int repetitionIndex = 0; repetitionIndex < this.numRepetitions; ++repetitionIndex) {
                Item i = new Item();
                i.setId(String.format("testId_%d%d", this.threadIndex, repetitionIndex));
                this.ksession.insert((Object)i);
                this.ksession.fireAllRules();
            }
        }
    }

    @Traitable
    public static class Item {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class CountingWorkingMemoryEventListener
    implements RuleRuntimeEventListener {
        private int inserts = 0;
        private int updates = 0;
        private int deletes = 0;

        public int getInserts() {
            return this.inserts;
        }

        public int getUpdates() {
            return this.updates;
        }

        public int getdeletes() {
            return this.deletes;
        }

        public void objectInserted(ObjectInsertedEvent event) {
            if (!(event.getObject() instanceof String)) {
                ++this.inserts;
            }
        }

        public void objectUpdated(ObjectUpdatedEvent event) {
            if (!(event.getObject() instanceof String)) {
                ++this.updates;
            }
        }

        public void objectDeleted(ObjectDeletedEvent objectdeleteedEvent) {
            if (!(objectdeleteedEvent.getOldObject() instanceof String)) {
                ++this.deletes;
            }
        }

        public void reset() {
            this.inserts = 0;
            this.deletes = 0;
            this.updates = 0;
        }
    }

    @Traitable
    public static class XYZ
    extends TraitableFoo {
        public XYZ() {
            super(null, 0, null);
        }
    }

    @Traitable
    public static class TraitableFoo {
        private String id;

        public TraitableFoo(String id, int x, Object k) {
            this.setId(id);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static interface IntfParent {
    }

    public static class TBean {
        private String fld;

        public String getFld() {
            return this.fld;
        }

        public void setFld(String fld) {
            this.fld = fld;
        }

        public TBean(String fld) {
            this.fld = fld;
        }
    }
}

