/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.io.ByteArrayInputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.traits.core.factmodel.Fact;
import org.drools.traits.core.factmodel.Field;
import org.drools.traits.core.factmodel.Jenerator;
import org.junit.Assert;
import org.junit.Test;

public class JeneratorTest {
    @Test
    public void testRoundTrip() throws Exception {
        Fact f = new Fact();
        f.name = "Foobar";
        Field f1 = new Field();
        f1.name = "name";
        f1.type = "java.lang.String";
        f.fields.add(f1);
        Field f2 = new Field();
        f2.name = "age";
        f2.type = "java.lang.Integer";
        f.fields.add(f2);
        Fact f_ = new Fact();
        f_.name = "Baz";
        Field f1_ = new Field();
        f1_.name = "name";
        f1_.type = "java.lang.String";
        f_.fields.add(f1_);
        Jenerator jen = new Jenerator();
        byte[] data = jen.createJar(new Fact[]{f, f_}, "whee.waa");
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(data));
        JarEntry je = jis.getNextJarEntry();
        Assert.assertNotNull((Object)je);
        System.err.println(je.getName());
        Assert.assertEquals((Object)"factmodel.xml", (Object)je.getName());
        je = jis.getNextJarEntry();
        Assert.assertNotNull((Object)je);
        System.err.println(je.getName());
        Assert.assertEquals((Object)"whee/waa/Foobar.class", (Object)je.getName());
        je = jis.getNextJarEntry();
        Assert.assertNotNull((Object)je);
        System.err.println(je.getName());
        Assert.assertEquals((Object)"whee/waa/Baz.class", (Object)je.getName());
        Fact[] facts = jen.loadMetaModel(new JarInputStream(new ByteArrayInputStream(data)));
        Assert.assertEquals((long)2L, (long)facts.length);
        Assert.assertEquals((Object)"Foobar", (Object)facts[0].name);
        Assert.assertEquals((Object)"Baz", (Object)facts[1].name);
    }
}

