/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.factmodel.traits;

import org.assertj.core.api.Assertions;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.traits.compiler.factmodel.traits.IPerson;
import org.drools.traits.compiler.factmodel.traits.IStudent;
import org.drools.traits.compiler.factmodel.traits.Imp;
import org.drools.traits.compiler.factmodel.traits.TraitTestUtils;
import org.drools.traits.core.factmodel.Entity;
import org.drools.traits.core.factmodel.LogicalTypeInconsistencyException;
import org.drools.traits.core.util.StandaloneTraitFactory;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StandaloneTest {
    private StandaloneTraitFactory factory;

    @Before
    public void init() {
        ProjectClassLoader loader = ProjectClassLoader.createProjectClassLoader();
        this.factory = TraitTestUtils.createStandaloneTraitFactory();
    }

    @Test
    public void testThing() throws LogicalTypeInconsistencyException {
        Entity core = new Entity("x");
        Thing thing = this.factory.don((TraitableBean)core, Thing.class);
        Assertions.assertThat((Object)thing).isNotNull();
    }

    @Test
    public void testHierarchy() throws LogicalTypeInconsistencyException {
        Imp imp = new Imp();
        imp.setName("john doe");
        CoreWrapper core = this.factory.makeTraitable((Object)imp, Imp.class);
        IStudent student = (IStudent)this.factory.don((TraitableBean)core, IStudent.class);
        System.out.println(student.getName());
        System.out.println(student.getSchool());
        Assert.assertEquals((Object)"john doe", (Object)student.getName());
        Assert.assertNull((Object)student.getSchool());
        IPerson p = (IPerson)this.factory.don((TraitableBean)core, IPerson.class);
        student.setName("alan ford");
        System.out.println(p.getName());
        Assert.assertEquals((Object)"alan ford", (Object)p.getName());
    }

    @Test
    public void testLegacy() throws LogicalTypeInconsistencyException {
        Imp imp = new Imp();
        imp.setName("john doe");
        CoreWrapper core = this.factory.makeTraitable((Object)imp, Imp.class);
        IFoo foo = (IFoo)this.factory.don((TraitableBean)core, IFoo.class);
        System.out.println(foo.getName());
        System.out.println(foo instanceof Thing);
        Assert.assertEquals((Object)"john doe", (Object)foo.getName());
        Assert.assertTrue((boolean)(foo instanceof Thing));
    }

    @Trait
    public static interface IFoo {
        public String getName();

        public void setName(String var1);
    }
}

