/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.traits.core.factmodel.Triple;
import org.drools.traits.core.factmodel.TripleImpl;
import org.drools.traits.core.factmodel.TripleStore;
import org.junit.Test;
import org.kie.api.runtime.rule.Variable;

public class TripleStoreTest {
    private Variable V = Variable.v;

    @Test
    public void testPutAndGet() {
        TripleStore store = new TripleStore(1000000, 0.6f);
        Individual ind = new Individual();
        TripleImpl t = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assertions.assertThat((boolean)store.put((Triple)t)).isFalse();
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        t = store.get((Triple)tKey);
        Assertions.assertThat((Object)t.getValue()).isEqualTo((Object)"mark");
    }

    @Test
    public void testPutAndGetWithExisting() {
        TripleStore store = new TripleStore(1000000, 0.6f);
        Individual ind = new Individual();
        TripleImpl t = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assertions.assertThat((boolean)store.put((Triple)t)).isFalse();
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        t = store.get((Triple)tKey);
        Assertions.assertThat((Object)t.getValue()).isEqualTo((Object)"mark");
        t = new TripleImpl((Object)ind, "hasName", (Object)"davide");
        Assertions.assertThat((boolean)store.put((Triple)t)).isTrue();
        tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        t = store.get((Triple)tKey);
        Assertions.assertThat((Object)t.getValue()).isEqualTo((Object)"davide");
    }

    @Test
    public void testPutAndGetandRemove() {
        TripleStore store = new TripleStore(1000000, 0.6f);
        Individual ind = new Individual();
        TripleImpl t = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assertions.assertThat((boolean)store.put((Triple)t)).isFalse();
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        t = store.get((Triple)tKey);
        Assertions.assertThat((Object)t.getValue()).isEqualTo((Object)"mark");
        t = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        Assertions.assertThat((int)store.removeAll((Triple)t)).isEqualTo(1);
        Assertions.assertThat((boolean)store.remove((Triple)t)).isFalse();
        tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        Assertions.assertThat((Object)store.get((Triple)tKey)).isNull();
    }

    @Test
    public void testMassAddRemove() {
        int i;
        TripleStore store = new TripleStore();
        int instanceLength = 30000;
        int tripleLength = 70;
        TripleImpl t = null;
        ArrayList<Individual> inds = new ArrayList<Individual>(instanceLength);
        for (i = 0; i < instanceLength; ++i) {
            Individual ind = new Individual();
            inds.add(ind);
            for (int j = 0; j < tripleLength; ++j) {
                t = new TripleImpl((Object)ind, this.getPropertyName(j), (Object)(i * j));
                Assertions.assertThat((boolean)store.put((Triple)t)).isFalse();
            }
        }
        Assertions.assertThat((int)store.size()).isEqualTo(instanceLength * tripleLength);
        for (i = 0; i < instanceLength; ++i) {
            for (int j = 0; j < tripleLength; ++j) {
                t = new TripleImpl(inds.get(i), this.getPropertyName(j), (Object)this.V);
                store.removeAll((Triple)t);
            }
        }
        Assertions.assertThat((int)store.size()).isEqualTo(0);
    }

    public String getPropertyName(int i) {
        char c1 = (char)(65 + i / 3);
        char c2 = (char)(97 + i / 3);
        return c1 + "bl" + i + "" + c2 + "blah";
    }

    @Test
    public void testQueryVariable() {
        TripleStore store = new TripleStore(1000000, 0.6f);
        Individual ind = new Individual();
        TripleImpl t1 = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assertions.assertThat((boolean)store.put((Triple)t1)).isFalse();
        TripleImpl t2 = new TripleImpl((Object)ind, "hasAge", (Object)"35");
        Assertions.assertThat((boolean)store.put((Triple)t2)).isFalse();
        TripleImpl t3 = new TripleImpl((Object)ind, "hasCity", (Object)"london");
        Assertions.assertThat((boolean)store.put((Triple)t3)).isFalse();
        Individual ind2 = new Individual();
        TripleImpl t4 = new TripleImpl((Object)ind2, "hasCity", (Object)"bologna");
        Assertions.assertThat((boolean)store.put((Triple)t4)).isFalse();
        TripleImpl t5 = new TripleImpl((Object)ind2, "hasCar", (Object)"lancia");
        Assertions.assertThat((boolean)store.put((Triple)t5)).isFalse();
        TripleImpl t6 = new TripleImpl((Object)ind2, "hasWeapon", (Object)"lancia");
        Assertions.assertThat((boolean)store.put((Triple)t6)).isFalse();
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        Triple t = store.get((Triple)tKey);
        Assertions.assertThat((Object)t.getValue()).isEqualTo((Object)"mark");
        tKey = new TripleImpl((Object)ind2, "hasCity", (Object)this.V);
        t = store.get((Triple)tKey);
        Assertions.assertThat((Object)t.getValue()).isEqualTo((Object)"bologna");
        tKey = new TripleImpl((Object)ind, "hasCar", (Object)this.V);
        t = store.get((Triple)tKey);
        Assertions.assertThat((Object)t).isNull();
        tKey = new TripleImpl((Object)ind2, "hasCar", (Object)this.V);
        t = store.get((Triple)tKey);
        Assertions.assertThat((Object)t.getValue()).isEqualTo((Object)"lancia");
        tKey = new TripleImpl((Object)this.V, "hasCity", (Object)this.V);
        Collection coll = store.getAll((Triple)tKey);
        Assertions.assertThat((boolean)coll.containsAll(Arrays.asList(t3, t4))).isTrue();
        Assertions.assertThat((int)coll.size()).isEqualTo(2);
        tKey = new TripleImpl((Object)ind, (Object)this.V, (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assertions.assertThat((boolean)coll.containsAll(Arrays.asList(t1, t2, t3))).isTrue();
        Assertions.assertThat((int)coll.size()).isEqualTo(3);
        tKey = new TripleImpl((Object)ind2, (Object)this.V, (Object)"lancia");
        coll = store.getAll((Triple)tKey);
        Assertions.assertThat((boolean)coll.containsAll(Arrays.asList(t5, t6))).isTrue();
        Assertions.assertThat((int)coll.size()).isEqualTo(2);
        tKey = new TripleImpl((Object)this.V, (Object)this.V, (Object)"lancia");
        coll = store.getAll((Triple)tKey);
        Assertions.assertThat((boolean)coll.containsAll(Arrays.asList(t5, t6))).isTrue();
        Assertions.assertThat((int)coll.size()).isEqualTo(2);
        tKey = new TripleImpl((Object)this.V, (Object)this.V, (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assertions.assertThat((boolean)coll.containsAll(Arrays.asList(t1, t2, t3, t4, t5, t6))).isTrue();
        Assertions.assertThat((int)coll.size()).isEqualTo(6);
    }

    @Test
    public void testAddNary() {
        TripleStore store = new TripleStore(200, 0.6f);
        Individual ind = new Individual();
        TripleImpl t1 = new TripleImpl((Object)ind, "hasName", (Object)"marc");
        Assertions.assertThat((boolean)store.put((Triple)t1)).isFalse();
        TripleImpl t2 = new TripleImpl((Object)ind, "hasName", (Object)"mark");
        Assertions.assertThat((boolean)store.put((Triple)t2)).isTrue();
        TripleImpl t3 = new TripleImpl((Object)ind, "hasName", (Object)"daniel");
        store.add((Triple)t3);
        TripleImpl t4 = new TripleImpl((Object)ind, "hasCar", (Object)"mini");
        store.add((Triple)t4);
        TripleImpl t5 = new TripleImpl((Object)ind, "hasName", (Object)"oscar");
        store.add((Triple)t5);
        TripleImpl t6 = new TripleImpl((Object)ind, "hasCar", (Object)"ferrari");
        store.add((Triple)t6);
        TripleImpl tKey = new TripleImpl((Object)ind, "hasName", (Object)this.V);
        Collection coll = store.getAll((Triple)tKey);
        Assertions.assertThat((boolean)coll.containsAll(Arrays.asList(new TripleImpl((Object)ind, "hasName", (Object)"oscar"), new TripleImpl((Object)ind, "hasName", (Object)"mark"), new TripleImpl((Object)ind, "hasName", (Object)"daniel")))).isTrue();
        Assertions.assertThat((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"marc"))).isFalse();
        Assertions.assertThat((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"mark"))).isTrue();
        Assertions.assertThat((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"daniel"))).isTrue();
        Assertions.assertThat((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasCar", (Object)"mini"))).isTrue();
        Assertions.assertThat((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"oscar"))).isTrue();
        Assertions.assertThat((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasCar", (Object)"ferrari"))).isTrue();
        Assertions.assertThat((boolean)store.contains((Triple)new TripleImpl((Object)ind, "hasName", (Object)"oscar"))).isTrue();
        tKey = new TripleImpl((Object)ind, "hasCar", (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assertions.assertThat((boolean)coll.containsAll(Arrays.asList(new TripleImpl((Object)ind, "hasCar", (Object)"mini"), new TripleImpl((Object)ind, "hasCar", (Object)"ferrari")))).isTrue();
        store.remove((Triple)new TripleImpl((Object)ind, "hasCar", (Object)"mini"));
        tKey = new TripleImpl((Object)ind, "hasCar", (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assertions.assertThat((int)coll.size()).isEqualTo(1);
        store.remove((Triple)new TripleImpl((Object)ind, "hasCar", (Object)"ferrari"));
        tKey = new TripleImpl((Object)ind, "hasCar", (Object)this.V);
        coll = store.getAll((Triple)tKey);
        Assertions.assertThat((int)coll.size()).isEqualTo(0);
    }

    public static class Individual {
    }
}

