/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.util.Calendar;
import java.util.Date;
import org.drools.compiler.builder.impl.classbuilder.ClassBuilder;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.traits.core.factmodel.TraitClassBuilderFactory;
import org.drools.util.ClassUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.drools.wiring.dynamic.PackageClassLoader;
import org.junit.Test;

public class InstancesHashcodedTest {
    private Class build(ClassBuilder builder, ClassDefinition classDef) throws Exception {
        ProjectClassLoader prjClassLoader = ProjectClassLoader.createProjectClassLoader();
        byte[] d = builder.buildClass(classDef, (ClassLoader)prjClassLoader);
        JavaDialectRuntimeData data = new JavaDialectRuntimeData();
        data.write(ClassUtils.convertClassToResourcePath((String)classDef.getClassName()), d);
        PackageClassLoader classLoader = new PackageClassLoader(data.getStore(), (ClassLoader)prjClassLoader);
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache((ClassLoader)classLoader));
        store.setEagerWire(true);
        Class<?> clazz = classLoader.loadClass(classDef.getClassName());
        classDef.setDefinedClass(clazz);
        return clazz;
    }

    @Test
    public void testInstanceHashcodes() {
        ClassDefinition cd = new ClassDefinition("br.com.auster.TestClass2", null, new String[0]);
        cd.addField(new FieldDefinition("cutDate", "java.util.Date", true));
        cd.addField(new FieldDefinition("dueDate", "java.util.Date", true));
        cd.addField(new FieldDefinition("issueDate", "java.util.Date", false));
        cd.addField(new FieldDefinition("cycleCode", "java.lang.String", false));
        ClassBuilder cb = new TraitClassBuilderFactory().getBeanClassBuilder();
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2006);
        cal.set(2, 5);
        cal.set(5, 1);
        Date cut = cal.getTime();
        cal.set(2, 6);
        cal.set(5, 13);
        Date d1 = cal.getTime();
        cal.set(5, 15);
        Date d2 = cal.getTime();
        try {
            Class klass = this.build(cb, cd);
            Object o1 = klass.newInstance();
            cd.getField("cutDate").getFieldAccessor().setValue(o1, (Object)cut);
            cd.getField("dueDate").getFieldAccessor().setValue(o1, (Object)d1);
            Object o2 = klass.newInstance();
            cd.getField("cutDate").getFieldAccessor().setValue(o2, (Object)cut);
            cd.getField("dueDate").getFieldAccessor().setValue(o2, (Object)d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

