/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.traits.core.factmodel.HierarchyEncoder;
import org.drools.traits.core.factmodel.IndexedTypeHierarchy;
import org.drools.traits.core.util.HierarchyEncoderImpl;
import org.junit.Test;

public class HierarchyTest {
    @Test
    public void testHierEncoderTrivial() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("B"));
        encoder.encode((Object)"D", Arrays.asList("B", "C"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("11"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("111"));
    }

    @Test
    public void testHierManyRoots() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"C", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"D", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"E", (Collection)Collections.EMPTY_LIST);
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"E")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((int)encoder.size()).isEqualTo(5);
        Assertions.assertThat((int)encoder.getSortedMembers().size()).isEqualTo(5);
        Assertions.assertThat((int)encoder.getSortedMap().size()).isEqualTo(5);
    }

    @Test
    public void testHierManyRootsPropagation() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("B", "C"));
        encoder.encode((Object)"E", (Collection)Collections.EMPTY_LIST);
        System.out.println(encoder);
        BitSet a = encoder.getCode((Object)"A");
        BitSet b = encoder.getCode((Object)"B");
        BitSet c = encoder.getCode((Object)"C");
        BitSet d = encoder.getCode((Object)"D");
        BitSet e = encoder.getCode((Object)"E");
        Assertions.assertThat((encoder.superset(b, a) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(c, a) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(d, a) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(d, b) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(d, c) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(e, a) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(e, b) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(e, c) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(e, d) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(e, e) == 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testHierALotOfClasses() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        int N = 1194;
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        for (int j = 1; j < N; ++j) {
            encoder.encode((Object)("X" + j), Arrays.asList("A"));
        }
        Assertions.assertThat((int)encoder.size()).isEqualTo(N);
        BitSet code = encoder.getCode((Object)("X" + (N - 1)));
        Assertions.assertThat((int)code.cardinality()).isEqualTo(1);
        Assertions.assertThat((boolean)code.get(N - 2)).isTrue();
    }

    @Test
    public void testHierEncoderSimpleInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("B"));
        encoder.encode((Object)"E", Arrays.asList("B"));
        encoder.encode((Object)"F", Arrays.asList("C"));
        encoder.encode((Object)"G", Arrays.asList("C"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"E")).isEqualTo((Object)this.parseBitSet("1001"));
        Assertions.assertThat((Object)encoder.getCode((Object)"F")).isEqualTo((Object)this.parseBitSet("110"));
        Assertions.assertThat((Object)encoder.getCode((Object)"G")).isEqualTo((Object)this.parseBitSet("1010"));
    }

    @Test
    public void testHierEncoderAnotherSimpleInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("11000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("101000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("110000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B7")).isEqualTo((Object)this.parseBitSet("111000"));
    }

    @Test
    public void testHierEncoderAnotherSimpleInheritanceChangeOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("11"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("110"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B7")).isEqualTo((Object)this.parseBitSet("111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100000"));
    }

    @Test
    public void testHierEncoderBipartiteInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B1", "B2", "B3"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("10111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("1111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("100111000"));
    }

    @Test
    public void testHierEncoderBipartiteInheritanceDiffOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B1", "B2", "B3"));
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("10111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("1111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("100111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100000000"));
    }

    @Test
    public void testSquare() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"T", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("T"));
        encoder.encode((Object)"B", Arrays.asList("T"));
        encoder.encode((Object)"C", Arrays.asList("A", "B"));
        encoder.encode((Object)"D", Arrays.asList("A", "B"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"T")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("1011"));
    }

    @Test
    public void testConflictArising() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("B"));
        encoder.encode((Object)"E", Arrays.asList("B"));
        encoder.encode((Object)"F", Arrays.asList("C"));
        encoder.encode((Object)"G", Arrays.asList("C"));
        encoder.encode((Object)"H", Arrays.asList("E"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"E")).isEqualTo((Object)this.parseBitSet("1001"));
        Assertions.assertThat((Object)encoder.getCode((Object)"F")).isEqualTo((Object)this.parseBitSet("110"));
        Assertions.assertThat((Object)encoder.getCode((Object)"G")).isEqualTo((Object)this.parseBitSet("1010"));
        Assertions.assertThat((Object)encoder.getCode((Object)"H")).isEqualTo((Object)this.parseBitSet("11001"));
        encoder.encode((Object)"I", Arrays.asList("E", "F"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"A")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"C")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"D")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"E")).isEqualTo((Object)this.parseBitSet("1000001"));
        Assertions.assertThat((Object)encoder.getCode((Object)"F")).isEqualTo((Object)this.parseBitSet("100010"));
        Assertions.assertThat((Object)encoder.getCode((Object)"G")).isEqualTo((Object)this.parseBitSet("1010"));
        Assertions.assertThat((Object)encoder.getCode((Object)"H")).isEqualTo((Object)this.parseBitSet("1010001"));
        Assertions.assertThat((Object)encoder.getCode((Object)"I")).isEqualTo((Object)this.parseBitSet("1100011"));
        this.checkHier((HierarchyEncoder)encoder, 'I');
    }

    @Test
    public void testConflictArising2() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("B"));
        encoder.encode((Object)"E", Arrays.asList("B"));
        encoder.encode((Object)"F", Arrays.asList("C"));
        encoder.encode((Object)"G", Arrays.asList("C"));
        encoder.encode((Object)"H", Arrays.asList("E"));
        encoder.encode((Object)"J", Arrays.asList("F"));
        encoder.encode((Object)"K", Arrays.asList("J"));
        System.out.println(encoder);
        encoder.encode((Object)"I", Arrays.asList("E", "F"));
        System.out.println(encoder);
        this.checkHier((HierarchyEncoder)encoder, 'K');
    }

    @Test
    public void testHierEncoderBipartiteStarInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        encoder.encode((Object)"A4", Arrays.asList("A1", "A2", "A3"));
        encoder.encode((Object)"A5", Arrays.asList("A4"));
        encoder.encode((Object)"A6", Arrays.asList("A4"));
        encoder.encode((Object)"A7", Arrays.asList("A4"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("11"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("101"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("110"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B7")).isEqualTo((Object)this.parseBitSet("111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A4")).isEqualTo((Object)this.parseBitSet("111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A5")).isEqualTo((Object)this.parseBitSet("1111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A6")).isEqualTo((Object)this.parseBitSet("10111000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A7")).isEqualTo((Object)this.parseBitSet("100111000"));
    }

    @Test
    public void testHierEncoderBipartiteStarInheritanceDiffOrder() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"R", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A1", Arrays.asList("R"));
        encoder.encode((Object)"A2", Arrays.asList("R"));
        encoder.encode((Object)"A3", Arrays.asList("R"));
        encoder.encode((Object)"A4", Arrays.asList("A1", "A2", "A3"));
        encoder.encode((Object)"A5", Arrays.asList("A4"));
        encoder.encode((Object)"A6", Arrays.asList("A4"));
        encoder.encode((Object)"A7", Arrays.asList("A4"));
        encoder.encode((Object)"B1", Arrays.asList("R"));
        encoder.encode((Object)"B2", Arrays.asList("R"));
        encoder.encode((Object)"B3", Arrays.asList("R"));
        encoder.encode((Object)"B4", Arrays.asList("B1", "B2"));
        encoder.encode((Object)"B5", Arrays.asList("B1", "B3"));
        encoder.encode((Object)"B6", Arrays.asList("B2", "B3"));
        encoder.encode((Object)"B7", Arrays.asList("B4", "B5", "B6"));
        System.out.println(encoder);
        Assertions.assertThat((Object)encoder.getCode((Object)"R")).isEqualTo((Object)this.parseBitSet("0"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A1")).isEqualTo((Object)this.parseBitSet("1"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A2")).isEqualTo((Object)this.parseBitSet("10"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A3")).isEqualTo((Object)this.parseBitSet("100"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A4")).isEqualTo((Object)this.parseBitSet("111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A5")).isEqualTo((Object)this.parseBitSet("1111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A6")).isEqualTo((Object)this.parseBitSet("10111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"A7")).isEqualTo((Object)this.parseBitSet("100111"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B1")).isEqualTo((Object)this.parseBitSet("1000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B2")).isEqualTo((Object)this.parseBitSet("10000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B3")).isEqualTo((Object)this.parseBitSet("100000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B4")).isEqualTo((Object)this.parseBitSet("011000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B5")).isEqualTo((Object)this.parseBitSet("101000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B6")).isEqualTo((Object)this.parseBitSet("110000000"));
        Assertions.assertThat((Object)encoder.getCode((Object)"B7")).isEqualTo((Object)this.parseBitSet("111000000"));
    }

    private BitSet parseBitSet(String s) {
        BitSet b = new BitSet();
        int n = s.length();
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) != '1') continue;
            b.set(n - j - 1);
        }
        return b;
    }

    @Test
    public void testHierEncoderComplexInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        this.checkHier((HierarchyEncoder)encoder, 'A');
        encoder.encode((Object)"B", Arrays.asList("A"));
        this.checkHier((HierarchyEncoder)encoder, 'B');
        encoder.encode((Object)"C", Arrays.asList("A"));
        this.checkHier((HierarchyEncoder)encoder, 'C');
        encoder.encode((Object)"D", Arrays.asList("B"));
        this.checkHier((HierarchyEncoder)encoder, 'D');
        encoder.encode((Object)"E", Arrays.asList("B"));
        this.checkHier((HierarchyEncoder)encoder, 'E');
        encoder.encode((Object)"F", Arrays.asList("C"));
        this.checkHier((HierarchyEncoder)encoder, 'F');
        encoder.encode((Object)"G", Arrays.asList("C"));
        this.checkHier((HierarchyEncoder)encoder, 'G');
        encoder.encode((Object)"H", Arrays.asList("D"));
        this.checkHier((HierarchyEncoder)encoder, 'H');
        encoder.encode((Object)"I", Arrays.asList("D"));
        this.checkHier((HierarchyEncoder)encoder, 'I');
        encoder.encode((Object)"J", Arrays.asList("E", "F"));
        this.checkHier((HierarchyEncoder)encoder, 'J');
        encoder.encode((Object)"K", Arrays.asList("E", "F"));
        this.checkHier((HierarchyEncoder)encoder, 'K');
        encoder.encode((Object)"L", Arrays.asList("G"));
        this.checkHier((HierarchyEncoder)encoder, 'L');
        encoder.encode((Object)"M", Arrays.asList("G"));
        this.checkHier((HierarchyEncoder)encoder, 'M');
        encoder.encode((Object)"N", Arrays.asList("I", "L"));
        this.checkHier((HierarchyEncoder)encoder, 'N');
        encoder.encode((Object)"O", Arrays.asList("H", "M"));
        this.checkHier((HierarchyEncoder)encoder, 'O');
        System.out.println(encoder);
        Collection codes = encoder.getSortedMap().values();
        Iterator iter = codes.iterator();
        Long last = -1L;
        for (int j = 0; j < codes.size() - 1; ++j) {
            BitSet ns = (BitSet)iter.next();
            Long next = this.toLong(ns);
            System.out.println(next);
            Assertions.assertThat((next > last ? 1 : 0) != 0).isTrue();
            last = next;
        }
    }

    private Long toLong(BitSet ns) {
        Long l = 0L;
        for (int j = 0; j < ns.length(); ++j) {
            if (!ns.get(j)) continue;
            l = l + (long)(1 << j);
        }
        return l;
    }

    private void checkHier(HierarchyEncoder encoder, char fin) {
        int j;
        ArrayList[] sups = new ArrayList[fin - 65 + 1];
        for (j = 65; j <= fin; ++j) {
            sups[j - 65] = ((HierarchyEncoderImpl)encoder).ancestorValues((Object)("" + (char)j));
        }
        for (j = 65; j < 65 + sups.length; ++j) {
            for (int k = 65; k < 65 + sups.length; ++k) {
                String x = "" + (char)j;
                String y = "" + (char)k;
                BitSet xcode = encoder.getCode((Object)x);
                BitSet ycode = encoder.getCode((Object)y);
                int subOf = ((HierarchyEncoderImpl)encoder).superset(xcode, ycode);
                if (x.equals(y)) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)subOf).as(x + " vs " + y, new Object[0])).isEqualTo(0);
                    continue;
                }
                if (sups[j - 65].contains(y)) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)subOf).as(x + " vs " + y, new Object[0])).isEqualTo(1);
                    continue;
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)subOf).as(x + " vs " + y, new Object[0])).isEqualTo(-1);
            }
        }
    }

    @Test
    public void testHierEncoderMoreInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("A"));
        encoder.encode((Object)"E", Arrays.asList("B"));
        encoder.encode((Object)"F", Arrays.asList("C"));
        encoder.encode((Object)"G", Arrays.asList("D"));
        encoder.encode((Object)"H", Arrays.asList("D"));
        encoder.encode((Object)"I", Arrays.asList("E"));
        encoder.encode((Object)"J", Arrays.asList("F"));
        encoder.encode((Object)"K", Arrays.asList("G"));
        encoder.encode((Object)"L", Arrays.asList("I", "J"));
        List[] sups = new List[]{encoder.ancestorValues((Object)"A"), encoder.ancestorValues((Object)"B"), encoder.ancestorValues((Object)"C"), encoder.ancestorValues((Object)"D"), encoder.ancestorValues((Object)"E"), encoder.ancestorValues((Object)"F"), encoder.ancestorValues((Object)"G"), encoder.ancestorValues((Object)"H"), encoder.ancestorValues((Object)"I"), encoder.ancestorValues((Object)"J"), encoder.ancestorValues((Object)"K"), encoder.ancestorValues((Object)"L")};
        for (int j = 65; j <= 76; ++j) {
            for (int k = 65; k <= 76; ++k) {
                String x = "" + (char)j;
                String y = "" + (char)k;
                BitSet xcode = encoder.getCode((Object)x);
                BitSet ycode = encoder.getCode((Object)y);
                int subOf = encoder.superset(xcode, ycode);
                if (x.equals(y)) {
                    Assertions.assertThat((int)subOf).isEqualTo(0);
                    continue;
                }
                if (sups[j - 65].contains(y)) {
                    Assertions.assertThat((int)subOf).isEqualTo(1);
                    continue;
                }
                Assertions.assertThat((int)subOf).isEqualTo(-1);
            }
        }
    }

    @Test
    public void testSecondOrderInheritance() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"T", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("T"));
        encoder.encode((Object)"B", Arrays.asList("T"));
        encoder.encode((Object)"C", Arrays.asList("T"));
        encoder.encode((Object)"D", Arrays.asList("C"));
        encoder.encode((Object)"F", Arrays.asList("B", "C"));
        System.out.println(encoder);
        encoder.encode((Object)"Z", Arrays.asList("A", "B", "D"));
        System.out.println(encoder);
        Assertions.assertThat((encoder.superset(encoder.getCode((Object)"Z"), encoder.getCode((Object)"F")) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((encoder.superset(encoder.getCode((Object)"F"), encoder.getCode((Object)"Z")) < 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testDecoderAncestors() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("Thing"));
        encoder.encode((Object)"Z", Arrays.asList("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", Arrays.asList("Thing"));
        encoder.encode((Object)"Q", Arrays.asList("Thing"));
        encoder.encode((Object)"R", Arrays.asList("Thing"));
        encoder.encode((Object)"S", Arrays.asList("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        System.out.println(encoder);
        BitSet b = this.parseBitSet("1100111");
        Collection x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        Assertions.assertThat((boolean)x.contains("Q")).isTrue();
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        Assertions.assertThat((boolean)x.contains("R")).isTrue();
        Assertions.assertThat((boolean)x.contains("S")).isTrue();
        Assertions.assertThat((boolean)x.contains("M")).isTrue();
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        Assertions.assertThat((int)x.size()).isEqualTo(9);
        b = this.parseBitSet("100000");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("Q")).isTrue();
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        b = this.parseBitSet("1111");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(6);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        Assertions.assertThat((boolean)x.contains("B")).isTrue();
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        Assertions.assertThat((boolean)x.contains("N")).isTrue();
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        b = this.parseBitSet("111");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(4);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        b = this.parseBitSet("1");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        b = this.parseBitSet("10");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        b = this.parseBitSet("0");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        b = this.parseBitSet("1011");
        x = encoder.upperAncestors(b);
        System.out.println("ANC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(4);
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("B")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
    }

    @Test
    public void testDecoderDescendants() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("Thing"));
        encoder.encode((Object)"Z", Arrays.asList("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", Arrays.asList("Thing"));
        encoder.encode((Object)"Q", Arrays.asList("Thing"));
        encoder.encode((Object)"R", Arrays.asList("Thing"));
        encoder.encode((Object)"S", Arrays.asList("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        System.out.println(encoder);
        BitSet b = this.parseBitSet("111");
        Collection x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(3);
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        Assertions.assertThat((boolean)x.contains("N")).isTrue();
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        b = this.parseBitSet("10");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(5);
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        Assertions.assertThat((boolean)x.contains("N")).isTrue();
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        Assertions.assertThat((boolean)x.contains("B")).isTrue();
        b = this.parseBitSet("100000");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(4);
        Assertions.assertThat((boolean)x.contains("Q")).isTrue();
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        Assertions.assertThat((boolean)x.contains("M")).isTrue();
        Assertions.assertThat((boolean)x.contains("O")).isTrue();
        b = this.parseBitSet("100010");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        b = this.parseBitSet("1111");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("N")).isTrue();
        b = this.parseBitSet("1");
        x = encoder.lowerDescendants(b);
        System.out.println("DESC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(5);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("B")).isTrue();
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        Assertions.assertThat((boolean)x.contains("N")).isTrue();
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        System.out.println(" +*******************************+ ");
        x = encoder.lowerDescendants(new BitSet());
        System.out.println("DESC " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(13);
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
    }

    @Test
    public void testHierEncoderDecoderLower() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("Thing"));
        encoder.encode((Object)"Z", Arrays.asList("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", Arrays.asList("Thing"));
        encoder.encode((Object)"Q", Arrays.asList("Thing"));
        encoder.encode((Object)"R", Arrays.asList("Thing"));
        encoder.encode((Object)"S", Arrays.asList("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        System.out.println(encoder);
        Collection x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("B")));
        System.out.println("GCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("B")).isTrue();
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("B")));
        System.out.println("GCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("N")).isTrue();
        x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("Z", "Q")));
        System.out.println("GCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("Z", "Q")));
        System.out.println("GCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("A", "Z")));
        System.out.println("GCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("B")).isTrue();
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("A", "Z")));
        System.out.println("GCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("B")).isTrue();
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        x = encoder.lowerBorder(encoder.metMembersCode(Arrays.asList("Thing")));
        System.out.println("GCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        x = encoder.immediateChildren(encoder.metMembersCode(Arrays.asList("Thing")));
        System.out.println("GCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(5);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        Assertions.assertThat((boolean)x.contains("P")).isTrue();
        Assertions.assertThat((boolean)x.contains("Q")).isTrue();
        Assertions.assertThat((boolean)x.contains("R")).isTrue();
    }

    @Test
    public void testHierEncoderDecoderUpper() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"Thing", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"A", Arrays.asList("Thing"));
        encoder.encode((Object)"Z", Arrays.asList("Thing"));
        encoder.encode((Object)"B", Arrays.asList("A", "Z"));
        encoder.encode((Object)"C", Arrays.asList("A", "Z"));
        encoder.encode((Object)"N", Arrays.asList("B", "C"));
        encoder.encode((Object)"P", Arrays.asList("Thing"));
        encoder.encode((Object)"Q", Arrays.asList("Thing"));
        encoder.encode((Object)"R", Arrays.asList("Thing"));
        encoder.encode((Object)"S", Arrays.asList("R"));
        encoder.encode((Object)"T", Arrays.asList("C", "Q"));
        encoder.encode((Object)"M", Arrays.asList("R", "Q"));
        encoder.encode((Object)"O", Arrays.asList("M", "P"));
        System.out.println(encoder);
        Collection x = encoder.upperBorder(encoder.metMembersCode(Arrays.asList("B")));
        System.out.println("LCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("B")).isTrue();
        x = encoder.immediateParents(encoder.metMembersCode(Arrays.asList("B")));
        System.out.println("LCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        x = encoder.upperBorder(encoder.jointMembersCode(Arrays.asList("Z", "Q")));
        System.out.println("LCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        x = encoder.immediateParents(encoder.jointMembersCode(Arrays.asList("Z", "Q")));
        System.out.println("LCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("Thing")).isTrue();
        x = encoder.upperBorder(encoder.jointMembersCode(Arrays.asList("B", "C")));
        System.out.println("LCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        x = encoder.immediateParents(encoder.jointMembersCode(Arrays.asList("B", "C")));
        System.out.println("LCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("A")).isTrue();
        Assertions.assertThat((boolean)x.contains("Z")).isTrue();
        x = encoder.upperBorder(encoder.jointMembersCode(Arrays.asList("T")));
        System.out.println("LCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(1);
        Assertions.assertThat((boolean)x.contains("T")).isTrue();
        x = encoder.immediateParents(encoder.jointMembersCode(Arrays.asList("T")));
        System.out.println("LCS " + x);
        Assertions.assertThat((int)x.size()).isEqualTo(2);
        Assertions.assertThat((boolean)x.contains("C")).isTrue();
        Assertions.assertThat((boolean)x.contains("Q")).isTrue();
    }

    @Test
    public void testClassInstanceHierarchies() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        BitSet ak = encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        BitSet bk = encoder.encode((Object)"B", Arrays.asList("A"));
        BitSet ck = encoder.encode((Object)"C", Arrays.asList("A"));
        BitSet dk = encoder.encode((Object)"D", Arrays.asList("B"));
        BitSet ek = encoder.encode((Object)"E", Arrays.asList("B"));
        BitSet fk = encoder.encode((Object)"F", Arrays.asList("C"));
        BitSet gk = encoder.encode((Object)"G", Arrays.asList("C"));
        BitSet hk = encoder.encode((Object)"H", Arrays.asList("D"));
        BitSet ik = encoder.encode((Object)"I", Arrays.asList("D"));
        BitSet jk = encoder.encode((Object)"J", Arrays.asList("E", "F"));
        BitSet kk = encoder.encode((Object)"K", Arrays.asList("E", "F"));
        BitSet lk = encoder.encode((Object)"L", Arrays.asList("G"));
        BitSet mk = encoder.encode((Object)"M", Arrays.asList("G"));
        BitSet nk = encoder.encode((Object)"N", Arrays.asList("I", "L"));
        BitSet ok = encoder.encode((Object)"O", Arrays.asList("H", "M"));
        System.out.println(encoder);
        IndexedTypeHierarchy types = new IndexedTypeHierarchy((Object)"A", new BitSet(), (Object)"ZZZZ", encoder.getBottom());
        types.addMember((Object)"A", ak);
        types.addMember((Object)"c", ck);
        types.addMember((Object)"f", fk);
        types.addMember((Object)"j", jk);
        types.addMember((Object)"k", kk);
        types.addMember((Object)"n", nk);
        types.addMember((Object)"o", ok);
        types.addMember((Object)"h", hk);
        System.out.println(types);
        Assertions.assertThat((Collection)types.children((Object)"A")).isEqualTo(Arrays.asList("c", "h"));
        Assertions.assertThat((Collection)types.children((Object)"c")).isEqualTo(Arrays.asList("f", "n", "o"));
        Assertions.assertThat((Collection)types.children((Object)"f")).isEqualTo(Arrays.asList("j", "k"));
        Assertions.assertThat((Collection)types.children((Object)"j")).isEqualTo(Arrays.asList("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"k")).isEqualTo(Arrays.asList("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"n")).isEqualTo(Arrays.asList("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"o")).isEqualTo(Arrays.asList("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"h")).isEqualTo(Arrays.asList("o"));
        Assertions.assertThat((Collection)types.children((Object)"ZZZZ")).isEqualTo(Arrays.asList(new Object[0]));
        Assertions.assertThat((Collection)types.parents((Object)"a")).isEqualTo(Arrays.asList(new Object[0]));
        Assertions.assertThat((Collection)types.parents((Object)"c")).isEqualTo(Arrays.asList("A"));
        Assertions.assertThat((Collection)types.parents((Object)"f")).isEqualTo(Arrays.asList("c"));
        Assertions.assertThat((Collection)types.parents((Object)"j")).isEqualTo(Arrays.asList("f"));
        Assertions.assertThat((Collection)types.parents((Object)"k")).isEqualTo(Arrays.asList("f"));
        Assertions.assertThat((Collection)types.parents((Object)"n")).isEqualTo(Arrays.asList("c"));
        Assertions.assertThat((Collection)types.parents((Object)"o")).isEqualTo(Arrays.asList("c", "h"));
        Assertions.assertThat((Collection)types.parents((Object)"h")).isEqualTo(Arrays.asList("A"));
        Assertions.assertThat((Collection)types.parents((Object)"ZZZZ")).isEqualTo(Arrays.asList("j", "k", "n", "o"));
        BitSet pk = encoder.encode((Object)"P", Arrays.asList("O"));
        types.addMember((Object)"p", pk);
        System.out.println(types);
        Assertions.assertThat((Collection)types.parents((Object)"p")).isEqualTo(Arrays.asList("o"));
        Assertions.assertThat((Collection)types.parents((Object)"ZZZZ")).isEqualTo(Arrays.asList("j", "k", "n", "p"));
        Assertions.assertThat((Collection)types.children((Object)"p")).isEqualTo(Arrays.asList("ZZZZ"));
        types.removeMember((Object)"o");
        System.out.println(types);
        Assertions.assertThat((Collection)types.parents((Object)"p")).isEqualTo(Arrays.asList("c", "h"));
        Assertions.assertThat((Collection)types.children((Object)"c")).isEqualTo(Arrays.asList("f", "n", "p"));
        Assertions.assertThat((Collection)types.children((Object)"f")).isEqualTo(Arrays.asList("j", "k"));
        Assertions.assertThat((Collection)types.children((Object)"n")).isEqualTo(Arrays.asList("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"p")).isEqualTo(Arrays.asList("ZZZZ"));
        Assertions.assertThat((Collection)types.children((Object)"h")).isEqualTo(Arrays.asList("p"));
    }

    @Test
    public void testUnwantedCodeOverriding() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        BitSet ak = encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        BitSet ck = encoder.encode((Object)"C", Arrays.asList("A"));
        BitSet dk = encoder.encode((Object)"D", Arrays.asList("A"));
        BitSet gk = encoder.encode((Object)"G", Arrays.asList("C", "D"));
        BitSet bk = encoder.encode((Object)"B", Arrays.asList("A"));
        BitSet ek = encoder.encode((Object)"E", Arrays.asList("B"));
        BitSet ik = encoder.encode((Object)"I", Arrays.asList("E", "C"));
        BitSet fk = encoder.encode((Object)"F", Arrays.asList("B", "C"));
        BitSet jk = encoder.encode((Object)"J", Arrays.asList("F", "D"));
        BitSet lk = encoder.encode((Object)"L", Arrays.asList("J"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet ok = encoder.encode((Object)"O", Arrays.asList("L"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet kk = encoder.encode((Object)"K", Arrays.asList("F", "G"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet mk = encoder.encode((Object)"M", Arrays.asList("J", "K"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet nk = encoder.encode((Object)"N", Arrays.asList("K"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet hk = encoder.encode((Object)"H", Arrays.asList("F"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        BitSet pk = encoder.encode((Object)"P", Arrays.asList("A"));
        Assertions.assertThat((Object)encoder.getCode((Object)"L")).isNotNull();
        System.out.println(encoder);
        Assertions.assertThat((int)encoder.size()).isEqualTo(16);
    }

    @Test
    public void testDeepTree() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("A"));
        encoder.encode((Object)"D", Arrays.asList("C"));
        encoder.encode((Object)"E", Arrays.asList("D"));
        encoder.encode((Object)"F", Arrays.asList("D"));
        encoder.encode((Object)"G", Arrays.asList("C"));
        encoder.encode((Object)"H", Arrays.asList("G"));
        encoder.encode((Object)"I", Arrays.asList("G"));
        encoder.encode((Object)"J", Arrays.asList("C"));
        encoder.encode((Object)"K", Arrays.asList("C"));
        encoder.encode((Object)"L", Arrays.asList("B"));
        encoder.encode((Object)"M", Arrays.asList("B"));
        encoder.encode((Object)"N", Arrays.asList("A"));
        encoder.encode((Object)"O", Arrays.asList("N"));
        System.out.println(encoder);
        this.checkHier((HierarchyEncoder)encoder, 'O');
    }

    @Test
    public void testNestedTree() {
        HierarchyEncoderImpl encoder = new HierarchyEncoderImpl();
        encoder.encode((Object)"A", (Collection)Collections.EMPTY_LIST);
        encoder.encode((Object)"B", Arrays.asList("A"));
        encoder.encode((Object)"C", Arrays.asList("B"));
        encoder.encode((Object)"D", Arrays.asList("B"));
        encoder.encode((Object)"E", Arrays.asList("D"));
        encoder.encode((Object)"F", Arrays.asList("E"));
        encoder.encode((Object)"G", Arrays.asList("E"));
        encoder.encode((Object)"H", Arrays.asList("G"));
        encoder.encode((Object)"I", Arrays.asList("H"));
        encoder.encode((Object)"J", Arrays.asList("E"));
        encoder.encode((Object)"K", Arrays.asList("J"));
        encoder.encode((Object)"L", Arrays.asList("K"));
        encoder.encode((Object)"M", Arrays.asList("J"));
        encoder.encode((Object)"N", Arrays.asList("M"));
        encoder.encode((Object)"O", Arrays.asList("J"));
        encoder.encode((Object)"P", Arrays.asList("O"));
        encoder.encode((Object)"Q", Arrays.asList("J"));
        encoder.encode((Object)"R", Arrays.asList("Q"));
        encoder.encode((Object)"S", Arrays.asList("B"));
        encoder.encode((Object)"T", Arrays.asList("S"));
        encoder.encode((Object)"U", Arrays.asList("T"));
        encoder.encode((Object)"V", Arrays.asList("B"));
        encoder.encode((Object)"W", Arrays.asList("V"));
        encoder.encode((Object)"X", Arrays.asList("W"));
        System.out.println(encoder);
        encoder.encode((Object)"Y", Arrays.asList("F", "W"));
        System.out.println(encoder);
        this.checkHier((HierarchyEncoder)encoder, (char)(65 + encoder.size() - 1));
    }
}

