/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.drools.core.WorkingMemory;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.TraitHelper;
import org.drools.core.beliefsystem.Mode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitFieldTMS;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.util.bitmask.BitMask;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.traits.core.base.TraitUtils;
import org.drools.traits.core.factmodel.HierarchyEncoder;
import org.drools.traits.core.factmodel.LogicalTypeInconsistencyException;
import org.drools.traits.core.factmodel.TraitFactoryImpl;
import org.drools.traits.core.factmodel.TraitProxyImpl;
import org.drools.traits.core.factmodel.TraitRegistryImpl;
import org.drools.traits.core.factmodel.TraitTypeMapImpl;
import org.drools.traits.core.metadata.Metadatable;
import org.drools.traits.core.metadata.Modify;
import org.drools.traits.core.reteoo.TraitRuntimeComponentFactory;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraitHelperImpl
implements Externalizable,
TraitHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TraitHelperImpl.class);
    private InternalWorkingMemoryActions workingMemory;
    private InternalWorkingMemoryEntryPoint entryPoint;

    public TraitHelperImpl(InternalWorkingMemoryActions workingMemory, InternalWorkingMemoryEntryPoint nep) {
        this.workingMemory = workingMemory;
        this.entryPoint = nep;
    }

    public TraitHelperImpl() {
    }

    public <T, K> T don(InternalMatch internalMatch, K core, Collection<Class<? extends Thing>> traits, boolean logical, Mode ... modes) {
        if (core instanceof Thing && ((Thing)core).getCore() != core) {
            return this.don(internalMatch, ((Thing)core).getCore(), traits, logical, modes);
        }
        if (traits.isEmpty()) {
            return (T)this.don(internalMatch, core, Thing.class, logical, new Mode[0]);
        }
        try {
            T thing = this.applyManyTraits(internalMatch, core, traits, null, logical, modes);
            return thing;
        }
        catch (LogicalTypeInconsistencyException ltie) {
            LOG.error("Exception", (Throwable)ltie);
            return null;
        }
    }

    public <T, K> T don(InternalMatch internalMatch, K core, Class<T> trait, boolean logical, Mode ... modes) {
        return this.don(internalMatch, core, trait, null, logical, modes);
    }

    public <T, K> T don(InternalMatch internalMatch, K core, Class<T> trait, Modify initArgs, boolean logical, Mode ... modes) {
        if (core instanceof Thing && ((Thing)core).getCore() != core) {
            return this.don(internalMatch, ((Thing)core).getCore(), trait, initArgs, logical, modes);
        }
        try {
            T thing = this.applyTrait(internalMatch, core, trait, initArgs, logical, modes);
            return thing;
        }
        catch (LogicalTypeInconsistencyException ltie) {
            LOG.error("Exception", (Throwable)ltie);
            return null;
        }
    }

    protected <T> T doInsertTrait(InternalMatch internalMatch, T thing, Object core, boolean logical, Mode ... modes) {
        if (thing == core) {
            return thing;
        }
        if (logical) {
            this.insertLogical(internalMatch, thing, modes);
        } else {
            this.insert(thing, internalMatch);
        }
        return thing;
    }

    private void updateTraits(Object object, BitMask mask, Thing originator, Class<?> modifiedClass, Collection<Thing> traits, InternalMatch internalMatch) {
        this.updateManyTraits(object, mask, Collections.singletonList(originator), modifiedClass, traits, internalMatch);
    }

    private void updateManyTraits(Object object, BitMask mask, Collection<Thing> originators, Class<?> modifiedClass, Collection<Thing> traits, InternalMatch internalMatch) {
        for (Thing t : traits) {
            InternalFactHandle h;
            if (originators.contains(t) || (h = (InternalFactHandle)this.lookupFactHandle(t)) == null) continue;
            NamedEntryPoint nep = (NamedEntryPoint)h.getEntryPoint((ReteEvaluator)this.workingMemory);
            PropagationContext propagationContext = nep.getPctxFactory().createPropagationContext(nep.getReteEvaluator().getNextPropagationIdCounter(), PropagationContext.Type.MODIFICATION, internalMatch != null ? internalMatch.getRule() : null, internalMatch != null ? (TerminalNode)internalMatch.getTuple().getTupleSink() : null, h, nep.getEntryPoint(), mask, modifiedClass, null);
            nep.update(h, (Object)t, (Object)t, nep.getObjectTypeConfigurationRegistry().getObjectTypeConf((Object)t), propagationContext);
        }
    }

    public void updateTraits(InternalFactHandle handle, BitMask mask, Class<?> modifiedClass, InternalMatch internalMatch) {
        Thing x;
        if (handle.isTraitable()) {
            if (((TraitableBean)handle.getObject()).hasTraits()) {
                this.updateTraits(handle.getObject(), mask, null, modifiedClass, ((TraitableBean)handle.getObject())._getTraitMap().values(), internalMatch);
            }
        } else if (handle.isTraiting() && (x = (Thing)handle.getObject()) != x.getCore()) {
            Object core = x.getCore();
            InternalFactHandle coreHandle = (InternalFactHandle)this.getFactHandle(core);
            ((NamedEntryPoint)coreHandle.getEntryPoint((ReteEvaluator)this.workingMemory)).update(coreHandle, core, mask, modifiedClass, internalMatch);
            this.updateTraits(core, mask, x, modifiedClass, ((TraitableBean)core)._getTraitMap().values(), internalMatch);
        }
    }

    private <T, K> void refresh(T thing, K core, TraitableBean inner, Class<T> trait, Collection<Thing> mostSpecificTraits, boolean logical, InternalMatch internalMatch) {
        if (mostSpecificTraits != null) {
            this.updateCore(inner, core, trait, logical, internalMatch);
            if (!mostSpecificTraits.isEmpty()) {
                this.updateTraits(inner, PropertySpecificUtil.onlyTraitBitSetMask(), (Thing)thing, trait, mostSpecificTraits, internalMatch);
            }
        } else if (Thing.class == trait) {
            this.updateCore(inner, core, trait, logical, internalMatch);
        }
    }

    protected <T, K> T applyManyTraits(InternalMatch internalMatch, K core, Collection<Class<? extends Thing>> traits, Object value, boolean logical, Mode ... modes) throws LogicalTypeInconsistencyException {
        TraitFactoryImpl builder = TraitFactoryImpl.getTraitBuilderForKnowledgeBase(this.entryPoint.getKnowledgeBase());
        TraitableBean inner = this.makeTraitable(core, builder, logical, internalMatch);
        Collection mostSpecificTraits = inner.getMostSpecificTraits();
        boolean newTraitsAdded = false;
        Thing firstThing = null;
        ArrayList<Thing> things = new ArrayList<Thing>(traits.size());
        this.checkStaticTypeCode(inner);
        for (Class<? extends Thing> trait : traits) {
            boolean needsUpdate;
            boolean needsProxy = trait.isAssignableFrom(inner.getClass());
            boolean hasTrait = inner.hasTrait(trait.getName());
            boolean bl = needsUpdate = needsProxy || core != inner;
            if (hasTrait) continue;
            Thing thing = this.asTrait(core, inner, trait, needsProxy, hasTrait, needsUpdate, builder, logical, internalMatch);
            this.configureTrait(thing, value);
            things.add(thing);
            if (newTraitsAdded || trait == Thing.class) continue;
            firstThing = thing;
            newTraitsAdded = true;
        }
        for (Thing t : things) {
            this.doInsertTrait(internalMatch, t, core, logical, modes);
        }
        if (newTraitsAdded && mostSpecificTraits != null) {
            this.updateCore(inner, core, null, logical, internalMatch);
            if (!mostSpecificTraits.isEmpty()) {
                this.updateManyTraits(inner, PropertySpecificUtil.onlyTraitBitSetMask(), things, core.getClass(), mostSpecificTraits, internalMatch);
            }
        }
        return (T)firstThing;
    }

    private void checkStaticTypeCode(TraitableBean inner) {
        TraitTypeMapImpl ttm;
        if (!inner.hasTraits() && (ttm = (TraitTypeMapImpl)inner._getTraitMap()) != null && ttm.getStaticTypeCode() == null) {
            TraitRegistryImpl registry = (TraitRegistryImpl)((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry(this.workingMemory.getKnowledgeBase());
            BitSet staticCode = registry.getStaticTypeCode(inner.getClass().getName());
            ttm.setStaticTypeCode(staticCode);
            if (staticCode != null) {
                for (String staticTrait : registry.getStaticTypes(inner.getClass().getName())) {
                    ttm.addStaticTrait(staticTrait, registry.getHierarchy().getCode(staticTrait));
                }
            }
        }
    }

    protected <T, K> T applyTrait(InternalMatch internalMatch, K core, Class<T> trait, Object value, boolean logical, Mode ... modes) throws LogicalTypeInconsistencyException {
        TraitFactoryImpl builder = TraitFactoryImpl.getTraitBuilderForKnowledgeBase(this.entryPoint.getKnowledgeBase());
        TraitableBean inner = this.makeTraitable(core, builder, logical, internalMatch);
        boolean needsProxy = trait.isAssignableFrom(inner.getClass());
        boolean hasTrait = inner.hasTrait(trait.getName());
        boolean needsUpdate = needsProxy || core != inner;
        this.checkStaticTypeCode(inner);
        Collection<Thing> mostSpecificTraits = this.getTraitBoundary(inner, needsProxy, hasTrait, trait);
        T thing = this.asTrait(core, inner, trait, needsProxy, hasTrait, needsUpdate, builder, logical, internalMatch);
        this.configureTrait(thing, value);
        thing = this.doInsertTrait(internalMatch, thing, core, logical, modes);
        this.refresh(thing, core, inner, trait, mostSpecificTraits, logical, internalMatch);
        if (trait != Thing.class && inner._getFieldTMS() != null) {
            inner._getFieldTMS().resetModificationMask();
        }
        return thing;
    }

    private <T> void updateCore(TraitableBean inner, Object core, Class<T> trait, boolean logical, InternalMatch internalMatch) {
        FactHandle handle = this.lookupFactHandle(inner);
        InternalFactHandle h = (InternalFactHandle)handle;
        if (handle != null) {
            TraitFieldTMS fieldTMS = inner._getFieldTMS();
            BitMask mask = fieldTMS == null ? PropertySpecificUtil.onlyTraitBitSetMask() : fieldTMS.getModificationMask();
            Object o = h.getObject();
            NamedEntryPoint nep = (NamedEntryPoint)h.getEntryPoint((ReteEvaluator)this.workingMemory);
            PropagationContext propagationContext = nep.getPctxFactory().createPropagationContext(nep.getReteEvaluator().getNextPropagationIdCounter(), PropagationContext.Type.MODIFICATION, internalMatch.getRule(), (TerminalNode)internalMatch.getTuple().getTupleSink(), h, nep.getEntryPoint(), mask, core.getClass(), null);
            nep.update(h, o, o, nep.getObjectTypeConfigurationRegistry().getObjectTypeConf(o), propagationContext);
        } else {
            handle = this.workingMemory.insert((Object)inner, false, internalMatch.getRule(), (TerminalNode)internalMatch.getTuple().getTupleSink());
        }
    }

    public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait, InternalMatch internalMatch) {
        Collection<Object> removedTypes;
        if (trait.isAssignableFrom(core.getClass())) {
            Collection removedTypes2 = core.removeTrait(trait.getName());
            if (!removedTypes2.isEmpty()) {
                this.reassignNodes(core, removedTypes2);
                FactHandle factHandle = this.getFactHandle(core);
                this.update(factHandle, PropertySpecificUtil.onlyTraitBitSetMask(), core.getClass(), internalMatch);
            }
            if (core instanceof Thing) {
                return (Thing)core;
            }
            return null;
        }
        Thing thing = core.getTrait(Thing.class.getName());
        if (trait == Thing.class) {
            ArrayList removedTypes3 = new ArrayList(core._getTraitMap().values());
            for (Thing thing2 : removedTypes3) {
                if (((TraitType)thing2)._isVirtual()) continue;
                this.delete(this.getFactHandle(thing2), internalMatch);
            }
            core._getTraitMap().clear();
            core._setTraitMap(null);
            return thing;
        }
        if (core.hasTrait(trait.getName())) {
            removedTypes = core.removeTrait(trait.getName());
        } else {
            HierarchyEncoder<String> hier = ((TraitRuntimeComponentFactory)RuntimeComponentFactory.get()).getTraitRegistry(this.workingMemory.getKnowledgeBase()).getHierarchy();
            BitSet bitSet = hier.getCode(trait.getName());
            removedTypes = core.removeTrait(bitSet);
        }
        removedTypes = new ArrayList<Thing<K>>(removedTypes);
        this.reassignNodes(core, removedTypes);
        for (Thing thing3 : removedTypes) {
            if (((TraitType)thing3)._isVirtual()) continue;
            InternalFactHandle handle = (InternalFactHandle)this.getFactHandle(thing3);
            if (handle.getEqualityKey() != null && handle.getEqualityKey().getLogicalFactHandle() == handle) {
                TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem(this.entryPoint).delete((FactHandle)handle);
                continue;
            }
            this.delete(this.getFactHandle(thing3), internalMatch);
        }
        if (!core.hasTraits()) {
            this.don(internalMatch, core, Thing.class, false, new Mode[0]);
        } else if (!removedTypes.isEmpty()) {
            this.update(this.getFactHandle(core), PropertySpecificUtil.onlyTraitBitSetMask(), core.getClass(), internalMatch);
        }
        return thing;
    }

    private <K, X extends TraitableBean> void reassignNodes(TraitableBean<K, X> core, Collection<Thing<K>> removedTraits) {
        if (!core.hasTraits()) {
            return;
        }
        Collection mst = ((TraitTypeMapImpl)core._getTraitMap()).getMostSpecificTraits();
        for (Thing<K> shedded : removedTraits) {
            for (BitSet bs : ((TraitProxyImpl)shedded).listAssignedOtnTypeCodes()) {
                boolean found = false;
                for (Thing tp : mst) {
                    TraitProxyImpl candidate = (TraitProxyImpl)tp;
                    if (!TraitUtils.supersetOrEqualset(candidate._getTypeCode(), bs)) continue;
                    candidate.assignOtn(bs);
                    found = true;
                    break;
                }
                if (!found) continue;
            }
        }
    }

    protected <K> Collection<Thing> getTraitBoundary(TraitableBean<K, ?> inner, boolean needsProxy, boolean hasTrait, Class trait) {
        boolean refresh;
        boolean bl = refresh = !needsProxy && !hasTrait && Thing.class != trait;
        if (!refresh) {
            return null;
        }
        if (inner._getTraitMap() == null || inner instanceof Thing) {
            return Collections.EMPTY_LIST;
        }
        if (inner._getTraitMap().isEmpty()) {
            return null;
        }
        ArrayList<Thing> ts = new ArrayList<Thing>();
        for (Thing t : inner._getTraitMap().values()) {
            if (!(t instanceof TraitProxyImpl) || !((TraitProxyImpl)t).hasOtns()) continue;
            ts.add(t);
        }
        return ts;
    }

    private <T, K> T asTrait(K core, TraitableBean inner, Class<T> trait, boolean needsProxy, boolean hasTrait, boolean needsUpdate, TraitFactoryImpl builder, boolean logical, InternalMatch internalMatch) throws LogicalTypeInconsistencyException {
        Object thing;
        if (needsProxy) {
            thing = inner;
            inner.addTrait(trait.getName(), (Thing)core);
        } else {
            thing = hasTrait ? inner.getTrait(trait.getName()) : builder.getProxy(inner, trait, logical);
        }
        if (needsUpdate) {
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(core);
            if (h == null) {
                h = this.lookupHandleForWrapper(core);
            }
            if (h == null) {
                h = (InternalFactHandle)this.workingMemory.insert(core, false, internalMatch.getRule(), (TerminalNode)internalMatch.getTuple().getTupleSink());
            }
            if (!h.isTraitOrTraitable()) {
                throw new IllegalStateException("A traited working memory element is being used with a default fact handle. Please verify that its class was declared as @Traitable : " + core.getClass().getName());
            }
            this.update((FactHandle)h, inner, internalMatch);
        }
        return (T)thing;
    }

    private <K> TraitableBean makeTraitable(K core, TraitFactoryImpl builder, boolean logical, InternalMatch internalMatch) {
        TraitableBean<K, CoreWrapper<K>> inner;
        boolean needsWrapping = !(core instanceof TraitableBean);
        ClassDefinition coreDef = this.lookupClassDefinition(core);
        TraitableBean<K, CoreWrapper<K>> traitableBean = inner = needsWrapping ? builder.asTraitable(core, coreDef) : (TraitableBean<K, CoreWrapper<K>>)core;
        if (needsWrapping) {
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(core);
            WorkingMemoryEntryPoint ep = h != null ? h.getEntryPoint((ReteEvaluator)this.workingMemory) : this.workingMemory.getEntryPoint("DEFAULT");
            ObjectTypeConfigurationRegistry reg = ep.getObjectTypeConfigurationRegistry();
            ObjectTypeConf coreConf = reg.getOrCreateObjectTypeConf(ep.getEntryPoint(), core);
            ObjectTypeConf innerConf = reg.getOrCreateObjectTypeConf(ep.getEntryPoint(), inner);
            if (coreConf.isTMSEnabled()) {
                innerConf.enableTMS();
            }
            if (inner._getFieldTMS() != null && inner._getFieldTMS().needsInit()) {
                inner._getFieldTMS().init((WorkingMemory)this.workingMemory);
            }
        } else {
            TraitFieldTMS ftms = inner._getFieldTMS();
            if (ftms != null) {
                FactHandle handle = this.lookupFactHandle(inner);
                if (handle == null) {
                    handle = this.workingMemory.insert(inner, false, internalMatch.getRule(), (TerminalNode)internalMatch.getTuple().getTupleSink());
                }
                if (ftms.needsInit()) {
                    ftms.init((WorkingMemory)this.workingMemory);
                }
            }
        }
        return inner;
    }

    protected <K> ClassDefinition lookupClassDefinition(K core) {
        TypeDeclaration decl;
        InternalKnowledgePackage pack = this.workingMemory.getKnowledgeBase().getPackage(core.getClass().getPackage().getName());
        if (pack != null && (decl = pack.getTypeDeclaration(core.getClass())) != null) {
            return decl.getTypeClassDef();
        }
        return null;
    }

    private <K> InternalFactHandle lookupHandleForWrapper(K core) {
        for (EntryPoint ep : this.workingMemory.getEntryPoints()) {
            ObjectStore store = ((WorkingMemoryEntryPoint)ep).getObjectStore();
            Iterator iter = store.iterateFactHandles();
            while (iter.hasNext()) {
                InternalFactHandle handle = (InternalFactHandle)iter.next();
                if (!handle.isTraitable() || !(handle.getObject() instanceof CoreWrapper) || ((CoreWrapper)handle.getObject()).getCore() != core) continue;
                return handle;
            }
        }
        return null;
    }

    public FactHandle lookupFactHandle(Object object) {
        FactHandle handle = this.getFactHandleFromWM(object);
        if (handle == null && object instanceof CoreWrapper) {
            handle = this.getFactHandleFromWM(((CoreWrapper)object).getCore());
        }
        return handle;
    }

    protected <T> void configureTrait(T thing, Object value) {
        if (value instanceof Modify && thing instanceof Metadatable) {
            Modify modify = (Modify)value;
            modify.call(thing);
        }
    }

    private FactHandle getFactHandleFromWM(Object object) {
        FactHandle handle = null;
        handle = this.entryPoint.getFactHandle(object);
        if (handle != null) {
            // empty if block
        }
        return handle;
    }

    public FactHandle getFactHandle(Object object) {
        FactHandle handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            if (object instanceof CoreWrapper) {
                handle = this.getFactHandleFromWM(((CoreWrapper)object).getCore());
            }
            if (handle == null) {
                throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
            }
        }
        return handle;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
    }

    public void update(FactHandle handle, Object newObject, InternalMatch internalMatch) {
        InternalFactHandle h = (InternalFactHandle)handle;
        h.getEntryPoint((ReteEvaluator)this.workingMemory).update((FactHandle)h, newObject, PropertySpecificUtil.onlyTraitBitSetMask(), newObject.getClass(), internalMatch);
    }

    public void update(FactHandle handle, BitMask mask, Class<?> modifiedClass, InternalMatch internalMatch) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((NamedEntryPoint)h.getEntryPoint((ReteEvaluator)this.workingMemory)).update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, internalMatch);
        if (h.isTraitOrTraitable()) {
            this.workingMemory.updateTraits(h, mask, modifiedClass, internalMatch);
        }
    }

    public void delete(FactHandle handle, InternalMatch internalMatch) {
        ((InternalFactHandle)handle).getEntryPoint((ReteEvaluator)this.workingMemory).delete(handle, internalMatch.getRule(), (TerminalNode)internalMatch.getTuple().getTupleSink());
    }

    public FactHandle insert(Object object, InternalMatch internalMatch) {
        FactHandle handle = this.workingMemory.insert(object, false, internalMatch.getRule(), (TerminalNode)internalMatch.getTuple().getTupleSink());
        return handle;
    }

    public void insertLogical(InternalMatch internalMatch, Object object, Mode ... modes) {
        if (!internalMatch.isMatched()) {
            return;
        }
        TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.workingMemory).insert(object, (Object)modes, internalMatch);
    }

    public void deleteWMAssertedTraitProxies(InternalFactHandle handle, RuleImpl rule, TerminalNode terminalNode) {
        TraitableBean traitableBean = (TraitableBean)handle.getObject();
        if (traitableBean.hasTraits()) {
            PriorityQueue removedTypes = new PriorityQueue(traitableBean._getTraitMap().values().size());
            removedTypes.addAll(traitableBean._getTraitMap().values());
            while (!removedTypes.isEmpty()) {
                InternalFactHandle proxyHandle;
                TraitProxyImpl proxy = (TraitProxyImpl)removedTypes.poll();
                if (proxy._isVirtual() || (proxyHandle = (InternalFactHandle)this.getFactHandle(proxy)).getEqualityKey() != null && proxyHandle.getEqualityKey().getLogicalFactHandle() == proxyHandle) continue;
                this.entryPoint.delete((FactHandle)proxyHandle, rule, terminalNode);
            }
        }
    }

    public <K> K extractTrait(InternalFactHandle handle, Class<K> klass) {
        TraitableBean tb;
        if (handle.isTraitable()) {
            tb = (TraitableBean)handle.getObject();
        } else if (handle.isTraiting()) {
            tb = ((TraitProxyImpl)handle.getObject()).getObject();
        } else {
            return null;
        }
        Thing k = tb.getTrait(klass.getCanonicalName());
        if (k != null) {
            return (K)k;
        }
        for (Object t : tb.getMostSpecificTraits()) {
            if (!klass.isAssignableFrom(t.getClass())) continue;
            return (K)t;
        }
        return null;
    }

    public void replaceCore(InternalFactHandle handle, Object object, Object originalObject, BitMask modificationMask, Class<? extends Object> aClass, InternalMatch internalMatch) {
        TraitableBean src = (TraitableBean)originalObject;
        TraitableBean tgt = (TraitableBean)object;
        tgt._setTraitMap(src._getTraitMap());
        tgt._setDynamicProperties(src._getDynamicProperties());
        tgt._setFieldTMS(src._getFieldTMS());
        this.updateTraits(handle, modificationMask, object.getClass(), internalMatch);
    }
}

