/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.Entry;
import org.drools.traits.core.factmodel.AbstractTriple;
import org.drools.traits.core.factmodel.Triple;
import org.drools.traits.core.factmodel.TripleImpl;
import org.kie.api.runtime.rule.Variable;

public class TripleStore
implements Externalizable {
    public static final String TYPE = "rdfs:type";
    public static final String PROXY = "drools:proxy";
    public static final String VALUE = "drools:hasValue";
    private String id;
    private Map<Triple, Triple> map;

    public TripleStore() {
        this.map = new HashMap<Triple, Triple>();
    }

    public TripleStore(int capacity, float loadFactor) {
        this.map = new HashMap<Triple, Triple>(capacity, loadFactor);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.map = (Map)in.readObject();
        this.id = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.map);
        out.writeObject(this.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean put(Triple triple, boolean checkExists) {
        return this.put(triple);
    }

    public boolean put(Triple triple) {
        Object val = triple.getValue();
        ((TripleImpl)triple).setValue(Variable.v);
        Triple prev = this.map.compute(triple, (key, existing) -> {
            if (existing != null) {
                ((TripleImpl)existing).setValue(val);
                return existing;
            }
            return key;
        });
        ((TripleImpl)triple).setValue(val);
        return prev != triple;
    }

    public boolean add(Triple triple) {
        this.map.put(triple, triple);
        return false;
    }

    public Triple get(Triple triple) {
        return this.map.get(triple);
    }

    public Collection<Triple> getAll(Triple triple) {
        ArrayList<Triple> list = new ArrayList<Triple>();
        if (triple.getInstance() != Variable.v && triple.getProperty() != Variable.v) {
            TripleCollector collector = new TripleCollector(list, triple);
            this.map.get(collector);
            return list;
        }
        for (Triple tx : this.map.values()) {
            if (!AbstractTriple.equals(triple, tx)) continue;
            list.add(tx);
        }
        return list;
    }

    public int removeAll(Triple triple) {
        int removed = 0;
        Collection<Triple> coll = this.getAll(triple);
        for (Triple t : coll) {
            if (!this.remove(t)) continue;
            ++removed;
        }
        return removed;
    }

    public boolean remove(Triple triple) {
        return this.map.remove(triple) != null;
    }

    public boolean contains(Triple triple) {
        return this.map.containsKey(triple);
    }

    public int size() {
        return this.map.size();
    }

    public class TripleCollector
    extends AbstractTriple {
        List<Triple> list;
        private Triple triple;

        public TripleCollector(List<Triple> list, Triple triple) {
            this.list = list;
            this.triple = triple;
        }

        public void setNext(Entry next) {
        }

        public Entry getNext() {
            return null;
        }

        @Override
        public Object getInstance() {
            return this.triple.getInstance();
        }

        @Override
        public Object getProperty() {
            return this.triple.getProperty();
        }

        @Override
        public Object getValue() {
            return Variable.v;
        }
    }
}

