/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.factmodel.traits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.base.factmodel.traits.Trait;
import org.drools.base.factmodel.traits.Traitable;
import org.drools.base.factmodel.traits.TraitableBean;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.traits.compiler.CommonTraitTest;
import org.drools.traits.compiler.factmodel.traits.SomeClass;
import org.drools.traits.compiler.factmodel.traits.SomeInterface;
import org.drools.traits.compiler.factmodel.traits.TraitTestUtils;
import org.drools.traits.core.factmodel.LogicalTypeInconsistencyException;
import org.drools.traits.core.factmodel.TraitFactoryImpl;
import org.drools.traits.core.factmodel.VirtualPropertyMode;
import org.drools.traits.core.util.StandaloneTraitFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Parameterized.class)
public class LegacyTraitTest
extends CommonTraitTest {
    public VirtualPropertyMode mode;

    @Parameterized.Parameters
    public static Collection modes() {
        return Arrays.asList({VirtualPropertyMode.MAP}, {VirtualPropertyMode.TRIPLES});
    }

    public LegacyTraitTest(VirtualPropertyMode m) {
        this.mode = m;
    }

    private KieSession getSessionFromString(String drl) {
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (knowledgeBuilder.hasErrors()) {
            throw new RuntimeException(knowledgeBuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(knowledgeBuilder.getKnowledgePackages());
        KieSession session = kbase.newKieSession();
        return session;
    }

    @Test
    public void traitWithPojoInterface() {
        String source = "package org.drools.compiler.test;\nimport " + Procedure.class.getCanonicalName() + ";\nimport " + LegacyTraitTest.class.getCanonicalName() + ";\nimport " + ExtendedProcedureImpl.class.getCanonicalName() + ";\nimport " + ExtendedProcedure.class.getCanonicalName() + ";\ndeclare trait ExtendedProcedure    @role( event )end declare trait Surgery extends ExtendedProcedure end declare ExtendedProcedureImpl     @Traitable end rule 'Don Procedure' when     $p : ExtendedProcedure() then     don( $p, Surgery.class ); end rule 'Test 1' dialect 'mvel' when     $s1 : ExtendedProcedure( $subject : subject )     $s2 : ExtendedProcedure( subject == $subject ) then end rule 'Test 2' dialect 'mvel' when     $s1 : ExtendedProcedure( $subject : subject.name )     $s2 : ExtendedProcedure( subject.name == $subject ) then end rule 'Test 3' dialect 'mvel' when     $s1 : ExtendedProcedure( ) then     update( $s1 ); end \n";
        KieSession ks = this.getSessionFromString(source);
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)ks.getKieBase());
        ExtendedProcedureImpl procedure1 = new ExtendedProcedureImpl();
        ExtendedProcedureImpl procedure2 = new ExtendedProcedureImpl();
        PatientImpl patient1 = new PatientImpl();
        patient1.setName("John");
        procedure1.setSubject(patient1);
        procedure1.setPers(new PatientImpl());
        PatientImpl patient2 = new PatientImpl();
        patient2.setName("John");
        procedure2.setSubject(patient2);
        procedure2.setPers(new PatientImpl());
        ks.insert((Object)procedure1);
        ks.insert((Object)procedure2);
        ks.fireAllRules(500);
    }

    @Test
    public void traitWithMixedInterfacesExtendingEachOther() {
        String source = "package org.drools.compiler.test;import " + BarImpl.class.getCanonicalName() + "; import " + Foo.class.getCanonicalName() + "; import " + Trunk.class.getCanonicalName() + "; global java.util.List list; declare trait Foo end declare trait Root end declare trait Foo2 extends Foo   @propertyReactive end rule 'Bar Don'when    $b : BarImpl( this isA Foo.class, this not isA Foo2.class )\n   String()\nthen    list.add( 3 );    retract( $b ); end rule 'Don Bar' no-loop when     $b : Foo( ) then     list.add( 1 );     don( $b, Foo2.class ); end rule 'Cant really shed Foo but Foo2' when    $b : Foo2() then    list.add( 2 );    shed( $b, Foo.class );    insert( \"done\" );end ";
        KieSession ks = this.getSessionFromString(source);
        KieBase kieBase = ks.getKieBase();
        TraitFactoryImpl.setMode((VirtualPropertyMode)this.mode, (KieBase)kieBase);
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.insert((Object)new BarImpl());
        int n = ks.fireAllRules();
        System.out.println(list);
        Assertions.assertThat(list).isEqualTo(Arrays.asList(1, 2, 3));
        Assertions.assertThat((int)n).isEqualTo(3);
    }

    @Test
    public void testTraitWithNonAccessorMethodShadowing() {
        StandaloneTraitFactory factory = TraitTestUtils.createStandaloneTraitFactory();
        try {
            SomeInterface r = (SomeInterface)factory.don((TraitableBean)new SomeClass(), SomeInterface.class);
            r.prepare();
            Assertions.assertThat((int)r.getFoo()).isEqualTo(42);
            Assertions.assertThat((String)r.doThis("that")).isEqualTo("I did that");
        }
        catch (LogicalTypeInconsistencyException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPojoExtendInterface() {
        String s1 = "package test;\ndeclare Poojo extends Mask end declare trait Mask end ";
        KieHelper kh = new KieHelper();
        kh.addContent("package test;\ndeclare Poojo extends Mask end declare trait Mask end ", ResourceType.DRL);
        Assertions.assertThat((int)kh.verify().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
    }

    @PropertyReactive
    @Trait
    public static interface Foo
    extends Trunk {
    }

    public static interface Trunk
    extends Root {
    }

    public static interface Root {
    }

    @Traitable
    @PropertyReactive
    public static class BarImpl
    implements Foo {
    }

    public class ExtendedProcedureImpl
    extends ProcedureImpl
    implements ExtendedProcedure {
        private Pers pers;

        @Override
        public Pers getPers() {
            return this.pers;
        }

        @Override
        public void setPers(Pers pers) {
            this.pers = pers;
        }
    }

    public class ProcedureImpl
    implements Procedure {
        private Patient subject;

        @Override
        public Patient getSubject() {
            return this.subject;
        }

        @Override
        public void setSubject(Patient patient) {
            this.subject = patient;
        }
    }

    public static interface ExtendedProcedure
    extends Procedure {
        public Pers getPers();

        public void setPers(Pers var1);
    }

    public static interface Procedure {
        public Patient getSubject();

        public void setSubject(Patient var1);
    }

    public static interface Patient
    extends Pers {
    }

    public static interface Pers {
        public String getName();
    }

    public static class PatientImpl
    implements Patient {
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

