/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.factmodel.traits.Traitable;
import org.drools.traits.compiler.Address;
import org.drools.traits.compiler.Cheese;
import org.drools.traits.compiler.Option;
import org.drools.traits.compiler.PersonInterface;
import org.drools.traits.compiler.Pet;

@Traitable
public class Person
implements Serializable,
PersonInterface {
    private static final long serialVersionUID = 510L;
    private String name;
    private String likes;
    private int age;
    private BigDecimal bigDecimal;
    private BigInteger bigInteger;
    private String hair;
    private char sex;
    private boolean alive;
    private boolean happy;
    private String status;
    private Cheese cheese;
    private Address address;
    private Pet pet;
    private List<Address> addresses = new ArrayList<Address>();
    private Map<Object, Address> namedAddresses = new HashMap<Object, Address>(0);
    public Object object;
    public Object notInEqualTestObject;

    public Person() {
    }

    public Person(String name, int age) {
        this.name = name;
        this.age = age;
    }

    public Person(String name, int age, boolean happy) {
        this.name = name;
        this.age = age;
        this.happy = happy;
    }

    public Person(String name) {
        this(name, "", 0);
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Option<Address> getAddressOption() {
        return new Option<Address>(this.address);
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public List getAddressesNoGenerics() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public void addAddress(Address address) {
        this.addresses.add(address);
    }

    public Map<Object, Address> getNamedAddresses() {
        return this.namedAddresses;
    }

    public void setNamedAddresses(Map<Object, Address> namedAddresses) {
        this.namedAddresses = namedAddresses;
    }

    public Person(String name, String likes) {
        this(name, likes, 0);
    }

    public Person(String name, String likes, int age) {
        this.name = name;
        this.likes = likes;
        this.age = age;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getLikes() {
        return this.likes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    public int getDoubleAge() {
        return this.age * 2;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Integer getAgeAsInteger() {
        return this.age;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    @Override
    public char getSex() {
        return this.sex;
    }

    @Override
    public void setSex(char sex) {
        this.sex = sex;
    }

    public String getHair() {
        return this.hair;
    }

    public void setHair(String hair) {
        this.hair = hair;
    }

    public Object getNotInEqualTestObject() {
        return this.notInEqualTestObject;
    }

    public void setNotInEqualTestObject(Object notInEqualTestObject) {
        this.notInEqualTestObject = notInEqualTestObject;
    }

    public String toString() {
        return "[Person name='" + this.name + " age='" + this.age + "' likes='" + this.likes + "']";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.addresses == null ? 0 : this.addresses.hashCode());
        result = 31 * result + this.age;
        result = 31 * result + (this.alive ? 1231 : 1237);
        result = 31 * result + (this.bigDecimal == null ? 0 : this.bigDecimal.hashCode());
        result = 31 * result + (this.bigInteger == null ? 0 : this.bigInteger.hashCode());
        result = 31 * result + (this.cheese == null ? 0 : this.cheese.hashCode());
        result = 31 * result + (this.hair == null ? 0 : this.hair.hashCode());
        result = 31 * result + (this.happy ? 1231 : 1237);
        result = 31 * result + (this.likes == null ? 0 : this.likes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        result = 31 * result + (this.pet == null ? 0 : this.pet.hashCode());
        result = 31 * result + this.sex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Person)) {
            return false;
        }
        Person other = (Person)obj;
        if (this.address == null ? other.getAddress() != null : !this.address.equals(other.getAddress())) {
            return false;
        }
        if (this.addresses == null ? other.getAddresses() != null : !this.addresses.equals(other.getAddresses())) {
            return false;
        }
        if (this.age != other.getAge()) {
            return false;
        }
        if (this.alive != other.isAlive()) {
            return false;
        }
        if (this.bigDecimal == null ? other.getBigDecimal() != null : !this.bigDecimal.equals(other.getBigDecimal())) {
            return false;
        }
        if (this.bigInteger == null ? other.getBigInteger() != null : !this.bigInteger.equals(other.getBigInteger())) {
            return false;
        }
        if (this.cheese == null ? other.getCheese() != null : !this.cheese.equals(other.getCheese())) {
            return false;
        }
        if (this.hair == null ? other.getHair() != null : !this.hair.equals(other.getHair())) {
            return false;
        }
        if (this.happy != other.isHappy()) {
            return false;
        }
        if (this.likes == null ? other.getLikes() != null : !this.likes.equals(other.getLikes())) {
            return false;
        }
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        if (this.object == null ? other.getObject() != null : !this.object.equals(other.getObject())) {
            return false;
        }
        if (this.pet == null ? other.getPet() != null : !this.pet.equals(other.getPet())) {
            return false;
        }
        return this.sex == other.getSex();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.bigDecimal;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.bigInteger;
    }

    @Override
    public void setBigInteger(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }

    public void setLikes(String likes) {
        this.likes = likes;
    }

    public Cheese getCheese() {
        return this.cheese;
    }

    public Pet getPet() {
        return this.pet;
    }

    public void setPet(Pet pet) {
        this.pet = pet;
    }

    public void setCheese(Cheese cheese) {
        this.cheese = cheese;
    }

    public boolean isHappy() {
        return this.happy;
    }

    public void setHappy(boolean happy) {
        this.happy = happy;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }
}

