/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.integrationtests;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.base.factmodel.traits.Thing;
import org.drools.base.factmodel.traits.Traitable;
import org.drools.io.ByteArrayResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.tms.beliefsystem.abductive.Abducible;
import org.drools.traits.compiler.CommonTraitTest;
import org.drools.traits.compiler.Person;
import org.drools.traits.core.factmodel.Entity;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.utils.KieHelper;

public class TraitTypeGenerationTest
extends CommonTraitTest {
    @Test(timeout=10000L)
    public void testWithDeclaredTypeAndTraitInDifferentPackages() {
        String str1 = "package org.pkg1;\ndeclare trait Trait     @propertyReactive\n    a : int\nend";
        String str2 = "package org.pkg2;\ndeclare Bean     @propertyReactive\n    @Traitable\n    a : int\n    b : int\nend";
        String str3 = "package org.pkg3;\nimport org.pkg1.Trait;\nimport org.pkg2.Bean;\nrule Init\nwhen\nthen\n    insert(new Bean(1, 2));\nend\nrule R\nwhen\n   $b : Bean( b == 2)then\n   Trait t = don( $b, Trait.class, true );\n   modify(t) { setA(2) };\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.pkg1;\ndeclare trait Trait     @propertyReactive\n    a : int\nend", "package org.pkg2;\ndeclare Bean     @propertyReactive\n    @Traitable\n    a : int\n    b : int\nend", "package org.pkg3;\nimport org.pkg1.Trait;\nimport org.pkg2.Bean;\nrule Init\nwhen\nthen\n    insert(new Bean(1, 2));\nend\nrule R\nwhen\n   $b : Bean( b == 2)then\n   Trait t = don( $b, Trait.class, true );\n   modify(t) { setA(2) };\nend");
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testWithBeanAndTraitInDifferentPackages() {
        String str1 = "package org.drools.compiler.integrationtests;\ndeclare trait Trait     @propertyReactive\n    a : int\nend";
        String str2 = "package org.drools.test;\nimport org.drools.compiler.integrationtests.Trait;\nimport " + Bean.class.getCanonicalName() + ";\nrule Init\nwhen\nthen\n    insert(new Bean(1, 2));\nend\nrule R\nwhen\n   $b : Bean( b == 2)then\n   Trait t = don( $b, Trait.class, true );\n   modify(t) { setA(2) };\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.drools.compiler.integrationtests;\ndeclare trait Trait     @propertyReactive\n    a : int\nend", str2);
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
    }

    @Test
    public void testIsAWith2KContainers() {
        String str = "import org.drools.traits.compiler.Person\n\nglobal java.util.List students\n\ndeclare trait Student\n    school : String\nend\n\nrule \"create student\" \n    when\n        $student : Person( age < 26, this not isA Student )\n    then\n        Student s = don( $student, Student.class );\n        s.setSchool(\"Masaryk University\");\n        update( $student );\nend\n\nrule \"found student\"\n    salience 10\n    when\n        student : Person( this isA Student )\n    then\n        students.add(student);\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/isA.drl", str);
        KieBuilder kbuilder = ks.newKieBuilder(kfs);
        kbuilder.buildAll();
        Assertions.assertThat((int)kbuilder.getResults().getMessages().size()).isEqualTo(0);
        ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).getKieBase();
        KieSession ksession = ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).newKieSession();
        Assertions.assertThat((Object)ksession).isNotNull();
        ArrayList students = new ArrayList();
        ksession.setGlobal("students", students);
        ksession.insert((Object)new Person("tom", 20));
        ksession.fireAllRules();
        Assertions.assertThat((int)students.size()).isEqualTo(1);
    }

    @Test
    public void testMvelJittingWithTraitProxies() throws Exception {
        String drl = "package org.drools.test; \nimport " + FooIntf.class.getCanonicalName() + ";\nimport " + BarKlass.class.getCanonicalName() + ";\ndeclare BarKlass end \ndeclare FooIntf end \ndeclare trait ExtFoo extends FooIntf end \ndeclare Kore @Traitable safe : boolean end \nrule \"Test2\" when FooIntf( safe == true ) then end \nrule \"In1\" when $s : String() then don( new Kore( true ), ExtFoo.class ); end \nrule \"In2\" when $s : Integer() then insert( new BarKlass() ); end \n";
        KieBase kb = this.loadKnowledgeBaseFromString(drl);
        KieSession ks = kb.newKieSession();
        for (int j = 0; j < 21; ++j) {
            ks.insert((Object)("x" + j));
            ks.fireAllRules();
        }
        Thread.sleep(100L);
        ks.insert((Object)0);
        ks.fireAllRules();
    }

    @Test
    public void testNeeds() {
        String droolsSource = "package org.drools.abductive.test; \nimport " + Entity.class.getPackage().getName() + ".*;import " + Thing.class.getPackage().getName() + ".*;import " + Abducible.class.getName() + "; \nglobal java.util.List list; \ndeclare Goal \n   entity : Thing \n   property : String \n   value : Object \nend \nquery check( Thing $thing, String $prop, Object $val )    Thing( this == $thing, fields[ $prop ] == $val )    or   (      need( $thing, $prop, $val ; )      and     Thing( this == $thing, fields[ $prop ] == $val )    ) end \n query need( Thing $thing, String $prop, Object $val )    @Abductive( target=Goal.class ) \n   Thing( this == $thing, fields[ $prop ] != $val ) end \n rule HandleGoal when    $g : Goal( $m : entity, $prop : property, $val : value ) then    System.out.println( 'Satisfy ' + $g ); \n   modify ( $m ) { getFields().put( $prop, $val ); } \nend declare trait Monkey\n   position : Integer = 1 \n end \nrule Main\nwhen \nthen \n   System.out.println( 'Don MONKEY ' );    Entity e = new Entity(); \n   Monkey monkey = don( e, Monkey.class );end \nrule MoveAround when    $m : Monkey( $pos : position )    ?check( $m, \"position\", 4 ; ) then    System.out.println( 'Monkey madness' + $m );    list.add( $m.getPosition() ); end ";
        KieSession session = this.loadKnowledgeBaseFromString(droolsSource).newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules();
        for (Object o : session.getObjects()) {
            System.out.println(">>> " + o);
        }
        Assertions.assertThat(list).isEqualTo(List.of(Integer.valueOf(4)));
    }

    @Test
    public void testRedeclareClassAsTrait() {
        String s1 = "package test; global java.util.List list; declare trait " + SomeClass.class.getCanonicalName() + " end ";
        KieHelper kh = new KieHelper();
        kh.addContent(s1, ResourceType.DRL);
        Assertions.assertThat((int)kh.verify().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(1);
    }

    @Test
    public void testMultipleInheritanceWithPosition1() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 //@position(0)\n field1 : int = 101 //@position(1)\n field2 : int = 102 //@position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 //@position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assertions.assertThat((boolean)kBuilder.hasErrors()).isFalse();
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assertions.assertThat((int)sw.getFields().size()).isEqualTo(5);
        Assertions.assertThat((String)((FactField)sw.getFields().get(0)).getName()).isEqualTo("field0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(1)).getName()).isEqualTo("field1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(2)).getName()).isEqualTo("mfield1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(3)).getName()).isEqualTo("field2");
        Assertions.assertThat((String)((FactField)sw.getFields().get(4)).getName()).isEqualTo("mfield0");
    }

    @Test
    public void testMultipleInheritanceWithPosition2() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 //@position(0)\n field1 : int = 101 //@position(1)\n field2 : int = 102 //@position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 @position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assertions.assertThat((boolean)kBuilder.hasErrors()).isFalse();
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assertions.assertThat((int)sw.getFields().size()).isEqualTo(5);
        Assertions.assertThat((String)((FactField)sw.getFields().get(0)).getName()).isEqualTo("mfield0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(1)).getName()).isEqualTo("field0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(2)).getName()).isEqualTo("mfield1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(3)).getName()).isEqualTo("field1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(4)).getName()).isEqualTo("field2");
    }

    @Test
    public void testMultipleInheritanceWithPosition3() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 @position(0)\n field1 : int = 101 @position(1)\n field2 : int = 102 @position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 //@position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assertions.assertThat((boolean)kBuilder.hasErrors()).isFalse();
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assertions.assertThat((int)sw.getFields().size()).isEqualTo(5);
        Assertions.assertThat((String)((FactField)sw.getFields().get(0)).getName()).isEqualTo("field0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(1)).getName()).isEqualTo("field2");
        Assertions.assertThat((String)((FactField)sw.getFields().get(2)).getName()).isEqualTo("field1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(3)).getName()).isEqualTo("mfield1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(4)).getName()).isEqualTo("mfield0");
    }

    @Test
    public void testMultipleInheritanceWithPosition4() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 @position(1)\n field1 : int = 101 @position(0)\n field2 : int = 102 @position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 @position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assertions.assertThat((boolean)kBuilder.hasErrors()).isFalse();
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assertions.assertThat((int)sw.getFields().size()).isEqualTo(5);
        Assertions.assertThat((String)((FactField)sw.getFields().get(0)).getName()).isEqualTo("field1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(1)).getName()).isEqualTo("field2");
        Assertions.assertThat((String)((FactField)sw.getFields().get(2)).getName()).isEqualTo("mfield0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(3)).getName()).isEqualTo("field0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(4)).getName()).isEqualTo("mfield1");
    }

    @Test
    public void testMultipleInheritanceWithPosition5() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 @position(2)\n field1 : int = 101 @position(1)\n field2 : int = 102 @position(8)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n mfield0 : int = 200 @position(7)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assertions.assertThat((boolean)kBuilder.hasErrors()).isFalse();
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assertions.assertThat((int)sw.getFields().size()).isEqualTo(5);
        Assertions.assertThat((String)((FactField)sw.getFields().get(0)).getName()).isEqualTo("field1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(1)).getName()).isEqualTo("field0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(2)).getName()).isEqualTo("mfield1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(3)).getName()).isEqualTo("mfield0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(4)).getName()).isEqualTo("field2");
    }

    @Test
    public void testMultipleInheritanceWithPosition6() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 //@position(0)\n field1 : int = 101 //@position(1)\n field2 : int = 102 //@position(0)\nend\n\ndeclare trait SecPosTrait\n@propertyReactive\n field3 : int = 100 //@position(0)\n field1 : int = 101 //@position(1)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait, SecPosTrait\n@propertyReactive\n mfield0 : int = 200 //@position(0)\n mfield1 : int = 201 //@position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assertions.assertThat((boolean)kBuilder.hasErrors()).isFalse();
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assertions.assertThat((int)sw.getFields().size()).isEqualTo(6);
        Assertions.assertThat((String)((FactField)sw.getFields().get(0)).getName()).isEqualTo("field0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(1)).getName()).isEqualTo("field1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(2)).getName()).isEqualTo("field2");
        Assertions.assertThat((String)((FactField)sw.getFields().get(3)).getName()).isEqualTo("field3");
        Assertions.assertThat((String)((FactField)sw.getFields().get(4)).getName()).isEqualTo("mfield0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(5)).getName()).isEqualTo("mfield1");
    }

    @Test
    public void testMultipleInheritanceWithPosition7() throws Exception {
        String drl = "package org.drools.test\ndeclare trait PosTrait\n@propertyReactive\n field0 : int = 100 @position(0)\n field1 : int = 101 @position(1)\n field2 : int = 102 @position(0)\nend\n\ndeclare trait SecPosTrait\n@propertyReactive\n field3 : int = 100 @position(2)\n field1 : int = 101 //@position(1)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait, SecPosTrait\n@propertyReactive\n mfield0 : int = 200 @position(0)\n mfield1 : int = 201 @position(2)\nend";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assertions.assertThat((boolean)kBuilder.hasErrors()).isFalse();
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        FactType sw = knowledgeBase.getFactType("org.drools.test", "MultiInhPosTrait");
        Assertions.assertThat((int)sw.getFields().size()).isEqualTo(6);
        Assertions.assertThat((String)((FactField)sw.getFields().get(0)).getName()).isEqualTo("field0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(1)).getName()).isEqualTo("field2");
        Assertions.assertThat((String)((FactField)sw.getFields().get(2)).getName()).isEqualTo("mfield0");
        Assertions.assertThat((String)((FactField)sw.getFields().get(3)).getName()).isEqualTo("field1");
        Assertions.assertThat((String)((FactField)sw.getFields().get(4)).getName()).isEqualTo("field3");
        Assertions.assertThat((String)((FactField)sw.getFields().get(5)).getName()).isEqualTo("mfield1");
    }

    @PropertyReactive
    @Traitable
    public static class Bean {
        private int a;
        private int b;

        public Bean() {
        }

        public Bean(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }
    }

    public static interface FooIntf {
        public boolean isSafe();

        public void setSafe(boolean var1);
    }

    public static class BarKlass
    implements FooIntf {
        @Override
        public boolean isSafe() {
            return true;
        }

        @Override
        public void setSafe(boolean safe) {
        }
    }

    public static class SomeClass {
    }
}

