/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.TransformerException;
import org.drools.FactHandle;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.common.DisconnectedFactHandle;
import org.drools.rule.Declaration;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.drools.runtime.rule.QueryResultsRow;
import org.drools.runtime.rule.impl.FlatQueryResults;
import org.drools.runtime.rule.impl.NativeQueryResults;
import org.drools.spi.ObjectType;
import org.drools.xml.jaxb.util.JaxbListWrapper;

public class ResultTranslator {
    private Object convert(Object obj) {
        if (obj instanceof FactHandle && !(obj instanceof DisconnectedFactHandle)) {
            return new DisconnectedFactHandle(((FactHandle)obj).toExternalForm());
        }
        if (obj instanceof NativeQueryResults) {
            NativeQueryResults nativeQueryResults = (NativeQueryResults)obj;
            ArrayList<Declaration> declrs = new ArrayList<Declaration>();
            HashMap<String, Integer> identifiers = new HashMap<String, Integer>();
            for (String identifier : nativeQueryResults.getIdentifiers()) {
                Declaration declr = (Declaration)nativeQueryResults.getDeclarations().get(identifier);
                ObjectType objectType = declr.getPattern().getObjectType();
                if (objectType instanceof ClassObjectType && ((ClassObjectType)objectType).getClassType() == DroolsQuery.class) continue;
                declrs.add(declr);
                identifiers.put(identifier, declrs.size() - 1);
            }
            ArrayList results = new ArrayList(nativeQueryResults.size());
            ArrayList factHandles = new ArrayList(nativeQueryResults.size());
            for (QueryResultsRow row : nativeQueryResults) {
                ArrayList<Object> objectList = new ArrayList<Object>();
                ArrayList<DisconnectedFactHandle> factHandleList = new ArrayList<DisconnectedFactHandle>();
                for (int i = 0; i < declrs.size(); ++i) {
                    objectList.add(this.convert(row.get(((Declaration)declrs.get(i)).getIdentifier())));
                    factHandleList.add(new DisconnectedFactHandle(row.getFactHandle(((Declaration)declrs.get(i)).getIdentifier()).toExternalForm()));
                }
                factHandles.add(factHandleList);
                results.add(objectList);
            }
            return new FlatQueryResults(identifiers, results, factHandles);
        }
        Class<?> vClass = obj.getClass();
        if (List.class.isAssignableFrom(vClass) && !JaxbListWrapper.class.equals(vClass)) {
            JaxbListWrapper wrapper = new JaxbListWrapper(((List)obj).size());
            for (Object item : (List)obj) {
                wrapper.add(this.convert(item));
            }
            return wrapper;
        }
        return obj;
    }

    public String transform(ExecutionResultImpl executionResult, Marshaller marshaller) throws JAXBException, TransformerException {
        try {
            StringWriter writer = new StringWriter();
            for (Map.Entry entry : executionResult.getFactHandles().entrySet()) {
                entry.setValue(this.convert(entry.getValue()));
            }
            for (Map.Entry entry : executionResult.getResults().entrySet()) {
                entry.setValue(this.convert(entry.getValue()));
            }
            marshaller.marshal((Object)executionResult, (Writer)writer);
            return writer.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

