/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import net.sf.jxls.reader.ReaderBuilder;
import net.sf.jxls.reader.XLSReader;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.impl.KnowledgeBuilderImpl;
import org.drools.io.ResourceFactory;
import org.drools.rule.CompositeClassLoader;
import org.drools.runtime.pipeline.PipelineContext;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.impl.BasePipelineContext;
import org.drools.runtime.pipeline.impl.CallableImpl;
import org.drools.runtime.pipeline.impl.Company;
import org.drools.runtime.pipeline.impl.Department;

public class JxlsTest
extends TestCase {
    public void test1() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeClassLoader cl = ((KnowledgeBuilderImpl)kbuilder).pkgBuilder.getRootClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        BufferedInputStream inputXLS = new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream("departmentData.xls"));
        XLSReader mainReader = ReaderBuilder.buildFromXML((InputStream)ResourceFactory.newClassPathResource((String)"departments.xml", ((Object)((Object)this)).getClass()).getInputStream());
        Transformer transformer = PipelineFactory.newJxlsTransformer((XLSReader)mainReader, (String)"[ 'departments' : new java.util.ArrayList(), 'company' : new org.drools.runtime.pipeline.impl.Company() ]");
        CallableImpl callable = new CallableImpl();
        callable.setReceiver((Receiver)transformer);
        transformer.setReceiver((Receiver)callable);
        BasePipelineContext context = new BasePipelineContext(Thread.currentThread().getContextClassLoader());
        Map beans = (Map)callable.call((Object)inputXLS, (PipelineContext)context);
        JxlsTest.assertEquals((String)Company.class.getName(), (String)beans.get("company").getClass().getName());
        JxlsTest.assertEquals((String)ArrayList.class.getName(), (String)beans.get("departments").getClass().getName());
        Company company = (Company)beans.get("company");
        JxlsTest.assertEquals((String)"A-Team", (String)company.getName());
        JxlsTest.assertEquals((int)4, (int)company.getEmployee().size());
        List departments = (List)beans.get("departments");
        JxlsTest.assertEquals((int)3, (int)departments.size());
        Department department = (Department)departments.get(0);
        JxlsTest.assertEquals((String)"IT", (String)department.getName());
        JxlsTest.assertEquals((int)5, (int)department.getStaff().size());
        department = (Department)departments.get(2);
        JxlsTest.assertEquals((String)"BA", (String)department.getName());
        JxlsTest.assertEquals((int)4, (int)department.getStaff().size());
    }
}

