/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.drools.util.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilsTest {
    private static final String TEST_FILE = "TestFile.txt";
    private static final String NOTEXISTING_FILE = "NotExisting.txt";

    @Test
    public void getFileExisting() {
        File retrieved = FileUtils.getFile((String)TEST_FILE);
        Assertions.assertThat((File)retrieved).exists();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(TEST_FILE);
    }

    @Test
    public void getFileNotExisting() {
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> FileUtils.getFile((String)NOTEXISTING_FILE));
    }

    @Test
    public void getFileInputStreamExisting() throws IOException {
        FileInputStream retrieved = FileUtils.getFileInputStream((String)TEST_FILE);
        Assertions.assertThat((InputStream)retrieved).isNotNull();
        retrieved.close();
    }

    @Test
    public void getFileInputStreamNotExisting() {
        Assert.assertThrows(RuntimeException.class, () -> FileUtils.getFileInputStream((String)NOTEXISTING_FILE));
    }
}

