/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.drools.util.ResourceHelper;
import org.junit.Test;

public class ResourceHelperTest {
    private static final String TEST_FILE = "TestFile.txt";

    @Test
    public void getResourcesByExtensionTest() {
        Collection resources = ResourceHelper.getResourcesByExtension((String)"txt");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)resources).hasSize(1)).anyMatch(elem -> elem.endsWith(TEST_FILE));
    }

    @Test
    public void getResourcesByExtensionExisting() {
        Collection retrieved = ResourceHelper.getFileResourcesByExtension((String)"txt");
        this.commonVerifyCollectionWithExpectedFile(retrieved, TEST_FILE);
    }

    @Test
    public void getResourcesByExtensionNotExisting() {
        Collection retrieved = ResourceHelper.getFileResourcesByExtension((String)"arg");
        this.commonVerifyCollectionWithoutExpectedFile(retrieved);
    }

    @Test
    public void getResourcesFromDirectoryTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        Optional<String> testFolder = classPathElements.stream().filter(elem -> elem.contains("test-classes")).findFirst();
        Assertions.assertThat((boolean)testFolder.isPresent()).isTrue();
        File dir = new File(testFolder.get());
        String regex = ".*TestFile.txt";
        Collection filesFound = ResourceHelper.getResourcesFromDirectory((File)dir, (Pattern)Pattern.compile(regex));
        Assertions.assertThat((Collection)filesFound).hasSize(1);
        Assertions.assertThat((Collection)ResourceHelper.getResourcesFromDirectory(null, null)).isEmpty();
        Assertions.assertThat((Collection)ResourceHelper.getResourcesFromDirectory((File)dir, (Pattern)Pattern.compile("noMatch"))).isEmpty();
    }

    @Test
    public void getResourcesFromDirectoryExisting() {
        File directory = new File("." + File.separator + "target" + File.separator + "test-classes");
        Pattern pattern = Pattern.compile(".*txt");
        Collection retrieved = ResourceHelper.getFileResourcesFromDirectory((File)directory, (Pattern)pattern);
        this.commonVerifyCollectionWithExpectedFile(retrieved, TEST_FILE);
    }

    @Test
    public void getResourcesFromDirectoryNotExisting() {
        File directory = new File("." + File.separator + "target" + File.separator + "test-classes");
        Pattern pattern = Pattern.compile(".*arg");
        Collection retrieved = ResourceHelper.getFileResourcesFromDirectory((File)directory, (Pattern)pattern);
        this.commonVerifyCollectionWithoutExpectedFile(retrieved);
    }

    @Test
    public void getClassPathElements() {
        Object[] retrieved = ResourceHelper.getClassPathElements();
        Assertions.assertThat((Object[])retrieved).isNotNull();
        Assertions.assertThat((retrieved.length == 0 ? 1 : 0) != 0).isFalse();
    }

    @Test
    public void getClassPathElementsTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        List notJar = classPathElements.stream().filter(elem -> !elem.contains(".jar")).collect(Collectors.toList());
        Assertions.assertThat((boolean)notJar.stream().anyMatch(elem -> elem.contains("test-classes"))).isTrue();
    }

    @Test
    public void internalGetResourcesTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        Optional<String> testFolder = classPathElements.stream().filter(elem -> elem.contains("test-classes")).findFirst();
        Assertions.assertThat((boolean)testFolder.isPresent()).isTrue();
        Collection filesFound = ResourceHelper.internalGetResources((String)testFolder.get(), (Pattern)Pattern.compile(".*\\.txt$"));
        Assertions.assertThat((int)filesFound.size()).isEqualTo(1);
        Assertions.assertThat((Collection)ResourceHelper.internalGetResources((String)((String)filesFound.iterator().next()), (Pattern)Pattern.compile(".*\\.txt$"))).isEmpty();
    }

    @Test
    public void internalGetResourcesExisting() {
        String path = "." + File.separator + "target" + File.separator + "test-classes";
        Pattern pattern = Pattern.compile(".*txt");
        Collection retrieved = ResourceHelper.internalGetFileResources((String)path, (Pattern)pattern);
        this.commonVerifyCollectionWithExpectedFile(retrieved, TEST_FILE);
    }

    @Test
    public void internalGetResourcesNotExisting() {
        String path = "." + File.separator + "target" + File.separator + "test-classes";
        Pattern pattern = Pattern.compile(".*arg");
        Collection retrieved = ResourceHelper.internalGetFileResources((String)path, (Pattern)pattern);
        this.commonVerifyCollectionWithoutExpectedFile(retrieved);
    }

    private void commonVerifyCollectionWithExpectedFile(Collection<File> toVerify, String expectedFile) {
        Assertions.assertThat(toVerify).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat(toVerify).hasSize(1)).allMatch(file -> file.exists() && file.getName().equals(expectedFile));
    }

    private void commonVerifyCollectionWithoutExpectedFile(Collection<File> toVerify) {
        Assertions.assertThat(toVerify).isNotNull();
        Assertions.assertThat(toVerify).isEmpty();
    }
}

