/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.util.ClassTypeResolver;
import org.junit.Test;

public class TypeResolverTest {
    @Test
    public void testResolvePrimtiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("boolean")).isEqualTo(Boolean.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("double")).isEqualTo(Double.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("float")).isEqualTo(Float.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("int")).isEqualTo(Integer.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("char")).isEqualTo(Character.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("long")).isEqualTo(Long.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("byte")).isEqualTo(Byte.TYPE);
        Assertions.assertThat((Class)resolver.resolveType("short")).isEqualTo(Short.TYPE);
    }

    @Test
    public void testResolveArrayOfPrimitiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("boolean[]")).isEqualTo(boolean[].class);
        Assertions.assertThat((Class)resolver.resolveType("double[]")).isEqualTo(double[].class);
        Assertions.assertThat((Class)resolver.resolveType("float[]")).isEqualTo(float[].class);
        Assertions.assertThat((Class)resolver.resolveType("int[]")).isEqualTo(int[].class);
        Assertions.assertThat((Class)resolver.resolveType("char[]")).isEqualTo(char[].class);
        Assertions.assertThat((Class)resolver.resolveType("long[]")).isEqualTo(long[].class);
        Assertions.assertThat((Class)resolver.resolveType("byte[]")).isEqualTo(byte[].class);
        Assertions.assertThat((Class)resolver.resolveType("short[]")).isEqualTo(short[].class);
    }

    @Test
    public void testResolveMultidimensionnalArrayOfPrimitiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Class)resolver.resolveType("int[][]")).isEqualTo(int[][].class);
        Assertions.assertThat((Class)resolver.resolveType("int[][][]")).isEqualTo(int[][][].class);
        Assertions.assertThat((Class)resolver.resolveType("int[][][][]")).isEqualTo(int[][][][].class);
    }

    @Test
    public void testResolveParametrizedTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Type type = resolver.resolveParametrizedType("java.util.Map<Integer, java.util.List<String>>");
        Assertions.assertThat((Object)type).isInstanceOf(ParameterizedType.class);
        Assertions.assertThat((Object)((ParameterizedType)type).getRawType()).isEqualTo(Map.class);
        Assertions.assertThat((int)((ParameterizedType)type).getActualTypeArguments().length).isEqualTo(2);
        Assertions.assertThat((Object)((ParameterizedType)type).getActualTypeArguments()[0]).isEqualTo(Integer.class);
        Assertions.assertThat((Object)((ParameterizedType)type).getActualTypeArguments()[1]).isInstanceOf(ParameterizedType.class);
        Assertions.assertThat((Object)((ParameterizedType)((ParameterizedType)type).getActualTypeArguments()[1]).getRawType()).isEqualTo(List.class);
        Assertions.assertThat((int)((ParameterizedType)((ParameterizedType)type).getActualTypeArguments()[1]).getActualTypeArguments().length).isEqualTo(1);
        Assertions.assertThat((Object)((ParameterizedType)((ParameterizedType)type).getActualTypeArguments()[1]).getActualTypeArguments()[0]).isEqualTo(String.class);
    }

    @Test
    public void testResolveParametrizedTypesWithWildcardFallbackToRaw() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Type type = resolver.resolveParametrizedType("java.util.Map<? extends Number, java.util.List<String>>");
        Assertions.assertThat((Object)type).isEqualTo(Map.class);
    }
}

