/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.bitmask;

import org.assertj.core.api.Assertions;
import org.drools.util.bitmask.AllSetBitMask;
import org.drools.util.bitmask.AllSetButLastBitMask;
import org.drools.util.bitmask.BitMask;
import org.drools.util.bitmask.EmptyBitMask;
import org.drools.util.bitmask.EmptyButLastBitMask;
import org.drools.util.bitmask.LongBitMask;
import org.drools.util.bitmask.OpenBitSet;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LongBitMaskTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSet() {
        Assertions.assertThat((String)new LongBitMask().set(0).toString()).isEqualTo("1");
        Assertions.assertThat((String)new LongBitMask().set(1).toString()).isEqualTo("2");
        Assertions.assertThat((String)new LongBitMask().set(65).toString()).isEqualTo("0, 2");
    }

    @Test
    public void testSetAll() {
        Assertions.assertThat((String)new LongBitMask().setAll((BitMask)new LongBitMask()).toString()).isEqualTo("0");
        Assertions.assertThat((String)new LongBitMask().setAll((BitMask)AllSetBitMask.get()).toString()).isEqualTo("-1");
        Assertions.assertThat((String)new LongBitMask().setAll((BitMask)AllSetButLastBitMask.get()).toString()).isEqualTo("9223372036854775807");
        Assertions.assertThat((String)new LongBitMask(1L).setAll((BitMask)AllSetButLastBitMask.get()).toString()).isEqualTo("-1");
        Assertions.assertThat((String)new LongBitMask().setAll((BitMask)new OpenBitSet()).toString()).isEqualTo("0");
        Assertions.assertThat((String)new LongBitMask().setAll((BitMask)EmptyButLastBitMask.get()).toString()).isEqualTo("1");
        Assertions.assertThat((String)new LongBitMask().setAll((BitMask)EmptyBitMask.get()).toString()).isEqualTo("0");
    }

    @Test
    public void testReset() {
        Assertions.assertThat((String)new LongBitMask().reset(0).toString()).isEqualTo("0");
        Assertions.assertThat((String)new LongBitMask().reset(1).toString()).isEqualTo("0");
        Assertions.assertThat((String)new LongBitMask().reset(65).toString()).isEqualTo("0");
    }

    @Test
    public void testResetAll() {
        Assertions.assertThat((String)new LongBitMask().resetAll((BitMask)new LongBitMask()).toString()).isEqualTo("0");
        Assertions.assertThat((String)new LongBitMask().resetAll((BitMask)AllSetBitMask.get()).toString()).isEqualTo("0");
        Assertions.assertThat((String)new LongBitMask().resetAll((BitMask)AllSetButLastBitMask.get()).toString()).isEqualTo("0");
        Assertions.assertThat((String)new LongBitMask().resetAll((BitMask)EmptyButLastBitMask.get()).toString()).isEqualTo("0");
        Assertions.assertThat((String)new LongBitMask().resetAll((BitMask)EmptyBitMask.get()).toString()).isEqualTo("0");
        this.thrown.expect(RuntimeException.class);
        new LongBitMask().resetAll((BitMask)new OpenBitSet()).toString();
    }

    @Test
    public void testIsSet() {
        Assertions.assertThat((boolean)new LongBitMask().set(1).isSet(0)).isFalse();
        Assertions.assertThat((boolean)new LongBitMask().set(1).isSet(1)).isTrue();
    }

    @Test
    public void testIsAllSet() {
        Assertions.assertThat((boolean)new LongBitMask().isAllSet()).isFalse();
        Assertions.assertThat((boolean)new LongBitMask(-1L).isAllSet()).isTrue();
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertThat((boolean)new LongBitMask(1L).isEmpty()).isFalse();
        Assertions.assertThat((boolean)new LongBitMask(0L).isEmpty()).isTrue();
    }

    @Test
    public void testIntersects() {
        Assertions.assertThat((boolean)new LongBitMask(0L).intersects((BitMask)EmptyBitMask.get())).isFalse();
        Assertions.assertThat((boolean)new LongBitMask(0L).intersects((BitMask)new LongBitMask(0L))).isFalse();
        Assertions.assertThat((boolean)new LongBitMask(2L).intersects((BitMask)new LongBitMask(2L))).isTrue();
    }

    @Test
    public void testClone() {
        Assertions.assertThat((long)new LongBitMask(1L).clone().asLong()).isEqualTo(1L);
    }

    @Test
    public void testGetInstancingStatement() {
        Assertions.assertThat((String)new LongBitMask(0L).getInstancingStatement()).isEqualTo("org.drools.util.bitmask.EmptyBitMask.get()");
        Assertions.assertThat((String)new LongBitMask(1L).getInstancingStatement()).isEqualTo("org.drools.util.bitmask.EmptyButLastBitMask.get()");
        Assertions.assertThat((String)new LongBitMask(Long.MAX_VALUE).getInstancingStatement()).isEqualTo("org.drools.util.bitmask.AllSetButLastBitMask.get()");
        Assertions.assertThat((String)new LongBitMask(-1L).getInstancingStatement()).isEqualTo("org.drools.util.bitmask.AllSetBitMask.get()");
        Assertions.assertThat((String)new LongBitMask(2L).getInstancingStatement()).isEqualTo("new org.drools.util.bitmask.LongBitMask(2L)");
    }
}

