/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.util.FileUtils;
import org.junit.Test;

public class FileUtilsTest {
    private static final String TEST_FILE = "TestFile.txt";
    private static final String NOT_EXISTING_FILE = "NotExisting.txt";

    @Test
    public void getFileExisting() {
        File retrieved = FileUtils.getFile((String)TEST_FILE);
        Assertions.assertThat((File)retrieved).exists();
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(TEST_FILE);
    }

    @Test
    public void getFileNotExisting() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> FileUtils.getFile((String)NOT_EXISTING_FILE));
    }

    @Test
    public void getFileInputStreamExisting() throws IOException {
        FileInputStream retrieved = FileUtils.getFileInputStream((String)TEST_FILE);
        Assertions.assertThat((InputStream)retrieved).isNotNull();
        retrieved.close();
    }

    @Test
    public void getFileInputStreamNotExisting() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> FileUtils.getFileInputStream((String)NOT_EXISTING_FILE));
    }

    @Test
    public void getInputStreamFromFileNameExisting() {
        Optional retrieved = FileUtils.getInputStreamFromFileNameAndClassLoader((String)TEST_FILE, (ClassLoader)FileUtilsTest.class.getClassLoader());
        Assertions.assertThat((Optional)retrieved).isPresent();
    }

    @Test
    public void getInputStreamFromFileNameNotExisting() {
        Optional retrieved = FileUtils.getInputStreamFromFileNameAndClassLoader((String)NOT_EXISTING_FILE, (ClassLoader)FileUtilsTest.class.getClassLoader());
        Assertions.assertThat((Optional)retrieved).isNotPresent();
    }

    @Test
    public void deleteDirectory() throws IOException {
        Path tempDirectory = Files.createTempDirectory("temp", new FileAttribute[0]);
        Path tempFile = Files.createTempFile(tempDirectory, "temp", "temp", new FileAttribute[0]);
        FileUtils.deleteDirectory((Path)tempDirectory);
        Assertions.assertThat((boolean)Files.exists(tempDirectory, new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.exists(tempFile, new LinkOption[0])).isFalse();
    }
}

