/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.cache.RuleInspectorCache;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.AnalyzerConfigurationMock;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.CheckFactory;
import org.drools.verifier.core.checks.base.CheckRunManager;
import org.drools.verifier.core.checks.base.CheckRunner;
import org.drools.verifier.core.checks.base.CheckStorage;
import org.drools.verifier.core.checks.base.JavaCheckRunner;
import org.drools.verifier.core.checks.base.SingleCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.Rule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CheckRunManagerTest {
    @Spy
    private CheckRunManager checkRunManager = new CheckRunManager((CheckRunner)new JavaCheckRunner());
    @Mock
    private RuleInspectorCache cache;
    private RuleInspector ruleInspector1;
    private RuleInspector ruleInspector2;
    private RuleInspector ruleInspector3;
    private ArrayList<RuleInspector> ruleInspectors;
    private CheckStorage checkStorage;
    private AnalyzerConfiguration configuration;

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.checkStorage = new CheckStorage(new CheckFactory(this.configuration){

            public HashSet<Check> makeSingleChecks(RuleInspector ruleInspector) {
                HashSet<Check> result = new HashSet<Check>();
                result.add((Check)new MockSingleCheck(ruleInspector));
                return result;
            }
        });
        this.ruleInspectors = new ArrayList();
        Mockito.when((Object)this.cache.all()).thenReturn(this.ruleInspectors);
        this.ruleInspector1 = this.mockRowInspector(1);
        this.ruleInspectors.add(this.ruleInspector1);
        this.ruleInspector2 = this.mockRowInspector(2);
        this.ruleInspectors.add(this.ruleInspector2);
        this.ruleInspector3 = this.mockRowInspector(3);
        this.ruleInspectors.add(this.ruleInspector3);
        this.checkRunManager.addChecks(this.ruleInspector1.getChecks());
        this.checkRunManager.addChecks(this.ruleInspector2.getChecks());
        this.checkRunManager.addChecks(this.ruleInspector3.getChecks());
    }

    @Test
    public void testChecksGetGenerated() throws Exception {
        Assert.assertEquals((long)5L, (long)this.ruleInspector1.getChecks().size());
        Assert.assertEquals((long)5L, (long)this.ruleInspector2.getChecks().size());
        Assert.assertEquals((long)5L, (long)this.ruleInspector3.getChecks().size());
    }

    @Test
    public void testRemove() throws Exception {
        this.checkRunManager.remove(this.ruleInspector2);
        Set checks = this.ruleInspector1.getChecks();
        Assert.assertEquals((long)3L, (long)checks.size());
        Assert.assertTrue((boolean)this.ruleInspector2.getChecks().isEmpty());
        Assert.assertEquals((long)3L, (long)this.ruleInspector3.getChecks().size());
    }

    @Test
    public void testRunTests() throws Exception {
        for (RuleInspector ruleInspector : this.cache.all()) {
            this.assertNoIssues(ruleInspector);
        }
        this.checkRunManager.run(null, null);
        for (RuleInspector ruleInspector : this.cache.all()) {
            this.assertHasIssues(ruleInspector);
        }
    }

    @Test
    public void testOnlyTestChanges() throws Exception {
        this.checkRunManager.run(null, null);
        RuleInspector newRuleInspector = this.mockRowInspector(3);
        this.ruleInspectors.add(newRuleInspector);
        this.checkRunManager.addChecks(newRuleInspector.getChecks());
        this.assertNoIssues(newRuleInspector);
        this.checkRunManager.run(null, null);
        this.assertHasIssues(newRuleInspector);
        Assert.assertEquals((long)7L, (long)this.ruleInspector1.getChecks().size());
        Assert.assertEquals((long)7L, (long)newRuleInspector.getChecks().size());
    }

    private RuleInspector mockRowInspector(int rowNumber) {
        return new RuleInspector(new Rule(Integer.valueOf(rowNumber), this.configuration), this.checkStorage, this.cache, (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
    }

    private void assertHasIssues(RuleInspector ruleInspector) {
        for (Check check : ruleInspector.getChecks()) {
            Assert.assertTrue((boolean)check.hasIssues());
        }
    }

    private void assertNoIssues(RuleInspector ruleInspector) {
        for (Check check : ruleInspector.getChecks()) {
            Assert.assertFalse((boolean)check.hasIssues());
        }
    }

    private class MockSingleCheck
    extends SingleCheck {
        public MockSingleCheck(RuleInspector ruleInspector) {
            super(ruleInspector, CheckRunManagerTest.this.configuration, CheckType.REDUNDANT_ROWS);
        }

        public boolean check() {
            this.hasIssues = true;
            return true;
        }

        protected Severity getDefaultSeverity() {
            return Severity.NOTE;
        }

        protected Issue makeIssue(Severity severity, CheckType checkType) {
            return new Issue(severity, checkType, Collections.emptySet());
        }
    }
}

