/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.checks.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class NumericIntegerConditionInspectorSubsumptionResolverTest {
    private final Integer value1;
    private final Integer value2;
    private final String operator1;
    private final String operator2;
    private final boolean redundancyExpected;
    private final Field field = (Field)Mockito.mock(Field.class);

    public NumericIntegerConditionInspectorSubsumptionResolverTest(String operator1, Integer value1, String operator2, Integer value2, boolean redundancyExpected) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.redundancyExpected = redundancyExpected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true}, {"!=", 0, "!=", 0, true}, {">", 0, ">", 0, true}, {">=", 0, ">=", 0, true}, {"<", 0, "<", 0, true}, {"<=", 0, "<=", 0, true}, {"==", 0, "==", 1, false}, {"!=", 0, "!=", 1, false}, {">", 0, ">", 1, false}, {">=", 0, ">=", 1, false}, {"<", 0, "<", 1, false}, {"<=", 0, "<=", 1, false}, {"==", 0, "!=", 0, false}, {"==", 0, ">", 0, false}, {"==", 0, ">=", 0, false}, {"==", 0, "<", 0, false}, {"==", 0, "<=", 0, false}, {"!=", 0, ">", 0, false}, {"!=", 0, ">=", 0, false}, {"!=", 0, "<", 0, false}, {"!=", 0, "<=", 0, false}, {">", 0, ">=", 0, false}, {">", 0, "<", 0, false}, {">", 0, "<=", 0, false}, {">=", 0, "<", 0, false}, {">=", 0, "<=", 0, false}, {"<", 0, "<=", 0, false}, {"==", 0, "!=", 1, false}, {"==", 0, ">", 1, false}, {"==", 0, ">=", 1, false}, {"==", 0, "<", 1, false}, {"==", 0, "<=", 1, false}, {"!=", 0, ">", 1, false}, {"!=", 0, ">=", 1, false}, {"!=", 0, "<", 1, false}, {"!=", 0, "<=", 1, false}, {">", 0, ">=", 1, true}, {">", 0, "<", 1, false}, {">", 0, "<=", 1, false}, {">=", 0, "<", 1, false}, {">=", 0, "<=", 1, false}, {"<", 0, "<=", 1, false}, {">", 0, ">=", 1, true}, {"<", 1, "<=", 0, true});
    }

    @Test
    public void parametrizedTest() {
        NumericIntegerConditionInspector a = this.getCondition(this.value1, this.operator1);
        NumericIntegerConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.redundancyExpected), (Object)this.redundancyExpected, (Object)a.isRedundant((Object)b));
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.redundancyExpected), (Object)this.redundancyExpected, (Object)b.isRedundant((Object)a));
    }

    private String getAssertDescription(NumericIntegerConditionInspector a, NumericIntegerConditionInspector b, boolean conflictExpected) {
        return String.format("Expected conditions '%s' and '%s' %sto be redundant:", a.toHumanReadableString(), b.toHumanReadableString(), conflictExpected ? "" : "not ");
    }

    private NumericIntegerConditionInspector getCondition(int value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new NumericIntegerConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{Integer.valueOf(value)}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

