/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.checks.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorConflictResolverOverlapTest {
    private final Values value1;
    private final Values value2;
    private final String operator1;
    private final String operator2;
    private final boolean conflictExpected;
    private final boolean overlapExpected;
    private final Field field = (Field)Mockito.mock(Field.class);

    public StringConditionInspectorConflictResolverOverlapTest(String operator1, Values value1, String operator2, Values value2, boolean conflictExpected, boolean overlapExpected) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.conflictExpected = conflictExpected;
        this.overlapExpected = overlapExpected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", new Values(new Comparable[]{"a"}), "==", new Values(new Comparable[]{"a"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), false, true}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"a", "b"}), false, true}, {"not in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"a", "b"}), false, true}, {"matches", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, true}, {"soundslike", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"b"}), false, true}, {"==", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{" "}), false, false}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"b"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), true, false}, {"==", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c", "d"}), true, false}, {"==", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), true, false}, {"==", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{" "}), false, false}, {"!=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true, false}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"c"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, false}, {">", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {">", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"0", "1", "A", "B", "a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{""}), false, false}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{" "}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {">=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"0", "1", "A", "B"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"A"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{""}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"A", "B", "a", "b"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"A"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{""}), false, false}, {"<", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"A", "B", "a", "b"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"A"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{""}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, false}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"in", new Values(new Comparable[]{"a", "b"}), "matches", new Values(new Comparable[]{"a"}), false, true}, {"in", new Values(new Comparable[]{"a", "b"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"c", "d"}), true, false}, {"in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"a", "b"}), true, false}, {"in", new Values(new Comparable[]{"a", "b"}), "matches", new Values(new Comparable[]{"c"}), true, false}, {"in", new Values(new Comparable[]{"a", "b"}), "soundslike", new Values(new Comparable[]{"c"}), true, false}, {"not in", new Values(new Comparable[]{"a", "b"}), "matches", new Values(new Comparable[]{"c"}), false, true}, {"not in", new Values(new Comparable[]{"a", "b"}), "soundslike", new Values(new Comparable[]{"c"}), false, true}, {"not in", new Values(new Comparable[]{"a", "b"}), "matches", new Values(new Comparable[]{"a"}), true, false}, {"matches", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"matches", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true});
    }

    @Test
    public void parametrizedConflictTest() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator1);
        StringConditionInspector b = this.getCondition(this.value2, this.operator2);
        boolean conflicts = a.conflicts((Object)b);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.conflictExpected, "conflict"), (Object)this.conflictExpected, (Object)conflicts);
        boolean conflicts1 = b.conflicts((Object)a);
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.conflictExpected, "conflict"), (Object)this.conflictExpected, (Object)conflicts1);
    }

    @Test
    public void parametrizedOverlapTest() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator1);
        StringConditionInspector b = this.getCondition(this.value2, this.operator2);
        boolean overlaps = a.overlaps((Object)b);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.overlapExpected, "overlap"), (Object)this.overlapExpected, (Object)overlaps);
        boolean overlaps1 = b.overlaps((Object)a);
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.overlapExpected, "overlap"), (Object)this.overlapExpected, (Object)overlaps1);
    }

    private StringConditionInspector getCondition(Values values, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new StringConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, values, (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }

    private String getAssertDescription(StringConditionInspector a, StringConditionInspector b, boolean conflictExpected, String condition) {
        return String.format("Expected condition '%s' %sto %s with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", condition, b.toHumanReadableString());
    }
}

