/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors;

import org.drools.verifier.core.cache.inspectors.FieldInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.verifier.core.checks.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.ObjectField;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class FieldInspectorRelationsTest {
    private AnalyzerConfigurationMock configurationMock;
    private FieldInspector a;
    private FieldInspector b;

    @Before
    public void setUp() throws Exception {
        this.configurationMock = new AnalyzerConfigurationMock();
        ObjectField objectField = (ObjectField)Mockito.mock(ObjectField.class);
        this.a = new FieldInspector(new Field(objectField, "org.Person", "String", "name", (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        this.b = new FieldInspector(new Field(objectField, "org.Person", "String", "name", (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
    }

    @Test
    public void testRedundancy01() throws Exception {
        Assert.assertTrue((boolean)this.a.isRedundant((Object)this.b));
        Assert.assertTrue((boolean)this.b.isRedundant((Object)this.a));
    }

    @Test
    public void testRedundancy02() throws Exception {
        FieldInspector x = new FieldInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.Address", "String", "name", (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        Assert.assertFalse((boolean)x.isRedundant((Object)this.b));
        Assert.assertFalse((boolean)this.b.isRedundant((Object)x));
    }

    @Test
    public void testSubsumpt01() throws Exception {
        Assert.assertTrue((boolean)this.a.subsumes((Object)this.b));
        Assert.assertTrue((boolean)this.b.subsumes((Object)this.a));
    }

    @Test
    public void testSubsumpt02() throws Exception {
        FieldInspector x = new FieldInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.Address", "String", "name", (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        Assert.assertFalse((boolean)x.subsumes((Object)this.b));
        Assert.assertFalse((boolean)this.b.subsumes((Object)x));
    }
}

