/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.checks.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.verifier.core.relations.Operator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorCoverTest {
    private final Values<String> value1;
    private final Values<String> value2;
    private final String operator;
    private final boolean covers;
    private final Field field = (Field)Mockito.mock(Field.class);

    public StringConditionInspectorCoverTest(Values<String> value1, String operator, Values<String> value2, boolean covers) {
        this.operator = operator;
        this.value1 = value1;
        this.value2 = value2;
        this.covers = covers;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({new Values(new Comparable[]{"toni"}), Operator.EQUALS.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.MATCHES.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.SOUNDSLIKE.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni", "eder"}), Operator.IN.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.GREATER_OR_EQUAL.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.LESS_OR_EQUAL.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni"}), Operator.LESS_THAN.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni"}), Operator.GREATER_THAN.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni"}), Operator.EQUALS.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni"}), Operator.MATCHES.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni"}), Operator.SOUNDSLIKE.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni", "eder"}), Operator.IN.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni"}), Operator.GREATER_OR_EQUAL.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni"}), Operator.LESS_OR_EQUAL.toString(), new Values(new Comparable[]{"michael"}), false}, {new Values(new Comparable[]{"toni", "eder"}), Operator.NOT_IN.toString(), new Values(new Comparable[]{"michael"}), true}, {new Values(new Comparable[]{"toni", "eder"}), Operator.NOT_IN.toString(), new Values(new Comparable[]{"eder"}), false}, {new Values(new Comparable[]{"toni"}), Operator.NOT_EQUALS.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni"}), Operator.NOT_EQUALS.toString(), new Values(new Comparable[]{"eder"}), true}, {new Values(new Comparable[]{"toni"}), Operator.NOT_MATCHES.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni"}), Operator.NOT_MATCHES.toString(), new Values(new Comparable[]{"eder"}), true}, {new Values(new Comparable[]{"toni rikkola"}), Operator.STR_ENDS_WITH.toString(), new Values(new Comparable[]{"rikkola"}), true}, {new Values(new Comparable[]{"toni rikkola"}), Operator.STR_ENDS_WITH.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"toni rikkola"}), Operator.STR_STARTS_WITH.toString(), new Values(new Comparable[]{"toni"}), true}, {new Values(new Comparable[]{"toni rikkola"}), Operator.STR_STARTS_WITH.toString(), new Values(new Comparable[]{"rikkola"}), false}, {new Values(new Comparable[]{"array"}), Operator.CONTAINS.toString(), new Values(new Comparable[]{"toni", "eder"}), false}, {new Values(new Comparable[]{"array"}), Operator.CONTAINS.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"array"}), Operator.CONTAINS.toString(), new Values(new Comparable[]{"eder"}), false}, {new Values(new Comparable[]{"array"}), Operator.NOT_CONTAINS.toString(), new Values(new Comparable[]{"toni", "eder"}), false}, {new Values(new Comparable[]{"array"}), Operator.NOT_CONTAINS.toString(), new Values(new Comparable[]{"toni"}), false}, {new Values(new Comparable[]{"array"}), Operator.NOT_CONTAINS.toString(), new Values(new Comparable[]{"eder"}), false});
    }

    @Test
    public void parametrizedTest() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator);
        Assert.assertEquals((String)this.getAssertDescription(a, this.covers, (String)this.value2.iterator().next()), (Object)this.covers, (Object)a.covers((Comparable)this.value2.iterator().next()));
    }

    private StringConditionInspector getCondition(Values<String> values, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new StringConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, values, (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }

    private String getAssertDescription(StringConditionInspector a, boolean covers, String condition) {
        return String.format("Expected condition '%s' to %s cover '%s':", a.toHumanReadableString(), covers ? "" : "not ", condition);
    }
}

