/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.verifier.core.checks.base.CheckBase;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.verifier.core.index.model.ObjectField;
import org.drools.verifier.core.relations.Operator;

public class SingleRangeCheck
extends CheckBase {
    private List<RangeError> errors = new ArrayList<RangeError>();
    private final Collection<RuleInspector> ruleInspectors;

    public SingleRangeCheck(AnalyzerConfiguration configuration, Collection<RuleInspector> ruleInspectors) {
        super(configuration);
        this.ruleInspectors = ruleInspectors;
    }

    @Override
    public boolean check() {
        if (this.ruleInspectors == null || this.ruleInspectors.isEmpty()) {
            this.hasIssues = false;
            return false;
        }
        this.errors.clear();
        int conditionNr = this.ruleInspectors.iterator().next().getConditionsInspectors().size();
        for (int i = 0; i < conditionNr; ++i) {
            this.checkCondition(i);
        }
        this.hasIssues = !this.errors.isEmpty();
        return this.hasIssues;
    }

    private void checkCondition(int conditionIndex) {
        Map fields = this.ruleInspectors.stream().map(r -> (ConditionsInspectorMultiMap)r.getConditionsInspectors().get(conditionIndex)).flatMap(cond -> cond.keySet().stream()).collect(Collectors.groupingBy(f -> this.getFieldOperatorType((ObjectField)f, conditionIndex), Collectors.toSet()));
        Set<ObjectField> rangeFields = fields.get((Object)OperatorType.RANGE);
        if (rangeFields != null && !rangeFields.isEmpty()) {
            this.checkRanges(rangeFields, this.partition(fields.get((Object)OperatorType.PARTITION), this.ruleInspectors, conditionIndex), conditionIndex);
        }
    }

    private void checkRanges(Collection<ObjectField> rangeFields, Map<PartitionKey, List<RuleInspector>> partitions, int conditionIndex) {
        for (Map.Entry<PartitionKey, List<RuleInspector>> partition : partitions.entrySet()) {
            ArrayList dimensions = new ArrayList();
            for (ObjectField field : rangeFields) {
                if ("Integer".equals(field.getFieldType())) {
                    this.checkMonodimensionalRange(partition, dimensions, field, conditionIndex, IntegerRange::new, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    continue;
                }
                this.checkMonodimensionalRange(partition, dimensions, field, conditionIndex, NumericRange::new, Double.MIN_VALUE, Double.MAX_VALUE);
            }
            this.checkBidimensionalRanges(partition, dimensions);
        }
    }

    private <T extends Comparable> void checkMonodimensionalRange(Map.Entry<PartitionKey, List<RuleInspector>> partition, List<List<? extends Range<?>>> dimensions, ObjectField field, int conditionIndex, Function<List<ConditionInspector>, Range<T>> rangeSupplier, T min, T max) {
        List ranges = partition.getValue().stream().map(r -> (ConditionsInspectorMultiMap)r.getConditionsInspectors().get(conditionIndex)).map(c -> c.get(field)).map(rangeSupplier).collect(Collectors.toList());
        T upper = this.getCoverageUpperBound(min, ranges);
        if (upper.equals(max)) {
            dimensions.add(ranges);
        } else {
            this.errors.add(new RangeError(partition.getValue(), partition.getKey(), upper));
        }
    }

    private void checkBidimensionalRanges(Map.Entry<PartitionKey, List<RuleInspector>> partition, List<List<? extends Range<?>>> dimensions) {
        if (this.errors.isEmpty() && dimensions.size() >= 2) {
            for (int i = 0; i < dimensions.size() - 1; ++i) {
                for (int j = i + 1; j < dimensions.size(); ++j) {
                    if (this.checkBidimensionalRanges(dimensions.get(i), dimensions.get(j))) continue;
                    this.errors.add(new RangeError(partition.getValue(), partition.getKey(), null));
                }
            }
        }
    }

    private <H extends Comparable, V extends Comparable> boolean checkBidimensionalRanges(List<? extends Range<? extends H>> hRanges, List<? extends Range<? extends V>> vRanges) {
        List bidiRanges = IntStream.range(0, hRanges.size()).mapToObj(i -> new BidimensionalRange((Range)hRanges.get(i), (Range)vRanges.get(i))).sorted(Comparator.comparing(r -> ((BidimensionalRange)r).horizontal)).collect(Collectors.toList());
        TreeSet hBreakPoints = new TreeSet();
        HashMap<Comparable, List> lowerHBounds = new HashMap<Comparable, List>();
        HashMap<Comparable, List> upperHBounds = new HashMap<Comparable, List>();
        for (BidimensionalRange bidiRange : bidiRanges) {
            Range hRange = bidiRange.horizontal;
            hBreakPoints.add(hRange.lowerBound);
            lowerHBounds.computeIfAbsent((Comparable)hRange.lowerBound, x -> new ArrayList()).add(bidiRange);
            if (hRange.upperBound.equals(hRange.maxValue())) continue;
            hBreakPoints.add(hRange.upperBound);
            upperHBounds.computeIfAbsent((Comparable)hRange.upperBound, x -> new ArrayList()).add(bidiRange);
        }
        V minV = vRanges.get(0).minValue();
        V maxV = vRanges.get(0).maxValue();
        boolean first = true;
        ArrayList parsedRanges = new ArrayList();
        for (Comparable sweep : hBreakPoints) {
            List exitingRanges;
            List enteringRanges = (List)lowerHBounds.get(sweep);
            if (enteringRanges != null) {
                parsedRanges.addAll(enteringRanges);
            }
            if ((exitingRanges = (List)upperHBounds.get(sweep)) != null) {
                parsedRanges.removeAll(exitingRanges);
            }
            if ((first || exitingRanges != null) && !maxV.equals(this.getCoverageUpperBound((Comparable)minV, (Stream)parsedRanges.stream().map(br -> ((BidimensionalRange)br).vertical)))) {
                return false;
            }
            first = false;
        }
        return true;
    }

    private OperatorType getFieldOperatorType(ObjectField field, int conditionIndex) {
        return this.ruleInspectors.stream().flatMap(r -> this.getConditionStream((RuleInspector)r, field, conditionIndex)).map(c -> Operator.resolve(((FieldCondition)c.getCondition()).getOperator())).map(OperatorType::decode).reduce(OperatorType.PARTITION, OperatorType::combine);
    }

    private Map<PartitionKey, List<RuleInspector>> partition(Collection<ObjectField> partitionFields, Collection<RuleInspector> rules, int conditionIndex) {
        ArrayList keysWithNull = new ArrayList();
        HashMap<PartitionKey, List<RuleInspector>> partitions = new HashMap<PartitionKey, List<RuleInspector>>();
        for (RuleInspector rule : rules) {
            PartitionKey key = this.getPartitionKey(partitionFields, rule, conditionIndex);
            partitions.computeIfAbsent(key, k -> {
                if (k.hasNulls()) {
                    keysWithNull.add(k);
                }
                return new ArrayList();
            }).add(rule);
        }
        for (PartitionKey key : keysWithNull) {
            for (Map.Entry partition : partitions.entrySet()) {
                if (!key.subsumes((PartitionKey)partition.getKey())) continue;
                ((List)partition.getValue()).addAll((Collection)partitions.get(key));
            }
        }
        keysWithNull.forEach(partitions::remove);
        return partitions;
    }

    private PartitionKey getPartitionKey(Collection<ObjectField> partitionFields, RuleInspector rule, int conditionIndex) {
        return partitionFields == null || partitionFields.isEmpty() ? PartitionKey.EMPTY_KEY : new PartitionKey(partitionFields.stream().map(f -> this.getValue(rule, (ObjectField)f, conditionIndex)).toArray());
    }

    private Object getValue(RuleInspector rule, ObjectField field, int conditionIndex) {
        List<ConditionInspector> conditions = this.getConditions(rule, field, conditionIndex);
        return conditions != null ? conditions.get(0).getCondition().getValues().iterator().next() : null;
    }

    private Stream<ConditionInspector> getConditionStream(RuleInspector rule, ObjectField field, int conditionIndex) {
        List<ConditionInspector> conditionInspectors = this.getConditions(rule, field, conditionIndex);
        return conditionInspectors != null ? conditionInspectors.stream() : Stream.empty();
    }

    private List<ConditionInspector> getConditions(RuleInspector rule, ObjectField field, int conditionIndex) {
        return rule.getConditionsInspectors() != null ? ((ConditionsInspectorMultiMap)rule.getConditionsInspectors().get(conditionIndex)).get(field) : null;
    }

    private <T extends Comparable> T getCoverageUpperBound(T lowerBound, List<? extends Range<? extends T>> ranges) {
        return this.getCoverageUpperBound(lowerBound, ranges.stream());
    }

    private <T extends Comparable> T getCoverageUpperBound(T lowerBound, Stream<? extends Range<? extends T>> ranges) {
        T limit = lowerBound;
        Iterator i = ranges.sorted().iterator();
        while (i.hasNext()) {
            Range range = (Range)i.next();
            if (range.lowerBound.compareTo(limit) > 0) {
                return limit;
            }
            limit = range.upperBound.compareTo(limit) > 0 ? range.upperBound : limit;
        }
        return limit;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return this.errors.get(0).toIssue(severity, checkType);
    }

    @Override
    protected CheckType getCheckType() {
        return CheckType.MISSING_RANGE;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.NOTE;
    }

    private static class RangeError {
        private final Collection<RuleInspector> ruleInspectors;
        private final PartitionKey partitionKey;
        private final Object uncoveredValue;

        private RangeError(Collection<RuleInspector> ruleInspectors, PartitionKey partitionKey, Object uncoveredValue) {
            this.ruleInspectors = ruleInspectors;
            this.partitionKey = partitionKey;
            this.uncoveredValue = uncoveredValue;
        }

        private Issue toIssue(Severity severity, CheckType checkType) {
            return new Issue(severity, checkType, new HashSet(this.ruleInspectors.stream().map(r -> r.getRowIndex() + 1).collect(Collectors.toSet()))).setDebugMessage(this.getMessage());
        }

        private String getMessage() {
            return "Uncovered range" + (this.uncoveredValue != null ? " starting from value " + this.uncoveredValue : "") + (this.partitionKey != PartitionKey.EMPTY_KEY ? " in partition " + this.partitionKey : "");
        }
    }

    private static class BidimensionalRange<H extends Comparable, V extends Comparable> {
        private final Range<? extends H> horizontal;
        private final Range<? extends V> vertical;

        private BidimensionalRange(Range<? extends H> horizontal, Range<? extends V> vertical) {
            this.horizontal = horizontal;
            this.vertical = vertical;
        }

        public String toString() {
            return "[" + this.horizontal + "][" + this.vertical + "]";
        }
    }

    private static class NumericRange
    extends Range<Double>
    implements Comparable<Range<Double>> {
        NumericRange(List<ConditionInspector> conditionInspectors) {
            super(conditionInspectors);
        }

        @Override
        protected Consumer<ConditionInspector> getConditionParser() {
            return c -> {
                FieldCondition cond = (FieldCondition)c.getCondition();
                Operator op = Operator.resolve(cond.getOperator());
                switch (op) {
                    case LESS_OR_EQUAL: 
                    case LESS_THAN: {
                        this.upperBound = Double.valueOf(((Number)cond.getValues().iterator().next()).doubleValue());
                        break;
                    }
                    case GREATER_OR_EQUAL: 
                    case GREATER_THAN: {
                        this.lowerBound = Double.valueOf(((Number)cond.getValues().iterator().next()).doubleValue());
                    }
                }
            };
        }

        @Override
        protected Double minValue() {
            return Double.MIN_VALUE;
        }

        @Override
        protected Double maxValue() {
            return Double.MAX_VALUE;
        }
    }

    private static class IntegerRange
    extends Range<Integer>
    implements Comparable<Range<Integer>> {
        IntegerRange(List<ConditionInspector> conditionInspectors) {
            super(conditionInspectors);
        }

        @Override
        protected Consumer<ConditionInspector> getConditionParser() {
            return c -> {
                FieldCondition cond = (FieldCondition)c.getCondition();
                Operator op = Operator.resolve(cond.getOperator());
                switch (op) {
                    case LESS_OR_EQUAL: {
                        this.upperBound = Integer.valueOf((Integer)cond.getValues().iterator().next() + 1);
                        break;
                    }
                    case LESS_THAN: {
                        this.upperBound = (Integer)cond.getValues().iterator().next();
                        break;
                    }
                    case GREATER_OR_EQUAL: {
                        this.lowerBound = Integer.valueOf((Integer)cond.getValues().iterator().next() - 1);
                        break;
                    }
                    case GREATER_THAN: {
                        this.lowerBound = (Integer)cond.getValues().iterator().next();
                        break;
                    }
                    case EQUALS: {
                        this.lowerBound = (Integer)cond.getValues().iterator().next();
                        this.upperBound = (Integer)cond.getValues().iterator().next();
                    }
                }
            };
        }

        @Override
        protected Integer minValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        protected Integer maxValue() {
            return Integer.MAX_VALUE;
        }
    }

    private static abstract class Range<T extends Comparable>
    implements Comparable<Range<T>> {
        protected T lowerBound = this.minValue();
        protected T upperBound = this.maxValue();

        public Range(List<ConditionInspector> conditionInspectors) {
            if (conditionInspectors != null) {
                conditionInspectors.forEach(this.getConditionParser());
            }
        }

        protected abstract Consumer<ConditionInspector> getConditionParser();

        public String toString() {
            return this.lowerBound + " < x < " + this.upperBound;
        }

        @Override
        public int compareTo(Range<T> o) {
            return this.lowerBound.compareTo(o.lowerBound);
        }

        protected abstract T minValue();

        protected abstract T maxValue();
    }

    private static class PartitionKey {
        private static PartitionKey EMPTY_KEY = new PartitionKey(new Object[0]);
        private final Object[] keys;

        private PartitionKey(Object[] keys) {
            this.keys = keys;
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.keys, ((PartitionKey)obj).keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }

        public String toString() {
            return Arrays.toString(this.keys);
        }

        boolean hasNulls() {
            return Stream.of(this.keys).anyMatch(Objects::isNull);
        }

        public boolean subsumes(PartitionKey other) {
            return IntStream.range(0, this.keys.length).allMatch(i -> this.keys[i] == null || this.keys[i].equals(other.keys[i]));
        }
    }

    static enum OperatorType {
        PARTITION,
        RANGE,
        UNKNOWN;


        static OperatorType decode(Operator op) {
            return op == Operator.EQUALS ? PARTITION : (op.isRangeOperator() ? RANGE : UNKNOWN);
        }

        OperatorType combine(OperatorType other) {
            if (this == UNKNOWN || other == UNKNOWN) {
                return UNKNOWN;
            }
            if (this == RANGE || other == RANGE) {
                return RANGE;
            }
            return PARTITION;
        }
    }
}

