/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.action;

import java.util.Date;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.action.ActionInspector;
import org.drools.verifier.core.cache.inspectors.action.FieldActionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.DataType;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldAction;
import org.drools.verifier.core.index.model.ObjectField;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActionInspectorConflictResolverTest {
    private AnalyzerConfiguration configuration;

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
    }

    @Test
    public void testRedundancy001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Rambo"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy003() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.test1.Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.test2.Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy004() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.BOOLEAN, Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"true"));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy005() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.BOOLEAN, Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"false"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy006() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.NUMERIC_INTEGER, Integer.valueOf(20));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"20"));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy007() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.NUMERIC_INTEGER, Integer.valueOf(20));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"10"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy008() throws Exception {
        Date date = new Date();
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.DATE, date);
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)this.format(date)));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy009() throws Exception {
        Date value = new Date();
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.DATE, value);
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"29-Dec-1981"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testConflict001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Rambo"));
        Assert.assertTrue((boolean)a.conflicts((Object)b));
        Assert.assertTrue((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testConflict002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.BOOLEAN, Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"false"));
        Assert.assertTrue((boolean)a.conflicts((Object)b));
        Assert.assertTrue((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Address", "String", "street", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Rambo"));
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict003() throws Exception {
        ActionInspector a = this.createSetActionInspector((Action)new FieldAction(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Column)Mockito.mock(Column.class), DataType.DataTypes.BOOLEAN, new Values(new Comparable[]{Boolean.valueOf(true)}), (AnalyzerConfiguration)new AnalyzerConfigurationMock()));
        ActionInspector b = this.createSetActionInspector((Action)new FieldAction(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Column)Mockito.mock(Column.class), DataType.DataTypes.STRING, new Values(new Comparable[]{Boolean.valueOf(true)}), (AnalyzerConfiguration)new AnalyzerConfigurationMock()));
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    private ActionInspector createSetActionInspector(Field field, DataType.DataTypes dataType, Comparable comparable) {
        return new FieldActionInspector(new FieldAction(field, (Column)Mockito.mock(Column.class), dataType, new Values(new Comparable[]{comparable}), (AnalyzerConfiguration)new AnalyzerConfigurationMock()), this.configuration);
    }

    private ActionInspector createSetActionInspector(Action action) {
        return new ActionInspector(action, new AnalyzerConfigurationMock()){};
    }

    private String format(Date dateValue) {
        return this.configuration.formatDate(dateValue);
    }
}

