/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.List;
import java.util.Set;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapChangeHandler;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeHandledMultiMapPreExistingDataTest {
    private MultiMap<Value, String, List<String>> map;
    private MultiMapChangeHandler.ChangeSet<Value, String> changeSet;
    private int timesCalled = 0;

    @Before
    public void setUp() throws Exception {
        this.timesCalled = 0;
        this.map = MultiMapFactory.make((boolean)true);
        this.map.put((Comparable)new Value((Comparable)((Object)"hello")), (Object)"a");
        this.map.put((Comparable)new Value((Comparable)((Object)"ok")), (Object)"b");
        this.map.put((Comparable)new Value((Comparable)((Object)"ok")), (Object)"c");
        this.map.addChangeListener((MultiMapChangeHandler)new MultiMapChangeHandler<Value, String>(){

            public void onChange(MultiMapChangeHandler.ChangeSet<Value, String> changeSet) {
                ChangeHandledMultiMapPreExistingDataTest.this.changeSet = changeSet;
                ChangeHandledMultiMapPreExistingDataTest.this.timesCalled++;
            }
        });
    }

    @Test
    public void move() throws Exception {
        this.map.move((Set)new Values(new Comparable[]{new Value((Comparable)((Object)"ok"))}), (Set)new Values(new Comparable[]{new Value((Comparable)((Object)"hello"))}), (Object)"b");
        Assert.assertEquals((long)1L, (long)this.timesCalled);
        Assert.assertEquals((long)2L, (long)this.map.get((Comparable)new Value((Comparable)((Object)"hello"))).size());
        Assert.assertTrue((boolean)this.map.get((Comparable)new Value((Comparable)((Object)"hello"))).contains("a"));
        Assert.assertTrue((boolean)this.map.get((Comparable)new Value((Comparable)((Object)"hello"))).contains("b"));
        Assert.assertEquals((long)1L, (long)this.map.get((Comparable)new Value((Comparable)((Object)"ok"))).size());
        Assert.assertTrue((boolean)this.map.get((Comparable)new Value((Comparable)((Object)"ok"))).contains("c"));
        Assert.assertEquals((long)1L, (long)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok"))).size());
        Assert.assertEquals((long)1L, (long)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).size());
    }

    @Test
    public void testRemove() throws Exception {
        this.map.remove((Comparable)new Value((Comparable)((Object)"ok")));
        Assert.assertEquals((long)2L, (long)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok"))).size());
        Assert.assertEquals((long)1L, (long)this.timesCalled);
    }

    @Test
    public void testRemoveValue() throws Exception {
        this.map.removeValue((Comparable)new Value((Comparable)((Object)"ok")), (Object)"b");
        Assert.assertEquals((long)1L, (long)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok"))).size());
        Assert.assertTrue((boolean)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok"))).contains("b"));
        Assert.assertEquals((long)1L, (long)this.timesCalled);
    }

    @Test
    public void testClear() throws Exception {
        this.map.clear();
        Assert.assertEquals((long)1L, (long)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"hello"))).size());
        Assert.assertTrue((boolean)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("a"));
        Assert.assertEquals((long)2L, (long)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok"))).size());
        Assert.assertTrue((boolean)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok"))).contains("b"));
        Assert.assertTrue((boolean)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok"))).contains("c"));
        Assert.assertEquals((long)1L, (long)this.timesCalled);
    }

    @Test
    public void testMerge() throws Exception {
        MultiMap other = MultiMapFactory.make();
        other.put((Comparable)new Value((Comparable)((Object)"hello")), (Object)"d");
        other.put((Comparable)new Value((Comparable)((Object)"ok")), (Object)"e");
        other.put((Comparable)new Value((Comparable)((Object)"newOne")), (Object)"f");
        MultiMap.merge(this.map, (MultiMap)other);
        Assert.assertEquals((long)1L, (long)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).size());
        Assert.assertTrue((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("d"));
        Assert.assertEquals((long)1L, (long)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"ok"))).size());
        Assert.assertTrue((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"ok"))).contains("e"));
        Assert.assertEquals((long)1L, (long)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"newOne"))).size());
        Assert.assertTrue((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"newOne"))).contains("f"));
        Assert.assertEquals((long)1L, (long)this.timesCalled);
    }
}

