/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks.base;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.PairCheckBundle;
import org.drools.verifier.core.maps.MultiSet;

public class PairCheckStorage {
    private final MultiSet<RuleInspector, PairCheckBundle> pairChecks = new MultiSet();
    private final Map<RuleInspector, MultiSet<RuleInspector, PairCheckBundle>> pairChecksByOtherRowInspector = new HashMap<RuleInspector, MultiSet<RuleInspector, PairCheckBundle>>();

    public void add(PairCheckBundle pairCheckList) {
        this.pairChecks.put(pairCheckList.getRuleInspector(), pairCheckList);
        this.addByOther(pairCheckList);
    }

    private void addByOther(PairCheckBundle pairCheckList) {
        MultiSet<RuleInspector, PairCheckBundle> multiSet = this.getByOther(pairCheckList.getOther());
        Collection<PairCheckBundle> collection = multiSet.get(pairCheckList.getRuleInspector());
        if (collection == null) {
            multiSet.put(pairCheckList.getRuleInspector(), pairCheckList);
        } else {
            collection.add(pairCheckList);
        }
    }

    private MultiSet<RuleInspector, PairCheckBundle> getByOther(RuleInspector other) {
        MultiSet<RuleInspector, PairCheckBundle> multiSet = this.pairChecksByOtherRowInspector.get(other);
        if (multiSet == null) {
            MultiSet<RuleInspector, PairCheckBundle> result = new MultiSet<RuleInspector, PairCheckBundle>();
            this.pairChecksByOtherRowInspector.put(other, result);
            return result;
        }
        return multiSet;
    }

    public Collection<PairCheckBundle> remove(RuleInspector ruleInspector) {
        HashSet<PairCheckBundle> result = new HashSet<PairCheckBundle>();
        Collection<PairCheckBundle> removedPairCheckLists = this.pairChecks.remove(ruleInspector);
        if (removedPairCheckLists != null) {
            result.addAll(removedPairCheckLists);
        }
        result.addAll(this.removeByOther(ruleInspector));
        return result;
    }

    private List<PairCheckBundle> removeByOther(RuleInspector ruleInspector) {
        MultiSet<RuleInspector, PairCheckBundle> removedMap = this.pairChecksByOtherRowInspector.remove(ruleInspector);
        if (removedMap != null) {
            for (RuleInspector inspector : removedMap.keys()) {
                Collection<PairCheckBundle> collection = removedMap.get(inspector);
                this.pairChecks.get(inspector).removeAll(collection);
                this.getByOther(inspector).remove(ruleInspector);
            }
            return removedMap.allValues();
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<PairCheckBundle> get(RuleInspector ruleInspector) {
        Collection<PairCheckBundle> pairCheckLists = this.pairChecks.get(ruleInspector);
        MultiSet<RuleInspector, PairCheckBundle> multiSet = this.getByOther(ruleInspector);
        HashSet<PairCheckBundle> result = new HashSet<PairCheckBundle>();
        if (pairCheckLists != null) {
            result.addAll(pairCheckLists);
        }
        result.addAll(multiSet.allValues());
        return result;
    }

    public void remove(Collection<PairCheckBundle> checks) {
        for (PairCheckBundle check : checks) {
            this.get(check.getOther()).remove(check);
        }
    }
}

