/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.relations;

import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.relations.IsSubsuming;
import org.drools.verifier.core.relations.SubsumptionBlocker;
import org.drools.verifier.core.relations.SubsumptionBlockers;

public class SubsumptionResolver {
    private final InspectorList collection;
    private final SubsumptionBlockers subsumptionBlockers;

    public SubsumptionResolver(InspectorList collection, boolean record) {
        this.collection = collection;
        this.subsumptionBlockers = new SubsumptionBlockers(record);
    }

    public boolean listSubsumesOther(InspectorList otherList) {
        SubsumptionBlocker blocker = this.subsumptionBlockers.get(otherList.getUuidKey());
        if (blocker != null) {
            return this.revalidateBlocker(otherList, blocker);
        }
        return this.resolve(otherList);
    }

    private boolean resolve(InspectorList otherList) {
        SubsumptionBlocker blocker = this.resolveSubsumption(otherList);
        if (blocker.foundIssue()) {
            this.subsumptionBlockers.add(blocker);
            return false;
        }
        return true;
    }

    private boolean revalidateBlocker(InspectorList otherList, SubsumptionBlocker first) {
        if (first.doesRelationStillExist()) {
            return false;
        }
        this.subsumptionBlockers.remove(first);
        return this.listSubsumesOther(otherList);
    }

    private SubsumptionBlocker resolveSubsumption(InspectorList otherList) {
        for (Object object : otherList) {
            SubsumptionBlocker blocker = SubsumptionResolver.isSubsumedByAnObjectInThisList(this.collection, (HasUUID)object);
            if (!blocker.foundIssue()) continue;
            return new SubsumptionBlocker(this.collection, otherList, blocker);
        }
        return SubsumptionBlocker.EMPTY;
    }

    public static SubsumptionBlocker isSubsumedByAnObjectInThisList(InspectorList otherCollection, HasUUID object) {
        if (object instanceof IsSubsuming) {
            if (SubsumptionResolver.subsumesItem(otherCollection, (IsSubsuming)((Object)object))) {
                return SubsumptionBlocker.EMPTY;
            }
            return new SubsumptionBlocker(otherCollection, object);
        }
        if (otherCollection.contains(object)) {
            return new SubsumptionBlocker(otherCollection, object);
        }
        return SubsumptionBlocker.EMPTY;
    }

    private static boolean subsumesItem(InspectorList otherCollection, IsSubsuming object) {
        return otherCollection.stream().anyMatch(other -> object.subsumes(other));
    }
}

