/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors;

import java.util.Collection;
import java.util.Set;
import org.drools.verifier.core.cache.RuleInspectorCache;
import org.drools.verifier.core.cache.inspectors.PatternInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.verifier.core.cache.inspectors.action.ActionInspector;
import org.drools.verifier.core.cache.inspectors.action.ActionsInspectorMultiMap;
import org.drools.verifier.core.cache.inspectors.action.BRLActionInspector;
import org.drools.verifier.core.cache.inspectors.condition.BRLConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.CheckStorage;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.ActionSuperType;
import org.drools.verifier.core.index.model.BRLAction;
import org.drools.verifier.core.index.model.BRLCondition;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.model.ConditionSuperType;
import org.drools.verifier.core.index.model.Conditions;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.verifier.core.index.model.Pattern;
import org.drools.verifier.core.index.model.Rule;
import org.drools.verifier.core.index.select.AllListener;
import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.relations.HumanReadable;
import org.drools.verifier.core.relations.IsConflicting;
import org.drools.verifier.core.relations.IsDeficient;
import org.drools.verifier.core.relations.IsRedundant;
import org.drools.verifier.core.relations.IsSubsuming;
import org.drools.verifier.core.util.PortablePreconditions;

public class RuleInspector
implements IsRedundant,
IsSubsuming,
IsConflicting,
IsDeficient<RuleInspector>,
HumanReadable,
HasKeys {
    private final Rule rule;
    private final CheckStorage checkStorage;
    private final RuleInspectorCache cache;
    private final AnalyzerConfiguration configuration;
    private final UUIDKey uuidKey;
    private final InspectorList<PatternInspector> patternInspectorList;
    private final InspectorList<ConditionInspector> brlConditionsInspectors;
    private final InspectorList<ActionInspector> brlActionInspectors;
    private InspectorList<ActionsInspectorMultiMap> actionsInspectors = null;
    private InspectorList<ConditionsInspectorMultiMap> conditionsInspectors = null;

    public RuleInspector(Rule rule, CheckStorage checkStorage, RuleInspectorCache cache, AnalyzerConfiguration configuration) {
        this.rule = PortablePreconditions.checkNotNull("rule", rule);
        this.checkStorage = PortablePreconditions.checkNotNull("checkStorage", checkStorage);
        this.cache = PortablePreconditions.checkNotNull("cache", cache);
        this.configuration = PortablePreconditions.checkNotNull("configuration", configuration);
        this.uuidKey = configuration.getUUID(this);
        this.patternInspectorList = new InspectorList(configuration);
        this.brlConditionsInspectors = new InspectorList(true, configuration);
        this.brlActionInspectors = new InspectorList(true, configuration);
        this.makePatternsInspectors();
        this.makeBRLActionInspectors();
        this.makeBRLConditionInspectors();
        this.makeChecks();
    }

    private void makeConditionsInspectors() {
        this.conditionsInspectors = new InspectorList(true, this.configuration);
        for (PatternInspector patternInspector : this.patternInspectorList) {
            this.conditionsInspectors.add(patternInspector.getConditionsInspector());
        }
    }

    private void makeActionsInspectors() {
        this.actionsInspectors = new InspectorList(true, this.configuration);
        for (PatternInspector patternInspector : this.patternInspectorList) {
            this.actionsInspectors.add(patternInspector.getActionsInspector());
        }
    }

    private void makeBRLConditionInspectors() {
        this.updateBRLConditionInspectors(this.rule.getConditions().where(Condition.superType().is((Comparable)((Object)ConditionSuperType.BRL_CONDITION))).select().all());
        this.rule.getConditions().where(Condition.superType().is((Comparable)((Object)ConditionSuperType.BRL_CONDITION))).listen().all(new AllListener<Condition>(){

            @Override
            public void onAllChanged(Collection<Condition> all) {
                RuleInspector.this.updateBRLConditionInspectors(all);
            }
        });
    }

    private void makeBRLActionInspectors() {
        this.updateBRLActionInspectors(this.rule.getActions().where(Action.superType().is((Comparable)((Object)ActionSuperType.BRL_ACTION))).select().all());
        this.rule.getActions().where(Action.superType().is((Comparable)((Object)ActionSuperType.BRL_ACTION))).listen().all(new AllListener<Action>(){

            @Override
            public void onAllChanged(Collection<Action> all) {
                RuleInspector.this.updateBRLActionInspectors(all);
            }
        });
    }

    private void makePatternsInspectors() {
        for (Pattern pattern : this.rule.getPatterns().where(Pattern.uuid().any()).select().all()) {
            PatternInspector patternInspector = new PatternInspector(pattern, new RuleInspectorUpdater(){

                @Override
                public void resetActionsInspectors() {
                    RuleInspector.this.actionsInspectors = null;
                }

                @Override
                public void resetConditionsInspectors() {
                    RuleInspector.this.conditionsInspectors = null;
                }
            }, this.configuration);
            this.patternInspectorList.add(patternInspector);
        }
    }

    private void updateBRLConditionInspectors(Collection<Condition> conditions) {
        this.brlConditionsInspectors.clear();
        for (Condition condition : conditions) {
            this.brlConditionsInspectors.add(new BRLConditionInspector((BRLCondition)condition, this.configuration));
        }
    }

    private void updateBRLActionInspectors(Collection<Action> actions) {
        this.brlActionInspectors.clear();
        for (Action action : actions) {
            this.brlActionInspectors.add(new BRLActionInspector((BRLAction)action, this.configuration));
        }
    }

    public InspectorList<ConditionsInspectorMultiMap> getConditionsInspectors() {
        if (this.conditionsInspectors == null) {
            this.makeConditionsInspectors();
        }
        return this.conditionsInspectors;
    }

    public InspectorList<ActionsInspectorMultiMap> getActionsInspectors() {
        if (this.actionsInspectors == null) {
            this.makeActionsInspectors();
        }
        return this.actionsInspectors;
    }

    public InspectorList<PatternInspector> getPatternsInspector() {
        return this.patternInspectorList;
    }

    public int getRowIndex() {
        return this.rule.getRowNumber();
    }

    public RuleInspectorCache getCache() {
        return this.cache;
    }

    public boolean isRedundant(Object other) {
        return other instanceof RuleInspector && this.rule.getActivationTime().overlaps(((RuleInspector)other).rule.getActivationTime()) && this.brlConditionsInspectors.isRedundant(((RuleInspector)other).brlConditionsInspectors) && this.brlActionInspectors.isRedundant(((RuleInspector)other).brlActionInspectors) && this.getActionsInspectors().isRedundant(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().isRedundant(((RuleInspector)other).getConditionsInspectors());
    }

    public boolean subsumes(Object other) {
        return other instanceof RuleInspector && this.rule.getActivationTime().overlaps(((RuleInspector)other).rule.getActivationTime()) && this.brlActionInspectors.subsumes(((RuleInspector)other).brlActionInspectors) && this.brlConditionsInspectors.subsumes(((RuleInspector)other).brlConditionsInspectors) && this.getActionsInspectors().subsumes(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().subsumes(((RuleInspector)other).getConditionsInspectors());
    }

    public boolean conflicts(Object other) {
        return other instanceof RuleInspector && this.rule.getActivationTime().overlaps(((RuleInspector)other).rule.getActivationTime()) && this.getActionsInspectors().conflicts(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().subsumes(((RuleInspector)other).getConditionsInspectors()) && this.getBrlConditionsInspectors().subsumes(((RuleInspector)other).getBrlConditionsInspectors());
    }

    public Rule getRule() {
        return this.rule;
    }

    @Override
    public boolean isDeficient(RuleInspector other) {
        if (other.atLeastOneActionHasAValue() && !this.getActionsInspectors().conflicts(other.getActionsInspectors())) {
            return false;
        }
        Collection allConditionsFromTheOtherRule = other.rule.getConditions().where(Condition.value().any()).select().all();
        if (allConditionsFromTheOtherRule.isEmpty()) {
            return true;
        }
        for (Condition condition : allConditionsFromTheOtherRule) {
            if (condition.getValues() == null || !(condition instanceof FieldCondition)) continue;
            FieldCondition fieldCondition = (FieldCondition)condition;
            Conditions conditions = this.rule.getPatterns().where(Pattern.name().is((Comparable)((Object)fieldCondition.getField().getFactType()))).select().fields().where(Field.name().is((Comparable)((Object)fieldCondition.getField().getName()))).select().conditions();
            if (!conditions.where(Condition.value().any()).select().exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return !this.atLeastOneConditionHasAValue() && !this.atLeastOneActionHasAValue();
    }

    public boolean atLeastOneActionHasAValue() {
        int amountOfActions = this.rule.getActions().where(Action.value().any()).select().all().size();
        return amountOfActions > 0;
    }

    public boolean atLeastOneConditionHasAValue() {
        int amountOfConditions = this.rule.getConditions().where(Condition.value().any()).select().all().size();
        return amountOfConditions > 0;
    }

    @Override
    public String toHumanReadableString() {
        return this.rule.getRowNumber().toString();
    }

    public InspectorList<ConditionInspector> getBrlConditionsInspectors() {
        return this.brlConditionsInspectors;
    }

    public InspectorList<ActionInspector> getBrlActionInspectors() {
        return this.brlActionInspectors;
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }

    public Set<Check> getChecks() {
        return this.checkStorage.getChecks(this);
    }

    private void makeChecks() {
        this.checkStorage.makeChecks(this);
    }

    public Set<Check> clearChecks() {
        return this.checkStorage.remove(this);
    }
}

