/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import java.util.Arrays;
import java.util.Collection;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Fields;
import org.drools.verifier.core.index.model.Pattern;
import org.drools.verifier.core.index.query.Where;
import org.drools.verifier.core.index.select.Listen;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.MultiMap;

public class Patterns {
    public final KeyTreeMap<Pattern> patternsMap = new KeyTreeMap(Pattern.keyDefinitions());

    public Patterns(Collection<Pattern> patternsMap) {
        for (Pattern pattern : patternsMap) {
            this.add(pattern);
        }
    }

    public Patterns(Pattern[] patternsMap) {
        this(Arrays.asList(patternsMap));
    }

    public Patterns() {
    }

    public void merge(Patterns patterns) {
        this.patternsMap.merge(patterns.patternsMap);
    }

    public Where<PatternsSelect, PatternsListen> where(final Matcher matcher) {
        return new Where<PatternsSelect, PatternsListen>(){

            @Override
            public PatternsSelect select() {
                return new PatternsSelect(matcher);
            }

            @Override
            public PatternsListen listen() {
                return new PatternsListen(matcher);
            }
        };
    }

    public void add(Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            this.patternsMap.put(pattern);
        }
    }

    public class PatternsListen
    extends Listen<Pattern> {
        public PatternsListen(Matcher matcher) {
            super(Patterns.this.patternsMap.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class PatternsSelect
    extends Select<Pattern> {
        public PatternsSelect(Matcher matcher) {
            super(Patterns.this.patternsMap.get(matcher.getKeyDefinition()), matcher);
        }

        public Fields fields() {
            Fields fields = new Fields();
            MultiMap subMap = this.asMap();
            if (subMap != null) {
                Collection patterns = subMap.allValues();
                for (Pattern pattern : patterns) {
                    fields.merge(pattern.getFields());
                }
            }
            return fields;
        }
    }
}

