/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.verifier.core.index.model.ObjectField;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorToHumanReadableTest {
    private static final String FIELD_NAME = "name";
    private static final String VALUE = "someValue";
    private static final String IS_NOT_NULL = "!= null";
    private static final String IS_NULL = "== null";
    private final String operator;
    private AnalyzerConfiguration configuration;

    public StringConditionInspectorToHumanReadableTest(String operator) {
        this.operator = operator;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        ArrayList<String> data = new ArrayList<String>(Arrays.asList("==", "!=", "<", ">", "<=", ">=", "matches", "soundslike", IS_NULL, IS_NOT_NULL));
        data.addAll(Arrays.asList("in", "not in"));
        ArrayList<Object[]> data2 = new ArrayList<Object[]>();
        for (String operator : data) {
            data2.add(new Object[]{operator});
        }
        return data2;
    }

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
    }

    @Test
    public void testToHumanReadableString() {
        StringConditionInspector inspector = this.getStringConditionInspector();
        if (IS_NOT_NULL.matches(this.operator)) {
            Assert.assertEquals((Object)String.format("%s %s", FIELD_NAME, this.operator), (Object)inspector.toHumanReadableString());
        } else if (IS_NULL.matches(this.operator)) {
            Assert.assertEquals((Object)String.format("%s %s", FIELD_NAME, this.operator), (Object)inspector.toHumanReadableString());
        } else {
            Assert.assertEquals((Object)String.format("%s %s %s", FIELD_NAME, this.operator, VALUE), (Object)inspector.toHumanReadableString());
        }
    }

    private StringConditionInspector getStringConditionInspector() {
        if (IS_NOT_NULL.matches(this.operator)) {
            return new StringConditionInspector(new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Test", "String", FIELD_NAME, this.configuration), (Column)Mockito.mock(Column.class), "!=", Values.nullValue(), this.configuration), this.configuration);
        }
        if (IS_NULL.matches(this.operator)) {
            return new StringConditionInspector(new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Test", "String", FIELD_NAME, this.configuration), (Column)Mockito.mock(Column.class), "==", Values.nullValue(), this.configuration), this.configuration);
        }
        return new StringConditionInspector(new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Test", "String", FIELD_NAME, this.configuration), (Column)Mockito.mock(Column.class), this.operator, new Values(new Comparable[]{VALUE}), this.configuration), this.configuration);
    }
}

