/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.select;

import java.util.Collection;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.util.HasKeys;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SelectNoMatchesTest {
    private Select<Address> select;

    @Before
    public void setUp() throws Exception {
        KeyDefinition keyDefinition = KeyDefinition.newKeyDefinition().withId("name").build();
        KeyTreeMap map = new KeyTreeMap(new KeyDefinition[]{keyDefinition});
        Address object = new Address();
        map.put((HasKeys)object);
        this.select = new Select(map.get(UUIDKey.UNIQUE_UUID), (Matcher)new ExactMatcher(keyDefinition, (Comparable)((Object)"Toni")));
    }

    @Test
    public void testAll() throws Exception {
        Collection all = this.select.all();
        Assert.assertTrue((boolean)all.isEmpty());
    }

    @Test
    public void testFirst() throws Exception {
        Assert.assertNull((Object)this.select.first());
    }

    @Test
    public void testLast() throws Exception {
        Assert.assertNull((Object)this.select.last());
    }

    private class Address
    implements HasKeys {
        private UUIDKey uuidKey = new AnalyzerConfigurationMock().getUUID(this);

        private Address() {
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey};
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

