/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.util.HasKeys;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KnownKeysKeyTreeMapTest {
    private KeyTreeMap<Person> map;

    @Before
    public void setUp() throws Exception {
        this.map = new KeyTreeMap(new KeyDefinition[]{KeyDefinition.newKeyDefinition().withId("age").build()});
    }

    @Test
    public void testExisting() throws Exception {
        Assert.assertNotNull((Object)this.map.get(KeyDefinition.newKeyDefinition().withId("age").build()));
    }

    @Test
    public void testUnknown() throws Exception {
        Assert.assertNull((Object)this.map.get(KeyDefinition.newKeyDefinition().withId("unknown").build()));
    }

    class Person
    implements HasKeys {
        private UUIDKey uuidKey = new AnalyzerConfigurationMock().getUUID(this);

        Person() {
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(KeyDefinition.newKeyDefinition().withId("name").build(), (Comparable)((Object)"hello"))};
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

