/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.relations;

import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.relations.ConflictResolver;
import org.drools.verifier.core.relations.Relation;
import org.drools.verifier.core.util.PortablePreconditions;

public class Conflict
extends Relation<Conflict> {
    public static Conflict EMPTY = new Conflict();
    private final HasUUID conflictedItem;
    private final HasUUID conflictingItem;

    public Conflict(HasUUID conflictedItem, HasUUID conflictingItem) {
        super(null);
        this.conflictedItem = PortablePreconditions.checkNotNull("conflictedItem", conflictedItem);
        this.conflictingItem = PortablePreconditions.checkNotNull("conflictingItem", conflictingItem);
    }

    public Conflict(InspectorList conflictedItem, InspectorList conflictingItem, Conflict origin) {
        super((Relation)PortablePreconditions.checkNotNull("origin", origin));
        this.conflictedItem = PortablePreconditions.checkNotNull("conflictedItem", conflictedItem);
        this.conflictingItem = PortablePreconditions.checkNotNull("conflictingItem", conflictingItem);
    }

    private Conflict() {
        super(null);
        this.conflictedItem = null;
        this.conflictingItem = null;
    }

    @Override
    public boolean foundIssue() {
        return this.conflictingItem != null;
    }

    public HasUUID getConflictedItem() {
        return this.conflictedItem;
    }

    public HasUUID getConflictingItem() {
        return this.conflictingItem;
    }

    @Override
    public UUIDKey otherUUID() {
        return this.conflictingItem.getUuidKey();
    }

    @Override
    public boolean doesRelationStillExist() {
        if (this.origin != null && this.stillContainsConflictedItem(((Conflict)this.getOrigin()).getConflictedItem()) && this.stillContainsConflictingItem(((Conflict)this.getOrigin()).getConflictingItem())) {
            return ConflictResolver.isConflicting(((Conflict)this.getOrigin()).getConflictedItem(), ((Conflict)this.getOrigin()).getConflictingItem()).foundIssue();
        }
        return false;
    }

    private boolean stillContainsConflictedItem(HasUUID item) {
        if (this.conflictedItem instanceof InspectorList) {
            return ((InspectorList)this.conflictedItem).contains(item);
        }
        if (this.parent != null) {
            return ((Conflict)this.parent).stillContainsConflictedItem(item);
        }
        return false;
    }

    private boolean stillContainsConflictingItem(HasUUID item) {
        if (this.conflictingItem instanceof InspectorList) {
            return ((InspectorList)this.conflictingItem).contains(item);
        }
        if (this.parent != null) {
            return ((Conflict)this.parent).stillContainsConflictingItem(item);
        }
        return false;
    }
}

