/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.PairCheck;
import org.drools.verifier.core.checks.base.PairCheckBundle;
import org.drools.verifier.core.checks.base.PairCheckStorage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PairCheckStorageListTest {
    private PairCheckStorage pairCheckStorage;
    @Mock
    private RuleInspector a;
    @Mock
    private RuleInspector b;
    @Mock
    private RuleInspector c;
    private PairCheckBundle pairCheckListOne;
    private PairCheckBundle pairCheckListTwo;

    @Before
    public void setUp() throws Exception {
        this.pairCheckStorage = new PairCheckStorage();
        this.pairCheckListOne = new PairCheckBundle(this.a, this.b, this.newMockList());
        this.pairCheckStorage.add(this.pairCheckListOne);
        this.pairCheckListTwo = new PairCheckBundle(this.b, this.a, this.newMockList());
        this.pairCheckStorage.add(this.pairCheckListTwo);
        this.pairCheckStorage.add(new PairCheckBundle(this.a, this.c, this.newMockList()));
        this.pairCheckStorage.add(new PairCheckBundle(this.c, this.a, this.newMockList()));
    }

    private List<Check> newMockList() {
        ArrayList<Check> checks = new ArrayList<Check>();
        checks.add((Check)Mockito.mock(PairCheck.class));
        return checks;
    }

    @Test
    public void getA() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.get(this.a);
        Assert.assertEquals((long)4L, (long)pairCheckLists.size());
        Assert.assertTrue((boolean)pairCheckLists.contains(this.pairCheckListOne));
        Assert.assertTrue((boolean)pairCheckLists.contains(this.pairCheckListTwo));
    }

    @Test
    public void getB() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.get(this.b);
        Assert.assertEquals((long)2L, (long)pairCheckLists.size());
        Assert.assertTrue((boolean)pairCheckLists.contains(this.pairCheckListOne));
        Assert.assertTrue((boolean)pairCheckLists.contains(this.pairCheckListTwo));
    }

    @Test
    public void removeB() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.remove(this.b);
        Assert.assertEquals((long)2L, (long)pairCheckLists.size());
        Assert.assertTrue((boolean)pairCheckLists.contains(this.pairCheckListOne));
        Assert.assertTrue((boolean)pairCheckLists.contains(this.pairCheckListTwo));
        Assert.assertTrue((boolean)this.pairCheckStorage.get(this.b).isEmpty());
        Collection pairChecksForAList = this.pairCheckStorage.get(this.a);
        Assert.assertEquals((long)2L, (long)pairChecksForAList.size());
        Assert.assertFalse((boolean)pairChecksForAList.contains(this.pairCheckListOne));
        Assert.assertFalse((boolean)pairChecksForAList.contains(this.pairCheckListTwo));
    }

    @Test
    public void removeA() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.remove(this.a);
        Assert.assertEquals((long)4L, (long)pairCheckLists.size());
        Assert.assertTrue((boolean)this.pairCheckStorage.get(this.a).isEmpty());
        Assert.assertTrue((boolean)this.pairCheckStorage.get(this.b).isEmpty());
        Assert.assertTrue((boolean)this.pairCheckStorage.get(this.c).isEmpty());
    }
}

