/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import java.util.Arrays;
import java.util.Collection;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.ObjectFields;
import org.drools.verifier.core.index.model.ObjectType;
import org.drools.verifier.core.index.query.Where;
import org.drools.verifier.core.index.select.Listen;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.MultiMap;

public class ObjectTypes {
    public final KeyTreeMap<ObjectType> map = new KeyTreeMap(ObjectType.keyDefinitions());

    public ObjectTypes(Collection<ObjectType> map) {
        for (ObjectType objectType : map) {
            this.add(objectType);
        }
    }

    public ObjectTypes(ObjectType[] map) {
        this(Arrays.asList(map));
    }

    public ObjectTypes() {
    }

    public void merge(ObjectTypes patterns) {
        this.map.merge(patterns.map);
    }

    public Where<ObjectTypesSelect, ObjectTypesListen> where(final Matcher matcher) {
        return new Where<ObjectTypesSelect, ObjectTypesListen>(){

            @Override
            public ObjectTypesSelect select() {
                return new ObjectTypesSelect(matcher);
            }

            @Override
            public ObjectTypesListen listen() {
                return new ObjectTypesListen(matcher);
            }
        };
    }

    public void add(ObjectType ... objectTypes) {
        for (ObjectType objectType : objectTypes) {
            this.map.put(objectType);
        }
    }

    public class ObjectTypesListen
    extends Listen<ObjectType> {
        public ObjectTypesListen(Matcher matcher) {
            super(ObjectTypes.this.map.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class ObjectTypesSelect
    extends Select<ObjectType> {
        public ObjectTypesSelect(Matcher matcher) {
            super(ObjectTypes.this.map.get(matcher.getKeyDefinition()), matcher);
        }

        public ObjectFields fields() {
            ObjectFields fields = new ObjectFields();
            MultiMap subMap = this.asMap();
            if (subMap != null) {
                Collection objectTypes = subMap.allValues();
                for (ObjectType objectType : objectTypes) {
                    fields.merge(objectType.getFields());
                }
            }
            return fields;
        }
    }
}

