/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks.base;

import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.api.Command;
import org.drools.verifier.api.StatusUpdate;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.CheckRunner;

public class CheckRunManager {
    protected final Set<Check> rechecks = new HashSet<Check>();
    private final CheckRunner checkRunner;

    public CheckRunManager(CheckRunner checkRunner) {
        this.checkRunner = checkRunner;
    }

    public void run(StatusUpdate onStatus, Command onCompletion) {
        this.cancelExistingAnalysis();
        if (this.rechecks.isEmpty() && onCompletion != null) {
            onCompletion.execute();
            return;
        }
        this.checkRunner.run(this.rechecks, onStatus, onCompletion);
        this.rechecks.clear();
    }

    public void addChecks(Set<Check> checks) {
        this.cancelExistingAnalysis();
        this.rechecks.addAll(checks);
    }

    public boolean isEmpty() {
        return this.rechecks.isEmpty();
    }

    public void remove(RuleInspector removedRuleInspector) {
        this.cancelExistingAnalysis();
        Set<Check> checks = removedRuleInspector.clearChecks();
        this.rechecks.removeAll(checks);
    }

    public void cancelExistingAnalysis() {
        this.checkRunner.cancelExistingAnalysis();
    }
}

