/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.query;

import java.util.Collection;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Columns;
import org.drools.verifier.core.index.model.ObjectType;
import org.drools.verifier.core.index.model.ObjectTypes;
import org.drools.verifier.core.index.model.Rule;
import org.drools.verifier.core.index.model.Rules;
import org.drools.verifier.core.index.query.QueryableIndex;
import org.drools.verifier.core.index.select.QueryCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class QueryableIndexTest {
    private QueryableIndex queryableIndex;
    @Mock
    private QueryCallback<Collection<Rule>> rulesQueryCallback;
    @Mock
    private QueryCallback<Column> firstColumnQueryCallback;
    @Mock
    private QueryCallback<ObjectType> objectTypeQueryCallback;
    @Captor
    private ArgumentCaptor<Collection<Rule>> rulesArgumentCaptor;
    @Captor
    private ArgumentCaptor<Column> firstColumnArgumentCaptor;
    @Captor
    private ArgumentCaptor<ObjectType> objectTypeArgumentCaptor;
    private AnalyzerConfiguration configuration;
    private Column firstColumn;

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        Rules rules = new Rules();
        rules.add(new Rule(Integer.valueOf(0), this.configuration));
        rules.add(new Rule(Integer.valueOf(1), this.configuration));
        rules.add(new Rule(Integer.valueOf(2), this.configuration));
        Columns columns = new Columns();
        this.firstColumn = new Column(0, this.configuration);
        columns.add(this.firstColumn);
        columns.add(new Column(1, this.configuration));
        ObjectTypes objectTypes = new ObjectTypes();
        objectTypes.add(new ObjectType[]{new ObjectType("Person", this.configuration)});
        objectTypes.add(new ObjectType[]{new ObjectType("Address", this.configuration)});
        this.queryableIndex = new QueryableIndex(rules, columns, objectTypes);
    }

    @Test
    public void queryAllRules() throws Exception {
        this.queryableIndex.getRules().where(Rule.index().any()).select().all(this.rulesQueryCallback);
        ((QueryCallback)Mockito.verify(this.rulesQueryCallback)).callback(this.rulesArgumentCaptor.capture());
        Assert.assertEquals((long)3L, (long)((Collection)this.rulesArgumentCaptor.getValue()).size());
    }

    @Test
    public void queryFirstColumn() throws Exception {
        this.queryableIndex.getColumns().where(Column.index().any()).select().first(this.firstColumnQueryCallback);
        ((QueryCallback)Mockito.verify(this.firstColumnQueryCallback)).callback(this.firstColumnArgumentCaptor.capture());
        Assert.assertEquals((Object)this.firstColumn, (Object)this.firstColumnArgumentCaptor.getValue());
    }

    @Test
    public void makeSureFirstAndLastObjectTypesAreTheSame() throws Exception {
        this.queryableIndex.getObjectTypes().where((Matcher)ObjectType.type().is((Comparable)((Object)"Person"))).select().first(this.objectTypeQueryCallback);
        ((QueryCallback)Mockito.verify(this.objectTypeQueryCallback)).callback(this.objectTypeArgumentCaptor.capture());
        ObjectType first = (ObjectType)this.objectTypeArgumentCaptor.getValue();
        Mockito.reset((Object[])new QueryCallback[]{this.objectTypeQueryCallback});
        this.queryableIndex.getObjectTypes().where((Matcher)ObjectType.type().is((Comparable)((Object)"Person"))).select().last(this.objectTypeQueryCallback);
        ((QueryCallback)Mockito.verify(this.objectTypeQueryCallback)).callback(this.objectTypeArgumentCaptor.capture());
        ObjectType last = (ObjectType)this.objectTypeArgumentCaptor.getValue();
        Assert.assertEquals((Object)"Person", (Object)first.getType());
        Assert.assertEquals((Object)first, (Object)last);
    }
}

