/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors;

import java.util.Collection;
import org.drools.verifier.core.cache.inspectors.FieldInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.verifier.core.cache.inspectors.action.ActionsInspectorMultiMap;
import org.drools.verifier.core.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.ObjectField;
import org.drools.verifier.core.index.model.Pattern;
import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasConflicts;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.relations.Conflict;
import org.drools.verifier.core.relations.HumanReadable;
import org.drools.verifier.core.relations.IsConflicting;
import org.drools.verifier.core.relations.IsRedundant;
import org.drools.verifier.core.relations.IsSubsuming;
import org.drools.verifier.core.relations.RelationResolver;
import org.drools.verifier.core.util.PortablePreconditions;

public class PatternInspector
implements HasConflicts,
IsConflicting,
IsSubsuming,
IsRedundant,
HumanReadable,
HasKeys {
    private final UUIDKey uuidKey;
    private final Pattern pattern;
    private final AnalyzerConfiguration configuration;
    private final InspectorList<FieldInspector> inspectorList;
    private final RelationResolver relationResolver;

    public PatternInspector(Pattern pattern, RuleInspectorUpdater ruleInspectorUpdater, AnalyzerConfiguration configuration) {
        this.pattern = PortablePreconditions.checkNotNull("pattern", pattern);
        this.configuration = PortablePreconditions.checkNotNull("configuration", configuration);
        this.uuidKey = configuration.getUUID(this);
        this.inspectorList = new InspectorList(configuration);
        this.relationResolver = new RelationResolver(this.inspectorList);
        this.makeFieldInspectors(pattern.getFields().where(Field.uuid().any()).select().all(), ruleInspectorUpdater);
    }

    private void makeFieldInspectors(Collection<Field> fields, RuleInspectorUpdater ruleInspectorUpdater) {
        this.inspectorList.clear();
        for (Field field : fields) {
            this.inspectorList.add(new FieldInspector(field, ruleInspectorUpdater, this.configuration));
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean conflicts(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.conflicts(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.isRedundant(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    public boolean subsumes(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.subsumes(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    @Override
    public Conflict hasConflicts() {
        return this.relationResolver.resolveConflict(this.inspectorList);
    }

    public ActionsInspectorMultiMap getActionsInspector() {
        ActionsInspectorMultiMap<ObjectField> actionsInspector = new ActionsInspectorMultiMap<ObjectField>(this.configuration);
        for (FieldInspector fieldInspector : this.inspectorList) {
            actionsInspector.addAllValues(fieldInspector.getObjectField(), fieldInspector.getActionInspectorList());
        }
        return actionsInspector;
    }

    public ConditionsInspectorMultiMap getConditionsInspector() {
        ConditionsInspectorMultiMap conditionsInspector = new ConditionsInspectorMultiMap(this.configuration);
        for (FieldInspector fieldInspector : this.inspectorList) {
            if (fieldInspector.getConditionInspectorList().isEmpty()) continue;
            conditionsInspector.addAllValues(fieldInspector.getObjectField(), fieldInspector.getConditionInspectorList());
        }
        return conditionsInspector;
    }

    @Override
    public String toHumanReadableString() {
        return this.pattern.getName();
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }
}

