/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.FieldCondition;

public class BooleanConditionInspector
extends ComparableConditionInspector {
    public BooleanConditionInspector(FieldCondition<Boolean> fieldCondition, AnalyzerConfiguration configuration) {
        super(fieldCondition, configuration);
    }

    @Override
    public boolean isRedundant(Object other) {
        if (this.equals(other)) {
            return true;
        }
        if (other instanceof BooleanConditionInspector) {
            switch (this.operator) {
                case EQUALS: {
                    switch (((BooleanConditionInspector)other).operator) {
                        case EQUALS: {
                            return this.getValues().containsAll(((BooleanConditionInspector)other).getValues());
                        }
                        case NOT_EQUALS: {
                            return !this.getValue().equals(((BooleanConditionInspector)other).getValue());
                        }
                    }
                    return false;
                }
                case NOT_EQUALS: {
                    switch (((BooleanConditionInspector)other).operator) {
                        case EQUALS: {
                            return !this.getValues().equals(((BooleanConditionInspector)other).getValues());
                        }
                        case NOT_EQUALS: {
                            return this.getValues().containsAll(((BooleanConditionInspector)other).getValues());
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean conflicts(Object other) {
        return !this.isRedundant(other);
    }

    @Override
    public boolean overlaps(Object other) {
        return this.isRedundant(other);
    }

    @Override
    public boolean subsumes(Object other) {
        return this.isRedundant(other);
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.field.getFactType());
        stringBuilder.append(".");
        stringBuilder.append(this.field.getName());
        stringBuilder.append(" ");
        stringBuilder.append((Object)this.operator);
        stringBuilder.append(" ");
        stringBuilder.append(this.getValues());
        return stringBuilder.toString();
    }
}

