/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.util;

import java.util.Collection;
import java.util.Map;

public class PortablePreconditions {
    protected PortablePreconditions() {
        throw new IllegalStateException("This class should be not instantiated!");
    }

    public static void checkCondition(String name, boolean condition) {
        if (!condition) {
            throw new IllegalStateException("Condition '" + name + "' is invalid!");
        }
    }

    public static <T> void checkEachParameterNotNull(String name, T ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter named '" + name + "' should be not null!");
        }
        for (T parameter : parameters) {
            if (parameter != null) continue;
            throw new IllegalArgumentException("Parameter named '" + name + "' should be not null!");
        }
    }

    public static <T extends Collection<?>> T checkNotEmpty(String name, T parameter) {
        if (parameter == null || parameter.size() == 0) {
            throw new IllegalArgumentException("Parameter named '" + name + "' should be filled!");
        }
        return parameter;
    }

    public static void checkNotEmpty(String name, Map<?, ?> parameter) {
        if (parameter == null || parameter.size() == 0) {
            throw new IllegalArgumentException("Parameter named '" + name + "' should be filled!");
        }
    }

    public static String checkNotEmpty(String name, String parameter) {
        if (parameter == null || parameter.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter named '" + name + "' should be filled!");
        }
        return parameter;
    }

    public static <T> T[] checkNotEmpty(String name, T[] parameter) {
        if (parameter == null || parameter.length == 0) {
            throw new IllegalArgumentException("Parameter named '" + name + "' should be filled!");
        }
        return parameter;
    }

    public static <T> T checkNotNull(String name, T parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter named '" + name + "' should be not null!");
        }
        return parameter;
    }

    public static void checkNullMandatory(String name, Object parameter) {
        if (parameter != null) {
            throw new IllegalArgumentException("Parameter named '" + name + "' should be null!");
        }
    }
}

