/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.relations.HumanReadable;
import org.drools.verifier.core.relations.IsConflicting;
import org.drools.verifier.core.relations.IsOverlapping;
import org.drools.verifier.core.relations.IsRedundant;
import org.drools.verifier.core.relations.IsSubsuming;

public abstract class ConditionInspector<T extends Comparable<T>>
implements IsRedundant,
IsOverlapping,
IsSubsuming,
IsConflicting,
HumanReadable,
HasKeys {
    private final UUIDKey uuidKey;
    private Condition<T> condition;

    public ConditionInspector(Condition<T> condition, AnalyzerConfiguration configuration) {
        this.condition = condition;
        this.uuidKey = configuration.getUUID(this);
    }

    public Condition<T> getCondition() {
        return this.condition;
    }

    public T getValue() {
        if (this.condition.getValues().isEmpty()) {
            return null;
        }
        return (T)((Comparable)this.condition.getValues().iterator().next());
    }

    protected boolean valueIsGreaterThanOrEqualTo(Comparable<T> otherValue) {
        return this.valueIsEqualTo(otherValue) || this.valueIsGreaterThan(otherValue);
    }

    protected boolean valueIsLessThanOrEqualTo(Comparable<T> otherValue) {
        return this.valueIsEqualTo(otherValue) || this.valueIsLessThan(otherValue);
    }

    protected boolean valueIsGreaterThan(Comparable<T> otherValue) {
        return otherValue.compareTo(this.getValue()) > 0;
    }

    protected boolean valueIsLessThan(Comparable<T> otherValue) {
        return otherValue.compareTo(this.getValue()) < 0;
    }

    protected boolean valueIsEqualTo(Comparable<T> otherValue) {
        if (otherValue == null) {
            return this.getValue() == null;
        }
        if (this.getValue() == null) {
            return false;
        }
        return otherValue.compareTo(this.getValue()) == 0;
    }

    public boolean isRedundant(Object object) {
        if (object instanceof IsSubsuming) {
            return this.subsumes(object) && ((IsSubsuming)object).subsumes(this);
        }
        return false;
    }

    public Values<Comparable> getValues() {
        return this.condition.getValues();
    }

    public boolean hasValue() {
        return !this.condition.getValues().isEmpty();
    }

    @Override
    public abstract String toHumanReadableString();

    public String toString() {
        return this.condition.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof HasUUID) {
            return this.uuidKey.equals(((HasUUID)obj).getUuidKey());
        }
        return false;
    }

    public int hashCode() {
        return this.toHumanReadableString().hashCode();
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }
}

