/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.action;

import java.util.Date;
import java.util.Iterator;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.relations.HumanReadable;
import org.drools.verifier.core.relations.IsConflicting;
import org.drools.verifier.core.relations.IsRedundant;
import org.drools.verifier.core.relations.IsSubsuming;

public abstract class ActionInspector
implements IsRedundant,
IsSubsuming,
IsConflicting,
HumanReadable,
HasKeys {
    private UUIDKey uuidKey;
    protected Action action;
    private AnalyzerConfiguration configuration;

    protected ActionInspector(Action action, AnalyzerConfiguration configuration) {
        this.action = action;
        this.uuidKey = configuration.getUUID(this);
        this.configuration = configuration;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof ActionInspector) {
            return this.areValuesRedundant(((ActionInspector)other).action.getValues());
        }
        return false;
    }

    private boolean areValuesRedundant(Values<Comparable> others) {
        for (Comparable comparable : this.action.getValues()) {
            if (this.isValueRedundant(others, comparable)) continue;
            return false;
        }
        for (Comparable comparable : others) {
            if (this.isValueRedundant(this.action.getValues(), comparable)) continue;
            return false;
        }
        return !this.action.getValues().isEmpty() || !others.isEmpty();
    }

    private boolean isValueRedundant(Values<Comparable> others, Comparable comparable) {
        for (Comparable other : others) {
            if (!this.isValueRedundant(comparable, other)) continue;
            return true;
        }
        return false;
    }

    private boolean isValueRedundant(Comparable value, Comparable other) {
        if (value.equals(other)) {
            return true;
        }
        if (value instanceof Date) {
            return this.areDatesEqual((Date)value, other);
        }
        if (other instanceof Date) {
            return this.areDatesEqual((Date)other, value);
        }
        return value.toString().equals(other.toString());
    }

    private boolean areDatesEqual(Date value, Comparable other) {
        if (other instanceof String) {
            return this.format(value).toString().equals(other);
        }
        return false;
    }

    private String format(Date dateValue) {
        return this.configuration.formatDate(dateValue);
    }

    public boolean conflicts(Object other) {
        if (other instanceof ActionInspector) {
            ActionInspector otherActionInspector = (ActionInspector)other;
            return !this.areValuesRedundant(otherActionInspector.action.getValues());
        }
        return false;
    }

    public boolean subsumes(Object other) {
        return this.isRedundant(other);
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = this.action.getValues().iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public boolean hasValue() {
        return this.action.getValues().isEmpty();
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[0];
    }
}

